// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#ifndef mfmrename_ui_h
#define mfmrename_ui_h

#include "mfmrename_ui_fluid.hxx"


class class_mfmrename : class_mfmrename_fluid {

public:

  class_mfmrename(int argc, char **argv);

private:

  void rename_files(class_table *mfmrename_table, Fl_Input *rename_template);
  
  void add_code(char *code);
  
  int get_param(char *string, char **param1, char **param2);

  void mfmrename_menu_fullname_callback();
  void mfmrename_menu_name_callback();
  void mfmrename_menu_ext_callback();
  void mfmrename_menu_counter_callback();
  void mfmrename_menu_insert_callback();
  void mfmrename_menu_overwrite_callback();
  void mfmrename_menu_delete_callback();
  void mfmrename_menu_replace_callback(); 
  void mfmrename_menu_rename_callback();
  void mfmrename_menu_reset_callback();
  void mfmrename_menu_exit_callback();
  void mfmrename_menu_help_callback();  
  void mfmrename_template_callback();

};

#endif
