// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <locale.h>
#include <stdio.h>
#include <FL/fl_draw.H>

#include "mfm_stat_ui.hxx"
#include "mfm_util.hxx"
#include "mfm_main_ui.hxx"

#include "file_info.hxx"
#include "fl_file_sort.hxx"


/**************************************************************************
* Metodi di class_mfm_stat
****************************************************************************/

/**************************************************************************
* Costruttore
****************************************************************************/

class_mfm_stat::class_mfm_stat(void *mfm_window) : class_mfm_stat_fluid() {

  char *line = NULL;

  class_mfm_window *ptr_window;

  long int dirs = 0,
           files = 0;
					 
	long long int size = 0;
					 
  ptr_window = (class_mfm_window *) mfm_window;

  for (int i=0; i < ptr_window->mfm_window_table->get_rows(); i++)

    if (ptr_window->mfm_window_table->table[i].selected) {

      char *name = convert_names(ptr_window->mfm_window_table->cell_label(ptr_window->col_name, i), false);

		  get_info(ptr_window->path, name, &dirs, &files, &size);

      free(name);
      
    }   

  asprintf(&line, "%li", files);

  mfm_stat_files->value(line);

  xfree(&line);

  asprintf(&line, "%li", dirs);

  mfm_stat_dirs->value(line);

  xfree(&line);

  if (size < 10240)

    asprintf(&line, "%lli Bytes", size);

  else if (size < 104857600)

    asprintf(&line, "%lli KB", (size+512)/1024);

  else

    asprintf(&line, "%lli MB", (size+524288)/1048576);

  mfm_stat_size->value(line);

  xfree(&line);

  mfm_stat->show();

} // class_mfm_stat



/**************************************************************************
*
* Function: get_info
*
* Calculate recursively statistical data
*
****************************************************************************/

void class_mfm_stat::get_info(char *path, char *file, long int *dirs, long int *files, long long int *size) {

  file_info file_stat;

  file_stat.set_file(path, file);

  if (file_stat.is_dir()) {
     
	  char *new_path;
		
		dirent **dir_files;
		
    (*dirs)++;	
		
		asprintf(&new_path, "%s%s/", path, file);
		
    int num_files = fl_filename_list(new_path, &dir_files, NULL);		
		
		for (int i = 0; i<num_files; i++) {

		  if (strcmp(dir_files[i]->d_name, ".") != 0 && strcmp(dir_files[i]->d_name, "..") &&
            strcmp(dir_files[i]->d_name, "./") != 0 && strcmp(dir_files[i]->d_name, "../"))
    		
        get_info(new_path, dir_files[i]->d_name, dirs, files, size);		
		
      free(dir_files[i]);		
			
		}

  	if (num_files>0)	

      free(dir_files);
		
		free(new_path);

	}
	
	else {

	  (*files)++;
		
		(*size) += file_stat.get_size();

	}

} // class_mfm_stat::get_info

/**************************************************************************
* Callback dei widget dell'interfaccia
****************************************************************************/

void class_mfm_stat::mfm_stat_exit_callback() {

  delete this->mfm_stat;
  delete this;

} // mfm_stat_exit_callback





