// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#ifndef mfm_get_path_ui_h
#define mfm_get_path_ui_h

#include "mfm_get_path_ui_fluid.hxx"
#include "mfm_main_ui.hxx"

typedef class_mfm_window *type_class_mfm_window;

char* get_path(char* label, char *path);

class class_mfm_window_index {

public:

  int num_window_index;
  type_class_mfm_window *ptr_window_index;

  void init();
  void add(type_class_mfm_window win_ptr);
  void del(type_class_mfm_window win_ptr);
  
};


class class_mfm_get_path : public class_mfm_get_path_fluid {

private:

  char **value_ptr;

public:

  class_mfm_get_path(char *title, char** value, char *path);

private:

  void mfm_get_path_browser_callback();
  void mfm_get_path_button_browse_callback();
  void mfm_get_path_button_ok_callback();
  void mfm_get_path_button_cancel_callback();
  void mfm_get_path_button_help_callback();  

};

extern class_mfm_window_index mfm_window_index;

#endif
