// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#ifndef mfm_dir_ui_h
#define mfm_dir_ui_h

#include <FL/Fl_Hold_Browser.H>

#include "mfm_dir_ui_fluid.hxx"


class class_mfm_open_dir {

public:

  char *path;
  
  void *parent;
  
  int level;
  
};


class class_mfm_dir_browser : public Fl_Hold_Browser {

public:

  class_mfm_dir_browser(int x, int y, int w, int h, void *ptr);

  char *get_dir(int row);
  void load_dir(int row); 
  int get_pointed_row(); 

private:

  void *ptr_dir;

  int handle(int event);

};


class class_mfm_dir : public class_mfm_dir_fluid {

public:

  bool verbose,
       overwrite; 

  Fl_Menu_Button *popup;   
  class_mfm_dir_browser *mfm_dir_browser;              
  
  class_mfm_dir();

private:

  virtual void mfm_dir_collapse_callback();
  virtual void mfm_dir_copy_callback();
  virtual void mfm_dir_move_callback();   
  virtual void mfm_dir_soft_link_callback();
  virtual void mfm_dir_hard_link_callback();
  virtual void mfm_dir_browse_callback();
  virtual void mfm_dir_terminal_callback();
  virtual void mfm_dir_trash_callback();
  virtual void mfm_dir_delete_callback();
  virtual void mfm_dir_exit_callback();  
  virtual void mfm_dir_help_callback();   

};

#endif
