// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#include <locale.h>
#include <stdio.h>
#include <FL/fl_draw.H>

#include "mfm_confirm_ui.hxx"

/**************************************************************************
*
* get_confirm
*
* Ask confirmation
*
****************************************************************************/

bool get_confirm(char* label, char* text) {

  class_mfm_confirm *confirm_dialog;

  bool value = false;

  confirm_dialog = new class_mfm_confirm(label, text, &value);
	
  while (confirm_dialog->mfm_confirm != NULL)	
  
    Fl::wait();

  delete confirm_dialog;

  return value;

} // get_confirm


/**************************************************************************
* Metodi di class_mfm_confirm
****************************************************************************/

/**************************************************************************
* Costruttore
****************************************************************************/

class_mfm_confirm::class_mfm_confirm(char* label, char* text, bool * value) : class_mfm_confirm_fluid() {

  value_ptr = value;
  
  mfm_confirm->label(label);
  
  mfm_confirm_output->value(text);
	
  mfm_confirm_output->cursor_color(FL_WHITE);
  
  mfm_confirm->show();

} // class_mfm_confirm


/**************************************************************************
* Callback dei widget dell'interfaccia
****************************************************************************/

void class_mfm_confirm::mfm_confirm_ok_callback() {

  *value_ptr = true;

  delete mfm_confirm;

  mfm_confirm = NULL;


} // mfm_confirm_ok_callback


void class_mfm_confirm::mfm_confirm_cancel_callback() {

  *value_ptr = false;

  delete mfm_confirm;

  mfm_confirm = NULL;


} // mfm_confirm_cancel_callback


