// My File Manager (MFM).
//
// Copyright 2005-2006 by Stefano Gatti.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
//=====================================================================

#ifndef mfm_attrib_ui_h
#define mfm_attrib_ui_h

#include "mfm_attrib_ui_fluid.hxx"
#include <FL/Fl_Menu_Item.H>

class class_mfm_attrib : public class_mfm_attrib_fluid {

private:

  void *ptr_mfm_window;
  Fl_Menu_Item *user_item,
               *group_item;

public:

  class_mfm_attrib(void *mfm_window);

private:

  void mfm_attrib_ch_mode(char *mode);

  virtual void mfm_attrib_owner_read_callback();
  virtual void mfm_attrib_owner_write_callback();
  virtual void mfm_attrib_owner_execute_callback();
  virtual void mfm_attrib_group_read_callback();
  virtual void mfm_attrib_group_write_callback();
  virtual void mfm_attrib_group_execute_callback();
  virtual void mfm_attrib_others_read_callback();
  virtual void mfm_attrib_others_write_callback();
  virtual void mfm_attrib_others_execute_callback();

  virtual void mfm_attrib_uid_callback();
  virtual void mfm_attrib_gid_callback();
  virtual void mfm_attrib_sticky_callback();
  
  virtual void mfm_attrib_user_callback();
  virtual void mfm_attrib_group_callback();

  virtual void mfm_attrib_touch_callback();
  virtual void mfm_attrib_exit_callback();
  virtual void mfm_attrib_help_callback();

};

#endif
