/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.client;

import com.sleepycat.client.SDatabase;
import com.sleepycat.client.SDatabaseConfig;
import com.sleepycat.client.SForeignKeyDeleteAction;
import com.sleepycat.client.SSecondaryKeyCreator;
import com.sleepycat.client.SSecondaryMultiKeyCreator;
import com.sleepycat.client.ThriftWrapper;
import com.sleepycat.thrift.TDatabaseConfig;
import com.sleepycat.thrift.TFKDeleteAction;
import com.sleepycat.thrift.TSecondaryDatabaseConfig;
import java.util.Objects;

public class SSecondaryConfig
extends SDatabaseConfig {
    private SecondaryConfigWrapper wrapper = new SecondaryConfigWrapper((TDatabaseConfig)super.getThriftObj());
    private SDatabase foreign;
    private SSecondaryKeyCreator keyCreator;
    private SSecondaryMultiKeyCreator multiKeyCreator;

    public SSecondaryConfig() {
        super(new TDatabaseConfig());
    }

    SSecondaryConfig(SSecondaryConfig sSecondaryConfig) {
        super((TDatabaseConfig)sSecondaryConfig.getThriftObj());
        this.foreign = sSecondaryConfig.foreign;
        this.keyCreator = sSecondaryConfig.keyCreator;
        this.multiKeyCreator = sSecondaryConfig.multiKeyCreator;
    }

    TSecondaryDatabaseConfig getThriftObject() {
        return (TSecondaryDatabaseConfig)this.wrapper.getThriftObj();
    }

    public boolean getImmutableSecondaryKey() {
        return (Boolean)this.wrapper.getField(TSecondaryDatabaseConfig._Fields.IMMUTABLE_SECONDARY_KEY);
    }

    public SSecondaryConfig setImmutableSecondaryKey(boolean bl) {
        ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setImmutableSecondaryKey(bl);
        return this;
    }

    public SDatabase getForeignKeyDatabase() {
        return this.foreign;
    }

    public SSecondaryConfig setForeignKeyDatabase(SDatabase sDatabase) {
        this.foreign = sDatabase;
        if (sDatabase == null) {
            ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).unsetForeignDb();
        } else {
            ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setForeignDb(sDatabase.getThriftObj());
        }
        return this;
    }

    public SForeignKeyDeleteAction getForeignKeyDeleteAction() {
        TFKDeleteAction tFKDeleteAction = (TFKDeleteAction)this.wrapper.getField(TSecondaryDatabaseConfig._Fields.FOREIGN_KEY_DELETE_ACTION);
        return SForeignKeyDeleteAction.toBdb(tFKDeleteAction);
    }

    public SSecondaryConfig setForeignKeyDeleteAction(SForeignKeyDeleteAction sForeignKeyDeleteAction) {
        ((TSecondaryDatabaseConfig)this.wrapper.getThriftObj()).setForeignKeyDeleteAction(SForeignKeyDeleteAction.toThrift(sForeignKeyDeleteAction));
        return this;
    }

    public SSecondaryKeyCreator getKeyCreator() {
        return this.keyCreator;
    }

    public SSecondaryConfig setKeyCreator(SSecondaryKeyCreator sSecondaryKeyCreator) {
        this.keyCreator = sSecondaryKeyCreator;
        return this;
    }

    public SSecondaryMultiKeyCreator getMultiKeyCreator() {
        return this.multiKeyCreator;
    }

    public void setMultiKeyCreator(SSecondaryMultiKeyCreator sSecondaryMultiKeyCreator) {
        this.multiKeyCreator = sSecondaryMultiKeyCreator;
    }

    private static class SecondaryConfigWrapper
    extends ThriftWrapper<TSecondaryDatabaseConfig, TSecondaryDatabaseConfig._Fields> {
        public SecondaryConfigWrapper(TDatabaseConfig tDatabaseConfig) {
            super(new TSecondaryDatabaseConfig().setDbConfig(Objects.requireNonNull(tDatabaseConfig)));
        }
    }
}

