/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.util;

import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.server.util.Adapters;
import com.sleepycat.server.util.InputArgs;
import com.sleepycat.thrift.TDbPutConfig;
import com.sleepycat.thrift.TKeyData;
import com.sleepycat.thrift.TKeyDataWithSecondaryKeys;
import java.util.List;
import java.util.stream.Collectors;

public class PutArgs
extends InputArgs {
    public DatabaseEntry key;
    public DatabaseEntry data;

    public PutArgs(List<TKeyDataWithSecondaryKeys> list, TDbPutConfig tDbPutConfig) throws DatabaseException {
        if (list.size() > 1 || tDbPutConfig == TDbPutConfig.OVERWRITE_DUP) {
            this.constructMultipleKey(list);
        } else {
            this.constructSingle(list.get(0));
        }
    }

    public PutArgs(TKeyDataWithSecondaryKeys tKeyDataWithSecondaryKeys) {
        this.constructSingle(tKeyDataWithSecondaryKeys);
    }

    private void constructSingle(TKeyDataWithSecondaryKeys tKeyDataWithSecondaryKeys) {
        if (tKeyDataWithSecondaryKeys.pdata.isSetPartial() && tKeyDataWithSecondaryKeys.pdata.partial) {
            throw new UnsupportedOperationException("Partial update is not supported for databases having secondary databases.");
        }
        this.key = Adapters.toBdbType(tKeyDataWithSecondaryKeys.pkey);
        this.data = Adapters.toBdbType(tKeyDataWithSecondaryKeys.pdata);
    }

    private void constructMultipleKey(List<TKeyDataWithSecondaryKeys> list) throws DatabaseException {
        this.key = this.convert(this.extract(list));
        this.data = null;
    }

    private List<TKeyData> extract(List<TKeyDataWithSecondaryKeys> list) {
        return list.stream().map(tKeyDataWithSecondaryKeys -> new TKeyData().setKey(tKeyDataWithSecondaryKeys.pkey).setData(tKeyDataWithSecondaryKeys.pdata)).collect(Collectors.toList());
    }
}

