# Node Foundation TSC Meeting 2015-09-30

## Links

* **Audio Recording**: https://soundcloud.com/node-foundation/tsc-meeting-2015-09-30
* **GitHub Issue**: https://github.com/nodejs/node/issues/3126
* **Minutes Google Doc**: https://docs.google.com/document/d/1RkLAWTIrhD3BTB2rs9_FahWI0C7lt9F8xnQXaueJPIE
* _Previous Minutes Google Doc: <https://docs.google.com/document/d/1RCR2pGOc2d80NNusaX5DZaktWvHEsDUqfEZP-tvexBk>_

## Present

* Rod Vagg (TSC)
* Brian White (TSC)
* Chris Dickinson (TSC)
* James Snell (TSC)
* Michael Dawson
* Ben Noordhuis (TSC)
* Steven R Loomis
* Bert Belder (TSC)
* Alexis Campailla (TSC)
* Domenic Denicola
* Seth Thompson

## Agenda

Extracted from **tsc-agenda** labelled issues and pull requests in the nodejs org prior to meeting.

### nodejs/node

* Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)
* Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)

### nodejs/TSC

* Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)

## Minutes

### Standup

* Rod Vagg (TSC) - Lots! Pass.
* Brian White (TSC) - DNS PR (querying NSS modules like mDNS works now, continuing work on other getnameinfo/getaddrinfo compat issues)
* Chris Dickinson (TSC) - Static Analysis
* James Snell (TSC) - Review of the HTTP module, going in depth with spec compliance 
* Michael Dawson - AIX, contributing changes from IBM repos, node-gyp, all related to getting native modules working on AIX, submitted PR to core, benchmarking — bare metal machine for benchmarking group, backporting test fix to 0.12, FIPS-compat work on the test suite, getting hooked into v8 security reporting
* Ben Noordhuis (TSC) - Review PRs, bug reports, fixed 1-2 bugs, sent a few patches upstream to V8 and gyp, fixed a few bugs in node-gyp.
* Steven R Loomis - Review PRs, bug reports. Looking into alternatives to packaging full ICU data. Might be able to `npm install` ICU data.
* Bert Belder (TSC) - 
* Alexis Campailla (TSC) - working on Node-serialport on Windows in Jenkins, looking into native module build service
* Domenic Denicola - v8-extras are starting to appear in Chrome, maybe use them in Node for startup performance. 

### Review of previous meeting

* Deprecate Array#values() in 0.12.x [#25877](https://github.com/nodejs/node-v0.x-archive/issues/25877)
* Deprecate smalloc in v0.12 [#25784](https://github.com/nodejs/node-v0.x-archive/issues/25784)
* Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)
* util: Remove p, has been deprecated for years [#2529](https://github.com/nodejs/node/pull/2529)

### Discussion: LTS & v5 release planning [#3000](https://github.com/nodejs/node/issues/3000)

(Chris: apologies, I did a bad job here.)

Ben: Plan is to ship the first LTS release with v8 4.5, not 4.6

Rod: Yes.

Ben: Is there a pressing reason to do so?

Rod: LTS comes off the v4.x branch, we committed to not bump V8 in stable releases.

Ben: It basically means that the first LTS release is going to ship with an outdated release.

James: Yes, we knew this was a strong possibility.

Michael: The model is that we give the community time to catch up. In the future that’s 6 months, so we’re never going to be on a supported version.

Ben: V8 moves quickly. If we stick with 4.5, we’re going to have to manage a bigger delta between our copy and upstream.

James: Yes, this was always going to be the case. We’re committed to supporting the V8 for 36 months.

Ben: Yes, my point is that we could be starting with a smaller delta.

Rod: One of the reasons we had this LTS delay on 4 is to shake out some of these concerns, like the buffer changes. Normally this shakeout will be 6 months, but this time it’s only been a month.

Alexis: Is v5 going to be LTS also?

Rod: We are having discussions about the overlap between v5 and v6, whether there’ll be a strict cutoff or some overlap. No decision yet. That’ll happen in April. It sounds like most folks are leaning towards
making the two releases (v4 LTS + v5) independent — option 1 [here](https://github.com/nodejs/node/issues/3000#issuecomment-144026295).

Ben: We still haven’t come up with a way to maintain V8 going forward.

James: We do need a good process there, you are absolutely right about that.

Rod: I vote for IBM to hire someone dedicated to this. (Laughter)

Michael: I can’t promise that at this point.

Rod: As the delta increases between versions this becomes more concerning.

James: make sure this is on the LTS WG agenda for next week.

Rod: We tried to tackle this once before, came up with job description but nothing concrete.

Michael: We stopped short of telling the foundation that this is a position that we need to staff.

James: I would agree. We’re at the point where bringing someone in at the foundation level is probably a good idea.

Rod: Noted. OK. We’ve got resolution there.

Michael: James: Make sure it’s on the LTS agenda for going back to the foundation for resources.

Rod: LTS is meeting this Monday (issue 43 on the repo). There’s some discussion around codenames and how to expose LTS info. We’ve committed to first week of October for LTS releases, so timing is going to be a little awkward with 4.1.2 coming out monday. Version 5 will be shipping when we have a stable V8, presumably mid-to-late october (1-3 weeks with no stable release line.)

Rod: We’ll be pulling in semver minor and patch changes, we’ll continue to have bugfix releases for version 4,

### Inspecting Node.js with Chrome DevTools [#2546](https://github.com/nodejs/node/issues/2546)

Rod: Trevor is lead on this, but isn’t present. Does anyone else have any updates?

Ben: Wasn’t the last contentious issue putting WS in core? I think we agreed that if it’s not exposed to user-land, it's fine.

Alexis: (discussion of another WS issue)

Bert: we decided on this

Ben: We agreed that if it was internal, non-exposed to core, 

(Talk about native deps for WS, buffer-util can be )

Ben: if this is a private dependency, we don’t need it to be fast, so we don’t necessarily need the native deps.

Chris: (Hopped into discussion from minute-taking, hence the bad minutes)
https://github.com/nodejs/node/pull/1202 - add mask/unmask
https://github.com/nodejs/node/pull/1319 - add utf8 validator

### Umbrella Program [#2](https://github.com/nodejs/TSC/pull/2)

Ben: it’s basically a template for describing projects that are under the umbrella of the node foundation. It doesn’t look that controversial to me.

Rod: it also doesn’t look that complete.

Ben: Indeed. I suggest we discuss next week when mikeal is on the call. Seems like a rubber-stamp LGTM to me.

Rod: We should think about what projects we want to introduce to the organization, including what happens to competition in the ecosystem when we pull in things (like build tools)
Domenic: This is for things like libuv, yes?

Rod: There are already npm projects knocking on the door. One such project is request. It has its own org right now, but could work under the auspices of the node foundation. However it exists in an ecosystem where there is competition — is it okay for us to bless one project over others? NAN is sort of in the same position, it _could_ have competition. Another example is the npm client possibly. If the foundation were in a position to take npm would we even want it?

### renaming of “language groups” from iojs-\* to nodejs-\* [#2525](https://github.com/nodejs/node/issues/2525)

Steven: Looking for buyoff on this.

Ben: Seen the approach and it looks good.

Rod: You should take this as “you have authority to move ahead”.

Steven: Will do.

### Next Meeting

October 7th
