/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.thrift.TEnum;

class TEnumMap<T extends TEnum, B> {
    private final Map<T, B> tbMap = new HashMap<T, B>();
    private final Map<B, T> btMap = new HashMap<B, T>();

    public TEnumMap(Collection<Pair<T, B>> collection) {
        collection.forEach(this::put);
    }

    private void put(Pair<T, B> pair) {
        if (this.tbMap.containsKey(((Pair)pair).t) || this.btMap.containsKey(((Pair)pair).b)) {
            throw new IllegalArgumentException("Duplicate entries.");
        }
        this.tbMap.put(((Pair)pair).t, ((Pair)pair).b);
        this.btMap.put(((Pair)pair).b, ((Pair)pair).t);
    }

    public B toBdb(T t) {
        if (!this.tbMap.containsKey(t)) {
            throw new IllegalArgumentException("Unsupported value: " + t);
        }
        return this.tbMap.get(t);
    }

    public T toThrift(B b) {
        if (!this.btMap.containsKey(b)) {
            throw new IllegalArgumentException("Unsupported value: " + b);
        }
        return (T)((TEnum)this.btMap.get(b));
    }

    public static class Pair<T, B> {
        private final T t;
        private final B b;

        public Pair(T t, B b) {
            this.t = Objects.requireNonNull(t);
            this.b = Objects.requireNonNull(b);
        }
    }
}

