/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server.util;

import com.sleepycat.db.BtreeStats;
import com.sleepycat.db.CacheFilePriority;
import com.sleepycat.db.CacheFileStats;
import com.sleepycat.db.CacheStats;
import com.sleepycat.db.CompactConfig;
import com.sleepycat.db.CompactStats;
import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.DatabaseConfig;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DatabaseStats;
import com.sleepycat.db.DatabaseType;
import com.sleepycat.db.DeadlockException;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.ForeignKeyDeleteAction;
import com.sleepycat.db.HashStats;
import com.sleepycat.db.HeapFullException;
import com.sleepycat.db.HeapStats;
import com.sleepycat.db.KeyRange;
import com.sleepycat.db.LockDetectMode;
import com.sleepycat.db.LockNotGrantedException;
import com.sleepycat.db.LockStats;
import com.sleepycat.db.LogStats;
import com.sleepycat.db.MetaCheckSumFailException;
import com.sleepycat.db.MutexStats;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.QueueStats;
import com.sleepycat.db.RunRecoveryException;
import com.sleepycat.db.SecondaryConfig;
import com.sleepycat.db.SequenceConfig;
import com.sleepycat.db.TransactionConfig;
import com.sleepycat.db.TransactionStats;
import com.sleepycat.db.VersionMismatchException;
import com.sleepycat.server.util.TEnumMap;
import com.sleepycat.thrift.TActiveTxnStat;
import com.sleepycat.thrift.TBtreeStat;
import com.sleepycat.thrift.TCacheFileStat;
import com.sleepycat.thrift.TCachePriority;
import com.sleepycat.thrift.TCacheStat;
import com.sleepycat.thrift.TCompactConfig;
import com.sleepycat.thrift.TCompactResult;
import com.sleepycat.thrift.TCursorConfig;
import com.sleepycat.thrift.TDatabaseConfig;
import com.sleepycat.thrift.TDatabaseException;
import com.sleepycat.thrift.TDatabaseExceptionType;
import com.sleepycat.thrift.TDatabaseStatResult;
import com.sleepycat.thrift.TDatabaseType;
import com.sleepycat.thrift.TDbt;
import com.sleepycat.thrift.TDurabilityPolicy;
import com.sleepycat.thrift.TEnvironmentConfig;
import com.sleepycat.thrift.TFKDeleteAction;
import com.sleepycat.thrift.TFileNotFoundException;
import com.sleepycat.thrift.THashStat;
import com.sleepycat.thrift.THeapStat;
import com.sleepycat.thrift.TIOException;
import com.sleepycat.thrift.TIsolationLevel;
import com.sleepycat.thrift.TKeyRangeResult;
import com.sleepycat.thrift.TLockDetectMode;
import com.sleepycat.thrift.TLockStat;
import com.sleepycat.thrift.TLogStat;
import com.sleepycat.thrift.TMutexStat;
import com.sleepycat.thrift.TOperationStatus;
import com.sleepycat.thrift.TQueueStat;
import com.sleepycat.thrift.TRuntimeException;
import com.sleepycat.thrift.TSecondaryDatabaseConfig;
import com.sleepycat.thrift.TSequenceConfig;
import com.sleepycat.thrift.TTransactionConfig;
import com.sleepycat.thrift.TTransactionStat;
import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;

public class Adapters {
    private static TEnumMap<TLockDetectMode, LockDetectMode> lockDetectModeMap = new TEnumMap(Arrays.asList(new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.EXPIRE, LockDetectMode.EXPIRE), new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.MAX_LOCKS, LockDetectMode.MAXLOCKS), new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.MAX_WRITE, LockDetectMode.MAXWRITE), new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.MIN_LOCKS, LockDetectMode.MINLOCKS), new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.MIN_WRITE, LockDetectMode.MINWRITE), new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.OLDEST, LockDetectMode.OLDEST), new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.RANDOM, LockDetectMode.RANDOM), new TEnumMap.Pair<TLockDetectMode, LockDetectMode>(TLockDetectMode.YOUNGEST, LockDetectMode.YOUNGEST)));
    private static TEnumMap<TCachePriority, CacheFilePriority> cachePriorityMap = new TEnumMap(Arrays.asList(new TEnumMap.Pair<TCachePriority, CacheFilePriority>(TCachePriority.VERY_LOW, CacheFilePriority.VERY_LOW), new TEnumMap.Pair<TCachePriority, CacheFilePriority>(TCachePriority.LOW, CacheFilePriority.LOW), new TEnumMap.Pair<TCachePriority, CacheFilePriority>(TCachePriority.DEFAULT, CacheFilePriority.DEFAULT), new TEnumMap.Pair<TCachePriority, CacheFilePriority>(TCachePriority.HIGH, CacheFilePriority.HIGH), new TEnumMap.Pair<TCachePriority, CacheFilePriority>(TCachePriority.VERY_HIGH, CacheFilePriority.VERY_HIGH)));
    private static TEnumMap<TDatabaseType, DatabaseType> databaseTypeMap = new TEnumMap(Arrays.asList(new TEnumMap.Pair<TDatabaseType, DatabaseType>(TDatabaseType.BTREE, DatabaseType.BTREE), new TEnumMap.Pair<TDatabaseType, DatabaseType>(TDatabaseType.HASH, DatabaseType.HASH), new TEnumMap.Pair<TDatabaseType, DatabaseType>(TDatabaseType.HEAP, DatabaseType.HEAP), new TEnumMap.Pair<TDatabaseType, DatabaseType>(TDatabaseType.QUEUE, DatabaseType.QUEUE), new TEnumMap.Pair<TDatabaseType, DatabaseType>(TDatabaseType.RECNO, DatabaseType.RECNO)));
    private static TEnumMap<TFKDeleteAction, ForeignKeyDeleteAction> fkDelMap = new TEnumMap(Arrays.asList(new TEnumMap.Pair<TFKDeleteAction, ForeignKeyDeleteAction>(TFKDeleteAction.ABORT, ForeignKeyDeleteAction.ABORT), new TEnumMap.Pair<TFKDeleteAction, ForeignKeyDeleteAction>(TFKDeleteAction.CASCADE, ForeignKeyDeleteAction.CASCADE)));
    private static TEnumMap<TOperationStatus, OperationStatus> opStatusMap = new TEnumMap(Arrays.asList(new TEnumMap.Pair<TOperationStatus, OperationStatus>(TOperationStatus.KEY_EMPTY, OperationStatus.KEYEMPTY), new TEnumMap.Pair<TOperationStatus, OperationStatus>(TOperationStatus.KEY_EXIST, OperationStatus.KEYEXIST), new TEnumMap.Pair<TOperationStatus, OperationStatus>(TOperationStatus.NOT_FOUND, OperationStatus.NOTFOUND), new TEnumMap.Pair<TOperationStatus, OperationStatus>(TOperationStatus.SUCCESS, OperationStatus.SUCCESS)));

    private static LockDetectMode toBdbType(TLockDetectMode tLockDetectMode) {
        return lockDetectModeMap.toBdb(tLockDetectMode);
    }

    public static CacheFilePriority toBdbType(TCachePriority tCachePriority) {
        return cachePriorityMap.toBdb(tCachePriority);
    }

    private static DatabaseType toBdbType(TDatabaseType tDatabaseType) {
        return databaseTypeMap.toBdb(tDatabaseType);
    }

    public static EnvironmentConfig toBdbType(TEnvironmentConfig tEnvironmentConfig) {
        return Adapters.update(new EnvironmentConfig(), tEnvironmentConfig);
    }

    public static EnvironmentConfig update(EnvironmentConfig environmentConfig2, TEnvironmentConfig tEnvironmentConfig) {
        HashMap<TEnvironmentConfig._Fields, BiConsumer<EnvironmentConfig, Object>> hashMap = new HashMap<TEnvironmentConfig._Fields, BiConsumer<EnvironmentConfig, Object>>();
        hashMap.put(TEnvironmentConfig._Fields.DURABILITY, (environmentConfig, object) -> {
            environmentConfig.setTxnNoSync(object == TDurabilityPolicy.NO_SYNC);
            environmentConfig.setTxnWriteNoSync(object == TDurabilityPolicy.WRITE_NO_SYNC);
        });
        hashMap.put(TEnvironmentConfig._Fields.ENCRYPTION_KEY, (environmentConfig, object) -> environmentConfig.setEncrypted((String)object));
        hashMap.put(TEnvironmentConfig._Fields.LOCK_DETECT_MODE, (environmentConfig, object) -> environmentConfig.setLockDetectMode(Adapters.toBdbType((TLockDetectMode)object)));
        return (EnvironmentConfig)Adapters.updateBdbObject((Object)environmentConfig2, (TBase)tEnvironmentConfig, (TFieldIdEnum[])TEnvironmentConfig._Fields.values(), hashMap);
    }

    public static DatabaseConfig toBdbType(TDatabaseConfig tDatabaseConfig) {
        return Adapters.update(new DatabaseConfig(), tDatabaseConfig);
    }

    public static DatabaseConfig update(DatabaseConfig databaseConfig2, TDatabaseConfig tDatabaseConfig) {
        HashMap<TDatabaseConfig._Fields, BiConsumer<DatabaseConfig, Object>> hashMap = new HashMap<TDatabaseConfig._Fields, BiConsumer<DatabaseConfig, Object>>();
        hashMap.put(TDatabaseConfig._Fields.HEAP_REGION_SIZE, (databaseConfig, object) -> databaseConfig.setHeapRegionSize(((Integer)object).intValue()));
        hashMap.put(TDatabaseConfig._Fields.PRIORITY, (databaseConfig, object) -> databaseConfig.setPriority(Adapters.toBdbType((TCachePriority)object)));
        hashMap.put(TDatabaseConfig._Fields.TYPE, (databaseConfig, object) -> databaseConfig.setType(Adapters.toBdbType((TDatabaseType)object)));
        return (DatabaseConfig)Adapters.updateBdbObject((Object)databaseConfig2, (TBase)tDatabaseConfig, (TFieldIdEnum[])TDatabaseConfig._Fields.values(), hashMap);
    }

    public static SecondaryConfig toBdbType(TSecondaryDatabaseConfig tSecondaryDatabaseConfig) {
        HashMap<TSecondaryDatabaseConfig._Fields, BiConsumer<SecondaryConfig, Object>> hashMap = new HashMap<TSecondaryDatabaseConfig._Fields, BiConsumer<SecondaryConfig, Object>>();
        hashMap.put(TSecondaryDatabaseConfig._Fields.DB_CONFIG, (secondaryConfig, object) -> Adapters.update((DatabaseConfig)secondaryConfig, (TDatabaseConfig)object));
        hashMap.put(TSecondaryDatabaseConfig._Fields.FOREIGN_DB, (secondaryConfig, object) -> {});
        hashMap.put(TSecondaryDatabaseConfig._Fields.FOREIGN_KEY_DELETE_ACTION, (secondaryConfig, object) -> secondaryConfig.setForeignKeyDeleteAction(fkDelMap.toBdb((TFKDeleteAction)object)));
        return (SecondaryConfig)Adapters.updateBdbObject((Object)new SecondaryConfig(), (TBase)tSecondaryDatabaseConfig, (TFieldIdEnum[])TSecondaryDatabaseConfig._Fields.values(), hashMap);
    }

    public static TransactionConfig toBdbType(TTransactionConfig tTransactionConfig) {
        HashMap<TTransactionConfig._Fields, BiConsumer<TransactionConfig, Object>> hashMap = new HashMap<TTransactionConfig._Fields, BiConsumer<TransactionConfig, Object>>();
        hashMap.put(TTransactionConfig._Fields.DURABILITY, (transactionConfig, object) -> {
            transactionConfig.setNoSync(object == TDurabilityPolicy.NO_SYNC);
            transactionConfig.setSync(object == TDurabilityPolicy.SYNC);
            transactionConfig.setWriteNoSync(object == TDurabilityPolicy.WRITE_NO_SYNC);
        });
        hashMap.put(TTransactionConfig._Fields.ISO_LEVEL, (transactionConfig, object) -> {
            transactionConfig.setReadCommitted(object == TIsolationLevel.READ_COMMITTED);
            transactionConfig.setReadUncommitted(object == TIsolationLevel.READ_UNCOMMITTED);
            transactionConfig.setSnapshot(object == TIsolationLevel.SNAPSHOT);
        });
        return (TransactionConfig)Adapters.updateBdbObject((Object)new TransactionConfig(), (TBase)tTransactionConfig, (TFieldIdEnum[])TTransactionConfig._Fields.values(), hashMap);
    }

    public static CompactConfig toBdbType(TCompactConfig tCompactConfig) {
        return (CompactConfig)Adapters.updateBdbObject((Object)new CompactConfig(), (TBase)tCompactConfig, (TFieldIdEnum[])TCompactConfig._Fields.values(), null);
    }

    public static CursorConfig toBdbType(TCursorConfig tCursorConfig) {
        HashMap<TCursorConfig._Fields, BiConsumer<CursorConfig, Object>> hashMap = new HashMap<TCursorConfig._Fields, BiConsumer<CursorConfig, Object>>();
        hashMap.put(TCursorConfig._Fields.ISO_LEVEL, (cursorConfig, object) -> {
            cursorConfig.setReadCommitted(object == TIsolationLevel.READ_COMMITTED);
            cursorConfig.setReadUncommitted(object == TIsolationLevel.READ_UNCOMMITTED);
            cursorConfig.setSnapshot(object == TIsolationLevel.SNAPSHOT);
        });
        return (CursorConfig)Adapters.updateBdbObject((Object)new CursorConfig(), (TBase)tCursorConfig, (TFieldIdEnum[])TCursorConfig._Fields.values(), hashMap);
    }

    public static SequenceConfig toBdbType(TSequenceConfig tSequenceConfig) {
        HashMap<TSequenceConfig._Fields, BiConsumer<SequenceConfig, Object>> hashMap = new HashMap<TSequenceConfig._Fields, BiConsumer<SequenceConfig, Object>>();
        hashMap.put(TSequenceConfig._Fields.MAXIMUM, (sequenceConfig, object) -> sequenceConfig.setRange(sequenceConfig.getRangeMin(), ((Long)object).longValue()));
        hashMap.put(TSequenceConfig._Fields.MINIMUM, (sequenceConfig, object) -> sequenceConfig.setRange(((Long)object).longValue(), sequenceConfig.getRangeMax()));
        return (SequenceConfig)Adapters.updateBdbObject((Object)new SequenceConfig(), (TBase)tSequenceConfig, (TFieldIdEnum[])TSequenceConfig._Fields.values(), hashMap);
    }

    public static DatabaseEntry toBdbType(TDbt tDbt) {
        return (DatabaseEntry)Adapters.updateBdbObject((Object)new DatabaseEntry(), (TBase)tDbt, (TFieldIdEnum[])TDbt._Fields.values(), null);
    }

    private static TLockDetectMode toThriftType(LockDetectMode lockDetectMode) {
        return lockDetectModeMap.toThrift(lockDetectMode);
    }

    public static TCachePriority toThriftType(CacheFilePriority cacheFilePriority) {
        return cachePriorityMap.toThrift(cacheFilePriority);
    }

    private static TDatabaseType toThriftType(DatabaseType databaseType) {
        return databaseTypeMap.toThrift(databaseType);
    }

    public static TEnvironmentConfig toThriftType(EnvironmentConfig environmentConfig3) {
        HashMap<TEnvironmentConfig._Fields, Function<EnvironmentConfig, Object>> hashMap = new HashMap<TEnvironmentConfig._Fields, Function<EnvironmentConfig, Object>>();
        hashMap.put(TEnvironmentConfig._Fields.ENCRYPTION_KEY, environmentConfig -> null);
        hashMap.put(TEnvironmentConfig._Fields.LOCK_DETECT_MODE, environmentConfig -> Adapters.toThriftType(environmentConfig.getLockDetectMode()));
        hashMap.put(TEnvironmentConfig._Fields.DURABILITY, environmentConfig2 -> {
            if (environmentConfig3.getTxnNoSync()) {
                return TDurabilityPolicy.NO_SYNC;
            }
            if (environmentConfig2.getTxnWriteNoSync()) {
                return TDurabilityPolicy.WRITE_NO_SYNC;
            }
            return TDurabilityPolicy.SYNC;
        });
        return (TEnvironmentConfig)Adapters.updateThriftObject((TBase)new TEnvironmentConfig(), (Object)environmentConfig3, (TFieldIdEnum[])TEnvironmentConfig._Fields.values(), hashMap);
    }

    public static TDatabaseConfig toThriftType(DatabaseConfig databaseConfig2) {
        HashMap<TDatabaseConfig._Fields, Function<DatabaseConfig, Object>> hashMap = new HashMap<TDatabaseConfig._Fields, Function<DatabaseConfig, Object>>();
        hashMap.put(TDatabaseConfig._Fields.HEAP_REGION_SIZE, databaseConfig -> (int)databaseConfig.getHeapRegionSize());
        hashMap.put(TDatabaseConfig._Fields.PRIORITY, databaseConfig -> Adapters.toThriftType(databaseConfig.getPriority()));
        hashMap.put(TDatabaseConfig._Fields.TYPE, databaseConfig -> Adapters.toThriftType(databaseConfig.getType()));
        return (TDatabaseConfig)Adapters.updateThriftObject((TBase)new TDatabaseConfig(), (Object)databaseConfig2, (TFieldIdEnum[])TDatabaseConfig._Fields.values(), hashMap);
    }

    public static TDbt toThriftType(DatabaseEntry databaseEntry, boolean bl) {
        TDbt tDbt = new TDbt();
        if (bl) {
            return tDbt.setRecordNumber(databaseEntry.getRecordNumber());
        }
        int n = databaseEntry.getOffset();
        int n2 = n + databaseEntry.getSize();
        return tDbt.setData(Arrays.copyOfRange(databaseEntry.getData(), n, n2));
    }

    public static TOperationStatus toThriftType(OperationStatus operationStatus) {
        return opStatusMap.toThrift(operationStatus);
    }

    public static TKeyRangeResult toThriftType(KeyRange keyRange) {
        return new TKeyRangeResult().setEqual(keyRange.equal).setGreater(keyRange.greater).setLess(keyRange.less);
    }

    public static TCursorConfig toThriftType(CursorConfig cursorConfig2) {
        HashMap<TCursorConfig._Fields, Function<CursorConfig, Object>> hashMap = new HashMap<TCursorConfig._Fields, Function<CursorConfig, Object>>();
        hashMap.put(TCursorConfig._Fields.ISO_LEVEL, cursorConfig -> {
            if (cursorConfig.getReadCommitted()) {
                return TIsolationLevel.READ_COMMITTED;
            }
            if (cursorConfig.getReadUncommitted()) {
                return TIsolationLevel.READ_UNCOMMITTED;
            }
            if (cursorConfig.getSnapshot()) {
                return TIsolationLevel.SNAPSHOT;
            }
            return null;
        });
        return (TCursorConfig)Adapters.updateThriftObject((TBase)new TCursorConfig(), (Object)cursorConfig2, (TFieldIdEnum[])TCursorConfig._Fields.values(), hashMap);
    }

    public static TCompactResult toThriftType(CompactStats compactStats2) {
        return (TCompactResult)Adapters.updateThriftObject((TBase)new TCompactResult(), (Object)compactStats2, (TFieldIdEnum[])TCompactResult._Fields.values(), Collections.singletonMap(TCompactResult._Fields.END_KEY, compactStats -> null));
    }

    public static TCacheStat toThriftType(CacheStats cacheStats) {
        return (TCacheStat)Adapters.updateThriftObject((TBase)new TCacheStat(), (Object)cacheStats, (TFieldIdEnum[])TCacheStat._Fields.values(), Collections.singletonMap(TCacheStat._Fields.PAGE_MAPPED, CacheStats::getMap));
    }

    public static TCacheFileStat toThriftType(CacheFileStats cacheFileStats) {
        return (TCacheFileStat)Adapters.updateThriftObject((TBase)new TCacheFileStat(), (Object)cacheFileStats, (TFieldIdEnum[])TCacheFileStat._Fields.values(), Collections.singletonMap(TCacheFileStat._Fields.PAGE_MAPPED, CacheFileStats::getMap));
    }

    public static TLockStat toThriftType(LockStats lockStats) {
        return (TLockStat)Adapters.updateThriftObject((TBase)new TLockStat(), (Object)lockStats, (TFieldIdEnum[])TLockStat._Fields.values(), null);
    }

    public static TLogStat toThriftType(LogStats logStats) {
        return (TLogStat)Adapters.updateThriftObject((TBase)new TLogStat(), (Object)logStats, (TFieldIdEnum[])TLogStat._Fields.values(), null);
    }

    public static TMutexStat toThriftType(MutexStats mutexStats) {
        return (TMutexStat)Adapters.updateThriftObject((TBase)new TMutexStat(), (Object)mutexStats, (TFieldIdEnum[])TMutexStat._Fields.values(), null);
    }

    public static TActiveTxnStat toThriftType(TransactionStats.Active active2) {
        HashMap<TActiveTxnStat._Fields, Function<TransactionStats.Active, Object>> hashMap = new HashMap<TActiveTxnStat._Fields, Function<TransactionStats.Active, Object>>();
        hashMap.put(TActiveTxnStat._Fields.LSN_FILE, active -> active.getLsn().getFile());
        hashMap.put(TActiveTxnStat._Fields.LSN_OFFSET, active -> active.getLsn().getOffset());
        hashMap.put(TActiveTxnStat._Fields.READ_LSN_FILE, active -> active.getReadLsn().getFile());
        hashMap.put(TActiveTxnStat._Fields.READ_LSN_OFFSET, active -> active.getReadLsn().getOffset());
        return (TActiveTxnStat)Adapters.updateThriftObject((TBase)new TActiveTxnStat(), (Object)active2, (TFieldIdEnum[])TActiveTxnStat._Fields.values(), hashMap);
    }

    public static TTransactionStat toThriftType(TransactionStats transactionStats2) {
        HashMap<TTransactionStat._Fields, Function<TransactionStats, Object>> hashMap = new HashMap<TTransactionStat._Fields, Function<TransactionStats, Object>>();
        hashMap.put(TTransactionStat._Fields.LAST_CKP_FILE, transactionStats -> transactionStats.getLastCkp().getFile());
        hashMap.put(TTransactionStat._Fields.LAST_CKP_OFFSET, transactionStats -> transactionStats.getLastCkp().getOffset());
        hashMap.put(TTransactionStat._Fields.ACTIVE_TXNS, transactionStats -> Arrays.stream(transactionStats.getTxnarray()).map(Adapters::toThriftType).collect(Collectors.toList()));
        return (TTransactionStat)Adapters.updateThriftObject((TBase)new TTransactionStat(), (Object)transactionStats2, (TFieldIdEnum[])TTransactionStat._Fields.values(), hashMap);
    }

    public static TDatabaseStatResult toThriftType(DatabaseStats databaseStats) {
        TDatabaseStatResult tDatabaseStatResult = new TDatabaseStatResult();
        if (databaseStats instanceof BtreeStats) {
            return tDatabaseStatResult.setBtreeStat(Adapters.toThriftType((BtreeStats)databaseStats));
        }
        if (databaseStats instanceof HashStats) {
            return tDatabaseStatResult.setHashStat(Adapters.toThriftType((HashStats)databaseStats));
        }
        if (databaseStats instanceof HeapStats) {
            return tDatabaseStatResult.setHeapStat(Adapters.toThriftType((HeapStats)databaseStats));
        }
        if (databaseStats instanceof QueueStats) {
            return tDatabaseStatResult.setQueueStat(Adapters.toThriftType((QueueStats)databaseStats));
        }
        return tDatabaseStatResult;
    }

    public static TBtreeStat toThriftType(BtreeStats btreeStats) {
        return (TBtreeStat)Adapters.updateThriftObject((TBase)new TBtreeStat(), (Object)btreeStats, (TFieldIdEnum[])TBtreeStat._Fields.values(), null);
    }

    public static THashStat toThriftType(HashStats hashStats) {
        return (THashStat)Adapters.updateThriftObject((TBase)new THashStat(), (Object)hashStats, (TFieldIdEnum[])THashStat._Fields.values(), null);
    }

    public static THeapStat toThriftType(HeapStats heapStats) {
        return (THeapStat)Adapters.updateThriftObject((TBase)new THeapStat(), (Object)heapStats, (TFieldIdEnum[])THeapStat._Fields.values(), null);
    }

    public static TQueueStat toThriftType(QueueStats queueStats) {
        return (TQueueStat)Adapters.updateThriftObject((TBase)new TQueueStat(), (Object)queueStats, (TFieldIdEnum[])TQueueStat._Fields.values(), null);
    }

    public static TException toThriftType(Exception exception) {
        if (exception instanceof RuntimeException) {
            return new TRuntimeException(exception.getClass().getName(), exception.getMessage());
        }
        if (exception instanceof DatabaseException) {
            TDatabaseExceptionType tDatabaseExceptionType = TDatabaseExceptionType.DATABASE;
            if (exception instanceof LockNotGrantedException) {
                tDatabaseExceptionType = TDatabaseExceptionType.LOCK_NOT_GRANTED;
            } else if (exception instanceof DeadlockException) {
                tDatabaseExceptionType = TDatabaseExceptionType.DEADLOCK;
            } else if (exception instanceof HeapFullException) {
                tDatabaseExceptionType = TDatabaseExceptionType.HEAP_FULL;
            } else if (exception instanceof MetaCheckSumFailException) {
                tDatabaseExceptionType = TDatabaseExceptionType.META_CHECKSUM_FAIL;
            } else if (exception instanceof RunRecoveryException) {
                tDatabaseExceptionType = TDatabaseExceptionType.RUN_RECOVERY;
            } else if (exception instanceof VersionMismatchException) {
                tDatabaseExceptionType = TDatabaseExceptionType.VERSION_MISMATCH;
            }
            TDatabaseException tDatabaseException = new TDatabaseException(tDatabaseExceptionType, exception.getMessage());
            tDatabaseException.setErrorNumber(((DatabaseException)((Object)exception)).getErrno());
            return tDatabaseException;
        }
        if (exception instanceof FileNotFoundException) {
            return new TFileNotFoundException(exception.getMessage());
        }
        if (exception instanceof IOException) {
            return new TIOException(exception.getMessage());
        }
        if (exception instanceof TException) {
            return (TException)exception;
        }
        throw new IllegalArgumentException("Unknown exception type.", exception);
    }

    private static <F extends TFieldIdEnum, B> B updateBdbObject(B b, TBase<?, F> tBase, F[] FArray, Map<F, BiConsumer<B, Object>> map) {
        if (tBase == null) {
            return b;
        }
        try {
            Map<String, PropertyDescriptor> map2 = Adapters.getProperties(b);
            for (F f : FArray) {
                if (!tBase.isSet(f)) continue;
                Object object = tBase.getFieldValue(f);
                if (map != null && map.containsKey(f)) {
                    map.get(f).accept(b, object);
                    continue;
                }
                PropertyDescriptor propertyDescriptor = map2.get(f.getFieldName());
                propertyDescriptor.getWriteMethod().invoke(b, object);
            }
            return b;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static <T extends TBase<?, F>, F extends TFieldIdEnum, B> T updateThriftObject(T t, B b, F[] FArray, Map<F, Function<B, ?>> map) {
        try {
            Map<String, PropertyDescriptor> map2 = Adapters.getProperties(b);
            for (F f : FArray) {
                Object object;
                if (map != null && map.containsKey(f)) {
                    object = map.get(f).apply(b);
                } else {
                    PropertyDescriptor propertyDescriptor = map2.get(f.getFieldName());
                    object = propertyDescriptor.getReadMethod().invoke(b, new Object[0]);
                }
                t.setFieldValue(f, object);
            }
            return t;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private static Map<String, PropertyDescriptor> getProperties(Object object) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        return Arrays.stream(beanInfo.getPropertyDescriptors()).collect(Collectors.toMap(FeatureDescriptor::getName, Function.identity()));
    }
}

