/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.server;

import com.sleepycat.server.BdbServiceHandler;
import com.sleepycat.server.config.BdbServerCmdOptions;
import com.sleepycat.server.config.BdbServerConfig;
import com.sleepycat.server.config.BdbServiceConfig;
import com.sleepycat.server.util.FileUtils;
import com.sleepycat.thrift.BdbService;
import java.io.FileReader;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Properties;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.thrift.TProcessor;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TTransportException;

public class BdbServer {
    public static final String VERSION = "6.2.23";

    public static void main(String[] stringArray) {
        try {
            BdbServerCmdOptions bdbServerCmdOptions = BdbServerCmdOptions.parse(stringArray);
            DOMConfigurator.configure((String)bdbServerCmdOptions.getLog4jConfig());
            Properties properties = BdbServer.loadProperties(bdbServerCmdOptions.getConfigFile());
            BdbServerConfig bdbServerConfig = new BdbServerConfig(properties);
            BdbServiceConfig bdbServiceConfig = new BdbServiceConfig(properties);
            bdbServiceConfig.initRootDirs();
            BdbServiceHandler bdbServiceHandler = new BdbServiceHandler();
            TServer tServer = BdbServer.createServer(bdbServerConfig, bdbServiceHandler);
            bdbServiceHandler.setServerAndConfig(tServer, bdbServiceConfig);
            BdbServer.shutdownHook(bdbServiceHandler);
            System.out.println("Starting to listen on " + bdbServerConfig.getPort());
            tServer.serve();
        }
        catch (Exception exception) {
            BdbServer.exit("", exception);
        }
    }

    private static Properties loadProperties(String string) {
        Properties properties = new Properties();
        try (FileReader fileReader = new FileReader(string);){
            if (FileUtils.hasAnyPermission(string, PosixFilePermission.OTHERS_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_WRITE)) {
                BdbServer.exit("The properties file '" + string + "' must not be globally accessible.", null);
            }
            properties.load(fileReader);
        }
        catch (IOException iOException) {
            BdbServer.exit("Failed to load '" + string + "'. ", iOException);
        }
        return properties;
    }

    private static TServer createServer(BdbServerConfig bdbServerConfig, BdbServiceHandler bdbServiceHandler) {
        BdbService.Processor processor = new BdbService.Processor((BdbService.Iface)bdbServiceHandler);
        TProcessorFactory tProcessorFactory = new TProcessorFactory((TProcessor)processor);
        TServer tServer = null;
        try {
            tServer = bdbServerConfig.createServer(tProcessorFactory);
        }
        catch (UnknownHostException | TTransportException throwable) {
            BdbServer.exit("Failed to start server. ", (Exception)throwable);
        }
        return tServer;
    }

    private static void shutdownHook(BdbServiceHandler bdbServiceHandler) {
        Runtime.getRuntime().addShutdownHook(new Thread(bdbServiceHandler::shutdown));
    }

    private static void exit(String string, Exception exception) {
        System.err.println(string + (exception == null ? "" : exception.getMessage()));
        System.exit(-1);
    }
}

