/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebKitDOMTestException.h"

#include "CSSImportRule.h"
#include "DOMObjectCache.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTestExceptionPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_TEST_EXCEPTION_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_TEST_EXCEPTION, WebKitDOMTestExceptionPrivate)

typedef struct _WebKitDOMTestExceptionPrivate {
    RefPtr<WebCore::TestException> coreObject;
} WebKitDOMTestExceptionPrivate;

namespace WebKit {

WebKitDOMTestException* kit(WebCore::TestException* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_TEST_EXCEPTION(ret);

    return wrapTestException(obj);
}

WebCore::TestException* core(WebKitDOMTestException* request)
{
    return request ? static_cast<WebCore::TestException*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMTestException* wrapTestException(WebCore::TestException* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEST_EXCEPTION(g_object_new(WEBKIT_TYPE_DOM_TEST_EXCEPTION, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMTestException, webkit_dom_test_exception, WEBKIT_TYPE_DOM_OBJECT)

enum {
    PROP_0,
    PROP_NAME,
};

static void webkit_dom_test_exception_finalize(GObject* object)
{
    WebKitDOMTestExceptionPrivate* priv = WEBKIT_DOM_TEST_EXCEPTION_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMTestExceptionPrivate();
    G_OBJECT_CLASS(webkit_dom_test_exception_parent_class)->finalize(object);
}

static void webkit_dom_test_exception_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;
    WebKitDOMTestException* self = WEBKIT_DOM_TEST_EXCEPTION(object);
    WebCore::TestException* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->name()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static GObject* webkit_dom_test_exception_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_test_exception_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMTestExceptionPrivate* priv = WEBKIT_DOM_TEST_EXCEPTION_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::TestException*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_test_exception_class_init(WebKitDOMTestExceptionClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMTestExceptionPrivate));
    gobjectClass->constructor = webkit_dom_test_exception_constructor;
    gobjectClass->finalize = webkit_dom_test_exception_finalize;
    gobjectClass->get_property = webkit_dom_test_exception_get_property;

    g_object_class_install_property(
        gobjectClass,
        PROP_NAME,
        g_param_spec_string(
            "name",
            "TestException:name",
            "read-only gchar* TestException:name",
            "",
            WEBKIT_PARAM_READABLE));

}

static void webkit_dom_test_exception_init(WebKitDOMTestException* request)
{
    WebKitDOMTestExceptionPrivate* priv = WEBKIT_DOM_TEST_EXCEPTION_GET_PRIVATE(request);
    new (priv) WebKitDOMTestExceptionPrivate();
}

gchar* webkit_dom_test_exception_get_name(WebKitDOMTestException* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEST_EXCEPTION(self), 0);
    WebCore::TestException* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->name());
    return result;
}

