/*
 * Copyright (C) 2014 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS
 * IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from generate-enums-with-same-base-name.json
// by the script: JavaScriptCore/replay/scripts/CodeGeneratorReplayInputs.py

#ifndef generate_enums_with_same_base_name_json_TestReplayInputs_h
#define generate_enums_with_same_base_name_json_TestReplayInputs_h

#if ENABLE(WEB_REPLAY)
#include "InternalNamespaceHeaderIncludeDummy.h"
#include <platform/ExternalNamespaceHeaderIncludeDummy.h>
#include <replay/FormData.h>
#include <replay/PlatformEvent.h>



namespace Test {
class FormCombo;
} // namespace Test

namespace JSC {
template<> struct InputTraits<Test::FormCombo> {
    static InputQueue queue() { return InputQueue::ScriptMemoizedData; }
    static const AtomicString& type();

    static void encode(JSC::EncodedValue&, const Test::FormCombo&);
    static bool decode(JSC::EncodedValue&, std::unique_ptr<Test::FormCombo>&);
};
template<> struct EncodingTraits<WebCore::FormData::Type> {
    typedef WebCore::FormData::Type DecodedType;

    static EncodedValue encodeValue(const WebCore::FormData::Type& value);
    static bool decodeValue(EncodedValue&, WebCore::FormData::Type& value);
};

template<> struct EncodingTraits<PlatformEvent::Type> {
    typedef PlatformEvent::Type DecodedType;

    static EncodedValue encodeValue(const PlatformEvent::Type& value);
    static bool decodeValue(EncodedValue&, PlatformEvent::Type& value);
};
} // namespace JSC

namespace Test {
class FormCombo : public NondeterministicInput<FormCombo> {
public:
    FormCombo(PlatformEvent::Type eventType, FormData::Type formType);
    virtual ~FormCombo();

    PlatformEvent::Type eventType() const { return m_eventType; }
    FormData::Type formType() const { return m_formType; }
private:
    PlatformEvent::Type m_eventType;
    FormData::Type m_formType;
};
} // namespace Test

#define TEST_REPLAY_INPUT_NAMES_FOR_EACH(macro) \
    macro(FormCombo) \
    \
// end of TEST_REPLAY_INPUT_NAMES_FOR_EACH

#endif // ENABLE(WEB_REPLAY)

#endif // generate-enums-with-same-base-name.json-TestReplayInputs_h
