Name
====

ngx_rds_json - an output filter that formats Resty DBD Streams generated by ngx_drizzle and others to JSON

Table of Contents
=================

* [Name](#name)
* [Status](#status)
* [Synopsis](#synopsis)
* [Description](#description)
* [Directives](#directives)
    * [rds_json](#rds_json)
    * [rds_json_buffer_size](#rds_json_buffer_size)
    * [rds_json_format](#rds_json_format)
    * [rds_json_root](#rds_json_root)
    * [rds_json_success_property](#rds_json_success_property)
    * [rds_json_user_property](#rds_json_user_property)
    * [rds_json_errcode_key](#rds_json_errcode_key)
    * [rds_json_errstr_key](#rds_json_errstr_key)
    * [rds_json_ret](#rds_json_ret)
    * [rds_json_content_type](#rds_json_content_type)
* [Installation](#installation)
* [Compatibility](#compatibility)
* [Author](#author)
* [Copyright & License](#copyright--license)
* [See Also](#see-also)

Status
======

This module is considered production ready.

We need your help! If you find this module useful and/or interesting, please consider joining the development!
Commit bit can be freely delivered at your request ;)

Synopsis
========

```nginx
server {
    location /mysql {
        drizzle_query 'select * from cats';
        drizzle_pass my_mysql_upstream;

        rds_json on;
    }

    location /foo {
        if ($arg_limit !~ '^\d{2}$') {
            rds_json_ret 400 'Bad "limit" argument';
        }

        drizzle_query "select * from dogs limit $arg_limit";
        drizzle_pass my_mysql_upstream;

        rds_json on;
    }
    ...
}
```

Description
===========

This module provides an output filter that can format the RDS outputs
generated by [ngx_drizzle](https://github.com/openresty/drizzle-nginx-module)
and [ngx_postgres](https://github.com/FRiCKLE/ngx_postgres/) modules to JSON.

[Back to TOC](#table-of-contents)

Directives
==========

[Back to TOC](#table-of-contents)

rds_json
--------
**syntax:** *rds_json  on|off*

**default:** *rds_json off*

Enables or disables the output filter of this module.

[Back to TOC](#table-of-contents)

rds_json_buffer_size
--------------------
**syntax:** *rds_json_buffer_size   &lt;bytes&gt;*

**default:** *rds_json_buffer_size &lt;page-size&gt;*

Controls the buffer size used by this module. default to the page size (4k/8k).
The bigger the buffer size, the less streammy the conversion
will be. But usually increasing the buffer size
does help reduce CPU time.

[Back to TOC](#table-of-contents)

rds_json_format
---------------
**syntax:** *rds_json_format  normal|compact*

**default:** *rds_json_format normal*

Controls the output JSON format. A sample of the default "normal" format
looks like this

```json
 [{"id":1,"name":"marry"},{"id":2,"name":"bob"}]
```

while it looks like below when in the "compact" format

```json
 [["id","name"],[1,"marry"],[2,"bob"]]
```

that is, the first row holds the column name list.

[Back to TOC](#table-of-contents)

rds_json_root
-------------
**syntax:** *rds_json_root &lt;key&gt;*

**default:** *no*

Specifies the "root" key for data rows (if any). For example,

```nginx
 rds_json on;
 rds_json_root rows;
```

will return JSON output like this:

```json
 {"rows":[{"id":2,"name":null},{"id":3,"name":"bob"}]}
```

if `rds_json_format compact` is also specified, then the
output will look like this:

```json
 {"rows":[["id","name"],[2,null],[3,"bob"]]}
```

Nginx variables are not supported in the <key> argument of
this directive.

If this directive is not defined, neither are [rds_json_success_property](#rds_json_success_property),
nor [rds_json_user_property](#rds_json_user_property), the JSON output for select queries will
just be an array at the top level.

When either [rds_json_success_property](#rds_json_success_property) or [rds_json_user_property](#rds_json_user_property) are specified,
this directive takes a default argument of "data".

[Back to TOC](#table-of-contents)

rds_json_success_property
-------------------------
**syntax:** *rds_json_success_property &lt;key&gt;*

**default:** *no*

Specifies the top-level object property name used in the JSON output
for indicating success or false of the query.

[Back to TOC](#table-of-contents)

rds_json_user_property
-----------------------
**syntax:** *rds_json_user_property &lt;key&gt; &lt;value&gt;*

**default:** *no*

Specifies additonal user properties for the top-level object
of the JSON output.

Multiple instances of this directives are allowed in a single scope.

Nginx variables are supported in the `value` argument.

Both of the `key` and `value` arguments will be automatically
quoted according to JSON strings' notation.

[Back to TOC](#table-of-contents)

rds_json_errcode_key
---------------------
**syntax:** *rds_json_errcode_key &lt;key&gt;*

**default:** *rds_json_errcode_key errcode*

Specifies the errcode key name used in the JSON output.

[Back to TOC](#table-of-contents)

rds_json_errstr_key
-------------------
**syntax:** *rds_json_errstr_key &lt;key&gt;*

**default:** *rds_json_errstr_key errstr*

Specifies the errstr key name used in the JSON output.

[Back to TOC](#table-of-contents)

rds_json_ret
------------
**syntax:** *rds_json_ret &lt;error-code&gt; &lt;descrption&gt;*

**default:** *no*

This directive enables a content handler that simply emits
an response body like this:

```json
 {"errcode":<error-code>,"errstr":"<description>"}
```

while the `<description>` string will be properly quoted as
a JSON string.

[Back to TOC](#table-of-contents)

rds_json_content_type
---------------------
**syntax:** *rds_json_content_type &lt;mime-type&gt;*

**default:** *rds_json_content_type application/json*

Controls the `Content-Type` header of the response generated by
this module's output filter.

[Back to TOC](#table-of-contents)

Installation
============

You're recommended to install this module (as well as the Nginx core and many other goodies) via the [ngx_openresty bundle](http://openresty.org). See [the detailed instructions](http://openresty.org/#Installation) for downloading and installing ngx_openresty into your system. This is the easiest and most safe way to set things up.

Alternatively, you can install this module manually with the Nginx source:

Grab the nginx source code from [nginx.org](http://nginx.org/), for example,
the version 1.7.10 (see [nginx compatibility](#compatibility)), and then build the source with this module:

```bash

 $ wget 'http://nginx.org/download/nginx-1.7.10.tar.gz'
 $ tar -xzvf nginx-1.7.10.tar.gz
 $ cd nginx-1.7.10/

 # Here we assume you would install you nginx under /opt/nginx/.
 $ ./configure --prefix=/opt/nginx \
     --add-module=/path/to/rds-json-nginx-module

 $ make -j2
 $ make install
```

ownload the latest version of the release tarball of this module from [echo-nginx-module file list](https://github.com/agentzh/echo-nginx-module/tags).

Also, this module is included and enabled by default in the [ngx_openresty bundle](http://openresty.org).

[Back to TOC](#table-of-contents)

Compatibility
=============
The following versions of Nginx should work with this module:

* **1.7.x** (last tested: 1.7.10)
* **1.6.x**
* **1.5.x** (last tested: 1.5.12)
* **1.4.x** (last tested: 1.4.4)
* **1.2.x** (last tested: 1.2.9)
* **1.1.x** (last tested: 1.1.5)
* **1.0.x** (last tested: 1.0.9)
* **0.9.x** (last tested: 0.9.4)
* **0.8.x** (last tested: 0.8.55)
* **0.7.x >= 0.7.46** (last tested: 0.7.68)

Earlier versions of Nginx like 0.6.x and 0.5.x will *not* work.

If you find that any particular version of Nginx above 0.7.44 does not
work with this module, please consider reporting a bug.

[Back to TOC](#table-of-contents)

Author
======
Yichun "agentzh" Zhang (章亦春) *&lt;agentzh@gmail.com&gt;*, CloudFlare Inc.

[Back to TOC](#table-of-contents)

Copyright & License
===================

This module is licenced under the BSD license.

Copyright (C) 2009-2015, Yichun Zhang (agentzh) &lt;agentzh@gmail.com&gt;, CloudFlare Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
notice, this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright
notice, this list of conditions and the following disclaimer in the
documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

[Back to TOC](#table-of-contents)

See Also
========

* [ngx_drizzle](https://github.com/openresty/drizzle-nginx-module)
* [ngx_postgres](https://github.com/FRiCKLE/ngx_postgres/)
* [ngx_rds_csv](https://github.com/openresty/rds-csv-nginx-module)

[Back to TOC](#table-of-contents)

