static const char* edge_laplace_cl_source =
"#define LAPLACE_RADIUS 2                                                      \n"
"#define EPSILON        1e-5f                                                  \n"
"                                                                              \n"
"void minmax(float x1, float x2, float x3,                                     \n"
"            float x4, float x5,                                               \n"
"            float *min_result,                                                \n"
"            float *max_result)                                                \n"
"{                                                                             \n"
"    float min1, min2, max1, max2;                                             \n"
"                                                                              \n"
"    if (x1 > x2)                                                              \n"
"    {                                                                         \n"
"        max1 = x1;                                                            \n"
"        min1 = x2;                                                            \n"
"    }                                                                         \n"
"    else                                                                      \n"
"    {                                                                         \n"
"        max1 = x2;                                                            \n"
"        min1 = x1;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"    if (x3 > x4)                                                              \n"
"    {                                                                         \n"
"        max2 = x3;                                                            \n"
"        min2 = x4;                                                            \n"
"    }                                                                         \n"
"    else                                                                      \n"
"    {                                                                         \n"
"        max2 = x4;                                                            \n"
"        min2 = x3;                                                            \n"
"    }                                                                         \n"
"                                                                              \n"
"    if (min1 < min2)                                                          \n"
"        *min_result = fmin(min1, x5);                                         \n"
"    else                                                                      \n"
"        *min_result = fmin(min2, x5);                                         \n"
"    if (max1 > max2)                                                          \n"
"        *max_result = fmax(max1, x5);                                         \n"
"    else                                                                      \n"
"        *max_result = fmax(max2, x5);                                         \n"
"}                                                                             \n"
"                                                                              \n"
"float4 get_pix(global float4 *in, int x, int y, int rowstride)                \n"
"{                                                                             \n"
"    int idx = x + y * rowstride;                                              \n"
"    return in[idx];                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"kernel void pre_edgelaplace (global float4 *in,                               \n"
"                             global float4 *out)                              \n"
"{                                                                             \n"
"    int gidx = get_global_id(0);                                              \n"
"    int gidy = get_global_id(1);                                              \n"
"                                                                              \n"
"    int src_width  = get_global_size(0) + 2;                                  \n"
"    int src_height = get_global_size(1) + 2;                                  \n"
"                                                                              \n"
"    int i = gidx + 1, j = gidy + 1;                                           \n"
"                                                                              \n"
"    float4 cur_pix;                                                           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 1, j - 1, src_width);                           \n"
"    float pix_fl[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 0, j - 1, src_width);                           \n"
"    float pix_fm[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i + 1, j - 1, src_width);                           \n"
"    float pix_fr[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 1, j - 0, src_width);                           \n"
"    float pix_ml[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 0, j - 0, src_width);                           \n"
"    float pix_mm[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i + 1, j - 0, src_width);                           \n"
"    float pix_mr[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 1, j + 1, src_width);                           \n"
"    float pix_bl[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 0, j + 1, src_width);                           \n"
"    float pix_bm[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i + 1, j + 1, src_width);                           \n"
"    float pix_br[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    int c;                                                                    \n"
"    float minval, maxval;                                                     \n"
"    float gradient[4];                                                        \n"
"                                                                              \n"
"    for (c = 0;c < 3; ++c)                                                    \n"
"    {                                                                         \n"
"        minmax(pix_fm[c], pix_bm[c], pix_ml[c], pix_mr[c],                    \n"
"            pix_mm[c], &minval, &maxval);                                     \n"
"        gradient[c] = 0.5f *                                                  \n"
"            fmax((maxval - pix_mm[c]),(pix_mm[c] - minval));                  \n"
"        gradient[c] =                                                         \n"
"            (pix_fl[c] + pix_fm[c] + pix_fr[c] +                              \n"
"             pix_bm[c] - 8.0f * pix_mm[c] + pix_br[c] +                       \n"
"             pix_ml[c] + pix_mr[c] + pix_bl[c]) <                             \n"
"             EPSILON ? -1.0f * gradient[c] : gradient[c];                     \n"
"    }                                                                         \n"
"    gradient[3] = pix_mm[3];                                                  \n"
"                                                                              \n"
"    out[gidx + gidy * get_global_size(0)] = (float4)                          \n"
"        (gradient[0], gradient[1], gradient[2], gradient[3]);                 \n"
"}                                                                             \n"
"                                                                              \n"
"kernel void knl_edgelaplace (global float4 *in,                               \n"
"                             global float4 *out)                              \n"
"{                                                                             \n"
"    int gidx = get_global_id(0);                                              \n"
"    int gidy = get_global_id(1);                                              \n"
"                                                                              \n"
"    int src_width  = get_global_size(0) + 2;                                  \n"
"    int src_height = get_global_size(1) + 2;                                  \n"
"                                                                              \n"
"    int i = gidx + 1, j = gidy + 1;                                           \n"
"                                                                              \n"
"    float4 cur_pix;                                                           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 1, j - 1, src_width);                           \n"
"    float pix_fl[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 0, j - 1, src_width);                           \n"
"    float pix_fm[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i + 1, j - 1, src_width);                           \n"
"    float pix_fr[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 1, j - 0, src_width);                           \n"
"    float pix_ml[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 0, j - 0, src_width);                           \n"
"    float pix_mm[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i + 1, j - 0, src_width);                           \n"
"    float pix_mr[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 1, j + 1, src_width);                           \n"
"    float pix_bl[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i - 0, j + 1, src_width);                           \n"
"    float pix_bm[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    cur_pix = get_pix(in, i + 1, j + 1, src_width);                           \n"
"    float pix_br[4] = {cur_pix.x, cur_pix.y, cur_pix.z, cur_pix.w};           \n"
"                                                                              \n"
"    int c;                                                                    \n"
"    float value[4];                                                           \n"
"                                                                              \n"
"    for (c = 0;c < 3; ++c)                                                    \n"
"    {                                                                         \n"
"        float current = pix_mm[c];                                            \n"
"        current =                                                             \n"
"            ((current > 0.0f) &&                                              \n"
"             (pix_fl[c] < 0.0f || pix_fm[c] < 0.0f ||                         \n"
"              pix_fr[c] < 0.0f || pix_ml[c] < 0.0f ||                         \n"
"              pix_mr[c] < 0.0f || pix_bl[c] < 0.0f ||                         \n"
"              pix_bm[c] < 0.0f || pix_br[c] < 0.0f )                          \n"
"            ) ? current : 0.0f;                                               \n"
"        value[c] = current;                                                   \n"
"    }                                                                         \n"
"    value[3] = pix_mm[3];                                                     \n"
"                                                                              \n"
"    out[gidx + gidy * get_global_size(0)] = (float4)                          \n"
"        (value[0], value[1], value[2], value[3]);                             \n"
"}                                                                             \n"
;
