.\"
.\" "$Id: cupsenable.man 11920 2014-06-11 19:03:59Z msweet $"
.\"
.\" cupsenable/cupsdisable man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cupsenable 8 "CUPS" "11 June 2014" "Apple Inc."
.SH NAME
cupsdisable, cupsenable \- stop/start printers and classes
.SH SYNOPSIS
.B cupsdisable
[
.B \-E
] [
.B \-U
.I username
] [
.B \-c
] [
\fB\-h \fIserver\fR[\fB:\fIport\fR]
] [
.B \-r
.I reason
] [
.B \-\-hold
]
.I destination(s)
.br
.B cupsenable
[
.B \-E
] [
.B \-U
.I username
] [
.B \-c
] [
\fB\-h \fIserver\fR[\fB:\fIport\fR]
] [
.B \-\-release
]
.I destination(s)
.SH DESCRIPTION
.B cupsenable
starts the named printers or classes while
.B cupsdisable
stops the named printers or classes.
.SH OPTIONS
The following options may be used:
.TP 5
.B \-E
Forces encryption of the connection to the server.
.TP 5
\fB\-U \fIusername\fR
Uses the specified username when connecting to the server.
.TP 5
.B \-c
Cancels all jobs on the named destination.
.TP 5
\fB\-h \fIserver\fR[\fB:\fIport\fR]
Uses the specified server and port.
.TP 5
.B \-\-hold
Holds remaining jobs on the named printer.
Useful for allowing the current job to complete before performing maintenance.
.TP 5
\fB\-r "\fIreason\fB"\fR
Sets the message associated with the stopped state.
If no reason is specified then the message is set to "Reason Unknown".
.TP 5
.B \-\-release
Releases pending jobs for printing.
Use after running \fBcupsdisable\fR with the \fI\-\-hold\fR option to resume printing.
.SH CONFORMING TO
Unlike the System V printing system, CUPS allows printer names to contain any printable character except SPACE, TAB, "/", or "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
The System V versions of these commands are \fBdisable\fR and \fBenable\fR, respectively.
They have been renamed to avoid conflicts with the
.BR bash (1)
build-in commands of the same names.
.LP
The CUPS versions of \fBdisable\fR and \fBenable\fR may ask the user for an access password depending on the printing system configuration.
This differs from the System V versions which require the root user to execute these commands.
.SH SEE ALSO
.BR cupsaccept (8),
.BR cupsreject (8),
.BR cancel (1),
.BR lp (1),
.BR lpadmin (8),
.BR lpstat (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2014 by Apple Inc.

.\"
.\" End of "$Id: cupsenable.man 11920 2014-06-11 19:03:59Z msweet $".
.\"
