/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef _SD_CFGID_HXX
#define _SD_CFGID_HXX

#include <sfx2/sfx.hrc>

// Item-Ids fuer Config-Items
#define SDCFG_IMPRESS           (SFX_ITEMTYPE_SD_BEGIN + 1)
#define SDCFG_DRAW              (SFX_ITEMTYPE_SD_BEGIN + 3)

// Acceleratoren, Menus, ...
#define RID_DRAW_STATUSBAR          (SFX_ITEMTYPE_SD_BEGIN + 7)

// Toolbars
#define RID_DRAW_TOOLBOX            (SFX_ITEMTYPE_SD_BEGIN + 11)
#define RID_SLIDE_TOOLBOX           (SFX_ITEMTYPE_SD_BEGIN + 12)
#define RID_DRAW_OBJ_TOOLBOX        (SFX_ITEMTYPE_SD_BEGIN + 13)
#define RID_SLIDE_OBJ_TOOLBOX       (SFX_ITEMTYPE_SD_BEGIN + 14)
#define RID_BEZIER_TOOLBOX          (SFX_ITEMTYPE_SD_BEGIN + 15)
#define RID_DRAW_TEXT_TOOLBOX       (SFX_ITEMTYPE_SD_BEGIN + 16)
#define RID_OUTLINE_TOOLBOX         (SFX_ITEMTYPE_SD_BEGIN + 17)
#define RID_DRAW_TABLE_TOOLBOX      (SFX_ITEMTYPE_SD_BEGIN + 18)
#define RID_GLUEPOINTS_TOOLBOX      (SFX_ITEMTYPE_SD_BEGIN + 19)
#define RID_DRAW_OPTIONS_TOOLBOX    (SFX_ITEMTYPE_SD_BEGIN + 20)
#define RID_DRAW_COMMONTASK_TOOLBOX (SFX_ITEMTYPE_SD_BEGIN + 21)
#define RID_FORMLAYER_TOOLBOX       (SFX_ITEMTYPE_SD_BEGIN + 22)
#define RID_DRAW_VIEWER_TOOLBOX     (SFX_ITEMTYPE_SD_BEGIN + 23)
#define RID_GRAPHIC_VIEWER_TOOLBOX  (SFX_ITEMTYPE_SD_BEGIN + 24)

#define RID_GRAPHIC_TOOLBOX         (SFX_ITEMTYPE_SD_BEGIN + 25)
#define RID_GRAPHIC_OPTIONS_TOOLBOX (SFX_ITEMTYPE_SD_BEGIN + 26)
#define RID_GRAPHIC_OBJ_TOOLBOX     (SFX_ITEMTYPE_SD_BEGIN + 27)
#define RID_GRAPHIC_TEXT_TOOLBOX    (SFX_ITEMTYPE_SD_BEGIN + 28)

#define RID_DRAW_GRAF_TOOLBOX       (SFX_ITEMTYPE_SD_BEGIN + 30)
#define RID_DRAW_MEDIA_TOOLBOX      (SFX_ITEMTYPE_SD_BEGIN + 31)


#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
