#
# spec file for package libax25 (Version 0.0.12)
#
# Copyright (c) 2005 SUSE LINUX Products GmbH, Nuernberg, Germany.
# This file and all modifications and additions to the pristine
# package are under the same license as the package itself.
#
# Please submit bugfixes or comments via http://www.suse.de/feedback/
#
# Mutated for Fedora 8 et al. by Matti Aarnio, OH2MQK, 2007-November
#

# norootforbuild
# neededforbuild  

# Not nearly this much, but I didn't want to determine the minimum set... [oh2mqk]
# This compiles now successfully at Fedora8, and SuSE SLES 10.1.
#BuildRequires:  acl attr bash bison bzip2 coreutils cpio cpp diffutils e2fsprogs file filesystem flex gawk glibc glibc-devel grep groff gziplibgcc m4 make man  net-tools patch popt sed util-linux autoconf automake binutils gcc  libtool rpm

Name:         libax25
URL:          http://ax25.sourceforge.net/
License:      GPL
Group:        System Environment/Libraries
Autoreqprov:  on
Version:      0.0.13
#Provides:     libax25 libax25-%{version}
Release:      6
Summary:      AX.25 Libraries for for applications and developers
Source:       libax25-0.0.13-6.tar.gz
BuildRoot:    %{_tmppath}/%{name}-%{version}-build

%description
LibAX25 is special purpose Radio Amateur AX.25 protocol family library.
This library has been unchanged since 2003-February

Authors:
--------
    Craig Small <csmall@small.dropbear.id.au>
    Jonathan Naylor <g4klx@g4klx.demon.co.uk>
    Tomi Manninen <Tomi.Manninen@hut.fi>
    Jean-Paul ROUBELAT <jpr@f6fbb.org>
    Matti Aarnio <oh2mqk@sral.fi>
 

%package devel
Summary: Files needed for developing applications using libax25.
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
LibAX25 is special purpose Radio Amateur AX.25 protocol family library.
This package contains files needed for developing applications with libax25.

%prep
#%setup -q -n libax25-%{version}
%setup -q

%build
## %{suse_update_config}
aclocal
libtoolize --copy --force
automake --add-missing
autoconf
export HARDWARE=`uname -m`
./configure --enable-shared --enable-static --prefix= --exec-prefix=  --bindir=/usr/bin --sbindir=/usr/sbin --libexecdir=/usr/libexec --datadir=/usr/share --sysconfdir=/etc --localstatedir=/var --libdir=/usr/%_lib --includedir=/usr/include --infodir=/usr/info --mandir=%{_mandir}  CC="gcc" AFLAGS="--noexecstack" LDFLAGS="-z noexecstack" CFLAGS="$RPM_OPT_FLAGS"

make

%install
rm -fr $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT
make installconf DESTDIR=$RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog INSTALL NEWS README
%dir /etc/ax25
%config /etc/ax25/axports
%config /etc/ax25/nrports
%config /etc/ax25/rsports
%{_libdir}/libax25.so
%{_libdir}/libax25.so.0
%{_libdir}/libax25.so.0.0.0
%{_libdir}/libax25io.so
%{_libdir}/libax25io.so.0
%{_libdir}/libax25io.so.0.0.0
%doc %{_mandir}/man5/axports.5.gz
%doc %{_mandir}/man5/nrports.5.gz
%doc %{_mandir}/man5/rsports.5.gz

%files devel
%{_includedir}/netax25
%{_libdir}/libax25.a
%{_libdir}/libax25.la
%{_libdir}/libax25io.a
%{_libdir}/libax25io.la
%doc %{_mandir}/man3/ax25.3.gz
%doc %{_mandir}/man3/rose.3.gz

%changelog -n libax25
* Mon Feb 04 2008 - oh2mqk@sral.fi
- upgrade to version 0.0.13
* Fri Jan 11 2008 - oh2mqk@sral.fi
- upgrade to version 0.0.12
- altered autoconf things
- observed to work also on SuSE SLES 10.1
- altered spec file to work on Fedora-8
* Sat Jan 10 2004 - adrian@suse.de
- add %%run_ldconfig
* Thu Dec 05 2002 - jreuter@suse.de
- upgrade to version 0.0.10
- bziped source archive
* Wed Sep 18 2002 - ro@suse.de
- removed bogus self-provides
* Tue Jul 02 2002 - meissner@suse.de
- Cleaned up .spec, buildrooted, auto* rerun.
* Tue Feb 12 2002 - jreuter@suse.de
- update to version 0.0.9
* Thu Nov 30 2000 - jreuter@suse.de
- changed group to Applications/Hamradio
* Wed Nov 08 2000 - sim@suse.de
- changed group to Applications/Communications
* Thu May 25 2000 - sim@suse.de
- doc to /usr/share/doc
* Thu Mar 02 2000 - kukuk@suse.de
- Use _mandir macro
* Thu Oct 28 1999 - ka@suse.de
- added make installconf to install section of spec file
* Thu Sep 16 1999 - ka@suse.de
- update to version 0.0.7
* Mon Sep 13 1999 - bs@suse.de
- ran old prepare_spec on spec file to switch to new prepare_spec.
* Thu Aug 12 1999 - ka@suse.de
- more detailed configure call to fix wrong paths in ax25tool/ax25apps
* Mon Jul 19 1999 - ka@suse.de
- update to version 0.0.6
* Tue Jul 13 1999 - ka@suse.de
- update to version 0.0.5
- fixed typo in pathnames.h
* Fri Jun 11 1999 - ka@suse.de
- added header files for glibc 2.1 received from Tomi Manninen
* Wed May 19 1999 - ro@suse.de
- re-added patch to apps/call.c
* Tue May 18 1999 - ka@suse.de
- added patch for procutils.c
* Fri May 07 1999 - ka@suse.de
- initial release of new sources for kernel 2.2.x
- renamed package to libax25
* Tue May 04 1999 - ro@suse.de
- rebuilt diff
- patched to build with glibc-2.1 and on alpha
- rspfd can't work on alpha yet due to inline asm
* Mon Mar 15 1999 - ro@suse.de
- renamed subpackage to ax25dev
* Fri Mar 12 1999 - ka@suse.de
- added sample configuration files to /etc/ax25/
* Thu Mar 11 1999 - ka@suse.de
- initial release
