/* ----------------------------------------------------------------------
 * p_plug_in_borderaverage_iter_ALT 
 * ----------------------------------------------------------------------
 */
gint p_plug_in_borderaverage_iter_ALT(GimpRunModeType run_mode, gint32 total_steps, gdouble current_step, gint32 len_struct) 
{
    typedef struct t_plug_in_borderaverage_Vals 
    {
      long      thickness;
      long      bucket_exponent;
    } t_plug_in_borderaverage_Vals; 

    t_plug_in_borderaverage_Vals  buf, *buf_from, *buf_to; 

    if(len_struct != sizeof(t_plug_in_borderaverage_Vals)) 
    {
      fprintf(stderr, "ERROR: p_plug_in_borderaverage_iter_ALT  stored Data missmatch in size %d != %d\n",   
                       (int)len_struct, (int)sizeof(t_plug_in_borderaverage_Vals) ); 
      return -1;  /* ERROR */ 
    }

    gimp_get_data("plug_in_borderaverage_ITER_FROM", g_plugin_data_from); 
    gimp_get_data("plug_in_borderaverage_ITER_TO",   g_plugin_data_to); 

    buf_from = (t_plug_in_borderaverage_Vals *)&g_plugin_data_from[0]; 
    buf_to   = (t_plug_in_borderaverage_Vals *)&g_plugin_data_to[0]; 
    memcpy(&buf, buf_from, sizeof(buf));

    p_delta_long(&buf.thickness, buf_from->thickness, buf_to->thickness, total_steps, current_step);
    p_delta_long(&buf.bucket_exponent, buf_from->bucket_exponent, buf_to->bucket_exponent, total_steps, current_step);

    gimp_set_data("plug_in_borderaverage", &buf, sizeof(buf)); 

    return 0; /* OK */
}
