/* $Id: e2_plugins.h 2568 2012-07-17 23:00:45Z tpgww $

Copyright (C) 2004-2012 tooar <tooar@emelfm2.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, see http://www.gnu.org/licenses.
*/

#ifndef __E2_PLUGINS_H__
#define __E2_PLUGINS_H__

#include "emelfm2.h"

/*values for lookup table of 'main program' functions, usable by plugins
NOTE: not all actually-used main-program functions are accessible via this
API, so that plugins need to be compiled with the main program, ans
this interface is fairly nominal, more for example than core use !
*/
/*enum
{
	E2API_ACTION_REGISTER = 0,
	E2API_ACTION_UNREGISTER,
	E2API_ACTION_GET,
	E2API_OPTION_GET,
	E2API_OPTION_REGISTER,
	E2API_REFRESH_DISABLE,
	E2API_REFRESH_ENABLE,
	E2API_POINTER_COUNT		//the last value, used for size checks
};
*/
typedef enum _E2_PlugCleans
{
	E2P_CLEANNONE  = 0,	//this is default value when Plugin is allocated
	E2P_CLEANICON  = 1,
	E2P_CLEANLABEL = 1 << 1,
	E2P_CLEANTIP   = 1 << 2,
	E2P_CLEANCHILD = 1 << 3,
} E2_PlugCleans;
//for cleaning all strings
#define E2P_CLEANALL 0x7

//plugins config treestore columns
enum
{
	LOAD_COL,
	MENU_COL,
	LABEL_COL,
	ICON_COL,
	TIP_COL,
	FILE_COL,
	PATH_COL,
	SIG_COL
};

/* To provide for multiple-actions in any plugin, this runtime data struct is used
 in 2 ways. When there is more than one action, a "parent" Plugin struct contains
 a list of "child" Plugin structs, one for each action.
 All Plugins, parents and children, are added to app.plugins as a flat list */
typedef struct _E2_Plugin
{
	const gchar *signature;	//ID string, never alters after it's initialised
	//this group of members will be NULL in any Plugin listed in action_list
	GModule *module;
	gboolean (*plugin_init)();  //fn called by main program, to let the plugin initialize itself
	GList *child_list;	//list of Plugins, each with action-specific data,
						//or NULL if only 1 action, and then the following will be used ...
	gchar *icon;  //user-editable context-menu icon file path (or "gtk-<...>")
	gchar *menu_name;  //user-editable name that appears in the plugins menu
	gchar *description;  //user-editable context-menu tooltip (useless for a sub-menu item)
	gboolean show_in_menu;  //TRUE if the plugin is to appear in the file-pane context menu
	E2_Action *action;	//what to run
	E2_PlugCleans cleanflags;	//what things to handle when cleaning up
} Plugin;

typedef struct _E2P_DirEnt
{
	gchar *path;
	mode_t mode;
} E2P_DirEnt;

// Plugins
//void *e2_plugins_api_lookup (gint type);
Plugin *e2_plugins_open1 (gchar *filepath);
gboolean e2_plugins_unload1 (Plugin *p, gboolean force);
void e2_plugins_load_all (void);
void e2_plugins_unload_all (gboolean force);
void e2_plugins_store_data (GtkTreeModel *model, GtkTreeIter *iter, Plugin *p,
	gboolean inmenu, gchar *localpath);
void e2_plugins_freshen_data (void);
void e2_plugins_update (void);
gboolean e2_plugins_configure (gpointer from, E2_ActionRuntime *art);
E2_Action *e2_plugins_action_register (const E2_Action *newaction);
gboolean e2_plugins_action_unregister (gchar *name);
//Plugin *get_plugin_by_name (gchar *name);
Plugin *e2_plugins_check_installed (const gchar *signature);
Plugin *e2_plugins_load_plugin (const gchar *signature);
gboolean e2_plugins_find_function (const gchar *signature, const gchar *func_name,
	gpointer *address);
Plugin *e2_plugins_create_child (Plugin *parent);
GList *e2_plugins_get_list (void);
E2_OptionSet *e2_plugins_option_register (E2_OptionType type, gchar *name,
	gchar *group, gchar *desc, gchar *tip, gchar *depends,
	E2_OptionSetupExtra *ex, E2_OptionFlags flags);
gboolean e2_plugins_option_unregister (gchar *name);
void e2_plugins_options_register (void);

#endif //ndef __E2_PLUGINS_H__
