/* $Id: e2_about_dialog.c 2672 2013-08-10 22:15:10Z tpgww $

Copyright (C) 2004-2013 tooar <tooar@emelfm2.net>

This file is part of emelFM2.
emelFM2 is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

emelFM2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with emelFM2; see the file GPL. If not, see http://www.gnu.org/licenses.
*/

#include "emelfm2.h"
#include <string.h>
#include "e2_dialog.h"
#include "e2_about_dialog.h"

/*
 dialog_data
  ->a = helpfile name for credits tab (1)
  ->b = helpfile name and heading for usage tab (2)
  ->c = helpfile name and heading for commands tab (3)
  ->d = helpfile name for actions tab (4)
  ->e = helpfile name (== one of the above) for the current tab
  ->f = read-button widget
*/

  /*****************/
 /*** callbacks ***/
/*****************/
/**
@brief about-dialog response-signal callback

@param dialog the about-dialog
@param response UNUSED the response code generated by the dialog
@param data pointer to data for the dialog
@return
*/
static void _e2_about_dialog_response_cb (GtkDialog *dialog, gint response,
	E2_Sextet *data)
{
	gchar *command;
	switch (response)
	{
		case E2_RESPONSE_USER1:	//read button click
			if (data->e == data->a	//check whether a file-heading is not used
				|| data->e == data->d)
				command = g_strconcat(_A(6),".",_A(109), NULL);	//file.view
			else
				command = g_strconcat(_A(6),".",_A(111), NULL);	//file.view_at
			e2_action_run_simple_from (command, (gchar *)data->e, dialog);
			g_free (command);
			break;
		default:
		//cleanup the strings constructed when dialog set up
			g_free (data->a);
			g_free (data->b);
			g_free (data->c);
			g_free (data->d);
			e2_utils_sextet_destroy (data);
			gtk_widget_destroy (GTK_WIDGET (dialog));
			break;
	}
}
/**
@brief the notebook's "switch-page" signal callback
Visisbility of view-file buttons is changed as appropriate
@param notebook UNUSED the notebook widget
@param page UNUSED the notebook page which is now focused
@param page_num the index of the new page
@param dialog_data pointer to dialog data

@return
*/
static void _e2_about_dialog_tabchange_cb (GtkNotebook *notebook,
#ifdef USE_GTK3_0
	GtkWidget *page,
#else
	GtkNotebookPage *page,
#endif
	guint page_num, E2_Sextet *dialog_data)
{
	switch (page_num)
	{
		case 0:	//main
			gtk_widget_hide (dialog_data->f);	//no view button here
			break;
		default:
			gtk_widget_show (dialog_data->f);
			break;
	}
	switch (page_num)
	{
		case 1:	//contribs
			dialog_data->e = dialog_data->a;	//set the string to use for viewing
			break;
		case 2:	//usage
			dialog_data->e = dialog_data->b;
			break;
		case 3:	//commands
			dialog_data->e = dialog_data->c;
			break;
		case 4:	//actions
			dialog_data->e = dialog_data->d;
			break;
		default:
//		case 0:	//main
			break;
	}
}
/**
@brief create and show tabbed about-dialog
Assumes BGL closed
@return the dialog widget, or NULL in case of a problem
*/
static GtkWidget *_e2_about_dialog_create (void)
{
	E2_Sextet *dialog_data = e2_utils_sextet_new ();
	if (dialog_data == NULL)
		return NULL;
	gchar *localiconsdir = e2_utils_get_icons_path (FALSE);
	gchar *localpath = g_build_filename (localiconsdir, BINNAME"_48.png", NULL);
	GtkWidget *dialog = e2_dialog_create (localpath,
		"<span size=\"x-large\" weight=\"bold\">" PROGNAME " " VERSION RELEASE "</span>",
		_("help"), (ResponseFunc)_e2_about_dialog_response_cb, dialog_data);
	e2_dialog_set_negative_response (dialog, GTK_RESPONSE_CLOSE);
#ifndef USE_GTK3_0
	gtk_dialog_set_has_separator (GTK_DIALOG (dialog), FALSE);	//looks better, with notebook
#endif
	g_free (localiconsdir);
	g_free (localpath);

	GtkWidget *notebook = e2_widget_add_notebook (
#ifdef USE_GTK2_14
		gtk_dialog_get_content_area (GTK_DIALOG (dialog)),
#else
		GTK_DIALOG(dialog)->vbox,
#endif
		TRUE, 0, NULL, NULL);
	//info tab (auto scrollbars set when shown)
	GtkWidget *vbox = e2_widget_add_notebook_page (/*dialog, */notebook,
		_("about"), GTK_POLICY_NEVER);
	gchar *public = g_markup_escape_text (COPYRIGHT, -1);
	gchar *utf1 = e2_utf8_from_locale (BUILDSTAMP);
	//emelFM2 is licensed under GPL v.3 or later, so any distributor will be
	//entitled to specify a version > 3, and must then adjust each .po file accordingly
	gchar *message = g_strdup_printf
	(
		_("<b>An \"orthodox\" file manager for GTK2+</b>\n\n"
		"Copyright &#169; %s\n\n"   //&#169; = ©
		"This program is licensed under the terms of\n"
		"version 3 of the General Public License\n\n"
		"This binary was compiled on %s\n"
		"using %s and GTK+%d.%d.%d"),
		public, utf1, BUILDINFO, GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION
	);
	GtkWidget *label = e2_widget_add_mid_label (vbox, message, 0.5, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_CENTER);
	g_free (public);
	g_free (utf1);
	g_free (message);
	gchar *fmsg = _("The file\n<b>%s</b>\ngives details.");
	//contribs tab (auto scrollbars set when shown)
	vbox = e2_widget_add_notebook_page (/*dialog, */notebook,
		_("contributors"), GTK_POLICY_NEVER);
	//assume no escaping needed in DOC_DIR
	gchar *helpfile = D_FILENAME_FROM_LOCALE (DOC_DIR G_DIR_SEPARATOR_S "CREDITS");
	gchar *message2 = g_strdup_printf (fmsg, helpfile);
	message = g_strconcat (
	_("This program is based on emelFM, developed by Michael Clark.\n\n"
		"Contributions have been made by many friends."), " ",
		message2, NULL);
	label = e2_widget_add_mid_label (vbox, message, 0.0, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	g_free (message2);
	g_free (message);
	dialog_data->a = helpfile;
	//usage tab (auto scrollbars set when shown)
	gchar *title = _("usage");	//this is not yet? translated in the helpfile heading
	vbox = e2_widget_add_notebook_page (/*dialog, */notebook, title, GTK_POLICY_NEVER);
	helpfile = e2_option_str_get ("usage-help-doc");
	message = g_strdup_printf (fmsg, helpfile);	//same filename for usage and commands tabs
	label = e2_widget_add_mid_label (vbox, message, 0.0, FALSE, 0); //assumes no escaping needed
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	dialog_data->b = g_strconcat (helpfile," [usage]",NULL);	//remember, for cleanup when finished
	//commands tab (auto scrollbars set when shown)
	title = _("commands");
	vbox = e2_widget_add_notebook_page (/*dialog, */notebook, title, GTK_POLICY_NEVER);
	label = e2_widget_add_mid_label (vbox, message, 0.0, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	g_free (message);
	dialog_data->c = g_strconcat (helpfile," [commands]",NULL); //remember, for cleanup when finished
	//actions tab (auto scrollbars set when shown)
	title = _("actions");
	vbox = e2_widget_add_notebook_page (/*dialog, */notebook, title, GTK_POLICY_NEVER);
	helpfile = D_FILENAME_FROM_LOCALE (DOC_DIR G_DIR_SEPARATOR_S "ACTIONS");
	message = g_strdup_printf (fmsg, helpfile);
	label = e2_widget_add_mid_label (vbox, message, 0.0, FALSE, 0);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	g_free (message);
	dialog_data->d = helpfile;

	dialog_data->f = e2_dialog_add_custom_button_full (dialog, FALSE,
		E2_RESPONSE_USER1, _("_View"), "view"E2ICONTB, _("Read the file"),
		NULL, NULL);
	//update all srolled wingows' policies after sizing
	g_signal_connect (G_OBJECT (GTK_DIALOG (dialog)), "show",
		G_CALLBACK (e2_dialog_show_notebook_cb), GTK_NOTEBOOK (notebook));
	g_signal_connect (G_OBJECT (notebook), "switch-page",
		G_CALLBACK (_e2_about_dialog_tabchange_cb), dialog_data);

//	e2_dialog_resize (dialog, 1.8);	//guess what is big enough for usual fonts
	e2_dialog_show (dialog, app.main_window, 0, &E2_BUTTON_CLOSE, NULL);

	return dialog;
}
  /******************/
 /***** action *****/
/******************/
/**
@brief about-dialog action to create and show dialog
@param from the button, menu item etc which was activated
@param art action runtime data
@return TRUE always
*/
static gboolean _e2_about_dialog_open (gpointer from, E2_ActionRuntime *art)
{
	GtkWidget *dialog = _e2_about_dialog_create ();
	return (dialog != NULL);
}
  /******************/
 /***** public *****/
/******************/
/**
@brief register about-dialog action
@return
*/
void e2_about_dialog_actions_register (void)
{
	E2_Action action =
	{g_strconcat(_A(4),".",_A(29),NULL),_e2_about_dialog_open,FALSE,E2_ACTION_TYPE_ITEM,0,NULL,NULL};
	e2_action_register (&action);
}
