/****************************************************************************
 *  (c) Copyright 2007 Wi-Fi Alliance.  All Rights Reserved
 *
 *
 *  LICENSE
 *
 *  License is granted only to Wi-Fi Alliance members and designated
 *  contractors ($B!H(BAuthorized Licensees$B!I(B)..AN  Authorized Licensees are granted
 *  the non-exclusive, worldwide, limited right to use, copy, import, export
 *  and distribute this software:
 *  (i) solely for noncommercial applications and solely for testing Wi-Fi
 *  equipment; and
 *  (ii) solely for the purpose of embedding the software into Authorized
 *  Licensee$B!G(Bs proprietary equipment and software products for distribution to
 *  its customers under a license with at least the same restrictions as
 *  contained in this License, including, without limitation, the disclaimer of
 *  warranty and limitation of liability, below..AN  The distribution rights
 *  granted in clause
 *  (ii), above, include distribution to third party companies who will
 *  redistribute the Authorized Licensee$B!G(Bs product to their customers with or
 *  without such third party$B!G(Bs private label. Other than expressly granted
 *  herein, this License is not transferable or sublicensable, and it does not
 *  extend to and may not be used with non-Wi-Fi applications..AN  Wi-Fi Alliance
 *  reserves all rights not expressly granted herein..AN 
 *.AN 
 *  Except as specifically set forth above, commercial derivative works of
 *  this software or applications that use the Wi-Fi scripts generated by this
 *  software are NOT AUTHORIZED without specific prior written permission from
 *  Wi-Fi Alliance.
 *.AN 
 *  Non-Commercial derivative works of this software for internal use are
 *  authorized and are limited by the same restrictions; provided, however,
 *  that the Authorized Licensee shall provide Wi-Fi Alliance with a copy of
 *  such derivative works under a perpetual, payment-free license to use,
 *  modify, and distribute such derivative works for purposes of testing Wi-Fi
 *  equipment.
 *.AN 
 *  Neither the name of the author nor "Wi-Fi Alliance" may be used to endorse
 *  or promote products that are derived from or that use this software without
 *  specific prior written permission from Wi-Fi Alliance.
 *
 *  THIS SOFTWARE IS PROVIDED BY WI-FI ALLIANCE "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 *  OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A.AN PARTICULAR PURPOSE,
 *  ARE DISCLAIMED. IN NO EVENT SHALL WI-FI ALLIANCE BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *  (INCLUDING, BUT NOT LIMITED TO, THE COST OF PROCUREMENT OF SUBSTITUTE
 *  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 *  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 *  STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE) ARISING IN ANY WAY OUT OF
 *  THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. ******************************************************************************
 */
 

/*
 * File: wfa_tlv.h
 *  definitions for each of command types. 
 *  format:
 *  ---------------------------------------------------
 *  |  tag   | length |   value   
 *  --------------------------------------------------- 
 *   2 bytes   2bytes    defined by length 
 */
#ifndef _WFA_TLV_H
#define _WFA_TLV_H

#include "wfa_types.h"

#define INTEGER_1 0x0001            /* byte */
#define INTEGER_2 0x0002            /* word */
#define OCTET_STRING 0x0003         /* string */

typedef struct _wfatlvHdr 
{
    WORD tag;   /* tag/type */
    WORD len;   /* value length */
} wfaTLV;

#define WFA_TLV_HDR_LEN sizeof(wfaTLV)
#ifndef WIN32
/* Commands */
#define WFA_GET_VERSION_TLV                                         0x01

/* Generic TRAFFIC GENERATOR Commands */
#define WFA_TRAFFIC_SEND_PING_TLV     (WFA_GET_VERSION_TLV + 0x01) 
#define WFA_TRAFFIC_STOP_PING_TLV     (WFA_TRAFFIC_SEND_PING_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_CONFIG_TLV  (WFA_TRAFFIC_STOP_PING_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_SEND_TLV    (WFA_TRAFFIC_AGENT_CONFIG_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_RECV_START_TLV (WFA_TRAFFIC_AGENT_SEND_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_RECV_STOP_TLV (WFA_TRAFFIC_AGENT_RECV_START_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_RESET_TLV (WFA_TRAFFIC_AGENT_RECV_STOP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_STATUS_TLV (WFA_TRAFFIC_AGENT_RESET_TLV + 0x01) /* 9 */

/* STATION/DUT Commands */
#define WFA_STA_GET_IP_CONFIG_TLV    (WFA_TRAFFIC_AGENT_STATUS_TLV + 0x01)
#define WFA_STA_SET_IP_CONFIG_TLV    (WFA_STA_GET_IP_CONFIG_TLV + 0x01)
#define WFA_STA_GET_MAC_ADDRESS_TLV  (WFA_STA_SET_IP_CONFIG_TLV + 0x01)
#define WFA_STA_SET_MAC_ADDRESS_TLV  (WFA_STA_GET_MAC_ADDRESS_TLV + 0x01) 
#define WFA_STA_IS_CONNECTED_TLV     (WFA_STA_SET_MAC_ADDRESS_TLV + 0x01) 
#define WFA_STA_VERIFY_IP_CONNECTION_TLV  (WFA_STA_IS_CONNECTED_TLV + 0x01)
#define WFA_STA_GET_BSSID_TLV        (WFA_STA_VERIFY_IP_CONNECTION_TLV + 0x01)
#define WFA_STA_GET_STATS_TLV        (WFA_STA_GET_BSSID_TLV + 0x01)  /* 17 */ 
#define WFA_STA_SET_ENCRYPTION_TLV   (WFA_STA_GET_STATS_TLV + 0x01)
#define WFA_STA_SET_PSK_TLV          (WFA_STA_SET_ENCRYPTION_TLV + 0x01)
#define WFA_STA_SET_EAPTLS_TLV       (WFA_STA_SET_PSK_TLV + 0x01)
#define WFA_STA_SET_UAPSD_TLV        (WFA_STA_SET_EAPTLS_TLV + 0x01)
#define WFA_STA_ASSOCIATE_TLV        (WFA_STA_SET_UAPSD_TLV + 0x01)
#define WFA_STA_SET_EAPTTLS_TLV      (WFA_STA_ASSOCIATE_TLV + 0x01)
#define WFA_STA_SET_EAPSIM_TLV       (WFA_STA_SET_EAPTTLS_TLV + 0x01)
#define WFA_STA_SET_PEAP_TLV         (WFA_STA_SET_EAPSIM_TLV + 0x01)
#define WFA_STA_SET_IBSS_TLV         (WFA_STA_SET_PEAP_TLV + 0x01)
#define WFA_STA_GET_INFO_TLV         (WFA_STA_SET_IBSS_TLV + 0x01)
#define WFA_DEVICE_GET_INFO_TLV      (WFA_STA_GET_INFO_TLV + 0x01)  
#define WFA_DEVICE_LIST_IF_TLV       (WFA_DEVICE_GET_INFO_TLV + 0x01)  /* 29 */

#define WFA_STA_DEBUG_SET_TLV        (WFA_DEVICE_LIST_IF_TLV + 0x01)  /* 30 */
#define WFA_STA_SET_MODE_TLV         (WFA_STA_DEBUG_SET_TLV + 0x01) /* 31 */
#define WFA_STA_SET_WMM_TLV          (WFA_STA_SET_MODE_TLV + 0x01) /* 32 */

#define WFA_STA_COMMANDS_END         (WFA_STA_SET_WMM_TLV + 0x01)  /* 33 */


/* Version response */
#define WFA_GET_VERSION_RESP_TLV  (WFA_STA_COMMANDS_END +       0x01) /* 34 */

/* Generic Traffic Generator Responses */
#define WFA_TRAFFIC_SEND_PING_RESP_TLV (WFA_GET_VERSION_RESP_TLV +  0x01) 
#define WFA_TRAFFIC_STOP_PING_RESP_TLV (WFA_TRAFFIC_SEND_PING_RESP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_CONFIG_RESP_TLV (WFA_TRAFFIC_STOP_PING_RESP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_SEND_RESP_TLV (WFA_TRAFFIC_AGENT_CONFIG_RESP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_RECV_START_RESP_TLV (WFA_TRAFFIC_AGENT_SEND_RESP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_RECV_STOP_RESP_TLV (WFA_TRAFFIC_AGENT_RECV_START_RESP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_RESET_RESP_TLV (WFA_TRAFFIC_AGENT_RECV_STOP_RESP_TLV + 0x01)
#define WFA_TRAFFIC_AGENT_STATUS_RESP_TLV (WFA_TRAFFIC_AGENT_RESET_RESP_TLV + 0x01)

/* STATION/DUT Responses */
#define WFA_STA_GET_IP_CONFIG_RESP_TLV (WFA_TRAFFIC_AGENT_STATUS_RESP_TLV + 0x01)  
#define WFA_STA_SET_IP_CONFIG_RESP_TLV (WFA_STA_GET_IP_CONFIG_RESP_TLV + 0x01)
#define WFA_STA_GET_MAC_ADDRESS_RESP_TLV (WFA_STA_SET_IP_CONFIG_RESP_TLV + 0x01)
#define WFA_STA_SET_MAC_ADDRESS_RESP_TLV (WFA_STA_GET_MAC_ADDRESS_RESP_TLV + 0x01) /* 47 */ 
#define WFA_STA_IS_CONNECTED_RESP_TLV (WFA_STA_SET_MAC_ADDRESS_RESP_TLV + 0x01) 
#define WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV  (WFA_STA_IS_CONNECTED_RESP_TLV + 0x01) /* 49 */
#define WFA_STA_GET_BSSID_RESP_TLV (WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV + 0x01)  /* 50 */
#define WFA_STA_GET_STATS_RESP_TLV (WFA_STA_GET_BSSID_RESP_TLV + 0x01) 
#define WFA_STA_SET_ENCRYPTION_RESP_TLV (WFA_STA_GET_STATS_RESP_TLV + 0x01)
#define WFA_STA_SET_PSK_RESP_TLV (WFA_STA_SET_ENCRYPTION_RESP_TLV + 0x01)
#define WFA_STA_SET_EAPTLS_RESP_TLV (WFA_STA_SET_PSK_RESP_TLV + 0x01)
#define WFA_STA_SET_UAPSD_RESP_TLV (WFA_STA_SET_EAPTLS_RESP_TLV + 0x01)
#define WFA_STA_ASSOCIATE_RESP_TLV (WFA_STA_SET_UAPSD_RESP_TLV + 0x01)
#define WFA_STA_SET_EAPTTLS_RESP_TLV   (WFA_STA_ASSOCIATE_RESP_TLV + 0x01)
#define WFA_STA_SET_EAPSIM_RESP_TLV   (WFA_STA_SET_EAPTTLS_RESP_TLV + 0x01)
#define WFA_STA_SET_PEAP_RESP_TLV      (WFA_STA_SET_EAPSIM_RESP_TLV + 0x01)
#define WFA_STA_SET_IBSS_RESP_TLV         (WFA_STA_SET_PEAP_RESP_TLV + 0x01)
#define WFA_STA_GET_INFO_RESP_TLV      (WFA_STA_SET_IBSS_RESP_TLV + 0x01)
#define WFA_DEVICE_GET_INFO_RESP_TLV  (WFA_STA_GET_INFO_RESP_TLV + 0x01)
#define WFA_DEVICE_LIST_IF_RESP_TLV (WFA_DEVICE_GET_INFO_RESP_TLV + 0x01) 

#define WFA_STA_DEBUG_SET_RESP_TLV  (WFA_DEVICE_LIST_IF_RESP_TLV + 0x01)
#define WFA_STA_SET_MODE_RESP_TLV   (WFA_STA_DEBUG_SET_RESP_TLV + 0x01) /* 31 */
#define WFA_STA_SET_WMM_RESP_TLV   (WFA_STA_SET_MODE_RESP_TLV + 0x01)   /* 32 */
#define WFA_STA_RESPONSE_END (WFA_STA_SET_WMM_RESP_TLV + 0x01)
#else
//Hardcode these value MindTree to avoid compilation issues
#define WFA_GET_VERSION_TLV                                         0x01

#define WFA_TRAFFIC_SEND_PING_TLV    0x02 
#define WFA_TRAFFIC_STOP_PING_TLV     0x03
#define WFA_TRAFFIC_AGENT_CONFIG_TLV  0x04
#define WFA_TRAFFIC_AGENT_SEND_TLV    0x05
#define WFA_TRAFFIC_AGENT_RECV_START_TLV 0x06
#define WFA_TRAFFIC_AGENT_RECV_STOP_TLV 0x07
#define WFA_TRAFFIC_AGENT_RESET_TLV 0x08
#define WFA_TRAFFIC_AGENT_STATUS_TLV 0x09 /* 9 */

/* STATION/DUT Commands */
#define WFA_STA_GET_IP_CONFIG_TLV    0x0a
#define WFA_STA_SET_IP_CONFIG_TLV    0x0b
#define WFA_STA_GET_MAC_ADDRESS_TLV  0x0c
#define WFA_STA_SET_MAC_ADDRESS_TLV  0x0d
#define WFA_STA_IS_CONNECTED_TLV     0x0e 
#define WFA_STA_VERIFY_IP_CONNECTION_TLV  0x0f
#define WFA_STA_GET_BSSID_TLV        0x10
#define WFA_STA_GET_STATS_TLV        0x11  /* 17 */ 
#define WFA_STA_SET_ENCRYPTION_TLV   0x12
#define WFA_STA_SET_PSK_TLV          0x13
#define WFA_STA_SET_EAPTLS_TLV       0x14
#define WFA_STA_SET_UAPSD_TLV        0x15
#define WFA_STA_ASSOCIATE_TLV        0x16
#define WFA_STA_SET_EAPTTLS_TLV      0x17
#define WFA_STA_SET_EAPSIM_TLV       0x18
#define WFA_STA_SET_PEAP_TLV         0x19
#define WFA_STA_SET_IBSS_TLV         0x1a
#define WFA_STA_GET_INFO_TLV         0x1b
#define WFA_DEVICE_GET_INFO_TLV      0x1c 
#define WFA_DEVICE_LIST_IF_TLV       0x1d  /* 29 */

#define WFA_STA_DEBUG_SET_TLV        0x1e  /* 30 */
#define WFA_STA_SET_MODE_TLV         0x1f  /* 31 */
#define WFA_STA_SET_WMM_TLV          0x20  /* 32 */

#define WFA_STA_COMMANDS_END         0x21  /* 33 */


/* Version response */
#define WFA_GET_VERSION_RESP_TLV     0x22  /* 34 */

/* Generic Traffic Generator Responses */
#define WFA_TRAFFIC_SEND_PING_RESP_TLV 0x23
#define WFA_TRAFFIC_STOP_PING_RESP_TLV 0x24
#define WFA_TRAFFIC_AGENT_CONFIG_RESP_TLV 0x25
#define WFA_TRAFFIC_AGENT_SEND_RESP_TLV 0x26
#define WFA_TRAFFIC_AGENT_RECV_START_RESP_TLV 0x27
#define WFA_TRAFFIC_AGENT_RECV_STOP_RESP_TLV 0x28
#define WFA_TRAFFIC_AGENT_RESET_RESP_TLV 0x29
#define WFA_TRAFFIC_AGENT_STATUS_RESP_TLV 0x2a

/* STATION/DUT Responses */
#define WFA_STA_GET_IP_CONFIG_RESP_TLV 0x2b
#define WFA_STA_SET_IP_CONFIG_RESP_TLV 0x2c
#define WFA_STA_GET_MAC_ADDRESS_RESP_TLV 0x2d
#define WFA_STA_SET_MAC_ADDRESS_RESP_TLV 0x2e /* 47 */ 
#define WFA_STA_IS_CONNECTED_RESP_TLV 0x2f 
#define WFA_STA_VERIFY_IP_CONNECTION_RESP_TLV  0x30 /* 49 */
#define WFA_STA_GET_BSSID_RESP_TLV 0x31 /* 50 */
#define WFA_STA_GET_STATS_RESP_TLV 0x32
#define WFA_STA_SET_ENCRYPTION_RESP_TLV 0x33
#define WFA_STA_SET_PSK_RESP_TLV 0x34
#define WFA_STA_SET_EAPTLS_RESP_TLV 0x35
#define WFA_STA_SET_UAPSD_RESP_TLV 0x36
#define WFA_STA_ASSOCIATE_RESP_TLV 0x37
#define WFA_STA_SET_EAPTTLS_RESP_TLV   0x38
#define WFA_STA_SET_EAPSIM_RESP_TLV    0x39
#define WFA_STA_SET_PEAP_RESP_TLV      0x3a
#define WFA_STA_SET_IBSS_RESP_TLV      0x3b
#define WFA_STA_GET_INFO_RESP_TLV      0x3c
#define WFA_DEVICE_GET_INFO_RESP_TLV   0x3d
#define WFA_DEVICE_LIST_IF_RESP_TLV 0x3e 

#define WFA_STA_DEBUG_SET_RESP_TLV  0x3f
#define WFA_STA_SET_MODE_RESP_TLV   0x40 /* 31 */
#define WFA_STA_SET_WMM_RESP_TLV    0x41 /* 32 */
#define WFA_STA_RESPONSE_END        0x42
#define WFA_TLV_END WFA_STA_RESPONSE_END 
#endif //MindTree

#define WFA_TLV_HEAD_LEN 1+2

extern WORD wfaGetTag(BYTE *tlv_data);
extern void wfaSetTag(BYTE *tlv_data, BYTE new_tag);
extern WORD wfaGetTLVLen(BYTE *tlv_data);
extern WORD wfaGetValueLen(BYTE *tlv_data);
extern BOOL wfaGetValue(BYTE *pstr, int value_len, BYTE *tlv_data);
extern BOOL wfaIsValidTag(BYTE the_tag);
extern void wfaAliasByTag(BYTE the_tag, char *aliasStr);
extern BOOL wfaDecodeTLV(BYTE *tlv_data, int tlv_len, BYTE *ptlv_tag, int *ptlv_val_len, BYTE *ptlv_value);
extern BOOL wfaEncodeTLV(WORD the_tag, WORD the_len, BYTE *the_value, BYTE *tlv_data);

extern WORD wfaGetValueType(BYTE the_tag, BYTE *tlv_data);

#endif
