// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================

/* Copyright (C) 2010 Denali Software Inc.  All rights reserved              */
/* THIS FILE IS AUTOMATICALLY GENERATED BY DENALI BLUEPRINT, DO NOT EDIT     */


#ifndef _RTC_WLAN_REG_REG_H_
#define _RTC_WLAN_REG_REG_H_


/* macros for WLAN_RESET_CONTROL */
#define WLAN_RESET_CONTROL_ADDRESS                                                        0x00000000
#define WLAN_RESET_CONTROL_OFFSET                                                         0x00000000
#define WLAN_RESET_CONTROL_MAC_WARM_RST_MSB                                                        0
#define WLAN_RESET_CONTROL_MAC_WARM_RST_LSB                                                        0
#define WLAN_RESET_CONTROL_MAC_WARM_RST_MASK                                              0x00000001
#define WLAN_RESET_CONTROL_MAC_WARM_RST_GET(x)                             (((x) & 0x00000001) >> 0)
#define WLAN_RESET_CONTROL_MAC_WARM_RST_SET(x)                             (((x) << 0) & 0x00000001)
#define WLAN_RESET_CONTROL_MAC_COLD_RST_MSB                                                        1
#define WLAN_RESET_CONTROL_MAC_COLD_RST_LSB                                                        1
#define WLAN_RESET_CONTROL_MAC_COLD_RST_MASK                                              0x00000002
#define WLAN_RESET_CONTROL_MAC_COLD_RST_GET(x)                             (((x) & 0x00000002) >> 1)
#define WLAN_RESET_CONTROL_MAC_COLD_RST_SET(x)                             (((x) << 1) & 0x00000002)
#define WLAN_RESET_CONTROL_WARM_RST_MSB                                                            2
#define WLAN_RESET_CONTROL_WARM_RST_LSB                                                            2
#define WLAN_RESET_CONTROL_WARM_RST_MASK                                                  0x00000004
#define WLAN_RESET_CONTROL_WARM_RST_GET(x)                                 (((x) & 0x00000004) >> 2)
#define WLAN_RESET_CONTROL_WARM_RST_SET(x)                                 (((x) << 2) & 0x00000004)
#define WLAN_RESET_CONTROL_COLD_RST_MSB                                                            3
#define WLAN_RESET_CONTROL_COLD_RST_LSB                                                            3
#define WLAN_RESET_CONTROL_COLD_RST_MASK                                                  0x00000008
#define WLAN_RESET_CONTROL_COLD_RST_GET(x)                                 (((x) & 0x00000008) >> 3)
#define WLAN_RESET_CONTROL_COLD_RST_SET(x)                                 (((x) << 3) & 0x00000008)
#define WLAN_RESET_CONTROL_BB_WARM_RST_MSB                                                         4
#define WLAN_RESET_CONTROL_BB_WARM_RST_LSB                                                         4
#define WLAN_RESET_CONTROL_BB_WARM_RST_MASK                                               0x00000010
#define WLAN_RESET_CONTROL_BB_WARM_RST_GET(x)                              (((x) & 0x00000010) >> 4)
#define WLAN_RESET_CONTROL_BB_WARM_RST_SET(x)                              (((x) << 4) & 0x00000010)
#define WLAN_RESET_CONTROL_BB_COLD_RST_MSB                                                         5
#define WLAN_RESET_CONTROL_BB_COLD_RST_LSB                                                         5
#define WLAN_RESET_CONTROL_BB_COLD_RST_MASK                                               0x00000020
#define WLAN_RESET_CONTROL_BB_COLD_RST_GET(x)                              (((x) & 0x00000020) >> 5)
#define WLAN_RESET_CONTROL_BB_COLD_RST_SET(x)                              (((x) << 5) & 0x00000020)
#define WLAN_RESET_CONTROL_RADIO_SRESET_MSB                                                        6
#define WLAN_RESET_CONTROL_RADIO_SRESET_LSB                                                        6
#define WLAN_RESET_CONTROL_RADIO_SRESET_MASK                                              0x00000040
#define WLAN_RESET_CONTROL_RADIO_SRESET_GET(x)                             (((x) & 0x00000040) >> 6)
#define WLAN_RESET_CONTROL_RADIO_SRESET_SET(x)                             (((x) << 6) & 0x00000040)
#define WLAN_RESET_CONTROL_MCI_RESET_MSB                                                           7
#define WLAN_RESET_CONTROL_MCI_RESET_LSB                                                           7
#define WLAN_RESET_CONTROL_MCI_RESET_MASK                                                 0x00000080
#define WLAN_RESET_CONTROL_MCI_RESET_GET(x)                                (((x) & 0x00000080) >> 7)
#define WLAN_RESET_CONTROL_MCI_RESET_SET(x)                                (((x) << 7) & 0x00000080)

/* macros for WLAN_XTAL_CONTROL */
#define WLAN_XTAL_CONTROL_ADDRESS                                                         0x00000004
#define WLAN_XTAL_CONTROL_OFFSET                                                          0x00000004
#define WLAN_XTAL_CONTROL_TCXO_MSB                                                                 0
#define WLAN_XTAL_CONTROL_TCXO_LSB                                                                 0
#define WLAN_XTAL_CONTROL_TCXO_MASK                                                       0x00000001
#define WLAN_XTAL_CONTROL_TCXO_GET(x)                                      (((x) & 0x00000001) >> 0)
#define WLAN_XTAL_CONTROL_TCXO_SET(x)                                      (((x) << 0) & 0x00000001)

/* macros for WLAN_REG_CONTROL0 */
#define WLAN_REG_CONTROL0_ADDRESS                                                         0x00000008
#define WLAN_REG_CONTROL0_OFFSET                                                          0x00000008
#define WLAN_REG_CONTROL0_SWREG_BITS_MSB                                                          31
#define WLAN_REG_CONTROL0_SWREG_BITS_LSB                                                           0
#define WLAN_REG_CONTROL0_SWREG_BITS_MASK                                                 0xffffffff
#define WLAN_REG_CONTROL0_SWREG_BITS_GET(x)                                (((x) & 0xffffffff) >> 0)
#define WLAN_REG_CONTROL0_SWREG_BITS_SET(x)                                (((x) << 0) & 0xffffffff)

/* macros for WLAN_REG_CONTROL1 */
#define WLAN_REG_CONTROL1_ADDRESS                                                         0x0000000c
#define WLAN_REG_CONTROL1_OFFSET                                                          0x0000000c
#define WLAN_REG_CONTROL1_SWREG_PROGRAM_MSB                                                        0
#define WLAN_REG_CONTROL1_SWREG_PROGRAM_LSB                                                        0
#define WLAN_REG_CONTROL1_SWREG_PROGRAM_MASK                                              0x00000001
#define WLAN_REG_CONTROL1_SWREG_PROGRAM_GET(x)                             (((x) & 0x00000001) >> 0)
#define WLAN_REG_CONTROL1_SWREG_PROGRAM_SET(x)                             (((x) << 0) & 0x00000001)
#define WLAN_REG_CONTROL1_OTPREG_LVL_MSB                                                           2
#define WLAN_REG_CONTROL1_OTPREG_LVL_LSB                                                           1
#define WLAN_REG_CONTROL1_OTPREG_LVL_MASK                                                 0x00000006
#define WLAN_REG_CONTROL1_OTPREG_LVL_GET(x)                                (((x) & 0x00000006) >> 1)
#define WLAN_REG_CONTROL1_OTPREG_LVL_SET(x)                                (((x) << 1) & 0x00000006)

/* macros for WLAN_QUADRATURE */
#define WLAN_QUADRATURE_ADDRESS                                                           0x00000010
#define WLAN_QUADRATURE_OFFSET                                                            0x00000010
#define WLAN_QUADRATURE_DAC_MSB                                                                    2
#define WLAN_QUADRATURE_DAC_LSB                                                                    0
#define WLAN_QUADRATURE_DAC_MASK                                                          0x00000007
#define WLAN_QUADRATURE_DAC_GET(x)                                         (((x) & 0x00000007) >> 0)
#define WLAN_QUADRATURE_DAC_SET(x)                                         (((x) << 0) & 0x00000007)
#define WLAN_QUADRATURE_ADC_MSB                                                                    7
#define WLAN_QUADRATURE_ADC_LSB                                                                    4
#define WLAN_QUADRATURE_ADC_MASK                                                          0x000000f0
#define WLAN_QUADRATURE_ADC_GET(x)                                         (((x) & 0x000000f0) >> 4)
#define WLAN_QUADRATURE_ADC_SET(x)                                         (((x) << 4) & 0x000000f0)

/* macros for WLAN_PLL_CONTROL */
#define WLAN_PLL_CONTROL_ADDRESS                                                          0x00000014
#define WLAN_PLL_CONTROL_OFFSET                                                           0x00000014
#define WLAN_PLL_CONTROL_DIV_MSB                                                                   9
#define WLAN_PLL_CONTROL_DIV_LSB                                                                   0
#define WLAN_PLL_CONTROL_DIV_MASK                                                         0x000003ff
#define WLAN_PLL_CONTROL_DIV_GET(x)                                        (((x) & 0x000003ff) >> 0)
#define WLAN_PLL_CONTROL_DIV_SET(x)                                        (((x) << 0) & 0x000003ff)
#define WLAN_PLL_CONTROL_REFDIV_MSB                                                               13
#define WLAN_PLL_CONTROL_REFDIV_LSB                                                               10
#define WLAN_PLL_CONTROL_REFDIV_MASK                                                      0x00003c00
#define WLAN_PLL_CONTROL_REFDIV_GET(x)                                    (((x) & 0x00003c00) >> 10)
#define WLAN_PLL_CONTROL_REFDIV_SET(x)                                    (((x) << 10) & 0x00003c00)
#define WLAN_PLL_CONTROL_CLK_SEL_MSB                                                              15
#define WLAN_PLL_CONTROL_CLK_SEL_LSB                                                              14
#define WLAN_PLL_CONTROL_CLK_SEL_MASK                                                     0x0000c000
#define WLAN_PLL_CONTROL_CLK_SEL_GET(x)                                   (((x) & 0x0000c000) >> 14)
#define WLAN_PLL_CONTROL_CLK_SEL_SET(x)                                   (((x) << 14) & 0x0000c000)
#define WLAN_PLL_CONTROL_BYPASS_MSB                                                               16
#define WLAN_PLL_CONTROL_BYPASS_LSB                                                               16
#define WLAN_PLL_CONTROL_BYPASS_MASK                                                      0x00010000
#define WLAN_PLL_CONTROL_BYPASS_GET(x)                                    (((x) & 0x00010000) >> 16)
#define WLAN_PLL_CONTROL_BYPASS_SET(x)                                    (((x) << 16) & 0x00010000)
#define WLAN_PLL_CONTROL_UPDATING_MSB                                                             17
#define WLAN_PLL_CONTROL_UPDATING_LSB                                                             17
#define WLAN_PLL_CONTROL_UPDATING_MASK                                                    0x00020000
#define WLAN_PLL_CONTROL_UPDATING_GET(x)                                  (((x) & 0x00020000) >> 17)
#define WLAN_PLL_CONTROL_NOPWD_MSB                                                                18
#define WLAN_PLL_CONTROL_NOPWD_LSB                                                                18
#define WLAN_PLL_CONTROL_NOPWD_MASK                                                       0x00040000
#define WLAN_PLL_CONTROL_NOPWD_GET(x)                                     (((x) & 0x00040000) >> 18)
#define WLAN_PLL_CONTROL_NOPWD_SET(x)                                     (((x) << 18) & 0x00040000)
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_MSB                                                         19
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_LSB                                                         19
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_MASK                                                0x00080000
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_GET(x)                              (((x) & 0x00080000) >> 19)
#define WLAN_PLL_CONTROL_MAC_OVERRIDE_SET(x)                              (((x) << 19) & 0x00080000)
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_MSB                                                         20
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_LSB                                                         20
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_MASK                                                0x00100000
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_GET(x)                              (((x) & 0x00100000) >> 20)
#define WLAN_PLL_CONTROL_DIG_TEST_CLK_SET(x)                              (((x) << 20) & 0x00100000)

/* macros for WLAN_PLL_SETTLE */
#define WLAN_PLL_SETTLE_ADDRESS                                                           0x00000018
#define WLAN_PLL_SETTLE_OFFSET                                                            0x00000018
#define WLAN_PLL_SETTLE_TIME_MSB                                                                  10
#define WLAN_PLL_SETTLE_TIME_LSB                                                                   0
#define WLAN_PLL_SETTLE_TIME_MASK                                                         0x000007ff
#define WLAN_PLL_SETTLE_TIME_GET(x)                                        (((x) & 0x000007ff) >> 0)
#define WLAN_PLL_SETTLE_TIME_SET(x)                                        (((x) << 0) & 0x000007ff)

/* macros for WLAN_XTAL_SETTLE */
#define WLAN_XTAL_SETTLE_ADDRESS                                                          0x0000001c
#define WLAN_XTAL_SETTLE_OFFSET                                                           0x0000001c
#define WLAN_XTAL_SETTLE_TIME_MSB                                                                  6
#define WLAN_XTAL_SETTLE_TIME_LSB                                                                  0
#define WLAN_XTAL_SETTLE_TIME_MASK                                                        0x0000007f
#define WLAN_XTAL_SETTLE_TIME_GET(x)                                       (((x) & 0x0000007f) >> 0)
#define WLAN_XTAL_SETTLE_TIME_SET(x)                                       (((x) << 0) & 0x0000007f)

/* macros for WLAN_CLOCK_OUT */
#define WLAN_CLOCK_OUT_ADDRESS                                                            0x00000020
#define WLAN_CLOCK_OUT_OFFSET                                                             0x00000020
#define WLAN_CLOCK_OUT_SELECT_MSB                                                                  4
#define WLAN_CLOCK_OUT_SELECT_LSB                                                                  0
#define WLAN_CLOCK_OUT_SELECT_MASK                                                        0x0000001f
#define WLAN_CLOCK_OUT_SELECT_GET(x)                                       (((x) & 0x0000001f) >> 0)
#define WLAN_CLOCK_OUT_SELECT_SET(x)                                       (((x) << 0) & 0x0000001f)
#define WLAN_CLOCK_OUT_DELAY_MSB                                                                   7
#define WLAN_CLOCK_OUT_DELAY_LSB                                                                   5
#define WLAN_CLOCK_OUT_DELAY_MASK                                                         0x000000e0
#define WLAN_CLOCK_OUT_DELAY_GET(x)                                        (((x) & 0x000000e0) >> 5)
#define WLAN_CLOCK_OUT_DELAY_SET(x)                                        (((x) << 5) & 0x000000e0)

/* macros for WLAN_BIAS_OVERRIDE */
#define WLAN_BIAS_OVERRIDE_ADDRESS                                                        0x00000024
#define WLAN_BIAS_OVERRIDE_OFFSET                                                         0x00000024
#define WLAN_BIAS_OVERRIDE_ON_MSB                                                                  0
#define WLAN_BIAS_OVERRIDE_ON_LSB                                                                  0
#define WLAN_BIAS_OVERRIDE_ON_MASK                                                        0x00000001
#define WLAN_BIAS_OVERRIDE_ON_GET(x)                                       (((x) & 0x00000001) >> 0)
#define WLAN_BIAS_OVERRIDE_ON_SET(x)                                       (((x) << 0) & 0x00000001)

/* macros for WLAN_RESET_CAUSE */
#define WLAN_RESET_CAUSE_ADDRESS                                                          0x00000028
#define WLAN_RESET_CAUSE_OFFSET                                                           0x00000028
#define WLAN_RESET_CAUSE_LAST_MSB                                                                  2
#define WLAN_RESET_CAUSE_LAST_LSB                                                                  0
#define WLAN_RESET_CAUSE_LAST_MASK                                                        0x00000007
#define WLAN_RESET_CAUSE_LAST_GET(x)                                       (((x) & 0x00000007) >> 0)

/* macros for WLAN_SYSTEM_SLEEP */
#define WLAN_SYSTEM_SLEEP_ADDRESS                                                         0x0000002c
#define WLAN_SYSTEM_SLEEP_OFFSET                                                          0x0000002c
#define WLAN_SYSTEM_SLEEP_DISABLE_MSB                                                              0
#define WLAN_SYSTEM_SLEEP_DISABLE_LSB                                                              0
#define WLAN_SYSTEM_SLEEP_DISABLE_MASK                                                    0x00000001
#define WLAN_SYSTEM_SLEEP_DISABLE_GET(x)                                   (((x) & 0x00000001) >> 0)
#define WLAN_SYSTEM_SLEEP_DISABLE_SET(x)                                   (((x) << 0) & 0x00000001)
#define WLAN_SYSTEM_SLEEP_LIGHT_MSB                                                                1
#define WLAN_SYSTEM_SLEEP_LIGHT_LSB                                                                1
#define WLAN_SYSTEM_SLEEP_LIGHT_MASK                                                      0x00000002
#define WLAN_SYSTEM_SLEEP_LIGHT_GET(x)                                     (((x) & 0x00000002) >> 1)
#define WLAN_SYSTEM_SLEEP_LIGHT_SET(x)                                     (((x) << 1) & 0x00000002)
#define WLAN_SYSTEM_SLEEP_MAC_IF_MSB                                                               2
#define WLAN_SYSTEM_SLEEP_MAC_IF_LSB                                                               2
#define WLAN_SYSTEM_SLEEP_MAC_IF_MASK                                                     0x00000004
#define WLAN_SYSTEM_SLEEP_MAC_IF_GET(x)                                    (((x) & 0x00000004) >> 2)

/* macros for WLAN_MAC_SLEEP_CONTROL */
#define WLAN_MAC_SLEEP_CONTROL_ADDRESS                                                    0x00000030
#define WLAN_MAC_SLEEP_CONTROL_OFFSET                                                     0x00000030
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_MSB                                                          0
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_LSB                                                          0
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_MASK                                                0x00000001
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_GET(x)                               (((x) & 0x00000001) >> 0)
#define WLAN_MAC_SLEEP_CONTROL_ENABLE_SET(x)                               (((x) << 0) & 0x00000001)
#define WLAN_MAC_SLEEP_CONTROL_RESERVED_MSB                                                        1
#define WLAN_MAC_SLEEP_CONTROL_RESERVED_LSB                                                        1
#define WLAN_MAC_SLEEP_CONTROL_RESERVED_MASK                                              0x00000002
#define WLAN_MAC_SLEEP_CONTROL_RESERVED_GET(x)                             (((x) & 0x00000002) >> 1)
#define WLAN_MAC_SLEEP_CONTROL_RESERVED_SET(x)                             (((x) << 1) & 0x00000002)
#define WLAN_MAC_SLEEP_CONTROL_HSEL_WMAC_ENABLE_MSB                                                2
#define WLAN_MAC_SLEEP_CONTROL_HSEL_WMAC_ENABLE_LSB                                                2
#define WLAN_MAC_SLEEP_CONTROL_HSEL_WMAC_ENABLE_MASK                                      0x00000004
#define WLAN_MAC_SLEEP_CONTROL_HSEL_WMAC_ENABLE_GET(x)                     (((x) & 0x00000004) >> 2)
#define WLAN_MAC_SLEEP_CONTROL_HSEL_WMAC_ENABLE_SET(x)                     (((x) << 2) & 0x00000004)

/* macros for WLAN_KEEP_AWAKE */
#define WLAN_KEEP_AWAKE_ADDRESS                                                           0x00000034
#define WLAN_KEEP_AWAKE_OFFSET                                                            0x00000034
#define WLAN_KEEP_AWAKE_COUNT_MSB                                                                  7
#define WLAN_KEEP_AWAKE_COUNT_LSB                                                                  0
#define WLAN_KEEP_AWAKE_COUNT_MASK                                                        0x000000ff
#define WLAN_KEEP_AWAKE_COUNT_GET(x)                                       (((x) & 0x000000ff) >> 0)
#define WLAN_KEEP_AWAKE_COUNT_SET(x)                                       (((x) << 0) & 0x000000ff)

/* macros for WLAN_DERIVED_RTC_CLK */
#define WLAN_DERIVED_RTC_CLK_ADDRESS                                                      0x00000038
#define WLAN_DERIVED_RTC_CLK_OFFSET                                                       0x00000038
#define WLAN_DERIVED_RTC_CLK_PERIOD_MSB                                                           15
#define WLAN_DERIVED_RTC_CLK_PERIOD_LSB                                                            1
#define WLAN_DERIVED_RTC_CLK_PERIOD_MASK                                                  0x0000fffe
#define WLAN_DERIVED_RTC_CLK_PERIOD_GET(x)                                 (((x) & 0x0000fffe) >> 1)
#define WLAN_DERIVED_RTC_CLK_PERIOD_SET(x)                                 (((x) << 1) & 0x0000fffe)
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_MSB                                                  18
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_LSB                                                  18
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_MASK                                         0x00040000
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_GET(x)                       (((x) & 0x00040000) >> 18)
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_MSB                                               20
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_LSB                                               20
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_MASK                                      0x00100000
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_GET(x)                    (((x) & 0x00100000) >> 20)
#define WLAN_DERIVED_RTC_CLK_EXTERNAL_DETECT_EN_SET(x)                    (((x) << 20) & 0x00100000)

/* macros for MAC_PCU_SLP32_MODE */
#define MAC_PCU_SLP32_MODE_ADDRESS                                                        0x0000003c
#define MAC_PCU_SLP32_MODE_OFFSET                                                         0x0000003c
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_MSB                                                   19
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_LSB                                                    0
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_MASK                                          0x000fffff
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_GET(x)                         (((x) & 0x000fffff) >> 0)
#define MAC_PCU_SLP32_MODE_HALF_CLK_LATENCY_SET(x)                         (((x) << 0) & 0x000fffff)
#define MAC_PCU_SLP32_MODE_ENABLE_MSB                                                             20
#define MAC_PCU_SLP32_MODE_ENABLE_LSB                                                             20
#define MAC_PCU_SLP32_MODE_ENABLE_MASK                                                    0x00100000
#define MAC_PCU_SLP32_MODE_ENABLE_GET(x)                                  (((x) & 0x00100000) >> 20)
#define MAC_PCU_SLP32_MODE_ENABLE_SET(x)                                  (((x) << 20) & 0x00100000)
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_MSB                                                   21
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_LSB                                                   21
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_MASK                                          0x00200000
#define MAC_PCU_SLP32_MODE_TSF_WRITE_STATUS_GET(x)                        (((x) & 0x00200000) >> 21)
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_MSB                                                      22
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_LSB                                                      22
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_MASK                                             0x00400000
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_GET(x)                           (((x) & 0x00400000) >> 22)
#define MAC_PCU_SLP32_MODE_DISABLE_32KHZ_SET(x)                           (((x) << 22) & 0x00400000)
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_MSB                                                23
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_LSB                                                23
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_MASK                                       0x00800000
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_GET(x)                     (((x) & 0x00800000) >> 23)
#define MAC_PCU_SLP32_MODE_FORCE_BIAS_BLOCK_ON_SET(x)                     (((x) << 23) & 0x00800000)
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_MSB                                                  24
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_LSB                                                  24
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_MASK                                         0x01000000
#define MAC_PCU_SLP32_MODE_TSF2_WRITE_STATUS_GET(x)                       (((x) & 0x01000000) >> 24)

/* macros for MAC_PCU_SLP32_WAKE */
#define MAC_PCU_SLP32_WAKE_ADDRESS                                                        0x00000040
#define MAC_PCU_SLP32_WAKE_OFFSET                                                         0x00000040
#define MAC_PCU_SLP32_WAKE_XTL_TIME_MSB                                                           15
#define MAC_PCU_SLP32_WAKE_XTL_TIME_LSB                                                            0
#define MAC_PCU_SLP32_WAKE_XTL_TIME_MASK                                                  0x0000ffff
#define MAC_PCU_SLP32_WAKE_XTL_TIME_GET(x)                                 (((x) & 0x0000ffff) >> 0)
#define MAC_PCU_SLP32_WAKE_XTL_TIME_SET(x)                                 (((x) << 0) & 0x0000ffff)

/* macros for MAC_PCU_SLP32_INC */
#define MAC_PCU_SLP32_INC_ADDRESS                                                         0x00000044
#define MAC_PCU_SLP32_INC_OFFSET                                                          0x00000044
#define MAC_PCU_SLP32_INC_TSF_INC_MSB                                                             19
#define MAC_PCU_SLP32_INC_TSF_INC_LSB                                                              0
#define MAC_PCU_SLP32_INC_TSF_INC_MASK                                                    0x000fffff
#define MAC_PCU_SLP32_INC_TSF_INC_GET(x)                                   (((x) & 0x000fffff) >> 0)
#define MAC_PCU_SLP32_INC_TSF_INC_SET(x)                                   (((x) << 0) & 0x000fffff)

/* macros for MAC_PCU_SLP_MIB1 */
#define MAC_PCU_SLP_MIB1_ADDRESS                                                          0x00000048
#define MAC_PCU_SLP_MIB1_OFFSET                                                           0x00000048
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_MSB                                                            31
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_LSB                                                             0
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_MASK                                                   0xffffffff
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_GET(x)                                  (((x) & 0xffffffff) >> 0)
#define MAC_PCU_SLP_MIB1_SLEEP_CNT_SET(x)                                  (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_SLP_MIB2 */
#define MAC_PCU_SLP_MIB2_ADDRESS                                                          0x0000004c
#define MAC_PCU_SLP_MIB2_OFFSET                                                           0x0000004c
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_MSB                                                            31
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_LSB                                                             0
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_MASK                                                   0xffffffff
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_GET(x)                                  (((x) & 0xffffffff) >> 0)
#define MAC_PCU_SLP_MIB2_CYCLE_CNT_SET(x)                                  (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_SLP_MIB3 */
#define MAC_PCU_SLP_MIB3_ADDRESS                                                          0x00000050
#define MAC_PCU_SLP_MIB3_OFFSET                                                           0x00000050
#define MAC_PCU_SLP_MIB3_CLR_CNT_MSB                                                               0
#define MAC_PCU_SLP_MIB3_CLR_CNT_LSB                                                               0
#define MAC_PCU_SLP_MIB3_CLR_CNT_MASK                                                     0x00000001
#define MAC_PCU_SLP_MIB3_CLR_CNT_GET(x)                                    (((x) & 0x00000001) >> 0)
#define MAC_PCU_SLP_MIB3_CLR_CNT_SET(x)                                    (((x) << 0) & 0x00000001)
#define MAC_PCU_SLP_MIB3_PENDING_MSB                                                               1
#define MAC_PCU_SLP_MIB3_PENDING_LSB                                                               1
#define MAC_PCU_SLP_MIB3_PENDING_MASK                                                     0x00000002
#define MAC_PCU_SLP_MIB3_PENDING_GET(x)                                    (((x) & 0x00000002) >> 1)

/* macros for MAC_PCU_TSF_L32 */
#define MAC_PCU_TSF_L32_ADDRESS                                                           0x00000054
#define MAC_PCU_TSF_L32_OFFSET                                                            0x00000054
#define MAC_PCU_TSF_L32_VALUE_MSB                                                                 31
#define MAC_PCU_TSF_L32_VALUE_LSB                                                                  0
#define MAC_PCU_TSF_L32_VALUE_MASK                                                        0xffffffff
#define MAC_PCU_TSF_L32_VALUE_GET(x)                                       (((x) & 0xffffffff) >> 0)
#define MAC_PCU_TSF_L32_VALUE_SET(x)                                       (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_TSF_U32 */
#define MAC_PCU_TSF_U32_ADDRESS                                                           0x00000058
#define MAC_PCU_TSF_U32_OFFSET                                                            0x00000058
#define MAC_PCU_TSF_U32_VALUE_MSB                                                                 31
#define MAC_PCU_TSF_U32_VALUE_LSB                                                                  0
#define MAC_PCU_TSF_U32_VALUE_MASK                                                        0xffffffff
#define MAC_PCU_TSF_U32_VALUE_GET(x)                                       (((x) & 0xffffffff) >> 0)
#define MAC_PCU_TSF_U32_VALUE_SET(x)                                       (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_WBTIMER_0 */
#define MAC_PCU_WBTIMER_0_ADDRESS                                                         0x0000005c
#define MAC_PCU_WBTIMER_0_OFFSET                                                          0x0000005c
#define MAC_PCU_WBTIMER_0_ENABLE_MSB                                                               0
#define MAC_PCU_WBTIMER_0_ENABLE_LSB                                                               0
#define MAC_PCU_WBTIMER_0_ENABLE_MASK                                                     0x00000001
#define MAC_PCU_WBTIMER_0_ENABLE_GET(x)                                    (((x) & 0x00000001) >> 0)
#define MAC_PCU_WBTIMER_0_ENABLE_SET(x)                                    (((x) << 0) & 0x00000001)

/* macros for MAC_PCU_WBTIMER_1 */
#define MAC_PCU_WBTIMER_1_ADDRESS                                                         0x00000060
#define MAC_PCU_WBTIMER_1_OFFSET                                                          0x00000060
#define MAC_PCU_WBTIMER_1_VALUE_MSB                                                               31
#define MAC_PCU_WBTIMER_1_VALUE_LSB                                                                0
#define MAC_PCU_WBTIMER_1_VALUE_MASK                                                      0xffffffff
#define MAC_PCU_WBTIMER_1_VALUE_GET(x)                                     (((x) & 0xffffffff) >> 0)
#define MAC_PCU_WBTIMER_1_VALUE_SET(x)                                     (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_GENERIC_TIMERS */
#define MAC_PCU_GENERIC_TIMERS_ADDRESS                                                    0x00000064
#define MAC_PCU_GENERIC_TIMERS_OFFSET                                                     0x00000064
#define MAC_PCU_GENERIC_TIMERS_DATA_MSB                                                           31
#define MAC_PCU_GENERIC_TIMERS_DATA_LSB                                                            0
#define MAC_PCU_GENERIC_TIMERS_DATA_MASK                                                  0xffffffff
#define MAC_PCU_GENERIC_TIMERS_DATA_GET(x)                                 (((x) & 0xffffffff) >> 0)
#define MAC_PCU_GENERIC_TIMERS_DATA_SET(x)                                 (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_GENERIC_TIMERS_MODE */
#define MAC_PCU_GENERIC_TIMERS_MODE_ADDRESS                                               0x000000bc
#define MAC_PCU_GENERIC_TIMERS_MODE_OFFSET                                                0x000000bc
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_MSB                                                     7
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_LSB                                                     0
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_MASK                                           0x000000ff
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_GET(x)                          (((x) & 0x000000ff) >> 0)
#define MAC_PCU_GENERIC_TIMERS_MODE_ENABLE_SET(x)                          (((x) << 0) & 0x000000ff)
#define MAC_PCU_GENERIC_TIMERS_MODE_OVERFLOW_INDEX_MSB                                            10
#define MAC_PCU_GENERIC_TIMERS_MODE_OVERFLOW_INDEX_LSB                                             8
#define MAC_PCU_GENERIC_TIMERS_MODE_OVERFLOW_INDEX_MASK                                   0x00000700
#define MAC_PCU_GENERIC_TIMERS_MODE_OVERFLOW_INDEX_GET(x)                  (((x) & 0x00000700) >> 8)
#define MAC_PCU_GENERIC_TIMERS_MODE_THRESH_MSB                                                    31
#define MAC_PCU_GENERIC_TIMERS_MODE_THRESH_LSB                                                    12
#define MAC_PCU_GENERIC_TIMERS_MODE_THRESH_MASK                                           0xfffff000
#define MAC_PCU_GENERIC_TIMERS_MODE_THRESH_GET(x)                         (((x) & 0xfffff000) >> 12)
#define MAC_PCU_GENERIC_TIMERS_MODE_THRESH_SET(x)                         (((x) << 12) & 0xfffff000)

/* macros for MAC_PCU_SLP1 */
#define MAC_PCU_SLP1_ADDRESS                                                              0x000000c0
#define MAC_PCU_SLP1_OFFSET                                                               0x000000c0
#define MAC_PCU_SLP1_CAB_TIMEOUT_EXT_MSB                                                           4
#define MAC_PCU_SLP1_CAB_TIMEOUT_EXT_LSB                                                           0
#define MAC_PCU_SLP1_CAB_TIMEOUT_EXT_MASK                                                 0x0000001f
#define MAC_PCU_SLP1_CAB_TIMEOUT_EXT_GET(x)                                (((x) & 0x0000001f) >> 0)
#define MAC_PCU_SLP1_CAB_TIMEOUT_EXT_SET(x)                                (((x) << 0) & 0x0000001f)
#define MAC_PCU_SLP1_ASSUME_DTIM_MSB                                                              19
#define MAC_PCU_SLP1_ASSUME_DTIM_LSB                                                              19
#define MAC_PCU_SLP1_ASSUME_DTIM_MASK                                                     0x00080000
#define MAC_PCU_SLP1_ASSUME_DTIM_GET(x)                                   (((x) & 0x00080000) >> 19)
#define MAC_PCU_SLP1_ASSUME_DTIM_SET(x)                                   (((x) << 19) & 0x00080000)
#define MAC_PCU_SLP1_BUG_59985_FIX_ENABLE_MSB                                                     20
#define MAC_PCU_SLP1_BUG_59985_FIX_ENABLE_LSB                                                     20
#define MAC_PCU_SLP1_BUG_59985_FIX_ENABLE_MASK                                            0x00100000
#define MAC_PCU_SLP1_BUG_59985_FIX_ENABLE_GET(x)                          (((x) & 0x00100000) >> 20)
#define MAC_PCU_SLP1_BUG_59985_FIX_ENABLE_SET(x)                          (((x) << 20) & 0x00100000)
#define MAC_PCU_SLP1_CAB_TIMEOUT_MSB                                                              31
#define MAC_PCU_SLP1_CAB_TIMEOUT_LSB                                                              21
#define MAC_PCU_SLP1_CAB_TIMEOUT_MASK                                                     0xffe00000
#define MAC_PCU_SLP1_CAB_TIMEOUT_GET(x)                                   (((x) & 0xffe00000) >> 21)
#define MAC_PCU_SLP1_CAB_TIMEOUT_SET(x)                                   (((x) << 21) & 0xffe00000)

/* macros for MAC_PCU_SLP2 */
#define MAC_PCU_SLP2_ADDRESS                                                              0x000000c4
#define MAC_PCU_SLP2_OFFSET                                                               0x000000c4
#define MAC_PCU_SLP2_BEACON_TIMEOUT_EXT_MSB                                                        4
#define MAC_PCU_SLP2_BEACON_TIMEOUT_EXT_LSB                                                        0
#define MAC_PCU_SLP2_BEACON_TIMEOUT_EXT_MASK                                              0x0000001f
#define MAC_PCU_SLP2_BEACON_TIMEOUT_EXT_GET(x)                             (((x) & 0x0000001f) >> 0)
#define MAC_PCU_SLP2_BEACON_TIMEOUT_EXT_SET(x)                             (((x) << 0) & 0x0000001f)
#define MAC_PCU_SLP2_BEACON_TIMEOUT_MSB                                                           31
#define MAC_PCU_SLP2_BEACON_TIMEOUT_LSB                                                           21
#define MAC_PCU_SLP2_BEACON_TIMEOUT_MASK                                                  0xffe00000
#define MAC_PCU_SLP2_BEACON_TIMEOUT_GET(x)                                (((x) & 0xffe00000) >> 21)
#define MAC_PCU_SLP2_BEACON_TIMEOUT_SET(x)                                (((x) << 21) & 0xffe00000)

/* macros for MAC_PCU_SLP3 */
#define MAC_PCU_SLP3_ADDRESS                                                              0x000000c8
#define MAC_PCU_SLP3_OFFSET                                                               0x000000c8
#define MAC_PCU_SLP3_CAB_AWAKE_DUR_MSB                                                            15
#define MAC_PCU_SLP3_CAB_AWAKE_DUR_LSB                                                             0
#define MAC_PCU_SLP3_CAB_AWAKE_DUR_MASK                                                   0x0000ffff
#define MAC_PCU_SLP3_CAB_AWAKE_DUR_GET(x)                                  (((x) & 0x0000ffff) >> 0)
#define MAC_PCU_SLP3_CAB_AWAKE_DUR_SET(x)                                  (((x) << 0) & 0x0000ffff)
#define MAC_PCU_SLP3_CAB_AWAKE_ENABLE_MSB                                                         16
#define MAC_PCU_SLP3_CAB_AWAKE_ENABLE_LSB                                                         16
#define MAC_PCU_SLP3_CAB_AWAKE_ENABLE_MASK                                                0x00010000
#define MAC_PCU_SLP3_CAB_AWAKE_ENABLE_GET(x)                              (((x) & 0x00010000) >> 16)
#define MAC_PCU_SLP3_CAB_AWAKE_ENABLE_SET(x)                              (((x) << 16) & 0x00010000)

/* macros for MAC_PCU_SLP4 */
#define MAC_PCU_SLP4_ADDRESS                                                              0x000000cc
#define MAC_PCU_SLP4_OFFSET                                                               0x000000cc
#define MAC_PCU_SLP4_BEACON2_TIMEOUT_MSB                                                          15
#define MAC_PCU_SLP4_BEACON2_TIMEOUT_LSB                                                           0
#define MAC_PCU_SLP4_BEACON2_TIMEOUT_MASK                                                 0x0000ffff
#define MAC_PCU_SLP4_BEACON2_TIMEOUT_GET(x)                                (((x) & 0x0000ffff) >> 0)
#define MAC_PCU_SLP4_BEACON2_TIMEOUT_SET(x)                                (((x) << 0) & 0x0000ffff)
#define MAC_PCU_SLP4_CAB2_TIMEOUT_MSB                                                             30
#define MAC_PCU_SLP4_CAB2_TIMEOUT_LSB                                                             16
#define MAC_PCU_SLP4_CAB2_TIMEOUT_MASK                                                    0x7fff0000
#define MAC_PCU_SLP4_CAB2_TIMEOUT_GET(x)                                  (((x) & 0x7fff0000) >> 16)
#define MAC_PCU_SLP4_CAB2_TIMEOUT_SET(x)                                  (((x) << 16) & 0x7fff0000)
#define MAC_PCU_SLP4_ASSUME_DTIM2_MSB                                                             31
#define MAC_PCU_SLP4_ASSUME_DTIM2_LSB                                                             31
#define MAC_PCU_SLP4_ASSUME_DTIM2_MASK                                                    0x80000000
#define MAC_PCU_SLP4_ASSUME_DTIM2_GET(x)                                  (((x) & 0x80000000) >> 31)
#define MAC_PCU_SLP4_ASSUME_DTIM2_SET(x)                                  (((x) << 31) & 0x80000000)

/* macros for MAC_PCU_RESET_TSF */
#define MAC_PCU_RESET_TSF_ADDRESS                                                         0x000000d0
#define MAC_PCU_RESET_TSF_OFFSET                                                          0x000000d0
#define MAC_PCU_RESET_TSF_ONE_SHOT_MSB                                                            24
#define MAC_PCU_RESET_TSF_ONE_SHOT_LSB                                                            24
#define MAC_PCU_RESET_TSF_ONE_SHOT_MASK                                                   0x01000000
#define MAC_PCU_RESET_TSF_ONE_SHOT_GET(x)                                 (((x) & 0x01000000) >> 24)
#define MAC_PCU_RESET_TSF_ONE_SHOT_SET(x)                                 (((x) << 24) & 0x01000000)
#define MAC_PCU_RESET_TSF_ONE_SHOT2_MSB                                                           25
#define MAC_PCU_RESET_TSF_ONE_SHOT2_LSB                                                           25
#define MAC_PCU_RESET_TSF_ONE_SHOT2_MASK                                                  0x02000000
#define MAC_PCU_RESET_TSF_ONE_SHOT2_GET(x)                                (((x) & 0x02000000) >> 25)
#define MAC_PCU_RESET_TSF_ONE_SHOT2_SET(x)                                (((x) << 25) & 0x02000000)

/* macros for MAC_PCU_TSF2_L32 */
#define MAC_PCU_TSF2_L32_ADDRESS                                                          0x000000d4
#define MAC_PCU_TSF2_L32_OFFSET                                                           0x000000d4
#define MAC_PCU_TSF2_L32_VALUE_MSB                                                                31
#define MAC_PCU_TSF2_L32_VALUE_LSB                                                                 0
#define MAC_PCU_TSF2_L32_VALUE_MASK                                                       0xffffffff
#define MAC_PCU_TSF2_L32_VALUE_GET(x)                                      (((x) & 0xffffffff) >> 0)
#define MAC_PCU_TSF2_L32_VALUE_SET(x)                                      (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_TSF2_U32 */
#define MAC_PCU_TSF2_U32_ADDRESS                                                          0x000000d8
#define MAC_PCU_TSF2_U32_OFFSET                                                           0x000000d8
#define MAC_PCU_TSF2_U32_VALUE_MSB                                                                31
#define MAC_PCU_TSF2_U32_VALUE_LSB                                                                 0
#define MAC_PCU_TSF2_U32_VALUE_MASK                                                       0xffffffff
#define MAC_PCU_TSF2_U32_VALUE_GET(x)                                      (((x) & 0xffffffff) >> 0)
#define MAC_PCU_TSF2_U32_VALUE_SET(x)                                      (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_GENERIC_TIMERS2 */
#define MAC_PCU_GENERIC_TIMERS2_ADDRESS                                                   0x000000dc
#define MAC_PCU_GENERIC_TIMERS2_OFFSET                                                    0x000000dc
#define MAC_PCU_GENERIC_TIMERS2_DATA_MSB                                                          31
#define MAC_PCU_GENERIC_TIMERS2_DATA_LSB                                                           0
#define MAC_PCU_GENERIC_TIMERS2_DATA_MASK                                                 0xffffffff
#define MAC_PCU_GENERIC_TIMERS2_DATA_GET(x)                                (((x) & 0xffffffff) >> 0)
#define MAC_PCU_GENERIC_TIMERS2_DATA_SET(x)                                (((x) << 0) & 0xffffffff)

/* macros for MAC_PCU_GENERIC_TIMERS_MODE2 */
#define MAC_PCU_GENERIC_TIMERS_MODE2_ADDRESS                                              0x00000134
#define MAC_PCU_GENERIC_TIMERS_MODE2_OFFSET                                               0x00000134
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_MSB                                                    7
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_LSB                                                    0
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_MASK                                          0x000000ff
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_GET(x)                         (((x) & 0x000000ff) >> 0)
#define MAC_PCU_GENERIC_TIMERS_MODE2_ENABLE_SET(x)                         (((x) << 0) & 0x000000ff)
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX_MSB                                           11
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX_LSB                                            8
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX_MASK                                  0x00000f00
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX_GET(x)                 (((x) & 0x00000f00) >> 8)
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX2_MSB                                          15
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX2_LSB                                          12
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX2_MASK                                 0x0000f000
#define MAC_PCU_GENERIC_TIMERS_MODE2_OVERFLOW_INDEX2_GET(x)               (((x) & 0x0000f000) >> 12)

/* macros for MAC_PCU_TSF_THRESHOLD */
#define MAC_PCU_TSF_THRESHOLD_ADDRESS                                                     0x00000144
#define MAC_PCU_TSF_THRESHOLD_OFFSET                                                      0x00000144
#define MAC_PCU_TSF_THRESHOLD_VALUE_MSB                                                           15
#define MAC_PCU_TSF_THRESHOLD_VALUE_LSB                                                            0
#define MAC_PCU_TSF_THRESHOLD_VALUE_MASK                                                  0x0000ffff
#define MAC_PCU_TSF_THRESHOLD_VALUE_GET(x)                                 (((x) & 0x0000ffff) >> 0)
#define MAC_PCU_TSF_THRESHOLD_VALUE_SET(x)                                 (((x) << 0) & 0x0000ffff)

/* macros for WLAN_HT */
#define WLAN_HT_ADDRESS                                                                   0x00000148
#define WLAN_HT_OFFSET                                                                    0x00000148
#define WLAN_HT_MODE_MSB                                                                           0
#define WLAN_HT_MODE_LSB                                                                           0
#define WLAN_HT_MODE_MASK                                                                 0x00000001
#define WLAN_HT_MODE_GET(x)                                                (((x) & 0x00000001) >> 0)
#define WLAN_HT_MODE_SET(x)                                                (((x) << 0) & 0x00000001)

/* macros for MAC_PCU_GENERIC_TIMERS_TSF_SEL */
#define MAC_PCU_GENERIC_TIMERS_TSF_SEL_ADDRESS                                            0x00000150
#define MAC_PCU_GENERIC_TIMERS_TSF_SEL_OFFSET                                             0x00000150
#define MAC_PCU_GENERIC_TIMERS_TSF_SEL_VALUE_MSB                                                  15
#define MAC_PCU_GENERIC_TIMERS_TSF_SEL_VALUE_LSB                                                   0
#define MAC_PCU_GENERIC_TIMERS_TSF_SEL_VALUE_MASK                                         0x0000ffff
#define MAC_PCU_GENERIC_TIMERS_TSF_SEL_VALUE_GET(x)                        (((x) & 0x0000ffff) >> 0)
#define MAC_PCU_GENERIC_TIMERS_TSF_SEL_VALUE_SET(x)                        (((x) << 0) & 0x0000ffff)

/* macros for MAC_PCU_BMISS_TIMEOUT */
#define MAC_PCU_BMISS_TIMEOUT_ADDRESS                                                     0x00000154
#define MAC_PCU_BMISS_TIMEOUT_OFFSET                                                      0x00000154
#define MAC_PCU_BMISS_TIMEOUT_VALUE_MSB                                                           23
#define MAC_PCU_BMISS_TIMEOUT_VALUE_LSB                                                            0
#define MAC_PCU_BMISS_TIMEOUT_VALUE_MASK                                                  0x00ffffff
#define MAC_PCU_BMISS_TIMEOUT_VALUE_GET(x)                                 (((x) & 0x00ffffff) >> 0)
#define MAC_PCU_BMISS_TIMEOUT_VALUE_SET(x)                                 (((x) << 0) & 0x00ffffff)
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_MSB                                                          24
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_LSB                                                          24
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_MASK                                                 0x01000000
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_GET(x)                               (((x) & 0x01000000) >> 24)
#define MAC_PCU_BMISS_TIMEOUT_ENABLE_SET(x)                               (((x) << 24) & 0x01000000)

/* macros for MAC_PCU_BMISS2_TIMEOUT */
#define MAC_PCU_BMISS2_TIMEOUT_ADDRESS                                                    0x00000158
#define MAC_PCU_BMISS2_TIMEOUT_OFFSET                                                     0x00000158
#define MAC_PCU_BMISS2_TIMEOUT_VALUE_MSB                                                          23
#define MAC_PCU_BMISS2_TIMEOUT_VALUE_LSB                                                           0
#define MAC_PCU_BMISS2_TIMEOUT_VALUE_MASK                                                 0x00ffffff
#define MAC_PCU_BMISS2_TIMEOUT_VALUE_GET(x)                                (((x) & 0x00ffffff) >> 0)
#define MAC_PCU_BMISS2_TIMEOUT_VALUE_SET(x)                                (((x) << 0) & 0x00ffffff)
#define MAC_PCU_BMISS2_TIMEOUT_ENABLE_MSB                                                         24
#define MAC_PCU_BMISS2_TIMEOUT_ENABLE_LSB                                                         24
#define MAC_PCU_BMISS2_TIMEOUT_ENABLE_MASK                                                0x01000000
#define MAC_PCU_BMISS2_TIMEOUT_ENABLE_GET(x)                              (((x) & 0x01000000) >> 24)
#define MAC_PCU_BMISS2_TIMEOUT_ENABLE_SET(x)                              (((x) << 24) & 0x01000000)

/* macros for RTC_AXI_AHB_BRIDGE */
#define RTC_AXI_AHB_BRIDGE_ADDRESS                                                        0x0000015c
#define RTC_AXI_AHB_BRIDGE_OFFSET                                                         0x0000015c
#define RTC_AXI_AHB_BRIDGE_MAX_BEATS_MSB                                                           1
#define RTC_AXI_AHB_BRIDGE_MAX_BEATS_LSB                                                           0
#define RTC_AXI_AHB_BRIDGE_MAX_BEATS_MASK                                                 0x00000003
#define RTC_AXI_AHB_BRIDGE_MAX_BEATS_GET(x)                                (((x) & 0x00000003) >> 0)
#define RTC_AXI_AHB_BRIDGE_MAX_BEATS_SET(x)                                (((x) << 0) & 0x00000003)

/* macros for UNIFIED_MAC_REVID */
#define UNIFIED_MAC_REVID_ADDRESS                                                         0x00000160
#define UNIFIED_MAC_REVID_OFFSET                                                          0x00000160
#define UNIFIED_MAC_REVID_VALUE_MSB                                                               31
#define UNIFIED_MAC_REVID_VALUE_LSB                                                                0
#define UNIFIED_MAC_REVID_VALUE_MASK                                                      0xffffffff
#define UNIFIED_MAC_REVID_VALUE_GET(x)                                     (((x) & 0xffffffff) >> 0)


#ifndef __ASSEMBLER__

typedef struct rtc_wlan_reg_reg_s {
  volatile unsigned int WLAN_RESET_CONTROL;                            /*        0x0 - 0x4        */
  volatile unsigned int WLAN_XTAL_CONTROL;                             /*        0x4 - 0x8        */
  volatile unsigned int WLAN_REG_CONTROL0;                             /*        0x8 - 0xc        */
  volatile unsigned int WLAN_REG_CONTROL1;                             /*        0xc - 0x10       */
  volatile unsigned int WLAN_QUADRATURE;                               /*       0x10 - 0x14       */
  volatile unsigned int WLAN_PLL_CONTROL;                              /*       0x14 - 0x18       */
  volatile unsigned int WLAN_PLL_SETTLE;                               /*       0x18 - 0x1c       */
  volatile unsigned int WLAN_XTAL_SETTLE;                              /*       0x1c - 0x20       */
  volatile unsigned int WLAN_CLOCK_OUT;                                /*       0x20 - 0x24       */
  volatile unsigned int WLAN_BIAS_OVERRIDE;                            /*       0x24 - 0x28       */
  volatile unsigned int WLAN_RESET_CAUSE;                              /*       0x28 - 0x2c       */
  volatile unsigned int WLAN_SYSTEM_SLEEP;                             /*       0x2c - 0x30       */
  volatile unsigned int WLAN_MAC_SLEEP_CONTROL;                        /*       0x30 - 0x34       */
  volatile unsigned int WLAN_KEEP_AWAKE;                               /*       0x34 - 0x38       */
  volatile unsigned int WLAN_DERIVED_RTC_CLK;                          /*       0x38 - 0x3c       */
  volatile unsigned int MAC_PCU_SLP32_MODE;                            /*       0x3c - 0x40       */
  volatile unsigned int MAC_PCU_SLP32_WAKE;                            /*       0x40 - 0x44       */
  volatile unsigned int MAC_PCU_SLP32_INC;                             /*       0x44 - 0x48       */
  volatile unsigned int MAC_PCU_SLP_MIB1;                              /*       0x48 - 0x4c       */
  volatile unsigned int MAC_PCU_SLP_MIB2;                              /*       0x4c - 0x50       */
  volatile unsigned int MAC_PCU_SLP_MIB3;                              /*       0x50 - 0x54       */
  volatile unsigned int MAC_PCU_TSF_L32;                               /*       0x54 - 0x58       */
  volatile unsigned int MAC_PCU_TSF_U32;                               /*       0x58 - 0x5c       */
  volatile unsigned int MAC_PCU_WBTIMER_0;                             /*       0x5c - 0x60       */
  volatile unsigned int MAC_PCU_WBTIMER_1;                             /*       0x60 - 0x64       */
  volatile unsigned int MAC_PCU_GENERIC_TIMERS[16];                    /*       0x64 - 0xa4       */
  volatile char pad__0[0x18];                                          /*       0xa4 - 0xbc       */
  volatile unsigned int MAC_PCU_GENERIC_TIMERS_MODE;                   /*       0xbc - 0xc0       */
  volatile unsigned int MAC_PCU_SLP1;                                  /*       0xc0 - 0xc4       */
  volatile unsigned int MAC_PCU_SLP2;                                  /*       0xc4 - 0xc8       */
  volatile unsigned int MAC_PCU_SLP3;                                  /*       0xc8 - 0xcc       */
  volatile unsigned int MAC_PCU_SLP4;                                  /*       0xcc - 0xd0       */
  volatile unsigned int MAC_PCU_RESET_TSF;                             /*       0xd0 - 0xd4       */
  volatile unsigned int MAC_PCU_TSF2_L32;                              /*       0xd4 - 0xd8       */
  volatile unsigned int MAC_PCU_TSF2_U32;                              /*       0xd8 - 0xdc       */
  volatile unsigned int MAC_PCU_GENERIC_TIMERS2[16];                   /*       0xdc - 0x11c      */
  volatile char pad__1[0x18];                                          /*      0x11c - 0x134      */
  volatile unsigned int MAC_PCU_GENERIC_TIMERS_MODE2;                  /*      0x134 - 0x138      */
  volatile char pad__2[0xc];                                           /*      0x138 - 0x144      */
  volatile unsigned int MAC_PCU_TSF_THRESHOLD;                         /*      0x144 - 0x148      */
  volatile unsigned int WLAN_HT;                                       /*      0x148 - 0x14c      */
  volatile char pad__3[0x4];                                           /*      0x14c - 0x150      */
  volatile unsigned int MAC_PCU_GENERIC_TIMERS_TSF_SEL;                /*      0x150 - 0x154      */
  volatile unsigned int MAC_PCU_BMISS_TIMEOUT;                         /*      0x154 - 0x158      */
  volatile unsigned int MAC_PCU_BMISS2_TIMEOUT;                        /*      0x158 - 0x15c      */
  volatile unsigned int RTC_AXI_AHB_BRIDGE;                            /*      0x15c - 0x160      */
  volatile unsigned int UNIFIED_MAC_REVID;                             /*      0x160 - 0x164      */
} rtc_wlan_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _RTC_WLAN_REG_REG_H_ */
