/* packet-ams.h
 *
 * $Id: packet-ams.h 46748 2012-12-26 05:57:06Z guy $
 *
 * Copyright (c) 2007 by Beckhoff Automation GmbH
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PACKET_AMS_H__
#define __PACKET_AMS_H__

/* FIXED PORTS */

#define AMSPORT_ROUTER            1
#define AMSPORT_DEBUGGER          2

#define AMSPORT_LOGGER            100
#define AMSPORT_EVENTLOG          110
#define AMSPORT_R0_RTIME          200
#define AMSPORT_R0_TRACE          (AMSPORT_R0_RTIME+90)
#define AMSPORT_R0_IO             300
#define AMSPORT_R0_SPS            400
#define AMSPORT_R0_NC             500
#define AMSPORT_R0_NCSAF          501
#define AMSPORT_R0_NCSVB          511
#define AMSPORT_R0_ISG            550
#define AMSPORT_R0_CNC            600
#define AMSPORT_R0_LINE           700
#define AMSPORT_R0_PLC            800
#define AMSPORT_R0_CAM            900
#define AMSPORT_R0_CAMTOOL        950

#define AMSPORT_R0_IOPORTBEGIN    1000
#define AMSPORT_R0_IOPORTEND      1199

#define AMSPORT_R0_USER           2000

#define AMSPORT_R3_SYSSERV        10000
#define AMSPORT_R3_CTRLPROG       10000
#define AMSPORT_R3_SYSCTRL        10001
#define AMSPORT_R3_SYSSAMPLER     10100
#define AMSPORT_R3_TCPRAWCONN     10200
#define AMSPORT_R3_TCPIPSERVER    10201
#define AMSPORT_R3_SYSMANAGER     10300
#define AMSPORT_R3_SMSSERVER      10400
#define AMSPORT_R3_MODBUSSERVER   10500
#define AMSPORT_R3_PLCCONTROL     10800
#define AMSPORT_R3_NCCTRL         11000
#define AMSPORT_R3_NCINTERPRETER  11500
#define AMSPORT_R3_STRECKECTRL    12000
#define AMSPORT_R3_CAMCTRL        13000
#define AMSPORT_R3_SCOPE          14000
#define AMSPORT_R3_SINECH1        15000
#define AMSPORT_R3_CONTROLNET     16000
#define AMSPORT_R3_OPCSERVER      17000
#define AMSPORT_R3_OPCCLIENT      17500

#define AMSPORT_R3_CUSTOMER_FIRST 25000
#define AMSPORT_R3_CUSTOMER_LAST  25999

#define AMSPORT_FIRST 1
#define AMSPORT_LAST  0xFFFE

#define AMSPORT_UNFIXEDPORT 0
#define AMSPORT_USEDEFAULT  0xFFFF

#define AMSPORT_IOBOXBEGIN_USB 0x6E00
#define AMSPORT_IOBOXEND_USB   0x6EFF
#define AMSPORT_IODEVBEGIN     0x7000
#define AMSPORT_IODEVEND       0x70FF
#define AMSPORT_IOBOXBEGIN     0x7100
#define AMSPORT_IOBOXEND       0x7FFF

#define AMSPORT_FREEBEGIN 0x8000
#define AMSPORT_FREEEND   0xBFFF


#define AMSPORT_NAMESIZE 31

/* Port types */
typedef enum
{
   PORTTYPE_INVALID    = -1,
   PORTTYPE_ROUTER     = 0x00,
   PORTTYPE_R3PORT     = 0x01,
   PORTTYPE_R0CTRLPORT = 0x02,
   PORTTYPE_R0TASKPORT = 0x03,
   PORTTYPE_R0IOPORT   = 0x04,
   PORTTYPE_TPPORT     = 0x05,
   PORTTYPE_MAXVAL     = 0xFF
}AMSPORT_TYPE;

/* Command IDs */

#define AMSCMD_LOGMESSAGE       0x0001
#define AMSCMD_ROUTERSHUTDOWN   0x0002
#define AMSCMD_ROUTERACTIVATED  0x0003
#define AMSCMD_SYSTEMREMOVED    0x0004
#define AMSCMD_CLOSECONNECTION  0x0005
#define AMSCMD_SIGNALSTART      0x00FB
#define AMSCMD_SIGNALSTOP       0x00FC
#define AMSCMD_HANDLERETAINDATA 0x00FD
#define AMSCMD_DEVICECONFIGID   0x00FE
#define AMSCMD_DOWNLOADSYMBOLS  0x00FF

#define AMS_ERRLOGCMDS          0x100

#define AMS_TASKCMDS            0x500
#define AMS_CTRLCMDS            0x600

#define AMS_ROUTERCMDS          0x900
#define AMS_RTIMECMDS           0x1000
#define AMS_TRACECMDS           (AMS_RTIMECMDS+0x900)
#define AMS_IOCMDS              0x2000
#define AMS_C1220CMDS           (AMS_IOCMDS+0x100)
#define AMS_FCxxxxCMDS          (AMS_IOCMDS+0x200)
#define AMS_SPSCMDS             0x3000
#define AMS_NCCMDS              0x4000
#define AMS_PLCCMDS             0x5000
#define AMS_LINECMDS            0x6000
#define AMS_CAMCMDS             0x7000

#define AMS_CMDSPECIFIC         0x8000


#define AMSERRCODEISWARNING     0x80000000

/* Error Arrays */

#define ERR_ROUTERERRS    0x0500
#define ERR_TASKERRS      0x0600
#define ERR_ADSERRS       0x0700
#define ERR_SYSSMPLERRS   0x0800
#define ERR_RTIMEERRS     0x1000
#define ERR_TRACEERRS     (ERR_RTIMEERRS+0x900)
#define ERR_IOERRS        0x2000
#define ERR_DPSLAVE       (ERR_IOERRS+0x900)
#define ERR_CP5412A2      (ERR_IOERRS+0xA00)
#define ERR_ASP           (ERR_IOERRS+0xB00)
#define ERR_CANSLAVE      (ERR_IOERRS+0xC00)
#define ERR_CIF30         (ERR_IOERRS+0xD00)
#define ERR_IBSSLAVE      (ERR_IOERRS+0xE00)
#define ERR_SPSERRS       0x3000
#define ERR_NCERRS        0x4000
#define ERR_PLCERRS       0x6000
#define ERR_STRKERRS      0x7000

#define ERR_PRJSPECIFIC   0x7800

#define ERR_DRIVEERRS_C3D 0xD000
#define ERR_DRIVEERRS_C2D 0xE000
#define ERR_DRIVEERRS_C1D 0xF000


/* Global Error codes */
#define ERR_NOERROR               0
#define ERR_INTERNAL              1
#define ERR_NORTIME               2
#define ERR_ALLOCLOCKEDMEM        3
#define ERR_INSERTMAILBOX         4
#define ERR_WRONGRECEIVEHMSG      5
#define ERR_TARGETPORTNOTFOUND    6
#define ERR_TARGETMACHINENOTFOUND 7
#define ERR_UNKNOWNCMDID          8
#define ERR_BADTASKID             9
#define ERR_NOIO                  10
#define ERR_UNKNOWNAMSCMD         11
#define ERR_WIN32ERROR            12
#define ERR_PORTNOTCONNECTED      13
#define ERR_INVALIDAMSLENGTH      14
#define ERR_INVALIDAMSNETID       15
#define ERR_LOWINSTLEVEL          16
#define ERR_NODEBUGINTAVAILABLE   17
#define ERR_PORTDISABLED          18
#define ERR_PORTALREADYCONNECTED  19
#define ERR_AMSSYNC_W32ERROR      20
#define ERR_AMSSYNC_TIMEOUT       21
#define ERR_AMSSYNC_AMSERROR      22
#define ERR_AMSSYNC_NOINDEXINMAP  23
#define ERR_INVALIDAMSPORT        24
#define ERR_NOMEMORY              25
#define ERR_TCPSEND               26
#define ERR_HOSTUNREACHABLE       27
#define ERR_INVALIDAMSFRAGMENT    28


/* ROUTER */
#define ROUTERERR_NOLOCKEDMEMORY   0 + ERR_ROUTERERRS
#define ROUTERERR_RESIZEMEMORY     1 + ERR_ROUTERERRS
#define ROUTERERR_MAILBOXFULL      2 + ERR_ROUTERERRS
#define ROUTERERR_DEBUGBOXFULL     3 + ERR_ROUTERERRS
#define ROUTERERR_UNKNOWNPORTTYPE  4 + ERR_ROUTERERRS
#define ROUTERERR_NOTINITIALIZED   5 + ERR_ROUTERERRS
#define ROUTERERR_PORTALREADYINUSE 6 + ERR_ROUTERERRS
#define ROUTERERR_NOTREGISTERED    7 + ERR_ROUTERERRS
#define ROUTERERR_NOMOREQUEUES     8 + ERR_ROUTERERRS
#define ROUTERERR_INVALIDPORT      9 + ERR_ROUTERERRS
#define ROUTERERR_NOTACTIVATED     10 + ERR_ROUTERERRS
#define ROUTERERR_FRAGMENTBOXFULL  11 + ERR_ROUTERERRS
#define ROUTERERR_FRAGMENTTIMEOUT  12 + ERR_ROUTERERRS
#define ROUTERERR_TOBEREMOVED      13 + ERR_ROUTERERRS

#define TASKERR_UNKNOWNTASKTYPE 0 + ERR_TASKERRS
#define TASKERR_TASKTERMINATED  1 + ERR_TASKERRS
#define TASKERR_EVENTTIMEOUT    2 + ERR_TASKERRS


/* System Sampler */
#define SMPLERR_INTERNAL    0 + ERR_SYSSMPLERRS
#define SMPLERR_INVALIDTYPE 1 + ERR_SYSSMPLERRS


/* RTIME */
#define RTERR_INTERNAL             0 + ERR_RTIMEERRS
#define RTERR_BADTIMERPERIODS      1 + ERR_RTIMEERRS
#define RTERR_INVALIDTASKPTR       2 + ERR_RTIMEERRS
#define RTERR_INVALIDSTACKPTR      3 + ERR_RTIMEERRS
#define RTERR_PRIOEXISTS           4 + ERR_RTIMEERRS
#define RTERR_NOMORETCB            5 + ERR_RTIMEERRS
#define RTERR_NOMORESEMAS          6 + ERR_RTIMEERRS
#define RTERR_NOMOREQUEUES         7 + ERR_RTIMEERRS
#define RTERR_SHUTDOWNTIMEOUT      8 + ERR_RTIMEERRS
#define RTERR_CHECKHOSTOSNOPCR     9 + ERR_RTIMEERRS
#define RTERR_CHECKHOSTOSNOIDT     10 + ERR_RTIMEERRS
#define RTERR_CHECKHOSTOSNOPHYSMEM 11 + ERR_RTIMEERRS
#define RTERR_CHECKHOSTOSMAPERR    12 + ERR_RTIMEERRS
#define RTERR_EXTIRQALREADYDEF     13 + ERR_RTIMEERRS
#define RTERR_EXTIRQNOTDEF         14 + ERR_RTIMEERRS
#define RTERR_EXTIRQINSTALLFAILED  15 + ERR_RTIMEERRS
#define RTERR_IRQLNOTLESSOREQUAL   16 + ERR_RTIMEERRS
#define RTERR_SYSCLOCKFAILURE      17 + ERR_RTIMEERRS


/* TRACE */
#define TRACEERR_REGISTRY 0 + ERR_TRACEERRS
#define TRACEERR_MEMMAP   1 + ERR_TRACEERRS
#define TRACEERR_NOTAVAIL 2 + ERR_TRACEERRS


/* IO */
#define IOERR_INTERNAL                        (0 + ERR_IOERRS)
#define IOERR_BADCARDNO                       (1 + ERR_IOERRS)
#define IOERR_INVALIDCARDADDR                 (2 + ERR_IOERRS)
#define IOERR_CDLLISTFULL                     (3 + ERR_IOERRS)
#define IOERR_BADCDLPARAM                     (4 + ERR_IOERRS)
#define IOERR_OPENIOFAILED                    (5 + ERR_IOERRS)
#define IOERR_RESETIOFAILED                   (6 + ERR_IOERRS)
#define IOERR_UNKNOWNDEVICE                   (7 + ERR_IOERRS)
#define IOERR_UNKNOWNDEVICEID                 (8 + ERR_IOERRS)
#define IOERR_UNKNOWNIMAGEID                  (9 + ERR_IOERRS)
#define IOERR_GETIOSTATE                      (10 + ERR_IOERRS)
#define IOERR_BADIMAGEID                      (11 + ERR_IOERRS)
#define IOERR_NOMORECLIENTSPACE               (12 + ERR_IOERRS)
#define IOERR_CLIENTINFONOTFOUND              (13 + ERR_IOERRS)
#define IOERR_CDLNOTINUSE                     (14 + ERR_IOERRS)
#define IOERR_TIMEOUTWITHDEVICE               (15 + ERR_IOERRS)
#define IOERR_C1220FUNC_1                     (16 + ERR_IOERRS)
#define IOERR_C1220FUNC_9                     (17 + ERR_IOERRS)
#define IOERR_C1220FUNC_C                     (18 + ERR_IOERRS)
#define IOERR_C1220FUNC_10                    (19 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_MAXSEND             (20 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_ADDRSET             (21 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK               (22 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK0              (23 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK1              (24 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK2              (25 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK3              (26 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK4              (27 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK5              (28 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK6              (29 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK7              (30 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK8              (31 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK9              (32 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK10             (33 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK11             (34 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK12             (35 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK13             (36 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK14             (37 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK15             (38 + ERR_IOERRS)
#define IOERR_C1220FUNC_1_BREAK16             (39 + ERR_IOERRS)
#define IOERR_SPC3DEVINITDP                   (40 + ERR_IOERRS)
#define IOERR_SPC3UPDATEOUTPUT                (41 + ERR_IOERRS)
#define IOERR_CIF30READDIAG                   (42 + ERR_IOERRS)
#define IOERR_CIF30COMMNOTSTARTED             (43 + ERR_IOERRS)
#define IOERR_CIF30SLAVEPARASIZE              (44 + ERR_IOERRS)
#define IOERR_CIF30NOPARAS                    (45 + ERR_IOERRS)
#define IOERR_CIF30SLAVEERROR                 (46 + ERR_IOERRS)
#define IOERR_CIF30WATCHDOGEXPIRED            (47 + ERR_IOERRS)
#define IOERR_UNKNOWNDEVICECMD                (48 + ERR_IOERRS)
#define IOERR_CIF40MESSAGEHANDLING            (49 + ERR_IOERRS)
#define IOERR_CIF40PARAERROR                  (50 + ERR_IOERRS)
#define IOERR_CIF40WATCHDOGEXPIRED            (51 + ERR_IOERRS)
#define IOERR_CIF40FLAGERROR                  (52 + ERR_IOERRS)
#define IOERR_CIF40COMMNOTSTARTED             (53 + ERR_IOERRS)
#define IOERR_CIF40READDIAG                   (54 + ERR_IOERRS)
#define IOERR_CIF40SLAVEERROR                 (55 + ERR_IOERRS)
#define IOERR_CIF40GLOBALERROR                (56 + ERR_IOERRS)
#define IOERR_CIF40CONFIGLIST                 (57 + ERR_IOERRS)
#define IOERR_CP5412A2SLAVEPARASIZE           (58 + ERR_IOERRS)
#define IOERR_CP5412A2NOPARAS                 (59 + ERR_IOERRS)
#define IOERR_CP5412A2SLAVEERROR              (60 + ERR_IOERRS)
#define IOERR_CP5412A2FATAL                   (61 + ERR_IOERRS)
#define IOERR_CP5412A2MAILBOXUSED             (62 + ERR_IOERRS)
#define IOERR_BEGINCONFIGWHILETICKER          (63 + ERR_IOERRS)
#define IOERR_UNEXPECTEDBOXCOUNT              (64 + ERR_IOERRS)
#define IOERR_C1200CHECKADDR                  (65 + ERR_IOERRS)
#define IOERR_C1200INTENSITYTEST              (66 + ERR_IOERRS)
#define IOERR_NOIMAGE                         (67 + ERR_IOERRS)
#define IOERR_INVALIDIMAGEOFFSSIZE            (68 + ERR_IOERRS)
#define IOERR_FORCESCOUNTEXCEEDEDMAXIMUM      (69 + ERR_IOERRS)
#define IOERR_SERCOSLIFECOUNTERERR            (70 + ERR_IOERRS)
#define IOERR_C1220NOTFOUND                   (71 + ERR_IOERRS)
#define IOERR_AMSDEVICENOAMSINTF              (72 + ERR_IOERRS)
#define IOERR_AMSDEVICEAMSCMDIDNOTSUPP        (73 + ERR_IOERRS)
#define IOERR_AMSDEVICEAMSSERVICERUNNING      (74 + ERR_IOERRS)
#define IOERR_PLCINTERFACE_BUSY               (75 + ERR_IOERRS)
#define IOERR_PLCINTERFACE_FAULT              (76 + ERR_IOERRS)
#define IOERR_PLCINTERFACE_TIMEOUT            (77 + ERR_IOERRS)
#define IOERR_PLCINTERFACE_RESETTIMEOUT       (78 + ERR_IOERRS)
#define IOERR_PLCINTERFACE_NODATAEXCH         (79 + ERR_IOERRS)
#define IOERR_PLCINTERFACE_RESET              (80 + ERR_IOERRS)
#define IOERR_CP5412A2INVALIDADDR             (81 + ERR_IOERRS)
#define IOERR_CP5412A2INVALIDPORT             (82 + ERR_IOERRS)
#define IOERR_AMSDEVICEBADBOXNO               (83 + ERR_IOERRS)
#define IOERR_AMSDEVICEBADTYPE                (84 + ERR_IOERRS)
#define IOERR_AMSDEVICEILLEGALADDRESS         (85 + ERR_IOERRS)
#define IOERR_CP5412A2INVALIDBOX              (86 + ERR_IOERRS)
#define IOERR_AMSDEVICEFIFOOVERFLOW           (87 + ERR_IOERRS)
#define IOERR_AMSDEVICEAMSSEQUENCEERROR       (88 + ERR_IOERRS)
#define IOERR_CP5412A2DPV1SYNTAXERROR         (89 + ERR_IOERRS)
#define IOERR_CP5412A2DEVICENOTRUNNING        (90 + ERR_IOERRS)
#define IOERR_AMSDEVICENOTRUNNING             (91 + ERR_IOERRS)
#define IOERR_AMSDEVICEBOXNOTDEFINED          (92 + ERR_IOERRS)
#define IOERR_CP5412A2BADSERVICEPARA          (93 + ERR_IOERRS)
#define IOERR_CP5412A2FIFOOVERFLOW            (94 + ERR_IOERRS)
#define IOERR_COMPORTOPENFAILED               (95 + ERR_IOERRS)
#define IOERR_CIF30BADMESSAGERESPONSE         (96 + ERR_IOERRS)
#define IOERR_CIF30DELETEDATABASE             (97 + ERR_IOERRS)
#define IOERR_CIF30STARTSEQFAILED             (98 + ERR_IOERRS)
#define IOERR_CIF30DOWNLOADFAILED             (99 + ERR_IOERRS)
#define IOERR_CIF30ENDSEQFAILED               (100 + ERR_IOERRS)
#define IOERR_CIF30BUSLOADFAILED              (101 + ERR_IOERRS)
#define IOERR_PLCINTERFACE_RESETREQ           (102 + ERR_IOERRS)
#define IOERR_CP5412A2INVALIDCYCLETICKS       (103 + ERR_IOERRS)
#define IOERR_CP5412A2DPBUSFAULT              (104 + ERR_IOERRS)
#define IOERR_INVALIDTERMCONFIG               (105 + ERR_IOERRS)
#define IOERR_SERCANSBREAK                    (106 + ERR_IOERRS)
#define IOERR_SERCANSPHASE0                   (107 + ERR_IOERRS)
#define IOERR_SERCANSPHASE1                   (108 + ERR_IOERRS)
#define IOERR_SERCANSPHASE2                   (109 + ERR_IOERRS)
#define IOERR_SERCANSPHASE3                   (110 + ERR_IOERRS)
#define IOERR_SERCANSPHASE4                   (111 + ERR_IOERRS)
#define IOERR_SERCANSNCSERVICECHNFAILED       (112 + ERR_IOERRS)
#define IOERR_RESOURCECONFICT                 (113 + ERR_IOERRS)
#define IOERR_C1220INITSTRINGCOMM             (114 + ERR_IOERRS)
#define IOERR_C1220REGSTRINGSLAVE             (115 + ERR_IOERRS)
#define IOERR_C1220STRREGFAULT                (116 + ERR_IOERRS)
#define IOERR_IOSTATEBUSY                     (117 + ERR_IOERRS)
#define IOERR_IBSSCITWATCHDOGEXPIRED          (118 + ERR_IOERRS)
#define IOERR_IBSSCITSYNCMAILBOXERROR         (119 + ERR_IOERRS)
#define IOERR_IBSSCITCONFIRMDIAGERROR         (120 + ERR_IOERRS)
#define IOERR_IBSSCITCREATECFGERROR           (121 + ERR_IOERRS)
#define IOERR_IBSSCITCOMPLETEREADCFGERROR     (122 + ERR_IOERRS)
#define IOERR_IBSSCITSTARTDATATRANSFERERROR   (123 + ERR_IOERRS)
#define IOERR_IBSSCITSETFAULTINDICATION       (124 + ERR_IOERRS)
#define IOERR_IBSSCITSETDEVICESTATEINDICATION (125 + ERR_IOERRS)
#define IOERR_IBSSCITSETBUSERRORINDICATION    (126 + ERR_IOERRS)
#define IOERR_IBSSCITSTOPDATATRANSFERERROR    (127 + ERR_IOERRS)
#define IOERR_IBSSCITSETVALUEINDICATION       (128 + ERR_IOERRS)
#define IOERR_IBSSCITINITIATEREQ              (129 + ERR_IOERRS)
#define IOERR_IBSSCITACTIVATECFGERROR         (130 + ERR_IOERRS)
#define IOERR_IBSSCITCOMPACTLOADPDRLERROR     (131 + ERR_IOERRS)
#define IOERR_IBSSCITCONTROLPARAMERROR        (132 + ERR_IOERRS)
#define IOERR_IBSSCITDEACTIVATECFGERROR       (133 + ERR_IOERRS)
#define IOERR_IBSSCITINVALIDPORT              (134 + ERR_IOERRS)
#define IOERR_C1220FUNC_7_ADDRESSTEST         (135 + ERR_IOERRS)
#define IOERR_FCXXXXMAILBOXUSED               (136 + ERR_IOERRS)
#define IOERR_FCXXXXDPRAMTOOSMALL             (137 + ERR_IOERRS)
#define IOERR_COMUPS_PORTINUSE                (138 + ERR_IOERRS)
#define IOERR_COMUPS_NOUPSORNOPOWER           (139 + ERR_IOERRS)
#define IOERR_COMUPS_LOWBATTERY               (140 + ERR_IOERRS)
#define IOERR_UPS_ALREADY_EXISTS              (141 + ERR_IOERRS)
#define IOERR_FCXXXXSTARTUPFAILED             (142 + ERR_IOERRS)
#define IOERR_C1220GETSTRINGCOMMTXSTATEFAILED (143 + ERR_IOERRS)
#define IOERR_C1220SENDSTRINGTOSLAVEFAILED    (144 + ERR_IOERRS)
#define IOERR_CP5613FIRMWARELOADFAILED        (145 + ERR_IOERRS)
#define IOERR_CP5613DPOPENFAILED              (146 + ERR_IOERRS)
#define IOERR_CP5613FATALERROR                (147 + ERR_IOERRS)
#define IOERR_CP5613DPUSEROPENFAILED          (148 + ERR_IOERRS)
#define IOERR_CP5613DPSETMODESTOPFAILED       (149 + ERR_IOERRS)
#define IOERR_CP5613DPSETMODECLEARFAILED      (150 + ERR_IOERRS)
#define IOERR_CP5613DPSETMODEOPERATEFAILED    (151 + ERR_IOERRS)
#define IOERR_CP5613NODATAAVAILABLE           (152 + ERR_IOERRS)
#define IOERR_CP5613DPSERVICEFAILED           (153 + ERR_IOERRS)
#define IOERR_CP5613DPSETMODEOFFLINEFAILED    (154 + ERR_IOERRS)
#define IOERR_CP5613DPUSERCLOSEFAILED         (155 + ERR_IOERRS)
#define IOERR_CP5613DPCLOSEFAILED             (156 + ERR_IOERRS)
#define IOERR_CP5613OTHERSERVICERETURNED      (157 + ERR_IOERRS)
#define IOERR_CP5613DPOKASYNC                 (158 + ERR_IOERRS)
#define IOERR_CP5613DPERROREVENT              (159 + ERR_IOERRS)
#define IOERR_CP5613DPERROREVENTNET           (160 + ERR_IOERRS)
#define IOERR_CP5613DPERRORREQPAR             (161 + ERR_IOERRS)
#define IOERR_CP5613DPERRORCI                 (162 + ERR_IOERRS)
#define IOERR_CP5613DPERRORRES                (163 + ERR_IOERRS)
#define IOERR_CP5613DPERRORUSRABORT           (164 + ERR_IOERRS)
#define IOERR_PKWSYNTAXERROR                  (165 + ERR_IOERRS)
#define IOERR_CP5412A2CDLCFGFAULT             (166 + ERR_IOERRS)
#define IOERR_IBSSCITINITLOADCFGERROR         (168 + ERR_IOERRS)
#define IOERR_IBSSCITLOADCFGERROR             (169 + ERR_IOERRS)
#define IOERR_IBSSCITTERMLOADCFGERROR         (170 + ERR_IOERRS)
#define IOERR_IBSSCITINITLOADPDRLERROR        (171 + ERR_IOERRS)
#define IOERR_IBSSCITLOADPDRLERROR            (172 + ERR_IOERRS)
#define IOERR_IBSSCITTERMLOADPDRLERROR        (173 + ERR_IOERRS)
#define IOERR_IBSSCITDELETEOBJECTERROR        (174 + ERR_IOERRS)
#define IOERR_IBSSCITCONTROLACTIVECFGGERROR   (175 + ERR_IOERRS)
#define IOERR_IBSSCITINITLOADPDDLERROR        (176 + ERR_IOERRS)
#define IOERR_IBSSCITLOADPDDLERROR            (177 + ERR_IOERRS)
#define IOERR_IBSSCITTERMLOADPDDLERROR        (178 + ERR_IOERRS)
#define IOERR_NOMOREMAPSINIMAGE               (179 + ERR_IOERRS)
#define IOERR_IBSSCITSETSLAVEINFOERROR        (180 + ERR_IOERRS)
#define IOERR_CIF40NOTREADY                   (190 + ERR_IOERRS)
#define IOERR_C1220SETAMSNETIDFAILED          (191 + ERR_IOERRS)
#define IOERR_AMSDEVICEIORESETACTIVE          (192 + ERR_IOERRS)
#define IOERR_C1220INITPROGRAMMABLECDL        (193 + ERR_IOERRS)
#define IOERR_FCXXXXINVALIDBOXNODOWNLOADED    (194 + ERR_IOERRS)


#define IOERR_CP5412A2_RESET         (4  + ERR_CP5412A2)
#define IOERR_CP5412A2_LOADBUSPARA   (5  + ERR_CP5412A2)
#define IOERR_CP5412A2_LOADSLAVE     (6  + ERR_CP5412A2)
#define IOERR_CP5412A2_LOADPRMDATA   (7  + ERR_CP5412A2)
#define IOERR_CP5412A2_LOADCFGDATA   (8  + ERR_CP5412A2)
#define IOERR_CP5412A2_LOADSLAVECDL  (9  + ERR_CP5412A2)
#define IOERR_CP5412A2_ACTIVATESLAVE (10 + ERR_CP5412A2)
#define IOERR_CP5412A2_ADDSLAVE      (11 + ERR_CP5412A2)
#define IOERR_CP5412A2_DELETESLAVE   (12 + ERR_CP5412A2)
#define IOERR_CP5412A2_STARTDATAEXCH (13 + ERR_CP5412A2)
#define IOERR_CP5412A2_STOPDATAEXCH  (14 + ERR_CP5412A2)
#define IOERR_CP5412A2_DEBUGDPM      (15 + ERR_CP5412A2)


/* FC Box - stamndadisiert */

#define FCERR_FMNOERROR             0
#define FCERR_FMDEACTIVATED         1
#define FCERR_FMNOANSWER            2
#define FCERR_FMMASTERLOCK          3
#define FCERR_FMINVALIDRESPONSE     4
#define FCERR_FMPRMFAULT            5
#define FCERR_FMFEATURENOTSUPPORTED 6
#define FCERR_FMCFGFAULT            7
#define FCERR_FMSTATIONNOTREADY     8
#define FCERR_FMSTATDIAG            9
#define FCERR_FMDIAGOVERFLOW        10
#define FCERR_FMPHYSICALFAULT       11
#define FCERR_FMDATATRANSFERLEFT    12
#define FCERR_FMSYNIFAULT           13
#define FCERR_FMTELEGRAMFAULT       14
#define FCERR_FMNORESSOURCES        15
#define FCERR_FMSERVICENOTACTIVATED 16
#define FCERR_FMUNEXPECTEDTELEGRAM  17
#define FCERR_FMSTATIONREADY        18
#define FCERR_FMADSSTARTUP          19
#define FCERR_FMINVALIDINDICATION   20
#define FCERR_FMSTATIONINFAULT      21
#define FCERR_FMINDICATIONMISSED    22
#define FCERR_FMWAITFORINDICATIONS  23

#define FCERR_FMFBUSSPECIFIC_1      40
#define FCERR_FMFBUSSPECIFIC_2      41
#define FCERR_FMFBUSSPECIFIC_3      42
#define FCERR_FMFBUSSPECIFIC_4      43
#define FCERR_FMFBUSSPECIFIC_5      44
#define FCERR_FMFBUSSPECIFIC_6      45
#define FCERR_FMFBUSSPECIFIC_7      46
#define FCERR_FMFBUSSPECIFIC_8      47
#define FCERR_FMFBUSSPECIFIC_9      48


/* FC520x */

#define FCERR_FMFC520XHEARTBEATFAULT     40
#define FCERR_FMFC520XSHUTDOWNRECEIVED   41
#define FCERR_FMFC520XEKEYERROR_VENDOR   42
#define FCERR_FMFC520XEKEYERROR_DEVTYPE  43
#define FCERR_FMFC520XEKEYERROR_PRODCODE 44
#define FCERR_FMFC520XEKEYERROR_REVISION 45
#define FCERR_FMFC520XSTARTUPATTR        46
#define FCERR_FMFC520XIOLENGTH_PROD      47
#define FCERR_FMFC520XIOLENGTH_CONS      48

#define FCERR_FMFC520XDEVICEOPERATE_RUN   0
#define FCERR_FMFC520XDEVICEOPERATE_IDLE  1
#define FCERR_FMFC520XDEVICEDUPMAC        2
#define FCERR_FMFC520XDEVICESELFTEST      3
#define FCERR_FMFC520XDEVICESTANDBY       4
#define FCERR_FMFC520XDEVICEMAJORFAULT    5
#define FCERR_FMFC520XDEVICEMINORFAULT    6
#define FCERR_FMFC520XDEVICEBUSSENSEFAIL  7

#define FCERR_FMFC520XCANBUSON        0x01
#define FCERR_FMFC520XCANBUSOFF       0x02
#define FCERR_FMFC520XCANWARNINGLIMIT 0x04
#define FCERR_FMFC520XCANOVERRUN      0x08


/* DP-Slave-Errors */

#define DPSLAVEERROR_NOERROR              (FCERR_FMNOERROR             + ERR_DPSLAVE)
#define DPSLAVEERROR_STATIONDEACTIVATED   (FCERR_FMDEACTIVATED         + ERR_DPSLAVE)
#define DPSLAVEERROR_STATIONNONEXISTENT   (FCERR_FMNOANSWER            + ERR_DPSLAVE)
#define DPSLAVEERROR_MASTERLOCK           (FCERR_FMMASTERLOCK          + ERR_DPSLAVE)
#define DPSLAVEERROR_INVALIDSLAVERESPONSE (FCERR_FMINVALIDRESPONSE     + ERR_DPSLAVE)
#define DPSLAVEERROR_PRMFAULT             (FCERR_FMPRMFAULT            + ERR_DPSLAVE)
#define DPSLAVEERROR_NOTSUPPORTED         (FCERR_FMFEATURENOTSUPPORTED + ERR_DPSLAVE)
#define DPSLAVEERROR_CFGFAULT             (FCERR_FMCFGFAULT            + ERR_DPSLAVE)
#define DPSLAVEERROR_STATIONNOTREADY      (FCERR_FMSTATIONNOTREADY     + ERR_DPSLAVE)
#define DPSLAVEERROR_STATDIAG             (FCERR_FMSTATDIAG            + ERR_DPSLAVE)
#define DPSLAVEERROR_DIAGOVERFLOW         (FCERR_FMDIAGOVERFLOW        + ERR_DPSLAVE)
#define DPSLAVEERROR_PHYSICALFAULT        (FCERR_FMPHYSICALFAULT       + ERR_DPSLAVE)
#define DPSLAVEERROR_TELEGRAMFAULT        (FCERR_FMTELEGRAMFAULT       + ERR_DPSLAVE)
#define DPSLAVEERROR_NORESSOURCES         (FCERR_FMNORESSOURCES        + ERR_DPSLAVE)
#define DPSLAVEERROR_SERVICENOTACTIVATED  (FCERR_FMSERVICENOTACTIVATED + ERR_DPSLAVE)
#define DPSLAVEERROR_UNEXPECTEDTELEGRAM   (FCERR_FMUNEXPECTEDTELEGRAM  + ERR_DPSLAVE)
#define DPSLAVEERROR_STATIONREADY         (FCERR_FMSTATIONREADY        + ERR_DPSLAVE)
#define DPSLAVEERROR_ADSSTARTUP           (FCERR_FMADSSTARTUP          + ERR_DPSLAVE)


/* CAN-Node-Errors */

#define CANNODEERROR_NOERROR            (0  + ERR_CANSLAVE)
#define CANNODEERROR_STATIONNONEXISTENT (1  + ERR_CANSLAVE)
#define CANNODEERROR_PRMFAULT           (4  + ERR_CANSLAVE)
#define CANNODEERROR_CFGFAULT           (6  + ERR_CANSLAVE)
#define CANNODEERROR_DEACTIVATED        (8  + ERR_CANSLAVE)
#define CANNODEERROR_PREOPERATIONAL     (12 + ERR_CANSLAVE)
#define CANNODEERROR_NOT_OPERATIONAL    (13 + ERR_CANSLAVE)


/* IBS-Device-Errors */

#define IBSDEVICEERROR_NOERROR            (0  + ERR_IBSSLAVE)
#define IBSDEVICEERROR_STATIONDEACTIVATED (1  + ERR_IBSSLAVE)
#define IBSDEVICEERROR_STATIONNONEXISTENT (2  + ERR_IBSSLAVE)
#define IBSDEVICEERROR_CFGFAULT           (6  + ERR_IBSSLAVE)
#define IBSDEVICEERROR_DIAGOVERFLOW       (10 + ERR_IBSSLAVE)
#define IBSDEVICEERROR_PHYSICALFAULT      (11 + ERR_IBSSLAVE)


/* PLC */
#define PLCWRN_LOADINGBOOTPRJ    ((0 + ERR_PLCERRS) | AMSERRCODEISWARNING)
#define PLCWRN_LOADINGRETAINDATA ((1 + ERR_PLCERRS) | AMSERRCODEISWARNING)


/* NC */
#define ERR_NCR0MANERRS (ERR_NCERRS+0x0000)
#define ERR_NCCHNERRS   (ERR_NCERRS+0x0100)


/* NC: R0-Manager Error Codes */
#define NCERR_INTERNAL            (0x0000 + ERR_NCR0MANERRS)
#define NCERR_NOMEMORY            (0x0001 + ERR_NCR0MANERRS)

#define NCERR_UNKNOWNCHANNELID    (0x0010 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNGROUPID      (0x0011 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNAXISID       (0x0012 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNENCODERID    (0x0013 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNCONTROLLERID (0x0014 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNDRIVEID      (0x0015 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNTABULARID    (0x0016 + ERR_NCR0MANERRS)

#define NCERR_UNKNOWNPLCTONCADDR  (0x0020 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNNCTOPLCADDR  (0x0021 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNENCINADDR    (0x0022 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNENCOUTADDR   (0x0023 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNDRIVEINADDR  (0x0024 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNDRIVEOUTADDR (0x0025 + ERR_NCR0MANERRS)

#define NCERR_UNKNOWNDSLAVETYPE   (0x0030 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNAXISTYPE     (0x0031 + ERR_NCR0MANERRS)
#define NCERR_UNKNOWNCHNTYPE      (0x0032 + ERR_NCR0MANERRS)

#define NCERR_AXISINCOMPATIBLE    (0x0040 + ERR_NCR0MANERRS)

#define NCERR_CHANNELINCOMPLETE   (0x0050 + ERR_NCR0MANERRS)
#define NCERR_GROUPINCOMPLETE     (0x0051 + ERR_NCR0MANERRS)
#define NCERR_AXISINCOMPLETE      (0x0052 + ERR_NCR0MANERRS)

#define NCERR_CHANNELEXISTS       (0x0060 + ERR_NCR0MANERRS)
#define NCERR_GROUPEXISTS         (0x0061 + ERR_NCR0MANERRS)
#define NCERR_AXISEXISTS          (0x0062 + ERR_NCR0MANERRS)
#define NCERR_TABULAREXISTS       (0x0063 + ERR_NCR0MANERRS)

#define NCERR_WRONGCHANNELINDEX   (0x0070 + ERR_NCR0MANERRS)
#define NCERR_WRONGGROUPINDEX     (0x0071 + ERR_NCR0MANERRS)


/* Channel Error Codes */
#define NCCHNERR_GROUPINDEX        (0x0001 + ERR_NCCHNERRS)
#define NCCHNERR_ADDR_GROUP        (0x0002 + ERR_NCCHNERRS)
#define NCCHNERR_NO_PLCINTERFACE   (0x0003 + ERR_NCCHNERRS)
#define NCCHNERR_ILLEGALMFUNCNR    (0x0004 + ERR_NCCHNERRS)
#define NCCHNERR_NOMEMORY          (0x0005 + ERR_NCCHNERRS)
#define NCCHNERR_ISBUSY            (0x0006 + ERR_NCCHNERRS)
#define NCCHNERR_NOTSUPPORTED      (0x0007 + ERR_NCCHNERRS)
#define NCCHNERR_ILLEGALSETTING    (0x0008 + ERR_NCCHNERRS)

#define NCCHNERR_NOFILE            (0x0010 + ERR_NCCHNERRS)
#define NCCHNERR_ITPSYNTAXLT       (0x0011 + ERR_NCCHNERRS)
#define NCCHNERR_ITPSYNTAXRT       (0x0012 + ERR_NCCHNERRS)
#define NCCHNERR_SUBNOTFOUND       (0x0013 + ERR_NCCHNERRS)
#define NCCHNERR_LOADBUFFERFULL    (0x0014 + ERR_NCCHNERRS)
#define NCCHNERR_INVALIDIDENTIFIER (0x0015 + ERR_NCCHNERRS)
#define NCCHNERR_UNKNOWNIDENTIFIER (0x0016 + ERR_NCCHNERRS)
#define NCCHNERR_SUBINCOMPLETE     (0x0017 + ERR_NCCHNERRS)

#define NCCHNERR_ZERODIVIDE        (0x0020 + ERR_NCCHNERRS)
#define NCCHNERR_BADCIRCLE         (0x0021 + ERR_NCCHNERRS)
#define NCCHNERR_INVALIDOPERATION  (0x0022 + ERR_NCCHNERRS)

#define NCCHNERR_CALLSTACKOVR      (0x0030 + ERR_NCCHNERRS)
#define NCCHNERR_CALLSTACKUDR      (0x0031 + ERR_NCCHNERRS)
#define NCCHNERR_CALCSTACKOVR      (0x0032 + ERR_NCCHNERRS)
#define NCCHNERR_CALCSTACKUDR      (0x0033 + ERR_NCCHNERRS)

#define NCCHNERR_REGINDEX          (0x0040 + ERR_NCCHNERRS)
#define NCCHNERR_GFUNCINDEX        (0x0041 + ERR_NCCHNERRS)
#define NCCHNERR_MFUNCINDEX        (0x0042 + ERR_NCCHNERRS)
#define NCCHNERR_EXTENDEDADDR      (0x0043 + ERR_NCCHNERRS)
#define NCCHNERR_INTERNALINDEXH    (0x0044 + ERR_NCCHNERRS)
#define NCCHNERR_MDBACCESSINDEX    (0x0045 + ERR_NCCHNERRS)

#define NCTRAFOERR_CANNOTCHANGE    (0x0050 + ERR_NCCHNERRS)
#define NCTRAFOERR_CANNOTCORRECT   (0x0051 + ERR_NCCHNERRS)
#define NCTRAFOERR_PLANE           (0x0052 + ERR_NCCHNERRS)
#define NCTRAFOERR_DPARAMINVALID   (0x0053 + ERR_NCCHNERRS)
#define NCTRAFOERR_TOOLRADIUSINV   (0x0054 + ERR_NCCHNERRS)
#define NCTRAFOERR_CHANGETOOLRAD   (0x0055 + ERR_NCCHNERRS)
#define NCTRAFOERR_CDOVERFLOW      (0x0056 + ERR_NCCHNERRS)
#define NCTRAFOERR_CDON            (0x0057 + ERR_NCCHNERRS)
#define NCTRAFOERR_CDCHECK         (0x0058 + ERR_NCCHNERRS)
#define NCTRAFOERR_CDUNEXPECTED    (0x0059 + ERR_NCCHNERRS)
#define NCTRAFOERR_CDNEGRADIUS     (0x005A + ERR_NCCHNERRS)
#define NCTRAFOERR_CDOCCURED       (0x005B + ERR_NCCHNERRS)
#define NCTRAFOERR_COOKEDTBLFULL   (0x005C + ERR_NCCHNERRS)
#define NCTRAFOERR_TFTBLFULL       (0x005D + ERR_NCCHNERRS)
#define NCTRAFOERR_EXECTFTBLFULL   (0x005E + ERR_NCCHNERRS)
#define NCTRAFOERR_EXECTFT         (0x005F + ERR_NCCHNERRS)

#define NCBACKUPERR_WRITEDATA      (0x0060 + ERR_NCCHNERRS)
#define NCBACKUPERR_TARGETENTRY    (0x0061 + ERR_NCCHNERRS)


#define MACHINEIDENTRYDONTCARE 0xFF
#define AMS_NETIDLEN           23

typedef struct AmsNetId_
{
   guint8 b[6];
} AmsNetId;
#define AmsNetId_Len (int)sizeof(AmsNetId)

typedef struct AmsAddr_
{
   AmsNetId   netId;
   guint16    port;
} AmsAddr;

typedef union ErrCodeUnion
{
   gint32 errCode;
   gint32 hRcv;
} ErrCodeUnion;

typedef union tUserUnion
{
   gint32 hUser;
   struct
   {
      guint16 fragmentNo;
      guint16 packetNo;
   } a;
} UserUnion;

typedef struct
{
   AmsAddr target;
   AmsAddr sender;
   guint16 cmdId;
   guint16 stateFlags;
   guint32 cbData;

   ErrCodeUnion anErrCodeUnion;
   UserUnion aUserUnion;
} AmsHead;
#define AmsHead_Len (int)sizeof(AmsHead)


/*   State flags */

#define AMSCMDSF_RESPONSE       0x0001
#define AMSCMDSF_NORETURN       0x0002
#define AMSCMDSF_ADSCMD         0x0004
#define AMSCMDSF_SYSCMD         0x0008
#define AMSCMDSF_HIGHPRIO       0x0010
#define AMSCMDSF_TIMESTAMPADDED 0x0020
#define AMSCMDSF_UDP            0x0040
#define AMSCMDSF_INITCMD        0x0080
#define AMSCMDSF_BROADCAST      0x8000


/*   AmsCmd */

typedef struct
{
   AmsHead head;
} AmsCmd, *PAmsCmd;


/* ADS */

#define ADS_FIXEDNAMESIZE 16


/* ADS Service Ids */
#define ADSSRVID_INVALID        0x00
#define ADSSRVID_READDEVICEINFO 0x01
#define ADSSRVID_READ           0x02
#define ADSSRVID_WRITE          0x03
#define ADSSRVID_READSTATE      0x04
#define ADSSRVID_WRITECTRL      0x05
#define ADSSRVID_ADDDEVICENOTE  0x06
#define ADSSRVID_DELDEVICENOTE  0x07
#define ADSSRVID_DEVICENOTE     0x08
#define ADSSRVID_READWRITE      0x09

/* ADS reserved index groups */
#define ADSIGRP_SYMTAB              0xF000
#define ADSIGRP_SYMNAME             0xF001
#define ADSIGRP_SYMVAL              0xF002

#define ADSIGRP_SYM_HNDBYNAME       0xF003
#define ADSIGRP_SYM_VALBYNAME       0xF004
#define ADSIGRP_SYM_VALBYHND        0xF005
#define ADSIGRP_SYM_RELEASEHND      0xF006
#define ADSIGRP_SYM_INFOBYNAME      0xF007
#define ADSIGRP_SYM_VERSION         0xF008
#define ADSIGRP_SYM_INFOBYNAMEEX    0xF009

#define ADSIGRP_SYM_DOWNLOAD        0xF00A
#define ADSIGRP_SYM_UPLOAD          0xF00B
#define ADSIGRP_SYM_UPLOADINFO      0xF00C
#define ADSIGRP_SYM_DOWNLOAD2       0xF00D
#define ADSIGRP_SYM_DT_UPLOAD       0xF00E
#define ADSIGRP_SYM_UPLOADINFO2     0xF00F

#define ADSIGRP_SYMNOTE             0xF010

#define ADSIGRP_SYM_DT_INFOBYNAMEEX 0xF011
#define ADSIGRP_SYM_ADDRBYHND       0xF012


#define ADSIGRP_IOIMAGE_RWIB        0xF020
#define ADSIGRP_IOIMAGE_RWIX        0xF021
#define ADSIGRP_IOIMAGE_RISIZE      0xF025

#define ADSIGRP_IOIMAGE_RWOB        0xF030
#define ADSIGRP_IOIMAGE_RWOX        0xF031
#define ADSIGRP_IOIMAGE_ROSIZE      0xF035
#define ADSIGRP_IOIMAGE_CLEARI      0xF040
#define ADSIGRP_IOIMAGE_CLEARO      0xF050

#define ADSIGRP_IOIMAGE_RWIOB       0xF060

#define ADSIGRP_IOIMAGE_CREATE      0xF068

#define ADSIGRP_SUMUP_READ          0xF080

#define ADSIGRP_SUMUP_WRITE         0xF081
#define ADS_SUMUP_IGRP(p, i)        (((guint32*)p)[(i)*3+0])
#define ADS_SUMUP_IOFFS(p, i)       (((guint32*)p)[(i)*3+1])
#define ADS_SUMUP_LENGTH(p, i)      (((guint32*)p)[(i)*3+2])

#define ADSIGRP_DEVICE_DATA 0xF100
   #define ADSIOFFS_DEVDATA_ADSSTATE        0x0000
   #define ADSIOFFS_DEVDATA_DEVSTATE        0x0002
   #define ADSIOFFS_DEVDATA_CONFIGID        0x0004
   #define ADSIOFFS_DEVDATA_ADSVERSIONCHECK 0x0005

#define ADSIGRP_TASK_DATA 0xF200
/* ADSIGRP_TASK_DATA   reserved until      0xF2FF*/

#define ADSIGRP_CANOPEN_BEGIN          0xF300
#define ADSIGRP_CANOPEN_SDO            0xF302
#define ADSIGRP_CANOPEN_SDO_INFO_LIST  0xF3FC
#define ADSIGRP_CANOPEN_SDO_INFO_OBJ   0xF3FD
#define ADSIGRP_CANOPEN_SDO_INFO_ENTRY 0xF3FE
#define ADSIGRP_CANOPEN_END            0xF3FF

#define ADSIGRP_ECAT_FOE_BEGIN         0xF400
#define ADSIGRP_ECAT_FOE_FOPENREAD     0xF401
#define ADSIGRP_ECAT_FOE_FOPENWRITE    0xF402
#define ADSIGRP_ECAT_FOE_FCLOSE        0xF403
#define ADSIGRP_ECAT_FOE_FREAD         0xF404
#define ADSIGRP_ECAT_FOE_FWRITE        0xF405
#define ADSIGRP_ECAT_FOE_PROGRESSINFO  0xF406
#define ADSIGRP_ECAT_FOE_END           0xF41F

#define ADSIGRP_ECAT_SOE 0xF420
   #define ADSIOFFS_ECAT_SOE_ELEMENT_MASK 0x00FF0000
   #define ADSIOFFS_ECAT_SOE_DATASTATE    0x00010000
   #define ADSIOFFS_ECAT_SOE_NAME         0x00020000
   #define ADSIOFFS_ECAT_SOE_ATTRIBUTE    0x00040000
   #define ADSIOFFS_ECAT_SOE_UNIT         0x00080000
   #define ADSIOFFS_ECAT_SOE_MIN          0x00100000
   #define ADSIOFFS_ECAT_SOE_MAX          0x00200000
   #define ADSIOFFS_ECAT_SOE_VALUE        0x00400000
   #define ADSIOFFS_ECAT_SOE_DEFAULT      0x00800000
   #define ADSIOFFS_ECAT_SOE_DRIVENO_MASK 0x07000000
   #define ADSIOFFS_ECAT_SOE_COMMAND      0x08000000

#define ADSIGRP_ECAT_VOE 0xF430


typedef enum nAdsState
{
   ADSSTATE_INVALID      =0,
   ADSSTATE_IDLE         =1,
   ADSSTATE_RESET        =2,
   ADSSTATE_INIT         =3,
   ADSSTATE_START        =4,
   ADSSTATE_RUN          =5,
   ADSSTATE_STOP         =6,
   ADSSTATE_SAVECFG      =7,
   ADSSTATE_LOADCFG      =8,
   ADSSTATE_POWERFAILURE =9,
   ADSSTATE_POWERGOOD    =10,
   ADSSTATE_ERROR        =11,
   ADSSTATE_SHUTDOWN     =12,
   ADSSTATE_SUSPEND      =13,
   ADSSTATE_RESUME       =14,
   ADSSTATE_CONFIG       =15,
   ADSSTATE_RECONFIG     =16,
   ADSSTATE_MAXSTATES
} ADSSTATE;

typedef enum nAdsTransMode
{
   ADSTRANS_NOTRANS     =0,
   ADSTRANS_CLIENTCYCLE =1,
   ADSTRANS_CLIENTONCHA =2,
   ADSTRANS_SERVERCYCLE =3,
   ADSTRANS_SERVERONCHA =4,
   ADSTRANS_CLIENT1REQ  =10,
   ADSTRANS_MAXMODES
}ADSTRANSMODE;


/* ADS error codes */
#define ADSERR_NOERR                     0x00

#define ADSERR_DEVICE_ERROR                (0x700)
#define ADSERR_DEVICE_SRVNOTSUPP           (0x701)
#define ADSERR_DEVICE_INVALIDGRP           (0x702)
#define ADSERR_DEVICE_INVALIDOFFSET        (0x703)
#define ADSERR_DEVICE_INVALIDACCESS        (0x704)
#define ADSERR_DEVICE_INVALIDSIZE          (0x705)
#define ADSERR_DEVICE_INVALIDDATA          (0x706)
#define ADSERR_DEVICE_NOTREADY             (0x707)
#define ADSERR_DEVICE_BUSY                 (0x708)
#define ADSERR_DEVICE_INVALIDCONTEXT       (0x709)
#define ADSERR_DEVICE_NOMEMORY             (0x70A)
#define ADSERR_DEVICE_INVALIDPARM          (0x70B)
#define ADSERR_DEVICE_NOTFOUND             (0x70C)
#define ADSERR_DEVICE_SYNTAX               (0x70D)
#define ADSERR_DEVICE_INCOMPATIBLE         (0x70E)
#define ADSERR_DEVICE_EXISTS               (0x70F)
#define ADSERR_DEVICE_SYMBOLNOTFOUND       (0x710)
#define ADSERR_DEVICE_SYMBOLVERSIONINVALID (0x711)
#define ADSERR_DEVICE_INVALIDSTATE         (0x712)
#define ADSERR_DEVICE_TRANSMODENOTSUPP     (0x713)
#define ADSERR_DEVICE_NOTIFYHNDINVALID     (0x714)
#define ADSERR_DEVICE_CLIENTUNKNOWN        (0x715)
#define ADSERR_DEVICE_NOMOREHDLS           (0x716)
#define ADSERR_DEVICE_INVALIDWATCHSIZE     (0x717)
#define ADSERR_DEVICE_NOTINIT              (0x718)
#define ADSERR_DEVICE_TIMEOUT              (0x719)
#define ADSERR_DEVICE_NOINTERFACE          (0x71A)
#define ADSERR_DEVICE_INVALIDINTERFACE     (0x71B)
#define ADSERR_DEVICE_INVALIDCLSID         (0x71C)
#define ADSERR_DEVICE_INVALIDOBJID         (0x71D)
#define ADSERR_DEVICE_PENDING              (0x71E)
#define ADSERR_DEVICE_ABORTED              (0x71F)
#define ADSERR_DEVICE_WARNING              (0x720)
#define ADSERR_DEVICE_INVALIDARRAYIDX      (0x721)
#define ADSERR_DEVICE_SYMBOLNOTACTIVE      (0x722)
#define ADSERR_DEVICE_ACCESSDENIED         (0x723)

#define ADSERR_CLIENT_ERROR          (0x740)
#define ADSERR_CLIENT_INVALIDPARM    (0x741)
#define ADSERR_CLIENT_LISTEMPTY      (0x742)
#define ADSERR_CLIENT_VARUSED        (0x743)
#define ADSERR_CLIENT_DUPLINVOKEID   (0x744)
#define ADSERR_CLIENT_SYNCTIMEOUT    (0x745)
#define ADSERR_CLIENT_W32ERROR       (0x746)
#define ADSERR_CLIENT_TIMEOUTINVALID (0x747)
#define ADSERR_CLIENT_PORTNOTOPEN    (0x748)
#define ADSERR_CLIENT_NOAMSADDR      (0x749)
#define ADSERR_CLIENT_SYNCINTERNAL   (0x750)
#define ADSERR_CLIENT_ADDHASH        (0x751)
#define ADSERR_CLIENT_REMOVEHASH     (0x752)
#define ADSERR_CLIENT_NOMORESYM      (0x753)
#define ADSERR_CLIENT_SYNCRESINVALID (0x754)
#define ADSERR_CLIENT_SYNCPORTLOCKED (0x755)


#define FACILITY_TC_ADS 0x1811
#define FACILITY_TC_CNC 0x1821
#define FACILITY_TC_IO  0x1831


#define ADS_E_ERROR                (0x98110000L + ADSERR_DEVICE_ERROR)
#define ADS_E_SRVNOTSUPP           (0x98110000L + ADSERR_DEVICE_SRVNOTSUPP)
#define ADS_E_INVALIDGRP           (0x98110000L + ADSERR_DEVICE_INVALIDGRP)
#define ADS_E_INVALIDOFFSET        (0x98110000L + ADSERR_DEVICE_INVALIDOFFSET)
#define ADS_E_INVALIDACCESS        (0x98110000L + ADSERR_DEVICE_INVALIDACCESS)
#define ADS_E_INVALIDSIZE          (0x98110000L + ADSERR_DEVICE_INVALIDSIZE)
#define ADS_E_INVALIDDATA          (0x98110000L + ADSERR_DEVICE_INVALIDDATA)
#define ADS_E_NOTREADY             (0x98110000L + ADSERR_DEVICE_NOTREADY)
#define ADS_E_BUSY                 (0x98110000L + ADSERR_DEVICE_BUSY)
#define ADS_E_INVALIDCONTEXT       (0x98110000L + ADSERR_DEVICE_INVALIDCONTEXT)
#define ADS_E_NOMEMORY             (0x98110000L + ADSERR_DEVICE_NOMEMORY)
#define ADS_E_INVALIDPARM          (0x98110000L + ADSERR_DEVICE_INVALIDPARM)
#define ADS_E_NOTFOUND             (0x98110000L + ADSERR_DEVICE_NOTFOUND)
#define ADS_E_SYNTAX               (0x98110000L + ADSERR_DEVICE_SYNTAX)
#define ADS_E_INCOMPATIBLE         (0x98110000L + ADSERR_DEVICE_INCOMPATIBLE)
#define ADS_E_EXISTS               (0x98110000L + ADSERR_DEVICE_EXISTS)
#define ADS_E_SYMBOLNOTFOUND       (0x98110000L + ADSERR_DEVICE_SYMBOLNOTFOUND)
#define ADS_E_SYMBOLVERSIONINVALID (0x98110000L + ADSERR_DEVICE_SYMBOLVERSIONINVALID)
#define ADS_E_INVALIDSTATE         (0x98110000L + ADSERR_DEVICE_INVALIDSTATE)
#define ADS_E_TRANSMODENOTSUPP     (0x98110000L + ADSERR_DEVICE_TRANSMODENOTSUPP)
#define ADS_E_NOTIFYHNDINVALID     (0x98110000L + ADSERR_DEVICE_NOTIFYHNDINVALID)
#define ADS_E_CLIENTUNKNOWN        (0x98110000L + ADSERR_DEVICE_CLIENTUNKNOWN)
#define ADS_E_NOMOREHDLS           (0x98110000L + ADSERR_DEVICE_NOMOREHDLS)
#define ADS_E_INVALIDWATCHSIZE     (0x98110000L + ADSERR_DEVICE_INVALIDWATCHSIZE)
#define ADS_E_NOTINIT              (0x98110000L + ADSERR_DEVICE_NOTINIT)
#define ADS_E_TIMEOUT              (0x98110000L + ADSERR_DEVICE_TIMEOUT)
#define ADS_E_NOINTERFACE          (0x98110000L + ADSERR_DEVICE_NOINTERFACE)
#define ADS_E_INVALIDINTERFACE     (0x98110000L + ADSERR_DEVICE_INVALIDINTERFACE)
#define ADS_E_INVALIDCLSID         (0x98110000L + ADSERR_DEVICE_INVALIDCLSID)
#define ADS_E_INVALIDOBJID         (0x98110000L + ADSERR_DEVICE_INVALIDOBJID)
#define ADS_E_PENDING              (0x98110000L + ADSERR_DEVICE_PENDING)
#define ADS_E_ABORTED              (0x98110000L + ADSERR_DEVICE_ABORTED)
#define ADS_E_WARNING              (0x98110000L + ADSERR_DEVICE_WARNING)
#define ADS_E_INVALIDARRAYIDX      (0x98110000L + ADSERR_DEVICE_INVALIDARRAYIDX)
#define ADS_E_SYMBOLNOTACTIVE      (0x98110000L + ADSERR_DEVICE_SYMBOLNOTACTIVE)
#define ADS_E_ACCESSDENIED         (0x98110000L + ADSERR_DEVICE_ACCESSDENIED)


#ifndef ANYSIZE_ARRAY
   #define ANYSIZE_ARRAY 1
#endif

/* ADS AMS command */
/*typedef struct
{
   guint32 hNotification;
   guint32 cbSampleSize;
   guint8  data[ANYSIZE_ARRAY];
} AdsNotificationSample, *PAdsNotificationSample;*/
#define AdsNotificationSample_Min_Len 4

typedef struct
{
   guint32 invokeId;
} TAdsReadDeviceInfoReq;

#define TAdsReadDeviceInfoReq_Len (int)sizeof(TAdsReadDeviceInfoReq)

/*typedef struct
{
   guint16 adsState;
   guint16 deviceState;
   guint32 cbLength;
   guint16 firstDataWord;
} TAdsWriteControlReq, TAdsWriteControlInd;*/
#define TAdsWriteControlReq_Len 10

typedef struct
{
   guint32 invokeId;
} TAdsReadStateReq;
#define TAdsReadStateReq_Len (int)sizeof(TAdsReadStateReq)

typedef struct
{
   guint32 indexGroup;
   guint32 indexOffset;
   guint32 cbLength;
} TAdsReadReq;
#define TAdsReadReq_Len (int)sizeof(TAdsReadReq)

/*typedef struct
{
   guint32 indexGroup;
   guint32 indexOffset;
   guint32 cbLength;
   guint16 firstDataWord;
} TAdsWriteReq;*/
#define TAdsWriteReq_Len 14

/*
typedef struct
{
   guint32 indexGroup;
   guint32 indexOffset;
   guint32 cbReadLength;
   guint32 cbWriteLength;
   guint16 firstDataWord;
} TAdsReadWriteReq;*/
#define TAdsReadWriteReq_Len 18

typedef struct
{
   guint32 cbLength;
   guint32 nTransMode;
   guint32 nMaxDelay;
   guint32 nCycleTime;
   guint8  nCmpMax[sizeof(double)];
   guint8  nCmpMin[sizeof(double)];
} AdsNotificationAttrib;

typedef struct
{
   guint32               indexGroup;
   guint32               indexOffset;
   AdsNotificationAttrib noteAttrib;
} TAdsAddDeviceNotificationReq; 
#define TAdsAddDeviceNotificationReq_Len (int)sizeof(TAdsAddDeviceNotificationReq)  

typedef struct
{
   guint32   hNotification;
}  TAdsDelDeviceNotificationReq;
#define TAdsDelDeviceNotificationReq_Len (int)sizeof(TAdsDelDeviceNotificationReq)

typedef struct
{
   guint32 cbLength;
   guint32 nStamps;
}  TAdsDeviceNotificationReq;
#define TAdsDeviceNotificationReq_Len (int)sizeof(TAdsDeviceNotificationReq)

typedef struct
{
   guint32  result;
} TAdsRes;
#define TAdsRes_Len (int)sizeof(TAdsRes)

typedef struct
{
   guint8  version;
   guint8  revision;
   guint16 build;
} AdsVersion, *PAdsVersion;

typedef struct
{
   guint32    result;
   AdsVersion version;
   char       sName[ADS_FIXEDNAMESIZE];
} TAdsReadDeviceInfoRes;
#define TAdsReadDeviceInfoRes_Len (int)sizeof(TAdsReadDeviceInfoRes)

typedef struct
{
   guint32 result;
} TAdsWriteControlRes;
#define TAdsWriteControlRes_Len (int)sizeof(TAdsWriteControlRes)

typedef struct
{
   guint32 result;
   guint16 adsState;
   guint16 deviceState;
} TAdsReadStateRes;
#define TAdsReadStateRes_Len (int)sizeof(TAdsReadStateRes)

typedef struct
{
   guint32 result;
   guint32 cbLength;
   guint16 firstDataWord;
} TAdsReadRes;
#define TAdsReadRes_Len (int)sizeof(TAdsReadRes)

typedef struct
{
   guint32 result;
   guint32 cbLength;
   guint16 firstDataWord;
} TAdsReadWriteRes;
#define TAdsReadWriteRes_Len (int)sizeof(TAdsReadWriteRes)

typedef struct
{
   guint32 result;
} TAdsWriteRes;
#define TAdsWriteRes_Len (int)sizeof(TAdsWriteRes)

typedef struct
{
   guint32 result;
   guint32 handle;
}  TAdsAddDeviceNotificationRes;   
#define TAdsAddDeviceNotificationRes_Len (int)sizeof(TAdsAddDeviceNotificationRes)

typedef struct
{
   guint32 result;
}  TAdsDelDeviceNotificationRes;   
#define TAdsDelDeviceNotificationRes_Len (int)sizeof(TAdsDelDeviceNotificationRes)


/* structure for decoding the header -----------------------------------------*/
/*typedef struct
{
   guint16 reserved;
   guint32 cbLength;
} TcpAdsParserHDR;
typedef TcpAdsParserHDR;*/
#define TcpAdsParserHDR_Len 6


#endif
