/* packet-dis-enums.h
 * Enumerated values and string array declarations for DIS enum parsing.
 * Copyright 2005, Scientific Research Corporation
 * Initial implementation by Jeremy Ouellette <jouellet@scires.com>
 *
 * $Id: packet-dis-enums.h 46660 2012-12-21 09:29:46Z guy $
 *
 * Wireshark - Network traffic analyzer
 * By Gerald Combs <gerald@wireshark.org>
 * Copyright 1998 Gerald Combs
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __PACKET_DIS_ENUMS_H__
#define __PACKET_DIS_ENUMS_H__

#include <epan/value_string.h>

extern const value_string DIS_PDU_RadioCategory_Strings[];
extern const value_string DIS_PDU_NomenclatureVersion_Strings[];
extern const value_string DIS_PDU_Nomenclature_Strings[];
extern const value_string DIS_PDU_RadioTransmitState_Strings[];
extern const value_string DIS_PDU_RadioInputSource_Strings[];
extern const value_string DIS_PDU_DetailModulationAmplitude_Strings[];
extern const value_string DIS_PDU_DetailModulationAmpAndAngle_Strings[];
extern const value_string DIS_PDU_DetailModulationAngle_Strings[];
extern const value_string DIS_PDU_DetailModulationCombination_Strings[];
extern const value_string DIS_PDU_DetailModulationPulse_Strings[];
extern const value_string DIS_PDU_DetailModulationUnmodulated_Strings[];
extern const value_string DIS_PDU_DetailModulationCPSM_Strings[];
extern const value_string DIS_PDU_CryptoSystem_Strings[];
extern const value_string DIS_PDU_ModParamMsgStart_Strings[];
extern const value_string DIS_PDU_ModParamClrChannel_Strings[];
extern const value_string DIS_PDU_TSAllocationFidelity_Strings[];
extern const value_string DIS_PDU_TerminalPrimaryMode_Strings[]; 
extern const value_string DIS_PDU_TerminalSecondaryMode_Strings[]; 
extern const value_string DIS_PDU_ModParamSyncState_Strings[];


typedef enum
{
    DIS_VERSION_OTHER             = 0,
    DIS_VERSION_1_0               = 1,
    DIS_VERSION_IEEE_1278_1993    = 2,
    DIS_VERSION_2_0_3RD_DRAFT     = 3,
    DIS_VERSION_2_0_4TH_DRAFT     = 4,
    DIS_VERSION_IEEE_1278_1_1995  = 5,
    DIS_VERSION_IEEE_1278_1A_1998 = 6,
    DIS_VERSION_IEEE_1278_1_200X  = 7
} DIS_PDU_ProtocolVersion;

extern const value_string DIS_PDU_ProtocolVersion_Strings[];

typedef enum
{
    DIS_PROTOCOLFAMILY_OTHER                                  = 0,
    DIS_PROTOCOLFAMILY_ENTITY_INFORMATION_INTERACTION         = 1,
    DIS_PROTOCOLFAMILY_WARFARE                                = 2,
    DIS_PROTOCOLFAMILY_LOGISTICS                              = 3,
    DIS_PROTOCOLFAMILY_RADIO_COMMUNICATIONS                   = 4,
    DIS_PROTOCOLFAMILY_SIMULATION_MANAGEMENT                  = 5,
    DIS_PROTOCOLFAMILY_DISTRIBUTED_EMISSION_REGENERATION      = 6,
    DIS_PROTOCOLFAMILY_ENTITY_MANAGEMENT                      = 7,
    DIS_PROTOCOLFAMILY_MINEFIELD                              = 8,
    DIS_PROTOCOLFAMILY_SYNTHETIC_ENVIRONMENT                  = 9,
    DIS_PROTOCOLFAMILY_SIMULATION_MANAGEMENT_WITH_RELIABILITY = 10,
    DIS_PROTOCOLFAMILY_LIVE_ENTITY                            = 11,
    DIS_PROTOCOLFAMILY_NON_REAL_TIME                          = 12,
    DIS_PROTOCOLFAMILY_INFORMATION_OPERATIONS                 = 13,
    DIS_PROTOCOLFAMILY_EXPERIMENTAL_COMPUTER_GENERATED_FORCES = 129,
    DIS_PROTOCOLFAMILY_EXPERIMENTAL_VDIS                      = 130,
    DIS_PROTOCOLFAMILY_PERSISTENT_OBJECT                      = 140,
    DIS_PROTOCOLFAMILY_EXPERIMENTAL                           = 150
} DIS_PDU_ProtocolFamily;

extern const value_string DIS_PDU_ProtocolFamily_Strings[];

typedef enum
{
    DIS_PDUTYPE_OTHER                              = 0,
    DIS_PDUTYPE_ENTITY_STATE                       = 1,
    DIS_PDUTYPE_FIRE                               = 2,
    DIS_PDUTYPE_DETONATION                         = 3,
    DIS_PDUTYPE_COLLISION                          = 4,
    DIS_PDUTYPE_SERVICE_REQUEST                    = 5,
    DIS_PDUTYPE_RESUPPLY_OFFER                     = 6,
    DIS_PDUTYPE_RESUPPLY_RECEIVED                  = 7,
    DIS_PDUTYPE_RESUPPLY_CANCEL                    = 8,
    DIS_PDUTYPE_REPAIR_COMPLETE                    = 9,
    DIS_PDUTYPE_REPAIR_RESPONSE                    = 10,
    DIS_PDUTYPE_CREATE_ENTITY                      = 11,
    DIS_PDUTYPE_REMOVE_ENTITY                      = 12,
    DIS_PDUTYPE_START_RESUME                       = 13,
    DIS_PDUTYPE_STOP_FREEZE                        = 14,
    DIS_PDUTYPE_ACKNOWLEDGE                        = 15,
    DIS_PDUTYPE_ACTION_REQUEST                     = 16,
    DIS_PDUTYPE_ACTION_RESPONSE                    = 17,
    DIS_PDUTYPE_DATA_QUERY                         = 18,
    DIS_PDUTYPE_SET_DATA                           = 19,
    DIS_PDUTYPE_DATA                               = 20,
    DIS_PDUTYPE_EVENT_REPORT                       = 21,
    DIS_PDUTYPE_COMMENT                            = 22,
    DIS_PDUTYPE_ELECTROMAGNETIC_EMISSION           = 23,
    DIS_PDUTYPE_DESIGNATOR                         = 24,
    DIS_PDUTYPE_TRANSMITTER                        = 25,
    DIS_PDUTYPE_SIGNAL                             = 26,
    DIS_PDUTYPE_RECEIVER                           = 27,
    DIS_PDUTYPE_IFF_ATC_NAVAIDS                    = 28,
    DIS_PDUTYPE_UNDERWATER_ACOUSTIC                = 29,
    DIS_PDUTYPE_SUPPLEMENTAL_EMISSION_ENTITY_STATE = 30,
    DIS_PDUTYPE_INTERCOM_SIGNAL                    = 31,
    DIS_PDUTYPE_INTERCOM_CONTROL                   = 32,
    DIS_PDUTYPE_AGGREGATE_STATE                    = 33,
    DIS_PDUTYPE_IS_GROUP_OF                        = 34,
    DIS_PDUTYPE_TRANSFER_CONTROL                   = 35,
    DIS_PDUTYPE_IS_PART_OF                         = 36,
    DIS_PDUTYPE_MINEFIELD_STATE                    = 37,
    DIS_PDUTYPE_MINEFIELD_QUERY                    = 38,
    DIS_PDUTYPE_MINEFIELD_DATA                     = 39,
    DIS_PDUTYPE_MINEFIELD_RESPONSE_NAK             = 40,
    DIS_PDUTYPE_ENVIRONMENTAL_PROCESS              = 41,
    DIS_PDUTYPE_GRIDDED_DATA                       = 42,
    DIS_PDUTYPE_POINT_OBJECT_STATE                 = 43,
    DIS_PDUTYPE_LINEAR_OBJECT_STATE                = 44,
    DIS_PDUTYPE_AREAL_OBJECT_STATE                 = 45,
    DIS_PDUTYPE_TSPI                               = 46,
    DIS_PDUTYPE_APPEARANCE                         = 47,
    DIS_PDUTYPE_ARTICULATED_PARTS                  = 48,
    DIS_PDUTYPE_LE_FIRE                            = 49,
    DIS_PDUTYPE_LE_DETONATION                      = 50,
    DIS_PDUTYPE_CREATE_ENTITY_R                    = 51,
    DIS_PDUTYPE_REMOVE_ENTITY_R                    = 52,
    DIS_PDUTYPE_START_RESUME_R                     = 53,
    DIS_PDUTYPE_STOP_FREEZE_R                      = 54,
    DIS_PDUTYPE_ACKNOWLEDGE_R                      = 55,
    DIS_PDUTYPE_ACTION_REQUEST_R                   = 56,
    DIS_PDUTYPE_ACTION_RESPONSE_R                  = 57,
    DIS_PDUTYPE_DATA_QUERY_R                       = 58,
    DIS_PDUTYPE_SET_DATA_R                         = 59,
    DIS_PDUTYPE_DATA_R                             = 60,
    DIS_PDUTYPE_EVENT_REPORT_R                     = 61,
    DIS_PDUTYPE_COMMENT_R                          = 62,
    DIS_PDUTYPE_RECORD_R                           = 63,
    DIS_PDUTYPE_SET_RECORD_R                       = 64,
    DIS_PDUTYPE_RECORD_QUERY_R                     = 65,
    DIS_PDUTYPE_COLLISION_ELASTIC                  = 66,
    DIS_PDUTYPE_ENTITY_STATE_UPDATE                = 67,
    DIS_PDUTYPE_DIRECTED_ENERGY_FIRE               = 68,
    DIS_PDUTYPE_ENTITY_DAMAGE_STATUS               = 69,
    DIS_PDUTYPE_INFORMATION_OPERATIONS_ACTION      = 70,
    DIS_PDUTYPE_INFORMATION_OPERATIONS_REPORT      = 71,
    DIS_PDUTYPE_ATTRIBUTE                          = 71,
    DIS_PDUTYPE_ANNOUNCE_OBJECT                    = 129,
    DIS_PDUTYPE_DELETE_OBJECT                      = 130,
    DIS_PDUTYPE_DESCRIBE_APPLICATION               = 131,
    DIS_PDUTYPE_DESCRIBE_EVENT                     = 132,
    DIS_PDUTYPE_DESCRIBE_OBJECT                    = 133,
    DIS_PDUTYPE_REQUEST_EVENT                      = 134,
    DIS_PDUTYPE_REQUEST_OBJECT                     = 135,
    DIS_PDUTYPE_APPLICATION_CONTROL                = 200,
    DIS_PDUTYPE_STEALTH_STATE                      = 201
} DIS_PDU_Type;

extern const value_string DIS_PDU_Type_Strings[];

typedef enum
{
    DIS_ENTITYKIND_OTHER            = 0,
    DIS_ENTITYKIND_PLATFORM         = 1,
    DIS_ENTITYKIND_MUNITION         = 2,
    DIS_ENTITYKIND_LIFE_FORM        = 3,
    DIS_ENTITYKIND_ENVIRONMENTAL    = 4,
    DIS_ENTITYKIND_CULTURAL_FEATURE = 5,
    DIS_ENTITYKIND_SUPPLY           = 6,
    DIS_ENTITYKIND_RADIO            = 7,
    DIS_ENTITYKIND_EXPENDABLE       = 8,
    DIS_ENTITYKIND_SENSOR_EMITTER   = 9
} DIS_PDU_EntityKind;

extern const value_string DIS_PDU_EntityKind_Strings[];

typedef enum
{
    DIS_DOMAIN_OTHER      = 0,
    DIS_DOMAIN_LAND       = 1,
    DIS_DOMAIN_AIR        = 2,
    DIS_DOMAIN_SURFACE    = 3,
    DIS_DOMAIN_SUBSURFACE = 4,
    DIS_DOMAIN_SPACE      = 5
} DIS_PDU_Domain;

extern const value_string DIS_PDU_Domain_Strings[];

typedef enum
{
    DIS_CATEGORY_LANDPLATFORM_OTHER                                      = 0,
    DIS_CATEGORY_LANDPLATFORM_TANK                                       = 1,
    DIS_CATEGORY_LANDPLATFORM_ARMORED_FIGHTING_VEHICLE                   = 2,
    DIS_CATEGORY_LANDPLATFORM_ARMORED_UTILITY_VEHICLE                    = 3,
    DIS_CATEGORY_LANDPLATFORM_SELF_PROPELLED_ARTILLERY                   = 4,
    DIS_CATEGORY_LANDPLATFORM_TOWED_ARTILLERY                            = 5,
    DIS_CATEGORY_LANDPLATFORM_SMALL_WHEELED_UTILITY_VEHICLE              = 6,
    DIS_CATEGORY_LANDPLATFORM_LARGE_WHEELED_UTILITY_VEHICLE              = 7,
    DIS_CATEGORY_LANDPLATFORM_SMALL_TRACKED_UTILITY_VEHICLE              = 8,
    DIS_CATEGORY_LANDPLATFORM_LARGE_TRACKED_UTILITY_VEHICLE              = 9,
    DIS_CATEGORY_LANDPLATFORM_MORTAR                                     = 10,
    DIS_CATEGORY_LANDPLATFORM_MINE_PLOW                                  = 11,
    DIS_CATEGORY_LANDPLATFORM_MINE_RAKE                                  = 12,
    DIS_CATEGORY_LANDPLATFORM_MINE_ROLLER                                = 13,
    DIS_CATEGORY_LANDPLATFORM_CARGO_TRAILER                              = 14,
    DIS_CATEGORY_LANDPLATFORM_FUEL_TRAILER                               = 15,
    DIS_CATEGORY_LANDPLATFORM_GENERATOR_TRAILER                          = 16,
    DIS_CATEGORY_LANDPLATFORM_WATER_TRAILER                              = 17,
    DIS_CATEGORY_LANDPLATFORM_ENGINEER_EQUIPMENT                         = 18,
    DIS_CATEGORY_LANDPLATFORM_HEAVY_EQUIPMENT_TRANSPORT_TRAILER          = 19,
    DIS_CATEGORY_LANDPLATFORM_MAINTENANCE_EQUIPMENT_TRAILER              = 20,
    DIS_CATEGORY_LANDPLATFORM_LIMBER                                     = 21,
    DIS_CATEGORY_LANDPLATFORM_CHEMICAL_DECONTAMINATION_TRAILER           = 22,
    DIS_CATEGORY_LANDPLATFORM_WARNING_SYSTEM                             = 23,
    DIS_CATEGORY_LANDPLATFORM_TRAIN_ENGINE                               = 24,
    DIS_CATEGORY_LANDPLATFORM_TRAIN_CAR                                  = 25,
    DIS_CATEGORY_LANDPLATFORM_TRAIN_CABOOSE                              = 26,
    DIS_CATEGORY_LANDPLATFORM_CIVILIAN_VEHICLE                           = 27,
    DIS_CATEGORY_LANDPLATFORM_AIR_DEFENSE_MISSILE_DEFENSE_UNIT_EQUIPMENT = 28,
    DIS_CATEGORY_LANDPLATFORM_C3I_SYSTEM                                 = 29,
    DIS_CATEGORY_LANDPLATFORM_OPERATIONS_FACILITY                        = 30,
    DIS_CATEGORY_LANDPLATFORM_INTELLIGENCE_FACILITY                      = 31,
    DIS_CATEGORY_LANDPLATFORM_SURVEILLANCE_FACILITY                      = 32,
    DIS_CATEGORY_LANDPLATFORM_COMMUNICATIONS_FACILITY                    = 33,
    DIS_CATEGORY_LANDPLATFORM_COMMAND_FACILITY                           = 34,
    DIS_CATEGORY_LANDPLATFORM_C4I_FACILITY                               = 35,
    DIS_CATEGORY_LANDPLATFORM_CONTROL_FACILITY                           = 36,
    DIS_CATEGORY_LANDPLATFORM_FIRE_CONTROL_FACILITY                      = 37,
    DIS_CATEGORY_LANDPLATFORM_MISSILE_DEFENSE_FACILITY                   = 38,
    DIS_CATEGORY_LANDPLATFORM_FIELD_COMMAND_POST                         = 39,
    DIS_CATEGORY_LANDPLATFORM_OBSERVATION_POST                           = 40
} DIS_PDU_Category_LandPlatform;

extern const value_string DIS_PDU_Category_LandPlatform_Strings[];

typedef enum
{
    DIS_CATEGORY_AIRPLATFORM_OTHER                             = 0,
    DIS_CATEGORY_AIRPLATFORM_FIGHTER_AIR_DEFENSE               = 1,
    DIS_CATEGORY_AIRPLATFORM_ATTACK_STRIKE                     = 2,
    DIS_CATEGORY_AIRPLATFORM_BOMBER                            = 3,
    DIS_CATEGORY_AIRPLATFORM_CARGO_TANKER                      = 4,
    DIS_CATEGORY_AIRPLATFORM_ASW_PATROL_OBSERVATION            = 5,
    DIS_CATEGORY_AIRPLATFORM_ELECTRONIC_WARFARE                = 6,
    DIS_CATEGORY_AIRPLATFORM_RECONNAISSANCE                    = 7,
    DIS_CATEGORY_AIRPLATFORM_SURVEILLANCE_C2                   = 8,
    DIS_CATEGORY_AIRPLATFORM_ATTACK_HELICOPTER                 = 20,
    DIS_CATEGORY_AIRPLATFORM_UTILITY_HELICOPTER                = 21,
    DIS_CATEGORY_AIRPLATFORM_ANTISUB_WARFARE_PATROL_HELICOPTER = 22,
    DIS_CATEGORY_AIRPLATFORM_CARGO_HELICOPTER                  = 23,
    DIS_CATEGORY_AIRPLATFORM_OBSERVATION_HELICOPTER            = 24,
    DIS_CATEGORY_AIRPLATFORM_SPECIAL_OPERATIONS_HELICOPTER     = 25,
    DIS_CATEGORY_AIRPLATFORM_TRAINER                           = 40,
    DIS_CATEGORY_AIRPLATFORM_UNMANNED                          = 50,
    DIS_CATEGORY_AIRPLATFORM_NON_COMBATANT_COMMERCIAL_AIRCRAFT = 57
} DIS_PDU_Category_AirPlatform;

extern const value_string DIS_PDU_Category_AirPlatform_Strings[];

typedef enum
{
    DIS_CATEGORY_SURFACEPLATFORM_OTHER = 0
} DIS_PDU_Category_SurfacePlatform;

extern const value_string DIS_PDU_Category_SurfacePlatform_Strings[];

typedef enum
{
    DIS_CATEGORY_SUBSURFACEPLATFORM_OTHER = 0
} DIS_PDU_Category_SubsurfacePlatform;

extern const value_string DIS_PDU_Category_SubsurfacePlatform_Strings[];

typedef enum
{
    DIS_CATEGORY_SPACEPLATFORM_OTHER = 0
} DIS_PDU_Category_SpacePlatform;

extern const value_string DIS_PDU_Category_SpacePlatform_Strings[];

typedef enum
{
    DIS_ENCODING_CLASS_ENCODED_AUDIO               = 0,
    DIS_ENCODING_CLASS_RAW_BINARY_DATA             = 1,
    DIS_ENCODING_CLASS_APPL_SPEC_DATA              = 2,
    DIS_ENCODING_CLASS_DB_INDEX                    = 3
} DIS_PDU_Encoding_Class;

extern const value_string DIS_PDU_Encoding_Class_Strings[];

typedef enum
{
    DIS_ENCODING_TYPE_OTHER                        = 0,
    DIS_ENCODING_TYPE_MU_LAW                       = 1,
    DIS_ENCODING_TYPE_CVSD                         = 2,
    DIS_ENCODING_TYPE_ADPCM_G721                   = 3,
    DIS_ENCODING_TYPE_16BIT_LINEAR_PCM             = 4,
    DIS_ENCODING_TYPE_8BIT_LINEAR_PCM              = 5,
    DIS_ENCODING_TYPE_VECTOR_QUANTIZATION          = 6
} DIS_PDU_Encoding_Type;

extern const value_string DIS_PDU_Encoding_Type_Strings[];

typedef enum
{
    DIS_TDL_TYPE_OTHER                        = 0,
    DIS_TDL_TYPE_PADIL                        = 1,
    DIS_TDL_TYPE_NATO_LINK1                   = 2,
    DIS_TDL_TYPE_ATDL1                        = 3,
    DIS_TDL_TYPE_LINK_11B                     = 4,
    DIS_TDL_TYPE_SADL                         = 5,
    DIS_TDL_TYPE_JTIDS_TADIL_J                = 6,
    DIS_TDL_TYPE_JTIDS_FDL_TADIL_J            = 7,
    DIS_TDL_TYPE_LINK_11A                     = 8,
    DIS_TDL_TYPE_IJMS                         = 9,
    DIS_TDL_TYPE_LINK_4A                      = 10,
    DIS_TDL_TYPE_LINK_4C                      = 11,
    DIS_TDL_TYPE_TIBS                         = 12,
    DIS_TDL_TYPE_ATL                          = 13,
    DIS_TDL_TYPE_CONSTANT_SRC                 = 14,
    DIS_TDL_TYPE_ABBRV_CC                     = 15,
    DIS_TDL_TYPE_MILSTAR                      = 16,
    DIS_TDL_TYPE_ATHS                         = 17,
    DIS_TDL_TYPE_OTHGOLD                      = 18,
    DIS_TDL_TYPE_TACELINT                     = 19,
    DIS_TDL_TYPE_AWW13                        = 20,
    DIS_TDL_TYPE_ABBRV_CC_2                   = 21,
    DIS_TDL_TYPE_EPLRS                        = 22,
    DIS_TDL_TYPE_PLRS                         = 23,
    DIS_TDL_TYPE_SINCGARS                     = 24,
    DIS_TDL_TYPE_HAVE_QUICK_I                 = 25,
    DIS_TDL_TYPE_HAVE_QUICK_II                = 26,
    DIS_TDL_TYPE_HAVE_QUICK_IIA               = 27,
    DIS_TDL_TYPE_IFDL1                        = 28,
    DIS_TDL_TYPE_IFDL2                        = 29,
    DIS_TDL_TYPE_IDM                          = 30,
    DIS_TDL_TYPE_AFAPD                        = 31,
    DIS_TDL_TYPE_CEC                          = 32,
    DIS_TDL_TYPE_FAAD_FDL                     = 33,
    DIS_TDL_TYPE_GBDL                         = 34,
    DIS_TDL_TYPE_IVIS                         = 35,
    DIS_TDL_TYPE_MTS                          = 36,
    DIS_TDL_TYPE_TACFIRE                      = 37,
    DIS_TDL_TYPE_IBS                          = 38,
    DIS_TDL_TYPE_ABIT                         = 39,
    DIS_TDL_TYPE_ATARS                        = 40,
    DIS_TDL_TYPE_BGPHES                       = 41,
    DIS_TDL_TYPE_CHBDL                        = 42,
    DIS_TDL_TYPE_GUARDRAIL_IDL                = 43,
    DIS_TDL_TYPE_GUARDRAIL_CSS1               = 44,
    DIS_TDL_TYPE_GUARDRAIL_CSS2               = 45,
    DIS_TDL_TYPE_GUARDRAIL_CSS2_MRDL          = 46,
    DIS_TDL_TYPE_GUARDRAIL_CSS2_DASR          = 47,
    DIS_TDL_TYPE_LOS_TETHER                   = 48,
    DIS_TDL_TYPE_LWCDL                        = 49,
    DIS_TDL_TYPE_L_52M                        = 50,
    DIS_TDL_TYPE_RR_ROWL_DL                   = 51,
    DIS_TDL_TYPE_SENIOR_SPAN                  = 52,
    DIS_TDL_TYPE_SENIOR_SPUR                  = 53,
    DIS_TDL_TYPE_SENIOR_STRETCH               = 54,
    DIS_TDL_TYPE_SENIOR_YEAR_IDL              = 55,
    DIS_TDL_TYPE_SPACE_CDL                    = 56,
    DIS_TDL_TYPE_TR_1_MIST_ADL                = 57,
    DIS_TDL_TYPE_KU_BAND_SATCOM               = 58,
    DIS_TDL_TYPE_MECDL                        = 59,
    DIS_TDL_TYPE_RADAR_DATA_TSDL              = 60,
    DIS_TDL_TYPE_SCDL                         = 61,
    DIS_TDL_TYPE_TACTICAL_UAV_VIDEO           = 62,
    DIS_TDL_TYPE_UHF_SATCOM                   = 63,
    DIS_TDL_TYPE_TCDL                         = 64,
    DIS_TDL_TYPE_LLAPI                        = 65,
    DIS_TDL_TYPE_WEAPONS_DL                   = 66,
    DIS_TDL_TYPE_GC3                          = 99,
    DIS_TDL_TYPE_LINK16_STD                   = 100,
    DIS_TDL_TYPE_LINK16_EDR                   = 101,
    DIS_TDL_TYPE_JTIDS_NET_DATA_LOAD          = 102,
    DIS_TDL_TYPE_LINK22                       = 103,
    DIS_TDL_TYPE_AFIWC_IADS                   = 104
} DIS_PDU_TDL_Type;

extern const value_string DIS_PDU_TDL_Type_Strings[];

typedef enum
{
    DIS_PATTERN_OMNI_DIRECTIONAL             = 0,
    DIS_PATTERN_BEAM                         = 1,
    DIS_PATTERN_SPHERICAL_HARMONIC           = 2
} DIS_PDU_AntennaPattern_Type;

extern const value_string DIS_PDU_AntennaPatternType_Strings[];   
    
typedef enum
{
    DIS_SYSTEM_MOD_OTHER                     = 0,
    DIS_SYSTEM_MOD_GENERIC                   = 1,
    DIS_SYSTEM_MOD_HQ                        = 2,
    DIS_SYSTEM_MOD_HQII                      = 3,
    DIS_SYSTEM_MOD_HQIIA                     = 4,
    DIS_SYSTEM_MOD_SINCGARS                  = 5,
    DIS_SYSTEM_MOD_CCTT_SINCGARS             = 6,
    DIS_SYSTEM_MOD_EPLRS                     = 7,
    DIS_SYSTEM_MOD_JTIDS_MIDS                = 8
} DIS_PDU_SYSTEM_MODULATION_TYPE;

extern const value_string DIS_PDU_SystemModulation_Strings[];

typedef enum
{
    DIS_MAJOR_MOD_OTHER                      = 0,
    DIS_MAJOR_MOD_AMPLITUDE                  = 1,
    DIS_MAJOR_MOD_AMPLITUDE_AND_ANGLE        = 2,
    DIS_MAJOR_MOD_ANGLE                      = 3,
    DIS_MAJOR_MOD_COMBINATION                = 4,
    DIS_MAJOR_MOD_PULSE                      = 5,
    DIS_MAJOR_MOD_UNMODULATED                = 6,
    DIS_MAJOR_MOD_CPSM                       = 7
} DIS_PDU_MAJOR_MODULATION_TYPE;

extern const value_string DIS_PDU_MajorModulation_Strings[];

typedef enum
{
    DIS_EMISSION_FUNCTION_OTHER                         = 0,
    DIS_EMISSION_FUNCTION_MULTI_FUNCTION                = 1,
    DIS_EMISSION_FUNCTION_EARLY_WARNING_SURVEILLANCE    = 2,
    DIS_EMISSION_FUNCTION_HEIGHT_FINDING                = 3,
    DIS_EMISSION_FUNCTION_FIRE_CONTROL                  = 4,
    DIS_EMISSION_FUNCTION_ACQUISITION_DETECTION         = 5,
    DIS_EMISSION_FUNCTION_TRACKING                      = 6,
    DIS_EMISSION_FUNCTION_GUIDANCE_ILLUMINATION         = 7,
    DIS_EMISSION_FUNCTION_FIRING_POINT_LAUNCH_POINT_LOCATION = 8,
    DIS_EMISSION_FUNCTION_RANGING                       = 9,
    DIS_EMISSION_FUNCTION_RADAR_ALTIMETER               = 10,
    DIS_EMISSION_FUNCTION_IMAGING                       = 11,
    DIS_EMISSION_FUNCTION_MOTION_DETECTION              = 12,
    DIS_EMISSION_FUNCTION_NAVIGATION                    = 13,
    DIS_EMISSION_FUNCTION_WEATHER_METEROLOGICAL         = 14,
    DIS_EMISSION_FUNCTION_INSTRUMENTATION               = 15,
    DIS_EMISSION_FUNCTION_IDENTIFICATION_CLASSIFICATION_INCLUDING_IFF = 16,
    DIS_EMISSION_FUNCTION_AAA_FIRE_CONTROL              = 17,
    DIS_EMISSION_FUNCTION_AIR_SEARCH_BOMB               = 18,
    DIS_EMISSION_FUNCTION_AIR_INTERCEPT                 = 19,
    DIS_EMISSION_FUNCTION_ALTIMETER                     = 20,
    DIS_EMISSION_FUNCTION_AIR_MAPPING                   = 21,
    DIS_EMISSION_FUNCTION_AIR_TRAFFIC_CONTROL           = 22,
    DIS_EMISSION_FUNCTION_BEACON                        = 23,
    DIS_EMISSION_FUNCTION_BATTLEFIELD_SURVEILLANCE      = 24,
    DIS_EMISSION_FUNCTION_GROUND_CONTROL_APPROACH       = 25,
    DIS_EMISSION_FUNCTION_GROUND_CONTROL_INTERCEPT      = 26,
    DIS_EMISSION_FUNCTION_COASTAL_SURVEILLANCE          = 27,
    DIS_EMISSION_FUNCTION_DECOY_MIMIC                   = 28,
    DIS_EMISSION_FUNCTION_DATA_TRANSMISSION             = 29,
    DIS_EMISSION_FUNCTION_EARTH_SURVEILLANCE            = 30,
    DIS_EMISSION_FUNCTION_GUN_LAY_BEACON                = 31,
    DIS_EMISSION_FUNCTION_GROUND_MAPPING                = 32,
    DIS_EMISSION_FUNCTION_HARBOR_SURVEILLANCE           = 33,
                                                  /* enum 34 deleted */
    DIS_EMISSION_FUNCTION_ILS                           = 35,
    DIS_EMISSION_FUNCTION_IONOSPHERIC_SOUND             = 36,
    DIS_EMISSION_FUNCTION_INTERROGATOR                  = 37,
    DIS_EMISSION_FUNCTION_BARRAGE_JAMMING               = 38,
    DIS_EMISSION_FUNCTION_CLICK_JAMMING                 = 39,
                                                  /* enum 40 deleted */
    DIS_EMISSION_FUNCTION_FREQUENCY_SWEPT_JAMMING       = 41,
    DIS_EMISSION_FUNCTION_JAMMING                       = 42,
                                                  /* enum 43 deleted */
    DIS_EMISSION_FUNCTION_PULSED_JAMMING                = 44,
    DIS_EMISSION_FUNCTION_REPEATER_JAMMING              = 45,
    DIS_EMISSION_FUNCTION_SPOT_NOISE_JAMMING            = 46,
    DIS_EMISSION_FUNCTION_MISSILE_ACQUISITION           = 47,
    DIS_EMISSION_FUNCTION_MISSILE_DOWNLINK              = 48,
                                                  /* enum 49 deleted */
    DIS_EMISSION_FUNCTION_SPACE                         = 50,
    DIS_EMISSION_FUNCTION_SURFACE_SEARCH                = 51,
    DIS_EMISSION_FUNCTION_SHELL_TRACKING                = 52,
                                                /* enums 52-55 unassigned */
    DIS_EMISSION_FUNCTION_TELEVISION                    = 56,
    DIS_EMISSION_FUNCTION_UNKNOWN                       = 57,
    DIS_EMISSION_FUNCTION_VIDEO_REMOTING                = 58,
    DIS_EMISSION_FUNCTION_EXPERIMENTAL_OR_TRAINING      = 59,
    DIS_EMISSION_FUNCTION_MISSILE_GUIDANCE              = 60,
    DIS_EMISSION_FUNCTION_MISSILE_HOMING                = 61,
    DIS_EMISSION_FUNCTION_MISSILE_TRACKING              = 62,
                                                  /* enum 63 unassigned */
    DIS_EMISSION_FUNCTION_JAMMING_NOISE                 = 64,
    DIS_EMISSION_FUNCTION_JAMMING_DECEPTION             = 65,
                                                  /* enum 66 deleted */
                                                /* enums 67-70 unassigned */
    DIS_EMISSION_FUNCTION_NAVIGATION_DISTANCE_MEASURING_EQUIPMENT = 71,
    DIS_EMISSION_FUNCTION_TERRAIN_FOLLOWING             = 72,
    DIS_EMISSION_FUNCTION_WEATHER_AVOIDANCE             = 73,
    DIS_EMISSION_FUNCTION_PROXIMITY_FUSE                = 74,
                                                  /* enum 75 deleted */
    DIS_EMISSION_FUNCTION_RADIOSONDE                    = 76,
    DIS_EMISSION_FUNCTION_SONOBUOY                      = 77,
    DIS_EMISSION_FUNCTION_BATHYTHERMAL_SENSOR           = 78,
    DIS_EMISSION_FUNCTION_TOWED_COUNTER_MEASURE         = 79,
                                                /* enums 80-95 unassigned */
    DIS_EMISSION_FUNCTION_WEAPON_NON_LETHAL             = 96,
    DIS_EMISSION_FUNCTION_WEAPON_LETHAL                 = 97
} DIS_PDU_Emission_Function;

extern const value_string DIS_PDU_EmissionFunction_Strings[];

typedef enum
{
    DIS_BEAM_FUNCTION_OTHER                             = 0,
    DIS_BEAM_FUNCTION_SEARCH                            = 1,
    DIS_BEAM_FUNCTION_HEIGHT_FINDER                     = 2,
    DIS_BEAM_FUNCTION_ACQUISITION                       = 3,
    DIS_BEAM_FUNCTION_TRACKING                          = 4,
    DIS_BEAM_FUNCTION_ACQUISITION_TRACKING              = 5,
    DIS_BEAM_FUNCTION_COMMAND_GUIDANCE                  = 6,
    DIS_BEAM_FUNCTION_ILLUMINATION                      = 7,
    DIS_BEAM_FUNCTION_RANGE_ONLY_RADAR                  = 8,
    DIS_BEAM_FUNCTION_MISSILE_BEACON                    = 9,
    DIS_BEAM_FUNCTION_MISSILE_FUZE                      = 10,
    DIS_BEAM_FUNCTION_ACTIVE_RADAR_MISSILE_SEEKER       = 11,
    DIS_BEAM_FUNCTION_JAMMER                            = 12,
    DIS_BEAM_FUNCTION_IFF                               = 13,
    DIS_BEAM_FUNCTION_NAVIGATIONAL_WEATHER              = 14,
    DIS_BEAM_FUNCTION_METEOROLOGICAL                    = 15,
    DIS_BEAM_FUNCTION_DATA_TRANSMISSION                 = 16,
    DIS_BEAM_FUNCTION_NAVIGATIONAL_DIRECTIONAL_BEACON   = 17
} DIS_PDU_Beam_Function;

extern const value_string DIS_PDU_BeamFunction_Strings[];

typedef enum
{
    DIS_ACKNOWLEDGE_FLAG_CREATE_ENTITY               = 1,
    DIS_ACKNOWLEDGE_FLAG_REMOVE_ENTITY               = 2,
    DIS_ACKNOWLEDGE_FLAG_START_RESUME                = 3,
    DIS_ACKNOWLEDGE_FLAG_STOP_FREEZE                 = 4,
    DIS_ACKNOWLEDGE_FLAG_TRANSFER_CONTROL_REQUEST    = 5
} DIS_PDU_AcknowledgeFlag;

extern const value_string DIS_PDU_AcknowledgeFlag_Strings[];

typedef enum
{
    DIS_ACTION_ID_OTHER                                         =     0,
    DIS_ACTION_ID_LOCAL_STORAGE_OF_THE_REQUESTED_INFORMATION    =     1,
    DIS_ACTION_ID_INFORM_SM_OF_EVENT_RAN_OUT_OF_AMMUNITION      =     2,
    DIS_ACTION_ID_INFORM_SM_OF_EVENT_KILLED_IN_ACTION           =     3,
    DIS_ACTION_ID_INFORM_SM_OF_EVENT_DAMAGE                     =     4,
    DIS_ACTION_ID_INFORM_SM_OF_EVENT_MOBILITY_DISABLED          =     5,
    DIS_ACTION_ID_INFORM_SM_OF_EVENT_FIRE_DISABLED              =     6,
    DIS_ACTION_ID_INFORM_SM_OF_EVENT_RAN_OUT_OF_FUEL            =     7,
    DIS_ACTION_ID_RECALL_CHECKPOINT_DATA                        =     8,
    DIS_ACTION_ID_RECALL_INITIAL_PARAMETERS                     =     9,
    DIS_ACTION_ID_INITIATE_TETHER_LEAD                          =    10,
    DIS_ACTION_ID_INITIATE_TETHER_FOLLOW                        =    11,
    DIS_ACTION_ID_UNTETHER                                      =    12,
    DIS_ACTION_ID_INITIATE_SERVICE_STATION_RESUPPLY             =    13,
    DIS_ACTION_ID_INITIATE_TAILGATE_RESUPPLY                    =    14,
    DIS_ACTION_ID_INITIATE_HITCH_LEAD                           =    15,
    DIS_ACTION_ID_INITIATE_HITCH_FOLLOW                         =    16,
    DIS_ACTION_ID_UNHITCH                                       =    17,
    DIS_ACTION_ID_MOUNT                                         =    18,
    DIS_ACTION_ID_DISMOUNT                                      =    19,
    DIS_ACTION_ID_START_DRC                                     =    20,
    DIS_ACTION_ID_STOP_DRC                                      =    21,
    DIS_ACTION_ID_DATA_QUERY                                    =    22,
    DIS_ACTION_ID_STATUS_REQUEST                                =    23,
    DIS_ACTION_ID_SEND_OBJECT_STATE_DATA                        =    24,
    DIS_ACTION_ID_RECONSTITUTE                                  =    25,
    DIS_ACTION_ID_LOCK_SITE_CONFIGURATION                       =    26,
    DIS_ACTION_ID_UNLOCK_SITE_CONFIGURATION                     =    27,
    DIS_ACTION_ID_UPDATE_SITE_CONFIGURATION                     =    28,
    DIS_ACTION_ID_QUERY_SITE_CONFIGURATION                      =    29,
    DIS_ACTION_ID_TETHERING_INFORMATION                         =    30,
    DIS_ACTION_ID_MOUNT_INTENT                                  =    31,
    DIS_ACTION_ID_ACCEPT_SUBSCRIPTION                           =    33,
    DIS_ACTION_ID_UNSUBSCRIBE                                   =    34,
    DIS_ACTION_ID_TELEPORT_ENTITY                               =    35,
    DIS_ACTION_ID_CHANGE_AGGREGATE_STATE                        =    36,
    DIS_ACTION_ID_REQUEST_START_PDU                             =    37,
    DIS_ACTION_ID_WAKEUP_GET_READY_FOR_INITIALIZATION           =    38,
    DIS_ACTION_ID_INITIALIZE_INTERNAL_PARAMETERS                =    39,
    DIS_ACTION_ID_SEND_PLAN_DATA                                =    40,
    DIS_ACTION_ID_SYNCHRONIZE_INTERNAL_CLOCKS                   =    41,
    DIS_ACTION_ID_RUN                                           =    42,
    DIS_ACTION_ID_SAVE_INTERNAL_PARAMETERS                      =    43,
    DIS_ACTION_ID_SIMULATE_MALFUNCTION                          =    44,
    DIS_ACTION_ID_JOIN_EXERCISE                                 =    45,
    DIS_ACTION_ID_RESIGN_EXERCISE                               =    46,
    DIS_ACTION_ID_TIME_ADVANCE                                  =    47,
    DIS_ACTION_ID_COMMAND_FROM_SIMULATOR                        =    48,
    DIS_ACTION_ID_SLING_LOAD_CAPABILITY_REQUEST                 =  4300,
    DIS_ACTION_ID_SLING_ATTACH_REQUEST                          =  4301,
    DIS_ACTION_ID_SLING_RELEASE_REQUEST                         =  4302,
    DIS_ACTION_ID_AIRMOUNT_MOUNT_REQUEST                        =  4303,
    DIS_ACTION_ID_AIRMOUNT_DISMOUNT_REQUEST                     =  4304,
    DIS_ACTION_ID_AIRMOUNT_INFO_REQUEST                         =  4305
} DIS_PDU_ActionId;

extern const value_string DIS_PDU_ActionId_Strings[];

typedef enum
{
    DIS_APPLICATION_GENERAL_STATUS_UNKNOWN                   = 1,
    DIS_APPLICATION_GENERAL_STATUS_FUNCTIONAL                = 2,
    DIS_APPLICATION_GENERAL_STATUS_DEGRADED_BUT_FUNCTIONAL   = 3,
    DIS_APPLICATION_GENERAL_STATUS_NOT_FUNCTIONAL            = 4
} DIS_PDU_ApplicationGeneralStatus;

extern const value_string DIS_PDU_ApplicationGeneralStatus_Strings[];

typedef enum
{
    DIS_APPLICATION_STATUS_TYPE_NOT_SPECIFIED             =     0,
    DIS_APPLICATION_STATUS_TYPE_CPU_USAGE_USER            =    10,
    DIS_APPLICATION_STATUS_TYPE_CPU_USAGE_SYSTEM          =    11,
    DIS_APPLICATION_STATUS_TYPE_CPU_USAGE_IO              =    12,
    DIS_APPLICATION_STATUS_TYPE_CPU_USAGE_IDLE            =    13,
    DIS_APPLICATION_STATUS_TYPE_CPU_USAGE_STEAL           =    14,
    DIS_APPLICATION_STATUS_TYPE_CPU_USAGE_NICE            =    15,
    DIS_APPLICATION_STATUS_TYPE_MEMORY_FREE               =    50,
    DIS_APPLICATION_STATUS_TYPE_MEMORY_USED               =    51,
    DIS_APPLICATION_STATUS_TYPE_SWAP_FREE                 =    60,
    DIS_APPLICATION_STATUS_TYPE_SWAP_USED                 =    61,
    DIS_APPLICATION_STATUS_TYPE_SWAP_CACHED               =    62,
    DIS_APPLICATION_STATUS_TYPE_TRANSMITTED_PACKETS_SEC   =   100,
    DIS_APPLICATION_STATUS_TYPE_TRANSMITTED_BYTES_SEC     =   101,
    DIS_APPLICATION_STATUS_TYPE_RECEIVED_PACKETS_SEC      =   110,
    DIS_APPLICATION_STATUS_TYPE_RECEIVED_BYTES_SEC        =   111,
    DIS_APPLICATION_STATUS_TYPE_NICE_LEVEL                =   150
} DIS_PDU_ApplicationStatusType;

extern const value_string DIS_PDU_ApplicationStatusType_Strings[];

typedef enum
{
    DIS_APPLICATION_TYPE_OTHER                                  =     0,
    DIS_APPLICATION_TYPE_RESOURCE_MANAGER                       =     1,
    DIS_APPLICATION_TYPE_SIMULATION_MANAGER                     =     2,
    DIS_APPLICATION_TYPE_GATEWAY                                =     3,
    DIS_APPLICATION_TYPE_STEALTH                                =     4,
    DIS_APPLICATION_TYPE_TACTICAL_INTERNET_INTERFACE            =     5
} DIS_PDU_ApplicationType;

extern const value_string DIS_PDU_ApplicationType_Strings[];

typedef enum
{
    DIS_DETONATION_RESULT_OTHER                                   = 0,
    DIS_DETONATION_RESULT_ENTITY_IMPACT                           = 1,
    DIS_DETONATION_RESULT_ENTITY_PROXIMATE_DETONATION             = 2,
    DIS_DETONATION_RESULT_GROUND_IMPACT                           = 3,
    DIS_DETONATION_RESULT_GROUND_PROXIMATE_DETONATION             = 4,
    DIS_DETONATION_RESULT_DETONATION                              = 5,
    DIS_DETONATION_RESULT_NONE_DUD                                = 6,
    DIS_DETONATION_RESULT_HE_HIT_SMALL                            = 7,
    DIS_DETONATION_RESULT_HE_HIT_MEDIUM                           = 8,
    DIS_DETONATION_RESULT_HE_HIT_LARGE                            = 9,
    DIS_DETONATION_RESULT_ARMOR_PIERCING_HIT                      = 10,
    DIS_DETONATION_RESULT_DIRT_BLAST_SMALL                        = 11,
    DIS_DETONATION_RESULT_DIRT_BLAST_MEDIUM                       = 12,
    DIS_DETONATION_RESULT_DIRT_BLAST_LARGE                        = 13,
    DIS_DETONATION_RESULT_WATER_BLAST_SMALL                       = 14,
    DIS_DETONATION_RESULT_WATER_BLAST_MEDIUM                      = 15,
    DIS_DETONATION_RESULT_WATER_BLAST_LARGE                       = 16,
    DIS_DETONATION_RESULT_AIR_HIT                                 = 17,
    DIS_DETONATION_RESULT_BUILDING_HIT_SMALL                      = 18,
    DIS_DETONATION_RESULT_BUILDING_HIT_MEDIUM                     = 19,
    DIS_DETONATION_RESULT_BUILDING_HIT_LARGE                      = 20,
    DIS_DETONATION_RESULT_MINE_CLEARING_LINE_CHARGE               = 21,
    DIS_DETONATION_RESULT_ENVIRONMENT_OBJECT_IMPACT               = 22,
    DIS_DETONATION_RESULT_ENVIRONMENT_OBJECT_PROXIMATE_DETONATION = 23,
    DIS_DETONATION_RESULT_WATER_IMPACT                            = 24,
    DIS_DETONATION_RESULT_AIR_BURST                               = 25,
    DIS_DETONATION_RESULT_KILL_WITH_FRAGMENT_TYPE_1               = 26,
    DIS_DETONATION_RESULT_KILL_WITH_FRAGMENT_TYPE_2               = 27,
    DIS_DETONATION_RESULT_KILL_WITH_FRAGMENT_TYPE_3               = 28,
    DIS_DETONATION_RESULT_KILL_WITH_FRAGMENT_TYPE_1_AFTER_FOF     = 29,
    DIS_DETONATION_RESULT_KILL_WITH_FRAGMENT_TYPE_2_AFTER_FOF     = 30,
    DIS_DETONATION_RESULT_MISS_DUE_TO_FOF                         = 31,
    DIS_DETONATION_RESULT_MISS_DUE_TO_ENDGAME_FAILURE             = 32,
    DIS_DETONATION_RESULT_MISS_DUE_TO_FOF_AND_ENDGAME_FAILURE     = 33
} DIS_PDU_DetonationResult;

extern const value_string DIS_PDU_DetonationResult_Strings[];

typedef enum
{
    DIS_CONTROL_ID_OTHER                                   =     0,
    DIS_CONTROL_ID_SHUTDOWN                                =     1,
    DIS_CONTROL_ID_DATA_QUERY                              =     2,
    DIS_CONTROL_ID_DATA                                    =     3,
    DIS_CONTROL_ID_SET_DATA                                =     4,
    DIS_CONTROL_ID_ADD_DATA                                =     5,
    DIS_CONTROL_ID_REMOVE_DATA                             =     6,
    DIS_CONTROL_ID_STATUS                                  =     7
} DIS_PDU_ControlId;

extern const value_string DIS_PDU_ControlId_Strings[];

typedef enum
{
    DIS_FROZEN_BEHAVIOR_RUN_INTERNAL_SIMULATION_CLOCK                = 0,
    DIS_FROZEN_BEHAVIOR_TRANSMIT_PDUS                                = 1,
    DIS_FROZEN_BEHAVIOR_UPDATE_SIM_MODELS_OF_OTHER_ENTITIES          = 2,
    DIS_FROZEN_BEHAVIOR_CONTINUE_TRANSMIT_PDU                        = 3,
    DIS_FROZEN_BEHAVIOR_CEASE_UPDATE_SIM_MODELS_OF_OTHER_ENTITIES    = 4,
    DIS_FROZEN_BEHAVIOR_CONTINUE_UPDATE_SIM_MODELS_OF_OTHER_ENTITIES = 5
} DIS_PDU_FrozenBehavior;

extern const value_string DIS_PDU_FrozenBehavior_Strings[];

typedef enum
{
    DIS_PARAM_TYPE_DESIG_ARTICULATED_PART                        =  0,
    DIS_PARAM_TYPE_DESIG_ATTACHED_PART                           =  1,
    DIS_PARAM_TYPE_DESIG_SEPARATION                              =  2,
    DIS_PARAM_TYPE_DESIG_ENTITY_TYPE                             =  3,
    DIS_PARAM_TYPE_DESIG_ENTITY_ASSOCIATION                      =  4,
    DIS_PARAM_TYPE_DESIG_ANTENNA_LOCATION                        =  5,
    DIS_PARAM_TYPE_DESIG_EXTENDED_PLATFORM_APPEARANCE            = 20,
    DIS_PARAM_TYPE_DESIG_EXTENDED_LIFEFORM_APPEARANCE            = 21,
    DIS_PARAM_TYPE_DESIG_HIGH_FIDELITY_LIGHTS                    = 22,
    DIS_PARAM_TYPE_DESIG_CHEVRON_MARKING                         = 23,
    DIS_PARAM_TYPE_DESIG_HIGH_FIDELITY_THERMAL_SENSOR            = 24,
    DIS_PARAM_TYPE_DESIG_ENTITY_OFFSET                           = 25,
    DIS_PARAM_TYPE_DESIG_DEAD_RECKONING                          = 26,
    DIS_PARAM_TYPE_DESIG_ARMY_TASK_ORGANIZATION                  = 27,
    DIS_PARAM_TYPE_DESIG_HEAD_GAZING_WEAPON_AIMING               = 28,
    DIS_PARAM_TYPE_DESIG_LIFEFORM_ACTION_SEQUENCE                = 29,
    DIS_PARAM_TYPE_DESIG_LEGACY_EXTENDED_LIFEFORM_APPEARANCE     = 30
} DIS_PDU_ParameterTypeDesignator;

extern const value_string DIS_PDU_ParameterTypeDesignator_Strings[];

typedef enum
{
    DIS_REASON_OTHER                                             = 0,
    DIS_REASON_RECESS                                            = 1,
    DIS_REASON_TERMINATION                                       = 2,
    DIS_REASON_SYSTEM_FAILURE                                    = 3,
    DIS_REASON_SECURITY_VIOLATION                                = 4,
    DIS_REASON_ENTITY_RECONSTITUTION                             = 5,
    DIS_REASON_STOP_FOR_RESET                                    = 6,
    DIS_REASON_STOP_FOR_RESTART                                  = 7,
    DIS_REASON_ABORT_TRAINING_RETURN_TO_TACTICAL_OPERATIONS      = 8
} DIS_PDU_Reason;

extern const value_string DIS_PDU_Reason_Strings[];

typedef enum
{
    DIS_REQUEST_STATUS_OTHER                                     =     0,
    DIS_REQUEST_STATUS_PENDING                                   =     1,
    DIS_REQUEST_STATUS_EXECUTING                                 =     2,
    DIS_REQUEST_STATUS_PARTIALLY_COMPLETE                        =     3,
    DIS_REQUEST_STATUS_COMPLETE                                  =     4,
    DIS_REQUEST_STATUS_REQUEST_REJECTED                          =     5,
    DIS_REQUEST_STATUS_RETRANSMIT_REQUEST_NOW                    =     6,
    DIS_REQUEST_STATUS_RETRANSMIT_REQUEST_LATER                  =     7,
    DIS_REQUEST_STATUS_INVALID_TIME_PARAMETERS                   =     8,
    DIS_REQUEST_STATUS_SIMULATION_TIME_EXCEEDED                  =     9,
    DIS_REQUEST_STATUS_REQUEST_DONE                              =    10,
    DIS_REQUEST_STATUS_TACCSF_LOS_REPLY_TYPE_1                   =   100,
    DIS_REQUEST_STATUS_TACCSF_LOS_REPLY_TYPE_2                   =   101,
    DIS_REQUEST_STATUS_JOIN_EXERCISE_REQUEST_REJECTED            =   201
} DIS_PDU_RequestStatus;

extern const value_string DIS_PDU_RequestStatus_Strings[];

typedef enum
{
    DIS_REQUIRED_RELIABILITY_SERVICE_ACKNOWLEDGED      = 0,
    DIS_REQUIRED_RELIABILITY_SERVICE_UNACKNOWLEDGED    = 1
} DIS_PDU_RequiredReliabilityService;

extern const value_string DIS_PDU_RequiredReliabilityService_Strings[];

typedef enum
{
    DIS_RESPONSE_FLAG_OTHER                            = 0,
    DIS_RESPONSE_FLAG_ABLE_TO_COMPLY                   = 1,
    DIS_RESPONSE_FLAG_UNABLE_TO_COMPLY                 = 2,
    DIS_RESPONSE_FLAG_PENDING_OPERATOR_ACTION          = 3
} DIS_PDU_DisResponseFlag;

extern const value_string DIS_PDU_DisResponseFlag_Strings[];

typedef enum
{
    DIS_PERSISTENT_OBJECT_TYPE_OTHER               = 0,
    DIS_PERSISTENT_OBJECT_TYPE_SIMULATOR_PRESENT   = 1,
    DIS_PERSISTENT_OBJECT_TYPE_DESCRIBE_OBJECT     = 2,
    DIS_PERSISTENT_OBJECT_TYPE_OBJECTS_PRESENT     = 3,
    DIS_PERSISTENT_OBJECT_TYPE_OBJECT_REQUEST      = 4,
    DIS_PERSISTENT_OBJECT_TYPE_DELETE_OBJECTS      = 5,
    DIS_PERSISTENT_OBJECT_TYPE_SET_WORLD_STATE     = 6,
    DIS_PERSISTENT_OBJECT_TYPE_NOMINATION          = 7
} DIS_PDU_PersistentObjectType;

extern const value_string DIS_PDU_PersistentObjectType_Strings[];

typedef enum
{
    DIS_PO_OBJECT_CLASS_OTHER                      =  0,
    DIS_PO_OBJECT_CLASS_WORLD_STATE                =  1,
    DIS_PO_OBJECT_CLASS_OVERLAY                    =  2,
    DIS_PO_OBJECT_CLASS_POINT                      =  3,
    DIS_PO_OBJECT_CLASS_LINE                       =  4,
    DIS_PO_OBJECT_CLASS_SECTOR                     =  5,
    DIS_PO_OBJECT_CLASS_TEXT                       =  6,
    DIS_PO_OBJECT_CLASS_UNIT                       =  7,
    DIS_PO_OBJECT_CLASS_UNIT_DEFINITION            =  8,
    DIS_PO_OBJECT_CLASS_STEALTH_CONTROLLER         =  9,
    DIS_PO_OBJECT_CLASS_H_HOUR                     = 10,
    DIS_PO_OBJECT_CLASS_VARIABLE                   = 11,
    DIS_PO_OBJECT_CLASS_TASK                       = 12,
    DIS_PO_OBJECT_CLASS_TASK_STATE                 = 13,
    DIS_PO_OBJECT_CLASS_TASK_FRAME                 = 14,
    DIS_PO_OBJECT_CLASS_TASK_AUTHORIZATION         = 15,
    DIS_PO_OBJECT_CLASS_PARAMETRIC_INPUT           = 16,
    DIS_PO_OBJECT_CLASS_PARAMETRIC_INPUT_HOLDER    = 17,
    DIS_PO_OBJECT_CLASS_EXERCISE_INITIALIZER       = 18,
    DIS_PO_OBJECT_CLASS_FIRE_PARAMETERS            = 19,
    DIS_PO_OBJECT_CLASS_MINEFIELD                  = 20,
    DIS_PO_OBJECT_CLASS_SIMULATION_REQUEST         = 21,
    DIS_PO_OBJECT_CLASS_NET_SUBSCRIPTION           = 22,
    DIS_PO_OBJECT_CLASS_LINK                       = 23,
    DIS_PO_OBJECT_CLASS_MINEFIELD_PARENT           = 24,
    DIS_PO_OBJECT_CLASS_CHEMICAL                   = 25,
    DIS_PO_OBJECT_CLASS_AlertUser                  = 26,
    DIS_PO_OBJECT_CLASS_HAND_OFF                   = 27,
    DIS_PO_OBJECT_CLASS_CIRCUIT                    = 28,
    DIS_PO_OBJECT_CLASS_CARGO                      = 29,
    DIS_PO_OBJECT_CLASS_MCM_ROUTE                  = 30,
    DIS_PO_OBJECT_CLASS_MESSAGE                    = 31
} DIS_PDU_PO_ObjectClass;

extern const value_string DIS_PDU_PO_ObjectClass_Strings[];

typedef enum
{
    DIS_EMITTER_NAME_10 = 10,
    DIS_EMITTER_NAME_45 = 45,
    DIS_EMITTER_NAME_80 = 80,
    DIS_EMITTER_NAME_90 = 90,
    DIS_EMITTER_NAME_135 = 135,
    DIS_EMITTER_NAME_180 = 180,
    DIS_EMITTER_NAME_225 = 225,
    DIS_EMITTER_NAME_270 = 270,
    DIS_EMITTER_NAME_315 = 315,
    DIS_EMITTER_NAME_360 = 360,
    DIS_EMITTER_NAME_405 = 405,
    DIS_EMITTER_NAME_450 = 450,
    DIS_EMITTER_NAME_495 = 495,
    DIS_EMITTER_NAME_540 = 540,
    DIS_EMITTER_NAME_585 = 585,
    DIS_EMITTER_NAME_630 = 630,
    DIS_EMITTER_NAME_675 = 675,
    DIS_EMITTER_NAME_720 = 720,
    DIS_EMITTER_NAME_765 = 765,
    DIS_EMITTER_NAME_810 = 810,
    DIS_EMITTER_NAME_855 = 855,
    DIS_EMITTER_NAME_900 = 900,
    DIS_EMITTER_NAME_945 = 945,
    DIS_EMITTER_NAME_990 = 990,
    DIS_EMITTER_NAME_1035 = 1035,
    DIS_EMITTER_NAME_1080 = 1080,
    DIS_EMITTER_NAME_1095 = 1095,
    DIS_EMITTER_NAME_1100 = 1100,
    DIS_EMITTER_NAME_1125 = 1125,
    DIS_EMITTER_NAME_1170 = 1170,
    DIS_EMITTER_NAME_1215 = 1215,
    DIS_EMITTER_NAME_1260 = 1260,
    DIS_EMITTER_NAME_1280 = 1280,
    DIS_EMITTER_NAME_1282 = 1282,
    DIS_EMITTER_NAME_1305 = 1305,
    DIS_EMITTER_NAME_1350 = 1350,
    DIS_EMITTER_NAME_1395 = 1395,
    DIS_EMITTER_NAME_1400 = 1400,
    DIS_EMITTER_NAME_1440 = 1440,
    DIS_EMITTER_NAME_1485 = 1485,
    DIS_EMITTER_NAME_1530 = 1530,
    DIS_EMITTER_NAME_1575 = 1575,
    DIS_EMITTER_NAME_1585 = 1585,
    DIS_EMITTER_NAME_1620 = 1620,
    DIS_EMITTER_NAME_1626 = 1626,
    DIS_EMITTER_NAME_1628 = 1628,
    DIS_EMITTER_NAME_1630 = 1630,
    DIS_EMITTER_NAME_1632 = 1632,
    DIS_EMITTER_NAME_1634 = 1634,
    DIS_EMITTER_NAME_1636 = 1636,
    DIS_EMITTER_NAME_1638 = 1638,
    DIS_EMITTER_NAME_1640 = 1640,
    DIS_EMITTER_NAME_1642 = 1642,
    DIS_EMITTER_NAME_1644 = 1644,
    DIS_EMITTER_NAME_1646 = 1646,
    DIS_EMITTER_NAME_1648 = 1648,
    DIS_EMITTER_NAME_1650 = 1650,
    DIS_EMITTER_NAME_1652 = 1652,
    DIS_EMITTER_NAME_1654 = 1654,
    DIS_EMITTER_NAME_1656 = 1656,
    DIS_EMITTER_NAME_1658 = 1658,
    DIS_EMITTER_NAME_1660 = 1660,
    DIS_EMITTER_NAME_1665 = 1665,
    DIS_EMITTER_NAME_1710 = 1710,
    DIS_EMITTER_NAME_1755 = 1755,
    DIS_EMITTER_NAME_1800 = 1800,
    DIS_EMITTER_NAME_1805 = 1805,
    DIS_EMITTER_NAME_1807 = 1807,
    DIS_EMITTER_NAME_1809 = 1809,
    DIS_EMITTER_NAME_1845 = 1845,
    DIS_EMITTER_NAME_1870 = 1870,
    DIS_EMITTER_NAME_1890 = 1890,
    DIS_EMITTER_NAME_1935 = 1935,
    DIS_EMITTER_NAME_1945 = 1945,
    DIS_EMITTER_NAME_1960 = 1960,
    DIS_EMITTER_NAME_1970 = 1970,
    DIS_EMITTER_NAME_1980 = 1980,
    DIS_EMITTER_NAME_2025 = 2025,
    DIS_EMITTER_NAME_2070 = 2070,
    DIS_EMITTER_NAME_2115 = 2115,
    DIS_EMITTER_NAME_2160 = 2160,
    DIS_EMITTER_NAME_2205 = 2205,
    DIS_EMITTER_NAME_2250 = 2250,
    DIS_EMITTER_NAME_2295 = 2295,
    DIS_EMITTER_NAME_2340 = 2340,
    DIS_EMITTER_NAME_2385 = 2385,
    DIS_EMITTER_NAME_2430 = 2430,
    DIS_EMITTER_NAME_2475 = 2475,
    DIS_EMITTER_NAME_2520 = 2520,
    DIS_EMITTER_NAME_2565 = 2565,
    DIS_EMITTER_NAME_2610 = 2610,
    DIS_EMITTER_NAME_2655 = 2655,
    DIS_EMITTER_NAME_2700 = 2700,
    DIS_EMITTER_NAME_2745 = 2745,
    DIS_EMITTER_NAME_2790 = 2790,
    DIS_EMITTER_NAME_2835 = 2835,
    DIS_EMITTER_NAME_2880 = 2880,
    DIS_EMITTER_NAME_2925 = 2925,
    DIS_EMITTER_NAME_2970 = 2970,
    DIS_EMITTER_NAME_3015 = 3015,
    DIS_EMITTER_NAME_3060 = 3060,
    DIS_EMITTER_NAME_3105 = 3105,
    DIS_EMITTER_NAME_3150 = 3150,
    DIS_EMITTER_NAME_3152 = 3152,
    DIS_EMITTER_NAME_3160 = 3160,
    DIS_EMITTER_NAME_3162 = 3162,
    DIS_EMITTER_NAME_3164 = 3164,
    DIS_EMITTER_NAME_3166 = 3166,
    DIS_EMITTER_NAME_3195 = 3195,
    DIS_EMITTER_NAME_3240 = 3240,
    DIS_EMITTER_NAME_3285 = 3285,
    DIS_EMITTER_NAME_3330 = 3330,
    DIS_EMITTER_NAME_3375 = 3375,
    DIS_EMITTER_NAME_3420 = 3420,
    DIS_EMITTER_NAME_3465 = 3465,
    DIS_EMITTER_NAME_3510 = 3510,
    DIS_EMITTER_NAME_3555 = 3555,
    DIS_EMITTER_NAME_3600 = 3600,
    DIS_EMITTER_NAME_3645 = 3645,
    DIS_EMITTER_NAME_3690 = 3690,
    DIS_EMITTER_NAME_3735 = 3735,
    DIS_EMITTER_NAME_3780 = 3780,
    DIS_EMITTER_NAME_3785 = 3785,
    DIS_EMITTER_NAME_3788 = 3788,
    DIS_EMITTER_NAME_3795 = 3795,
    DIS_EMITTER_NAME_3820 = 3820,
    DIS_EMITTER_NAME_3825 = 3825,
    DIS_EMITTER_NAME_3870 = 3870,
    DIS_EMITTER_NAME_3915 = 3915,
    DIS_EMITTER_NAME_3960 = 3960,
    DIS_EMITTER_NAME_4005 = 4005,
    DIS_EMITTER_NAME_4050 = 4050,
    DIS_EMITTER_NAME_4095 = 4095,
    DIS_EMITTER_NAME_4140 = 4140,
    DIS_EMITTER_NAME_4185 = 4185,
    DIS_EMITTER_NAME_4230 = 4230,
    DIS_EMITTER_NAME_4275 = 4275,
    DIS_EMITTER_NAME_4320 = 4320,
    DIS_EMITTER_NAME_4365 = 4365,
    DIS_EMITTER_NAME_4410 = 4410,
    DIS_EMITTER_NAME_4455 = 4455,
    DIS_EMITTER_NAME_4465 = 4465,
    DIS_EMITTER_NAME_4500 = 4500,
    DIS_EMITTER_NAME_4545 = 4545,
    DIS_EMITTER_NAME_4590 = 4590,
    DIS_EMITTER_NAME_4635 = 4635,
    DIS_EMITTER_NAME_4680 = 4680,
    DIS_EMITTER_NAME_4725 = 4725,
    DIS_EMITTER_NAME_4770 = 4770,
    DIS_EMITTER_NAME_4815 = 4815,
    DIS_EMITTER_NAME_4860 = 4860,
    DIS_EMITTER_NAME_4870 = 4870,
    DIS_EMITTER_NAME_4900 = 4900,
    DIS_EMITTER_NAME_4905 = 4905,
    DIS_EMITTER_NAME_4950 = 4950,
    DIS_EMITTER_NAME_4953 = 4953,
    DIS_EMITTER_NAME_4995 = 4995,
    DIS_EMITTER_NAME_5040 = 5040,
    DIS_EMITTER_NAME_5085 = 5085,
    DIS_EMITTER_NAME_5130 = 5130,
    DIS_EMITTER_NAME_5175 = 5175,
    DIS_EMITTER_NAME_5220 = 5220,
    DIS_EMITTER_NAME_5265 = 5265,
    DIS_EMITTER_NAME_5280 = 5280,
    DIS_EMITTER_NAME_5310 = 5310,
    DIS_EMITTER_NAME_5355 = 5355,
    DIS_EMITTER_NAME_5400 = 5400,
    DIS_EMITTER_NAME_5405 = 5405,
    DIS_EMITTER_NAME_5420 = 5420,
    DIS_EMITTER_NAME_5430 = 5430,
    DIS_EMITTER_NAME_5445 = 5445,
    DIS_EMITTER_NAME_5490 = 5490,
    DIS_EMITTER_NAME_5495 = 5495,
    DIS_EMITTER_NAME_5500 = 5500,
    DIS_EMITTER_NAME_5505 = 5505,
    DIS_EMITTER_NAME_5507 = 5507,
    DIS_EMITTER_NAME_5508 = 5508,
    DIS_EMITTER_NAME_5510 = 5510,
    DIS_EMITTER_NAME_5515 = 5515,
    DIS_EMITTER_NAME_5520 = 5520,
    DIS_EMITTER_NAME_5525 = 5525,
    DIS_EMITTER_NAME_5527 = 5527,
    DIS_EMITTER_NAME_5530 = 5530,
    DIS_EMITTER_NAME_5535 = 5535,
    DIS_EMITTER_NAME_5537 = 5537,
    DIS_EMITTER_NAME_5540 = 5540,
    DIS_EMITTER_NAME_5545 = 5545,
    DIS_EMITTER_NAME_5550 = 5550,
    DIS_EMITTER_NAME_5551 = 5551,
    DIS_EMITTER_NAME_5555 = 5555,
    DIS_EMITTER_NAME_5560 = 5560,
    DIS_EMITTER_NAME_5570 = 5570,
    DIS_EMITTER_NAME_5571 = 5571,
    DIS_EMITTER_NAME_5575 = 5575,
    DIS_EMITTER_NAME_5580 = 5580,
    DIS_EMITTER_NAME_5625 = 5625,
    DIS_EMITTER_NAME_5670 = 5670,
    DIS_EMITTER_NAME_5715 = 5715,
    DIS_EMITTER_NAME_5760 = 5760,
    DIS_EMITTER_NAME_5805 = 5805,
    DIS_EMITTER_NAME_5850 = 5850,
    DIS_EMITTER_NAME_5895 = 5895,
    DIS_EMITTER_NAME_5940 = 5940,
    DIS_EMITTER_NAME_5985 = 5985,
    DIS_EMITTER_NAME_6030 = 6030,
    DIS_EMITTER_NAME_6075 = 6075,
    DIS_EMITTER_NAME_6120 = 6120,
    DIS_EMITTER_NAME_6165 = 6165,
    DIS_EMITTER_NAME_6210 = 6210,
    DIS_EMITTER_NAME_6255 = 6255,
    DIS_EMITTER_NAME_6300 = 6300,
    DIS_EMITTER_NAME_6345 = 6345,
    DIS_EMITTER_NAME_6390 = 6390,
    DIS_EMITTER_NAME_6435 = 6435,
    DIS_EMITTER_NAME_6480 = 6480,
    DIS_EMITTER_NAME_6525 = 6525,
    DIS_EMITTER_NAME_6570 = 6570,
    DIS_EMITTER_NAME_6615 = 6615,
    DIS_EMITTER_NAME_6660 = 6660,
    DIS_EMITTER_NAME_6705 = 6705,
    DIS_EMITTER_NAME_6750 = 6750,
    DIS_EMITTER_NAME_6752 = 6752,
    DIS_EMITTER_NAME_6795 = 6795,
    DIS_EMITTER_NAME_6796 = 6796,
    DIS_EMITTER_NAME_6797 = 6797,
    DIS_EMITTER_NAME_6798 = 6798,
    DIS_EMITTER_NAME_6799 = 6799,
    DIS_EMITTER_NAME_6800 = 6800,
    DIS_EMITTER_NAME_6801 = 6801,
    DIS_EMITTER_NAME_6802 = 6802,
    DIS_EMITTER_NAME_6803 = 6803,
    DIS_EMITTER_NAME_6804 = 6804,
    DIS_EMITTER_NAME_6840 = 6840,
    DIS_EMITTER_NAME_6885 = 6885,
    DIS_EMITTER_NAME_6930 = 6930,
    DIS_EMITTER_NAME_6975 = 6975,
    DIS_EMITTER_NAME_7020 = 7020,
    DIS_EMITTER_NAME_7065 = 7065,
    DIS_EMITTER_NAME_7110 = 7110,
    DIS_EMITTER_NAME_7155 = 7155,
    DIS_EMITTER_NAME_7200 = 7200,
    DIS_EMITTER_NAME_7245 = 7245,
    DIS_EMITTER_NAME_7250 = 7250,
    DIS_EMITTER_NAME_7252 = 7252,
    DIS_EMITTER_NAME_7253 = 7253,
    DIS_EMITTER_NAME_7260 = 7260,
    DIS_EMITTER_NAME_7261 = 7261,
    DIS_EMITTER_NAME_7265 = 7265,
    DIS_EMITTER_NAME_7270 = 7270,
    DIS_EMITTER_NAME_7275 = 7275,
    DIS_EMITTER_NAME_7280 = 7280,
    DIS_EMITTER_NAME_7295 = 7295,
    DIS_EMITTER_NAME_7300 = 7300,
    DIS_EMITTER_NAME_7301 = 7301,
    DIS_EMITTER_NAME_7303 = 7303,
    DIS_EMITTER_NAME_7305 = 7305,
    DIS_EMITTER_NAME_7310 = 7310,
    DIS_EMITTER_NAME_7315 = 7315,
    DIS_EMITTER_NAME_7320 = 7320,
    DIS_EMITTER_NAME_7322 = 7322,
    DIS_EMITTER_NAME_7325 = 7325,
    DIS_EMITTER_NAME_7330 = 7330,
    DIS_EMITTER_NAME_7335 = 7335,
    DIS_EMITTER_NAME_7380 = 7380,
    DIS_EMITTER_NAME_7425 = 7425,
    DIS_EMITTER_NAME_7426 = 7426,
    DIS_EMITTER_NAME_7470 = 7470,
    DIS_EMITTER_NAME_7515 = 7515,
    DIS_EMITTER_NAME_7560 = 7560,
    DIS_EMITTER_NAME_7605 = 7605,
    DIS_EMITTER_NAME_7650 = 7650,
    DIS_EMITTER_NAME_7695 = 7695,
    DIS_EMITTER_NAME_7740 = 7740,
    DIS_EMITTER_NAME_7785 = 7785,
    DIS_EMITTER_NAME_7830 = 7830,
    DIS_EMITTER_NAME_7875 = 7875,
    DIS_EMITTER_NAME_7920 = 7920,
    DIS_EMITTER_NAME_7965 = 7965,
    DIS_EMITTER_NAME_8010 = 8010,
    DIS_EMITTER_NAME_8055 = 8055,
    DIS_EMITTER_NAME_8100 = 8100,
    DIS_EMITTER_NAME_8105 = 8105,
    DIS_EMITTER_NAME_8112 = 8112,
    DIS_EMITTER_NAME_8115 = 8115,
    DIS_EMITTER_NAME_8120 = 8120,
    DIS_EMITTER_NAME_8145 = 8145,
    DIS_EMITTER_NAME_8190 = 8190,
    DIS_EMITTER_NAME_8235 = 8235,
    DIS_EMITTER_NAME_8280 = 8280,
    DIS_EMITTER_NAME_8325 = 8325,
    DIS_EMITTER_NAME_8370 = 8370,
    DIS_EMITTER_NAME_8375 = 8375,
    DIS_EMITTER_NAME_8380 = 8380,
    DIS_EMITTER_NAME_8390 = 8390,
    DIS_EMITTER_NAME_8415 = 8415,
    DIS_EMITTER_NAME_8460 = 8460,
    DIS_EMITTER_NAME_8505 = 8505,
    DIS_EMITTER_NAME_8550 = 8550,
    DIS_EMITTER_NAME_8595 = 8595,
    DIS_EMITTER_NAME_8640 = 8640,
    DIS_EMITTER_NAME_8685 = 8685,
    DIS_EMITTER_NAME_8730 = 8730,
    DIS_EMITTER_NAME_8735 = 8735,
    DIS_EMITTER_NAME_8760 = 8760,
    DIS_EMITTER_NAME_8772 = 8772,
    DIS_EMITTER_NAME_8775 = 8775,
    DIS_EMITTER_NAME_8780 = 8780,
    DIS_EMITTER_NAME_8782 = 8782,
    DIS_EMITTER_NAME_8785 = 8785,
    DIS_EMITTER_NAME_8790 = 8790,
    DIS_EMITTER_NAME_8812 = 8812,
    DIS_EMITTER_NAME_8820 = 8820,
    DIS_EMITTER_NAME_8840 = 8840,
    DIS_EMITTER_NAME_8845 = 8845,
    DIS_EMITTER_NAME_8865 = 8865,
    DIS_EMITTER_NAME_8870 = 8870,
    DIS_EMITTER_NAME_8910 = 8910,
    DIS_EMITTER_NAME_8955 = 8955,
    DIS_EMITTER_NAME_9000 = 9000,
    DIS_EMITTER_NAME_9045 = 9045,
    DIS_EMITTER_NAME_9075 = 9075,
    DIS_EMITTER_NAME_9090 = 9090,
    DIS_EMITTER_NAME_9135 = 9135,
    DIS_EMITTER_NAME_9180 = 9180,
    DIS_EMITTER_NAME_9200 = 9200,
    DIS_EMITTER_NAME_9205 = 9205,
    DIS_EMITTER_NAME_9225 = 9225,
    DIS_EMITTER_NAME_9270 = 9270,
    DIS_EMITTER_NAME_9310 = 9310,
    DIS_EMITTER_NAME_9315 = 9315,
    DIS_EMITTER_NAME_9360 = 9360,
    DIS_EMITTER_NAME_9405 = 9405,
    DIS_EMITTER_NAME_9450 = 9450,
    DIS_EMITTER_NAME_9495 = 9495,
    DIS_EMITTER_NAME_9540 = 9540,
    DIS_EMITTER_NAME_9585 = 9585,
    DIS_EMITTER_NAME_9630 = 9630,
    DIS_EMITTER_NAME_9640 = 9640,
    DIS_EMITTER_NAME_9642 = 9642,
    DIS_EMITTER_NAME_9645 = 9645,
    DIS_EMITTER_NAME_9660 = 9660,
    DIS_EMITTER_NAME_9675 = 9675,
    DIS_EMITTER_NAME_9720 = 9720,
    DIS_EMITTER_NAME_9765 = 9765,
    DIS_EMITTER_NAME_9780 = 9780,
    DIS_EMITTER_NAME_9810 = 9810,
    DIS_EMITTER_NAME_9855 = 9855,
    DIS_EMITTER_NAME_9885 = 9885,
    DIS_EMITTER_NAME_9900 = 9900,
    DIS_EMITTER_NAME_9905 = 9905,
    DIS_EMITTER_NAME_9930 = 9930,
    DIS_EMITTER_NAME_9935 = 9935,
    DIS_EMITTER_NAME_9945 = 9945,
    DIS_EMITTER_NAME_9990 = 9990,
    DIS_EMITTER_NAME_10035 = 10035,
    DIS_EMITTER_NAME_10080 = 10080,
    DIS_EMITTER_NAME_10125 = 10125,
    DIS_EMITTER_NAME_10170 = 10170,
    DIS_EMITTER_NAME_10215 = 10215,
    DIS_EMITTER_NAME_10260 = 10260,
    DIS_EMITTER_NAME_10305 = 10305,
    DIS_EMITTER_NAME_10350 = 10350,
    DIS_EMITTER_NAME_10395 = 10395,
    DIS_EMITTER_NAME_10440 = 10440,
    DIS_EMITTER_NAME_10485 = 10485,
    DIS_EMITTER_NAME_10510 = 10510,
    DIS_EMITTER_NAME_10530 = 10530,
    DIS_EMITTER_NAME_10575 = 10575,
    DIS_EMITTER_NAME_10620 = 10620,
    DIS_EMITTER_NAME_10665 = 10665,
    DIS_EMITTER_NAME_10710 = 10710,
    DIS_EMITTER_NAME_10755 = 10755,
    DIS_EMITTER_NAME_10800 = 10800,
    DIS_EMITTER_NAME_10845 = 10845,
    DIS_EMITTER_NAME_10890 = 10890,
    DIS_EMITTER_NAME_10895 = 10895,
    DIS_EMITTER_NAME_10935 = 10935,
    DIS_EMITTER_NAME_10940 = 10940,
    DIS_EMITTER_NAME_10980 = 10980,
    DIS_EMITTER_NAME_10985 = 10985,
    DIS_EMITTER_NAME_11000 = 11000,
    DIS_EMITTER_NAME_11010 = 11010,
    DIS_EMITTER_NAME_11025 = 11025,
    DIS_EMITTER_NAME_11070 = 11070,
    DIS_EMITTER_NAME_11115 = 11115,
    DIS_EMITTER_NAME_11160 = 11160,
    DIS_EMITTER_NAME_11205 = 11205,
    DIS_EMITTER_NAME_11250 = 11250,
    DIS_EMITTER_NAME_11260 = 11260,
    DIS_EMITTER_NAME_11270 = 11270,
    DIS_EMITTER_NAME_11295 = 11295,
    DIS_EMITTER_NAME_11340 = 11340,
    DIS_EMITTER_NAME_11385 = 11385,
    DIS_EMITTER_NAME_11430 = 11430,
    DIS_EMITTER_NAME_11475 = 11475,
    DIS_EMITTER_NAME_11520 = 11520,
    DIS_EMITTER_NAME_11565 = 11565,
    DIS_EMITTER_NAME_11610 = 11610,
    DIS_EMITTER_NAME_11655 = 11655,
    DIS_EMITTER_NAME_11660 = 11660,
    DIS_EMITTER_NAME_11665 = 11665,
    DIS_EMITTER_NAME_11700 = 11700,
    DIS_EMITTER_NAME_11745 = 11745,
    DIS_EMITTER_NAME_11790 = 11790,
    DIS_EMITTER_NAME_11835 = 11835,
    DIS_EMITTER_NAME_11880 = 11880,
    DIS_EMITTER_NAME_11925 = 11925,
    DIS_EMITTER_NAME_11970 = 11970,
    DIS_EMITTER_NAME_11975 = 11975,
    DIS_EMITTER_NAME_12010 = 12010,
    DIS_EMITTER_NAME_12015 = 12015,
    DIS_EMITTER_NAME_12060 = 12060,
    DIS_EMITTER_NAME_12105 = 12105,
    DIS_EMITTER_NAME_12110 = 12110,
    DIS_EMITTER_NAME_12111 = 12111,
    DIS_EMITTER_NAME_12150 = 12150,
    DIS_EMITTER_NAME_12195 = 12195,
    DIS_EMITTER_NAME_12240 = 12240,
    DIS_EMITTER_NAME_12285 = 12285,
    DIS_EMITTER_NAME_12292 = 12292,
    DIS_EMITTER_NAME_12330 = 12330,
    DIS_EMITTER_NAME_12375 = 12375,
    DIS_EMITTER_NAME_12420 = 12420,
    DIS_EMITTER_NAME_12430 = 12430,
    DIS_EMITTER_NAME_12465 = 12465,
    DIS_EMITTER_NAME_12510 = 12510,
    DIS_EMITTER_NAME_12555 = 12555,
    DIS_EMITTER_NAME_12600 = 12600,
    DIS_EMITTER_NAME_12610 = 12610,
    DIS_EMITTER_NAME_12645 = 12645,
    DIS_EMITTER_NAME_12690 = 12690,
    DIS_EMITTER_NAME_12735 = 12735,
    DIS_EMITTER_NAME_12780 = 12780,
    DIS_EMITTER_NAME_12782 = 12782,
    DIS_EMITTER_NAME_12785 = 12785,
    DIS_EMITTER_NAME_12787 = 12787,
    DIS_EMITTER_NAME_12800 = 12800,
    DIS_EMITTER_NAME_12805 = 12805,
    DIS_EMITTER_NAME_12825 = 12825,
    DIS_EMITTER_NAME_12870 = 12870,
    DIS_EMITTER_NAME_12915 = 12915,
    DIS_EMITTER_NAME_12960 = 12960,
    DIS_EMITTER_NAME_13005 = 13005,
    DIS_EMITTER_NAME_13050 = 13050,
    DIS_EMITTER_NAME_13055 = 13055,
    DIS_EMITTER_NAME_13095 = 13095,
    DIS_EMITTER_NAME_13140 = 13140,
    DIS_EMITTER_NAME_13185 = 13185,
    DIS_EMITTER_NAME_13230 = 13230,
    DIS_EMITTER_NAME_13275 = 13275,
    DIS_EMITTER_NAME_13320 = 13320,
    DIS_EMITTER_NAME_13365 = 13365,
    DIS_EMITTER_NAME_13410 = 13410,
    DIS_EMITTER_NAME_13455 = 13455,
    DIS_EMITTER_NAME_13500 = 13500,
    DIS_EMITTER_NAME_13545 = 13545,
    DIS_EMITTER_NAME_13590 = 13590,
    DIS_EMITTER_NAME_13635 = 13635,
    DIS_EMITTER_NAME_13680 = 13680,
    DIS_EMITTER_NAME_13725 = 13725,
    DIS_EMITTER_NAME_13770 = 13770,
    DIS_EMITTER_NAME_13815 = 13815,
    DIS_EMITTER_NAME_13860 = 13860,
    DIS_EMITTER_NAME_13905 = 13905,
    DIS_EMITTER_NAME_13950 = 13950,
    DIS_EMITTER_NAME_13995 = 13995,
    DIS_EMITTER_NAME_14040 = 14040,
    DIS_EMITTER_NAME_14085 = 14085,
    DIS_EMITTER_NAME_14130 = 14130,
    DIS_EMITTER_NAME_14175 = 14175,
    DIS_EMITTER_NAME_14220 = 14220,
    DIS_EMITTER_NAME_14265 = 14265,
    DIS_EMITTER_NAME_14310 = 14310,
    DIS_EMITTER_NAME_14355 = 14355,
    DIS_EMITTER_NAME_14400 = 14400,
    DIS_EMITTER_NAME_14445 = 14445,
    DIS_EMITTER_NAME_14490 = 14490,
    DIS_EMITTER_NAME_14535 = 14535,
    DIS_EMITTER_NAME_14545 = 14545,
    DIS_EMITTER_NAME_14580 = 14580,
    DIS_EMITTER_NAME_14600 = 14600,
    DIS_EMITTER_NAME_14625 = 14625,
    DIS_EMITTER_NAME_14670 = 14670,
    DIS_EMITTER_NAME_14715 = 14715,
    DIS_EMITTER_NAME_14760 = 14760,
    DIS_EMITTER_NAME_14770 = 14770,
    DIS_EMITTER_NAME_14805 = 14805,
    DIS_EMITTER_NAME_14810 = 14810,
    DIS_EMITTER_NAME_14850 = 14850,
    DIS_EMITTER_NAME_14895 = 14895,
    DIS_EMITTER_NAME_14940 = 14940,
    DIS_EMITTER_NAME_14985 = 14985,
    DIS_EMITTER_NAME_15030 = 15030,
    DIS_EMITTER_NAME_15075 = 15075,
    DIS_EMITTER_NAME_15120 = 15120,
    DIS_EMITTER_NAME_15140 = 15140,
    DIS_EMITTER_NAME_15160 = 15160,
    DIS_EMITTER_NAME_15165 = 15165,
    DIS_EMITTER_NAME_15200 = 15200,
    DIS_EMITTER_NAME_15210 = 15210,
    DIS_EMITTER_NAME_15220 = 15220,
    DIS_EMITTER_NAME_15230 = 15230,
    DIS_EMITTER_NAME_15240 = 15240,
    DIS_EMITTER_NAME_15255 = 15255,
    DIS_EMITTER_NAME_15300 = 15300,
    DIS_EMITTER_NAME_15310 = 15310,
    DIS_EMITTER_NAME_15345 = 15345,
    DIS_EMITTER_NAME_15390 = 15390,
    DIS_EMITTER_NAME_15435 = 15435,
    DIS_EMITTER_NAME_15470 = 15470,
    DIS_EMITTER_NAME_15475 = 15475,
    DIS_EMITTER_NAME_15480 = 15480,
    DIS_EMITTER_NAME_15525 = 15525,
    DIS_EMITTER_NAME_15570 = 15570,
    DIS_EMITTER_NAME_15615 = 15615,
    DIS_EMITTER_NAME_15660 = 15660,
    DIS_EMITTER_NAME_15705 = 15705,
    DIS_EMITTER_NAME_15750 = 15750,
    DIS_EMITTER_NAME_15795 = 15795,
    DIS_EMITTER_NAME_15840 = 15840,
    DIS_EMITTER_NAME_15885 = 15885,
    DIS_EMITTER_NAME_15930 = 15930,
    DIS_EMITTER_NAME_15975 = 15975,
    DIS_EMITTER_NAME_16020 = 16020,
    DIS_EMITTER_NAME_16030 = 16030,
    DIS_EMITTER_NAME_16065 = 16065,
    DIS_EMITTER_NAME_16110 = 16110,
    DIS_EMITTER_NAME_16155 = 16155,
    DIS_EMITTER_NAME_16200 = 16200,
    DIS_EMITTER_NAME_16245 = 16245,
    DIS_EMITTER_NAME_16290 = 16290,
    DIS_EMITTER_NAME_16335 = 16335,
    DIS_EMITTER_NAME_16380 = 16380,
    DIS_EMITTER_NAME_16390 = 16390,
    DIS_EMITTER_NAME_16400 = 16400,
    DIS_EMITTER_NAME_16410 = 16410,
    DIS_EMITTER_NAME_16420 = 16420,
    DIS_EMITTER_NAME_16421 = 16421,
    DIS_EMITTER_NAME_16425 = 16425,
    DIS_EMITTER_NAME_16470 = 16470,
    DIS_EMITTER_NAME_16515 = 16515,
    DIS_EMITTER_NAME_16560 = 16560,
    DIS_EMITTER_NAME_16561 = 16561,
    DIS_EMITTER_NAME_16605 = 16605,
    DIS_EMITTER_NAME_16650 = 16650,
    DIS_EMITTER_NAME_16695 = 16695,
    DIS_EMITTER_NAME_16740 = 16740,
    DIS_EMITTER_NAME_16785 = 16785,
    DIS_EMITTER_NAME_16830 = 16830,
    DIS_EMITTER_NAME_16875 = 16875,
    DIS_EMITTER_NAME_16880 = 16880,
    DIS_EMITTER_NAME_16884 = 16884,
    DIS_EMITTER_NAME_16888 = 16888,
    DIS_EMITTER_NAME_16900 = 16900,
    DIS_EMITTER_NAME_16915 = 16915,
    DIS_EMITTER_NAME_16920 = 16920,
    DIS_EMITTER_NAME_16925 = 16925,
    DIS_EMITTER_NAME_16945 = 16945,
    DIS_EMITTER_NAME_16950 = 16950,
    DIS_EMITTER_NAME_16965 = 16965,
    DIS_EMITTER_NAME_17010 = 17010,
    DIS_EMITTER_NAME_17025 = 17025,
    DIS_EMITTER_NAME_17055 = 17055,
    DIS_EMITTER_NAME_17070 = 17070,
    DIS_EMITTER_NAME_17100 = 17100,
    DIS_EMITTER_NAME_17145 = 17145,
    DIS_EMITTER_NAME_17190 = 17190,
    DIS_EMITTER_NAME_17220 = 17220,
    DIS_EMITTER_NAME_17235 = 17235,
    DIS_EMITTER_NAME_17280 = 17280,
    DIS_EMITTER_NAME_17325 = 17325,
    DIS_EMITTER_NAME_17370 = 17370,
    DIS_EMITTER_NAME_17415 = 17415,
    DIS_EMITTER_NAME_17460 = 17460,
    DIS_EMITTER_NAME_17505 = 17505,
    DIS_EMITTER_NAME_17550 = 17550,
    DIS_EMITTER_NAME_17595 = 17595,
    DIS_EMITTER_NAME_17640 = 17640,
    DIS_EMITTER_NAME_17685 = 17685,
    DIS_EMITTER_NAME_17730 = 17730,
    DIS_EMITTER_NAME_17775 = 17775,
    DIS_EMITTER_NAME_17820 = 17820,
    DIS_EMITTER_NAME_17865 = 17865,
    DIS_EMITTER_NAME_17910 = 17910,
    DIS_EMITTER_NAME_17955 = 17955,
    DIS_EMITTER_NAME_18000 = 18000,
    DIS_EMITTER_NAME_18045 = 18045,
    DIS_EMITTER_NAME_18090 = 18090,
    DIS_EMITTER_NAME_18135 = 18135,
    DIS_EMITTER_NAME_18150 = 18150,
    DIS_EMITTER_NAME_18180 = 18180,
    DIS_EMITTER_NAME_18200 = 18200,
    DIS_EMITTER_NAME_18225 = 18225,
    DIS_EMITTER_NAME_18270 = 18270,
    DIS_EMITTER_NAME_18280 = 18280,
    DIS_EMITTER_NAME_18315 = 18315,
    DIS_EMITTER_NAME_18320 = 18320,
    DIS_EMITTER_NAME_18325 = 18325,
    DIS_EMITTER_NAME_18330 = 18330,
    DIS_EMITTER_NAME_18360 = 18360,
    DIS_EMITTER_NAME_18405 = 18405,
    DIS_EMITTER_NAME_18410 = 18410,
    DIS_EMITTER_NAME_18450 = 18450,
    DIS_EMITTER_NAME_18460 = 18460,
    DIS_EMITTER_NAME_18495 = 18495,
    DIS_EMITTER_NAME_18540 = 18540,
    DIS_EMITTER_NAME_18550 = 18550,
    DIS_EMITTER_NAME_18555 = 18555,
    DIS_EMITTER_NAME_18560 = 18560,
    DIS_EMITTER_NAME_18585 = 18585,
    DIS_EMITTER_NAME_18630 = 18630,
    DIS_EMITTER_NAME_18675 = 18675,
    DIS_EMITTER_NAME_18720 = 18720,
    DIS_EMITTER_NAME_18765 = 18765,
    DIS_EMITTER_NAME_18785 = 18785,
    DIS_EMITTER_NAME_18810 = 18810,
    DIS_EMITTER_NAME_18855 = 18855,
    DIS_EMITTER_NAME_18900 = 18900,
    DIS_EMITTER_NAME_18945 = 18945,
    DIS_EMITTER_NAME_18990 = 18990,
    DIS_EMITTER_NAME_19035 = 19035,
    DIS_EMITTER_NAME_19037 = 19037,
    DIS_EMITTER_NAME_19050 = 19050,
    DIS_EMITTER_NAME_19080 = 19080,
    DIS_EMITTER_NAME_19125 = 19125,
    DIS_EMITTER_NAME_19170 = 19170,
    DIS_EMITTER_NAME_19215 = 19215,
    DIS_EMITTER_NAME_19260 = 19260,
    DIS_EMITTER_NAME_19305 = 19305,
    DIS_EMITTER_NAME_19310 = 19310,
    DIS_EMITTER_NAME_19350 = 19350,
    DIS_EMITTER_NAME_19395 = 19395,
    DIS_EMITTER_NAME_19400 = 19400,
    DIS_EMITTER_NAME_19440 = 19440,
    DIS_EMITTER_NAME_19485 = 19485,
    DIS_EMITTER_NAME_19530 = 19530,
    DIS_EMITTER_NAME_19575 = 19575,
    DIS_EMITTER_NAME_19620 = 19620,
    DIS_EMITTER_NAME_19665 = 19665,
    DIS_EMITTER_NAME_19710 = 19710,
    DIS_EMITTER_NAME_19755 = 19755,
    DIS_EMITTER_NAME_19800 = 19800,
    DIS_EMITTER_NAME_19845 = 19845,
    DIS_EMITTER_NAME_19890 = 19890,
    DIS_EMITTER_NAME_19935 = 19935,
    DIS_EMITTER_NAME_19950 = 19950,
    DIS_EMITTER_NAME_19955 = 19955,
    DIS_EMITTER_NAME_19960 = 19960,
    DIS_EMITTER_NAME_19980 = 19980,
    DIS_EMITTER_NAME_20025 = 20025,
    DIS_EMITTER_NAME_20040 = 20040,
    DIS_EMITTER_NAME_20070 = 20070,
    DIS_EMITTER_NAME_20090 = 20090,
    DIS_EMITTER_NAME_20115 = 20115,
    DIS_EMITTER_NAME_20160 = 20160,
    DIS_EMITTER_NAME_20205 = 20205,
    DIS_EMITTER_NAME_20250 = 20250,
    DIS_EMITTER_NAME_20295 = 20295,
    DIS_EMITTER_NAME_20340 = 20340,
    DIS_EMITTER_NAME_20360 = 20360,
    DIS_EMITTER_NAME_20385 = 20385,
    DIS_EMITTER_NAME_20430 = 20430,
    DIS_EMITTER_NAME_20475 = 20475,
    DIS_EMITTER_NAME_20495 = 20495,
    DIS_EMITTER_NAME_20520 = 20520,
    DIS_EMITTER_NAME_20530 = 20530,
    DIS_EMITTER_NAME_20565 = 20565,
    DIS_EMITTER_NAME_20585 = 20585,
    DIS_EMITTER_NAME_20610 = 20610,
    DIS_EMITTER_NAME_20655 = 20655,
    DIS_EMITTER_NAME_20700 = 20700,
    DIS_EMITTER_NAME_20745 = 20745,
    DIS_EMITTER_NAME_20790 = 20790,
    DIS_EMITTER_NAME_20835 = 20835,
    DIS_EMITTER_NAME_20880 = 20880,
    DIS_EMITTER_NAME_20925 = 20925,
    DIS_EMITTER_NAME_20950 = 20950,
    DIS_EMITTER_NAME_20970 = 20970,
    DIS_EMITTER_NAME_21015 = 21015,
    DIS_EMITTER_NAME_21060 = 21060,
    DIS_EMITTER_NAME_21105 = 21105,
    DIS_EMITTER_NAME_21150 = 21150,
    DIS_EMITTER_NAME_21195 = 21195,
    DIS_EMITTER_NAME_21240 = 21240,
    DIS_EMITTER_NAME_21285 = 21285,
    DIS_EMITTER_NAME_21330 = 21330,
    DIS_EMITTER_NAME_21340 = 21340,
    DIS_EMITTER_NAME_21375 = 21375,
    DIS_EMITTER_NAME_21420 = 21420,
    DIS_EMITTER_NAME_21465 = 21465,
    DIS_EMITTER_NAME_21490 = 21490,
    DIS_EMITTER_NAME_21510 = 21510,
    DIS_EMITTER_NAME_21555 = 21555,
    DIS_EMITTER_NAME_21600 = 21600,
    DIS_EMITTER_NAME_21645 = 21645,
    DIS_EMITTER_NAME_21650 = 21650,
    DIS_EMITTER_NAME_21690 = 21690,
    DIS_EMITTER_NAME_21710 = 21710,
    DIS_EMITTER_NAME_21735 = 21735,
    DIS_EMITTER_NAME_21780 = 21780,
    DIS_EMITTER_NAME_21825 = 21825,
    DIS_EMITTER_NAME_21870 = 21870,
    DIS_EMITTER_NAME_21880 = 21880,
    DIS_EMITTER_NAME_21890 = 21890,
    DIS_EMITTER_NAME_21895 = 21895,
    DIS_EMITTER_NAME_21915 = 21915,
    DIS_EMITTER_NAME_21960 = 21960,
    DIS_EMITTER_NAME_21980 = 21980,
    DIS_EMITTER_NAME_22005 = 22005,
    DIS_EMITTER_NAME_22050 = 22050,
    DIS_EMITTER_NAME_22095 = 22095,
    DIS_EMITTER_NAME_22140 = 22140,
    DIS_EMITTER_NAME_22185 = 22185,
    DIS_EMITTER_NAME_22230 = 22230,
    DIS_EMITTER_NAME_22275 = 22275,
    DIS_EMITTER_NAME_22320 = 22320,
    DIS_EMITTER_NAME_22345 = 22345,
    DIS_EMITTER_NAME_22365 = 22365,
    DIS_EMITTER_NAME_22410 = 22410,
    DIS_EMITTER_NAME_22455 = 22455,
    DIS_EMITTER_NAME_22500 = 22500,
    DIS_EMITTER_NAME_22545 = 22545,
    DIS_EMITTER_NAME_22590 = 22590,
    DIS_EMITTER_NAME_22635 = 22635,
    DIS_EMITTER_NAME_22680 = 22680,
    DIS_EMITTER_NAME_22690 = 22690,
    DIS_EMITTER_NAME_22725 = 22725,
    DIS_EMITTER_NAME_22730 = 22730,
    DIS_EMITTER_NAME_22740 = 22740,
    DIS_EMITTER_NAME_22770 = 22770,
    DIS_EMITTER_NAME_22810 = 22810,
    DIS_EMITTER_NAME_22815 = 22815,
    DIS_EMITTER_NAME_22860 = 22860,
    DIS_EMITTER_NAME_22905 = 22905,
    DIS_EMITTER_NAME_22950 = 22950,
    DIS_EMITTER_NAME_22955 = 22955,
    DIS_EMITTER_NAME_22960 = 22960,
    DIS_EMITTER_NAME_22995 = 22995,
    DIS_EMITTER_NAME_23040 = 23040,
    DIS_EMITTER_NAME_23085 = 23085,
    DIS_EMITTER_NAME_23095 = 23095,
    DIS_EMITTER_NAME_23130 = 23130,
    DIS_EMITTER_NAME_23175 = 23175,
    DIS_EMITTER_NAME_23220 = 23220,
    DIS_EMITTER_NAME_23265 = 23265,
    DIS_EMITTER_NAME_23310 = 23310,
    DIS_EMITTER_NAME_23355 = 23355,
    DIS_EMITTER_NAME_23400 = 23400,
    DIS_EMITTER_NAME_23445 = 23445,
    DIS_EMITTER_NAME_23490 = 23490,
    DIS_EMITTER_NAME_23535 = 23535,
    DIS_EMITTER_NAME_23580 = 23580,
    DIS_EMITTER_NAME_23625 = 23625,
    DIS_EMITTER_NAME_23670 = 23670,
    DIS_EMITTER_NAME_23690 = 23690,
    DIS_EMITTER_NAME_23710 = 23710,
    DIS_EMITTER_NAME_23715 = 23715,
    DIS_EMITTER_NAME_23760 = 23760,
    DIS_EMITTER_NAME_23805 = 23805,
    DIS_EMITTER_NAME_23850 = 23850,
    DIS_EMITTER_NAME_23895 = 23895,
    DIS_EMITTER_NAME_23940 = 23940,
    DIS_EMITTER_NAME_23985 = 23985,
    DIS_EMITTER_NAME_23990 = 23990,
    DIS_EMITTER_NAME_24030 = 24030,
    DIS_EMITTER_NAME_24075 = 24075,
    DIS_EMITTER_NAME_24095 = 24095,
    DIS_EMITTER_NAME_24100 = 24100,
    DIS_EMITTER_NAME_24120 = 24120,
    DIS_EMITTER_NAME_24165 = 24165,
    DIS_EMITTER_NAME_24210 = 24210,
    DIS_EMITTER_NAME_24255 = 24255,
    DIS_EMITTER_NAME_24300 = 24300,
    DIS_EMITTER_NAME_24345 = 24345,
    DIS_EMITTER_NAME_24390 = 24390,
    DIS_EMITTER_NAME_24435 = 24435,
    DIS_EMITTER_NAME_24480 = 24480,
    DIS_EMITTER_NAME_24525 = 24525,
    DIS_EMITTER_NAME_24570 = 24570,
    DIS_EMITTER_NAME_24615 = 24615,
    DIS_EMITTER_NAME_24620 = 24620,
    DIS_EMITTER_NAME_24650 = 24650,
    DIS_EMITTER_NAME_24660 = 24660,
    DIS_EMITTER_NAME_24705 = 24705,
    DIS_EMITTER_NAME_24710 = 24710,
    DIS_EMITTER_NAME_24750 = 24750,
    DIS_EMITTER_NAME_24770 = 24770,
    DIS_EMITTER_NAME_24780 = 24780,
    DIS_EMITTER_NAME_24795 = 24795,
    DIS_EMITTER_NAME_24840 = 24840,
    DIS_EMITTER_NAME_24885 = 24885,
    DIS_EMITTER_NAME_24930 = 24930,
    DIS_EMITTER_NAME_24975 = 24975,
    DIS_EMITTER_NAME_25020 = 25020,
    DIS_EMITTER_NAME_25065 = 25065,
    DIS_EMITTER_NAME_25110 = 25110,
    DIS_EMITTER_NAME_25155 = 25155,
    DIS_EMITTER_NAME_25200 = 25200,
    DIS_EMITTER_NAME_25205 = 25205,
    DIS_EMITTER_NAME_25245 = 25245,
    DIS_EMITTER_NAME_25260 = 25260,
    DIS_EMITTER_NAME_25265 = 25265,
    DIS_EMITTER_NAME_25270 = 25270,
    DIS_EMITTER_NAME_25280 = 25280,
    DIS_EMITTER_NAME_25285 = 25285,
    DIS_EMITTER_NAME_25290 = 25290,
    DIS_EMITTER_NAME_25300 = 25300,
    DIS_EMITTER_NAME_25335 = 25335,
    DIS_EMITTER_NAME_25380 = 25380,
    DIS_EMITTER_NAME_25425 = 25425,
    DIS_EMITTER_NAME_25470 = 25470,
    DIS_EMITTER_NAME_25515 = 25515,
    DIS_EMITTER_NAME_25560 = 25560,
    DIS_EMITTER_NAME_25605 = 25605,
    DIS_EMITTER_NAME_25630 = 25630,
    DIS_EMITTER_NAME_25635 = 25635,
    DIS_EMITTER_NAME_25650 = 25650,
    DIS_EMITTER_NAME_25695 = 25695,
    DIS_EMITTER_NAME_25735 = 25735,
    DIS_EMITTER_NAME_25740 = 25740,
    DIS_EMITTER_NAME_25760 = 25760,
    DIS_EMITTER_NAME_25785 = 25785,
    DIS_EMITTER_NAME_25830 = 25830,
    DIS_EMITTER_NAME_25835 = 25835,
    DIS_EMITTER_NAME_25840 = 25840,
    DIS_EMITTER_NAME_25875 = 25875,
    DIS_EMITTER_NAME_25885 = 25885,
    DIS_EMITTER_NAME_25890 = 25890,
    DIS_EMITTER_NAME_25895 = 25895,
    DIS_EMITTER_NAME_25920 = 25920,
    DIS_EMITTER_NAME_25965 = 25965,
    DIS_EMITTER_NAME_26010 = 26010,
    DIS_EMITTER_NAME_26055 = 26055,
    DIS_EMITTER_NAME_26100 = 26100,
    DIS_EMITTER_NAME_26145 = 26145,
    DIS_EMITTER_NAME_26190 = 26190,
    DIS_EMITTER_NAME_26235 = 26235,
    DIS_EMITTER_NAME_26280 = 26280,
    DIS_EMITTER_NAME_26325 = 26325,
    DIS_EMITTER_NAME_26330 = 26330,
    DIS_EMITTER_NAME_26350 = 26350,
    DIS_EMITTER_NAME_26370 = 26370,
    DIS_EMITTER_NAME_26415 = 26415,
    DIS_EMITTER_NAME_26460 = 26460,
    DIS_EMITTER_NAME_26505 = 26505,
    DIS_EMITTER_NAME_26550 = 26550,
    DIS_EMITTER_NAME_26595 = 26595,
    DIS_EMITTER_NAME_26610 = 26610,
    DIS_EMITTER_NAME_26640 = 26640,
    DIS_EMITTER_NAME_26660 = 26660,
    DIS_EMITTER_NAME_26670 = 26670,
    DIS_EMITTER_NAME_26685 = 26685,
    DIS_EMITTER_NAME_26730 = 26730,
    DIS_EMITTER_NAME_26775 = 26775,
    DIS_EMITTER_NAME_26795 = 26795,
    DIS_EMITTER_NAME_26820 = 26820,
    DIS_EMITTER_NAME_26865 = 26865,
    DIS_EMITTER_NAME_26910 = 26910,
    DIS_EMITTER_NAME_26955 = 26955,
    DIS_EMITTER_NAME_27000 = 27000,
    DIS_EMITTER_NAME_27045 = 27045,
    DIS_EMITTER_NAME_27090 = 27090,
    DIS_EMITTER_NAME_27135 = 27135,
    DIS_EMITTER_NAME_27140 = 27140,
    DIS_EMITTER_NAME_27141 = 27141,
    DIS_EMITTER_NAME_27150 = 27150,
    DIS_EMITTER_NAME_27180 = 27180,
    DIS_EMITTER_NAME_27190 = 27190,
    DIS_EMITTER_NAME_27225 = 27225,
    DIS_EMITTER_NAME_27270 = 27270,
    DIS_EMITTER_NAME_27315 = 27315,
    DIS_EMITTER_NAME_27360 = 27360,
    DIS_EMITTER_NAME_27405 = 27405,
    DIS_EMITTER_NAME_27450 = 27450,
    DIS_EMITTER_NAME_27495 = 27495,
    DIS_EMITTER_NAME_27540 = 27540,
    DIS_EMITTER_NAME_27570 = 27570,
    DIS_EMITTER_NAME_27585 = 27585,
    DIS_EMITTER_NAME_27630 = 27630,
    DIS_EMITTER_NAME_27675 = 27675,
    DIS_EMITTER_NAME_27720 = 27720,
    DIS_EMITTER_NAME_27765 = 27765,
    DIS_EMITTER_NAME_27810 = 27810,
    DIS_EMITTER_NAME_27855 = 27855,
    DIS_EMITTER_NAME_27870 = 27870,
    DIS_EMITTER_NAME_27900 = 27900,
    DIS_EMITTER_NAME_27945 = 27945,
    DIS_EMITTER_NAME_27990 = 27990,
    DIS_EMITTER_NAME_28035 = 28035,
    DIS_EMITTER_NAME_28080 = 28080,
    DIS_EMITTER_NAME_28125 = 28125,
    DIS_EMITTER_NAME_28170 = 28170,
    DIS_EMITTER_NAME_28215 = 28215,
    DIS_EMITTER_NAME_28260 = 28260,
    DIS_EMITTER_NAME_28280 = 28280,
    DIS_EMITTER_NAME_28305 = 28305,
    DIS_EMITTER_NAME_28350 = 28350,
    DIS_EMITTER_NAME_28395 = 28395,
    DIS_EMITTER_NAME_28440 = 28440,
    DIS_EMITTER_NAME_28485 = 28485,
    DIS_EMITTER_NAME_28530 = 28530,
    DIS_EMITTER_NAME_28575 = 28575,
    DIS_EMITTER_NAME_28620 = 28620,
    DIS_EMITTER_NAME_28665 = 28665,
    DIS_EMITTER_NAME_28710 = 28710,
    DIS_EMITTER_NAME_28755 = 28755,
    DIS_EMITTER_NAME_28800 = 28800,
    DIS_EMITTER_NAME_28845 = 28845,
    DIS_EMITTER_NAME_28890 = 28890,
    DIS_EMITTER_NAME_28935 = 28935,
    DIS_EMITTER_NAME_28980 = 28980,
    DIS_EMITTER_NAME_29025 = 29025,
    DIS_EMITTER_NAME_29070 = 29070,
    DIS_EMITTER_NAME_29115 = 29115,
    DIS_EMITTER_NAME_29160 = 29160,
    DIS_EMITTER_NAME_29185 = 29185,
    DIS_EMITTER_NAME_29190 = 29190,
    DIS_EMITTER_NAME_29205 = 29205,
    DIS_EMITTER_NAME_29215 = 29215,
    DIS_EMITTER_NAME_29220 = 29220,
    DIS_EMITTER_NAME_29250 = 29250,
    DIS_EMITTER_NAME_29270 = 29270,
    DIS_EMITTER_NAME_29295 = 29295,
    DIS_EMITTER_NAME_29340 = 29340,
    DIS_EMITTER_NAME_29385 = 29385,
    DIS_EMITTER_NAME_29400 = 29400,
    DIS_EMITTER_NAME_29430 = 29430,
    DIS_EMITTER_NAME_29440 = 29440,
    DIS_EMITTER_NAME_29475 = 29475,
    DIS_EMITTER_NAME_29520 = 29520,
    DIS_EMITTER_NAME_29565 = 29565,
    DIS_EMITTER_NAME_29610 = 29610,
    DIS_EMITTER_NAME_29655 = 29655,
    DIS_EMITTER_NAME_29700 = 29700,
    DIS_EMITTER_NAME_29745 = 29745,
    DIS_EMITTER_NAME_29790 = 29790,
    DIS_EMITTER_NAME_29835 = 29835,
    DIS_EMITTER_NAME_29880 = 29880,
    DIS_EMITTER_NAME_29925 = 29925,
    DIS_EMITTER_NAME_29970 = 29970,
    DIS_EMITTER_NAME_30015 = 30015,
    DIS_EMITTER_NAME_30060 = 30060,
    DIS_EMITTER_NAME_30080 = 30080,
    DIS_EMITTER_NAME_30105 = 30105,
    DIS_EMITTER_NAME_30150 = 30150,
    DIS_EMITTER_NAME_30195 = 30195,
    DIS_EMITTER_NAME_30240 = 30240,
    DIS_EMITTER_NAME_30285 = 30285,
    DIS_EMITTER_NAME_30330 = 30330,
    DIS_EMITTER_NAME_30375 = 30375,
    DIS_EMITTER_NAME_30420 = 30420,
    DIS_EMITTER_NAME_30465 = 30465,
    DIS_EMITTER_NAME_30470 = 30470,
    DIS_EMITTER_NAME_30510 = 30510,
    DIS_EMITTER_NAME_30520 = 30520,
    DIS_EMITTER_NAME_30555 = 30555,
    DIS_EMITTER_NAME_30580 = 30580,
    DIS_EMITTER_NAME_30600 = 30600,
    DIS_EMITTER_NAME_30645 = 30645,
    DIS_EMITTER_NAME_30670 = 30670,
    DIS_EMITTER_NAME_30690 = 30690,
    DIS_EMITTER_NAME_30700 = 30700,
    DIS_EMITTER_NAME_30735 = 30735,
    DIS_EMITTER_NAME_30780 = 30780,
    DIS_EMITTER_NAME_30825 = 30825,
    DIS_EMITTER_NAME_30870 = 30870,
    DIS_EMITTER_NAME_30915 = 30915,
    DIS_EMITTER_NAME_30960 = 30960,
    DIS_EMITTER_NAME_31005 = 31005,
    DIS_EMITTER_NAME_31050 = 31050,
    DIS_EMITTER_NAME_31095 = 31095,
    DIS_EMITTER_NAME_31140 = 31140,
    DIS_EMITTER_NAME_31185 = 31185,
    DIS_EMITTER_NAME_31230 = 31230,
    DIS_EMITTER_NAME_31275 = 31275,
    DIS_EMITTER_NAME_31320 = 31320,
    DIS_EMITTER_NAME_31365 = 31365,
    DIS_EMITTER_NAME_31410 = 31410,
    DIS_EMITTER_NAME_31455 = 31455,
    DIS_EMITTER_NAME_31500 = 31500,
    DIS_EMITTER_NAME_31545 = 31545,
    DIS_EMITTER_NAME_31590 = 31590,
    DIS_EMITTER_NAME_31635 = 31635,
    DIS_EMITTER_NAME_31680 = 31680,
    DIS_EMITTER_NAME_31681 = 31681,
    DIS_EMITTER_NAME_31682 = 31682,
    DIS_EMITTER_NAME_31684 = 31684,
    DIS_EMITTER_NAME_31725 = 31725,
    DIS_EMITTER_NAME_31770 = 31770,
    DIS_EMITTER_NAME_31815 = 31815,
    DIS_EMITTER_NAME_31860 = 31860,
    DIS_EMITTER_NAME_31905 = 31905,
    DIS_EMITTER_NAME_31950 = 31950,
    DIS_EMITTER_NAME_31995 = 31995,
    DIS_EMITTER_NAME_32040 = 32040,
    DIS_EMITTER_NAME_32085 = 32085,
    DIS_EMITTER_NAME_32130 = 32130,
    DIS_EMITTER_NAME_32175 = 32175,
    DIS_EMITTER_NAME_32220 = 32220,
    DIS_EMITTER_NAME_32265 = 32265,
    DIS_EMITTER_NAME_32310 = 32310,
    DIS_EMITTER_NAME_32330 = 32330,
    DIS_EMITTER_NAME_32355 = 32355,
    DIS_EMITTER_NAME_32400 = 32400,
    DIS_EMITTER_NAME_32445 = 32445,
    DIS_EMITTER_NAME_32490 = 32490,
    DIS_EMITTER_NAME_32535 = 32535,
    DIS_EMITTER_NAME_32580 = 32580,
    DIS_EMITTER_NAME_32625 = 32625,
    DIS_EMITTER_NAME_32670 = 32670,
    DIS_EMITTER_NAME_32715 = 32715,
    DIS_EMITTER_NAME_32760 = 32760,
    DIS_EMITTER_NAME_32805 = 32805,
    DIS_EMITTER_NAME_32850 = 32850,
    DIS_EMITTER_NAME_32895 = 32895,
    DIS_EMITTER_NAME_32940 = 32940,
    DIS_EMITTER_NAME_32985 = 32985,
    DIS_EMITTER_NAME_33030 = 33030,
    DIS_EMITTER_NAME_33075 = 33075,
    DIS_EMITTER_NAME_33120 = 33120,
    DIS_EMITTER_NAME_33165 = 33165,
    DIS_EMITTER_NAME_33210 = 33210,
    DIS_EMITTER_NAME_33255 = 33255,
    DIS_EMITTER_NAME_33300 = 33300,
    DIS_EMITTER_NAME_33345 = 33345,
    DIS_EMITTER_NAME_33390 = 33390,
    DIS_EMITTER_NAME_33435 = 33435,
    DIS_EMITTER_NAME_33480 = 33480,
    DIS_EMITTER_NAME_33525 = 33525,
    DIS_EMITTER_NAME_33570 = 33570,
    DIS_EMITTER_NAME_33590 = 33590,
    DIS_EMITTER_NAME_33595 = 33595,
    DIS_EMITTER_NAME_33600 = 33600,
    DIS_EMITTER_NAME_33615 = 33615,
    DIS_EMITTER_NAME_33660 = 33660,
    DIS_EMITTER_NAME_33705 = 33705,
    DIS_EMITTER_NAME_33750 = 33750,
    DIS_EMITTER_NAME_33795 = 33795,
    DIS_EMITTER_NAME_33840 = 33840,
    DIS_EMITTER_NAME_33860 = 33860,
    DIS_EMITTER_NAME_33885 = 33885,
    DIS_EMITTER_NAME_33930 = 33930,
    DIS_EMITTER_NAME_33975 = 33975,
    DIS_EMITTER_NAME_34020 = 34020,
    DIS_EMITTER_NAME_34040 = 34040,
    DIS_EMITTER_NAME_34065 = 34065,
    DIS_EMITTER_NAME_34110 = 34110,
    DIS_EMITTER_NAME_34155 = 34155,
    DIS_EMITTER_NAME_34200 = 34200,
    DIS_EMITTER_NAME_34245 = 34245,
    DIS_EMITTER_NAME_34290 = 34290,
    DIS_EMITTER_NAME_34335 = 34335,
    DIS_EMITTER_NAME_34380 = 34380,
    DIS_EMITTER_NAME_34425 = 34425,
    DIS_EMITTER_NAME_34470 = 34470,
    DIS_EMITTER_NAME_34515 = 34515,
    DIS_EMITTER_NAME_34560 = 34560,
    DIS_EMITTER_NAME_34605 = 34605,
    DIS_EMITTER_NAME_34625 = 34625,
    DIS_EMITTER_NAME_34640 = 34640,
    DIS_EMITTER_NAME_34650 = 34650,
    DIS_EMITTER_NAME_34670 = 34670,
    DIS_EMITTER_NAME_34695 = 34695,
    DIS_EMITTER_NAME_34740 = 34740,
    DIS_EMITTER_NAME_34785 = 34785,
    DIS_EMITTER_NAME_34795 = 34795,
    DIS_EMITTER_NAME_34830 = 34830,
    DIS_EMITTER_NAME_34875 = 34875,
    DIS_EMITTER_NAME_34920 = 34920,
    DIS_EMITTER_NAME_34965 = 34965,
    DIS_EMITTER_NAME_35010 = 35010,
    DIS_EMITTER_NAME_35055 = 35055,
    DIS_EMITTER_NAME_35100 = 35100,
    DIS_EMITTER_NAME_35145 = 35145,
    DIS_EMITTER_NAME_35190 = 35190,
    DIS_EMITTER_NAME_35235 = 35235,
    DIS_EMITTER_NAME_35280 = 35280,
    DIS_EMITTER_NAME_35325 = 35325,
    DIS_EMITTER_NAME_35370 = 35370,
    DIS_EMITTER_NAME_35415 = 35415,
    DIS_EMITTER_NAME_35460 = 35460,
    DIS_EMITTER_NAME_35480 = 35480,
    DIS_EMITTER_NAME_35490 = 35490,
    DIS_EMITTER_NAME_35505 = 35505,
    DIS_EMITTER_NAME_35550 = 35550,
    DIS_EMITTER_NAME_35570 = 35570,
    DIS_EMITTER_NAME_35580 = 35580,
    DIS_EMITTER_NAME_35595 = 35595,
    DIS_EMITTER_NAME_35640 = 35640,
    DIS_EMITTER_NAME_35685 = 35685,
    DIS_EMITTER_NAME_35730 = 35730,
    DIS_EMITTER_NAME_35775 = 35775,
    DIS_EMITTER_NAME_35800 = 35800,
    DIS_EMITTER_NAME_35820 = 35820,
    DIS_EMITTER_NAME_35865 = 35865,
    DIS_EMITTER_NAME_35910 = 35910,
    DIS_EMITTER_NAME_35955 = 35955,
    DIS_EMITTER_NAME_36000 = 36000,
    DIS_EMITTER_NAME_36045 = 36045,
    DIS_EMITTER_NAME_36090 = 36090,
    DIS_EMITTER_NAME_36135 = 36135,
    DIS_EMITTER_NAME_36180 = 36180,
    DIS_EMITTER_NAME_36220 = 36220,
    DIS_EMITTER_NAME_36225 = 36225,
    DIS_EMITTER_NAME_36230 = 36230,
    DIS_EMITTER_NAME_36270 = 36270,
    DIS_EMITTER_NAME_36315 = 36315,
    DIS_EMITTER_NAME_36360 = 36360,
    DIS_EMITTER_NAME_36380 = 36380,
    DIS_EMITTER_NAME_36405 = 36405,
    DIS_EMITTER_NAME_36420 = 36420,
    DIS_EMITTER_NAME_36425 = 36425,
    DIS_EMITTER_NAME_36430 = 36430,
    DIS_EMITTER_NAME_36450 = 36450,
    DIS_EMITTER_NAME_36495 = 36495,
    DIS_EMITTER_NAME_36540 = 36540,
    DIS_EMITTER_NAME_36585 = 36585,
    DIS_EMITTER_NAME_36630 = 36630,
    DIS_EMITTER_NAME_36675 = 36675,
    DIS_EMITTER_NAME_36720 = 36720,
    DIS_EMITTER_NAME_36765 = 36765,
    DIS_EMITTER_NAME_36810 = 36810,
    DIS_EMITTER_NAME_36855 = 36855,
    DIS_EMITTER_NAME_36900 = 36900,
    DIS_EMITTER_NAME_36945 = 36945,
    DIS_EMITTER_NAME_36990 = 36990,
    DIS_EMITTER_NAME_37035 = 37035,
    DIS_EMITTER_NAME_37050 = 37050,
    DIS_EMITTER_NAME_37080 = 37080,
    DIS_EMITTER_NAME_37125 = 37125,
    DIS_EMITTER_NAME_37170 = 37170,
    DIS_EMITTER_NAME_37215 = 37215,
    DIS_EMITTER_NAME_37260 = 37260,
    DIS_EMITTER_NAME_37265 = 37265,
    DIS_EMITTER_NAME_37305 = 37305,
    DIS_EMITTER_NAME_37350 = 37350,
    DIS_EMITTER_NAME_37395 = 37395,
    DIS_EMITTER_NAME_37440 = 37440,
    DIS_EMITTER_NAME_37485 = 37485,
    DIS_EMITTER_NAME_37530 = 37530,
    DIS_EMITTER_NAME_37575 = 37575,
    DIS_EMITTER_NAME_37620 = 37620,
    DIS_EMITTER_NAME_37665 = 37665,
    DIS_EMITTER_NAME_37710 = 37710,
    DIS_EMITTER_NAME_37755 = 37755,
    DIS_EMITTER_NAME_37800 = 37800,
    DIS_EMITTER_NAME_37845 = 37845,
    DIS_EMITTER_NAME_37850 = 37850,
    DIS_EMITTER_NAME_37890 = 37890,
    DIS_EMITTER_NAME_37935 = 37935,
    DIS_EMITTER_NAME_37980 = 37980,
    DIS_EMITTER_NAME_38025 = 38025,
    DIS_EMITTER_NAME_38045 = 38045,
    DIS_EMITTER_NAME_38070 = 38070,
    DIS_EMITTER_NAME_38115 = 38115,
    DIS_EMITTER_NAME_38120 = 38120,
    DIS_EMITTER_NAME_38160 = 38160,
    DIS_EMITTER_NAME_38205 = 38205,
    DIS_EMITTER_NAME_38210 = 38210,
    DIS_EMITTER_NAME_38250 = 38250,
    DIS_EMITTER_NAME_38260 = 38260,
    DIS_EMITTER_NAME_38295 = 38295,
    DIS_EMITTER_NAME_38320 = 38320,
    DIS_EMITTER_NAME_38340 = 38340,
    DIS_EMITTER_NAME_38385 = 38385,
    DIS_EMITTER_NAME_38430 = 38430,
    DIS_EMITTER_NAME_38475 = 38475,
    DIS_EMITTER_NAME_38520 = 38520,
    DIS_EMITTER_NAME_38565 = 38565,
    DIS_EMITTER_NAME_38570 = 38570,
    DIS_EMITTER_NAME_38572 = 38572,
    DIS_EMITTER_NAME_38610 = 38610,
    DIS_EMITTER_NAME_38655 = 38655,
    DIS_EMITTER_NAME_38700 = 38700,
    DIS_EMITTER_NAME_38715 = 38715,
    DIS_EMITTER_NAME_38745 = 38745,
    DIS_EMITTER_NAME_38790 = 38790,
    DIS_EMITTER_NAME_38835 = 38835,
    DIS_EMITTER_NAME_38880 = 38880,
    DIS_EMITTER_NAME_38925 = 38925,
    DIS_EMITTER_NAME_38950 = 38950,
    DIS_EMITTER_NAME_38955 = 38955,
    DIS_EMITTER_NAME_38970 = 38970,
    DIS_EMITTER_NAME_39015 = 39015,
    DIS_EMITTER_NAME_39060 = 39060,
    DIS_EMITTER_NAME_39105 = 39105,
    DIS_EMITTER_NAME_39150 = 39150
} DIS_PDU_EmitterName;

extern const value_string DIS_PDU_EmitterName_Strings[];
#endif /* packet-dis-enums.h */
