/*
 * Copyright 2008,2009 Chris Young <chris@unsatisfactorysoftware.co.uk>
 *
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 *
 * NetSurf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * NetSurf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef AMIGA_MENU_H
#define AMIGA_MENU_H
#include <exec/types.h>
#include <intuition/intuition.h>
#include <libraries/gadtools.h>
#include "content/hlcache.h"

/* Number of hotlist items, menu structure needs to be changed in ami_create_menu()
 * if this value is changed. */
#define AMI_HOTLIST_ITEMS 60
//gwin->hotlist_items

/* Maximum number of menu items - first value is number of static items
 * (ie. everything not intially defined as NM_IGNORE) */
#define AMI_MENU_MAX 57 + AMI_HOTLIST_ITEMS

/* Where the hotlist entries start */
#define AMI_MENU_HOTLIST 48

/* Where the hotlist entries end */
#define AMI_MENU_HOTLIST_MAX AMI_MENU_HOTLIST+AMI_HOTLIST_ITEMS

/* Number of ARexx menu items.  menu structure in ami_create_menu() needs to be
 * changed if this value is modified. */
#define AMI_MENU_AREXX_ITEMS 20

/* Where the ARexx menu items start.  ARexx menu items are right at the end...
 * for now, at least.  We can get away with AMI_MENU_MAX falling short as it is
 * only used for freeing the UTF-8 converted menu labels */
#define AMI_MENU_AREXX AMI_MENU_MAX

/* Where the ARexx menu items end (incidentally this is the real AMI_MENU_MAX) */
#define AMI_MENU_AREXX_MAX AMI_MENU_AREXX+AMI_MENU_AREXX_ITEMS

/* The Intuition menu numbers of some menus we might need to modify */
#define AMI_MENU_SAVEAS_TEXT FULLMENUNUM(0,4,1)
#define AMI_MENU_SAVEAS_COMPLETE FULLMENUNUM(0,4,2)
#define AMI_MENU_SAVEAS_PDF FULLMENUNUM(0,4,3)
#define AMI_MENU_SAVEAS_IFF FULLMENUNUM(0,4,4)
#define AMI_MENU_CLOSETAB FULLMENUNUM(0,6,0)
#define AMI_MENU_CUT FULLMENUNUM(1,0,0)
#define AMI_MENU_COPY FULLMENUNUM(1,1,0)
#define AMI_MENU_PASTE FULLMENUNUM(1,2,0)
#define AMI_MENU_SELECTALL FULLMENUNUM(1,4,0)
#define AMI_MENU_CLEAR FULLMENUNUM(1,5,0)
#define AMI_MENU_FIND FULLMENUNUM(2,0,0)
#define AMI_MENU_FOREIMG FULLMENUNUM(2,8,0)
#define AMI_MENU_BACKIMG FULLMENUNUM(2,8,1)
#define AMI_MENU_JS FULLMENUNUM(2,9,0)

/* A special value for ami_menu_window_close */
#define AMI_MENU_WINDOW_CLOSE_ALL (void *)1

struct gui_window;
struct gui_window_2;

struct gui_window_2 *ami_menu_window_close;
bool ami_menu_check_toggled;

void ami_free_menulabs(struct gui_window_2 *gwin);
struct NewMenu *ami_create_menu(struct gui_window_2 *gwin);
void ami_menu_refresh(struct gui_window_2 *gwin);
void ami_menu_update_checked(struct gui_window_2 *gwin);
void ami_menu_update_disabled(struct gui_window *g, hlcache_handle *c);
#endif
