/* external.c generated by valac 0.16.1, the Vala compiler
 * generated from external.vala, do not modify */

/*

This file is part of Auditive.

Copyright 2010-2012 Graeme Sheppard.

Auditive is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Auditive is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Auditive. If not, see <http://www.gnu.org/licenses/>.

*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <curses.h>
#include <gobject/gvaluecollector.h>


#define TYPE_METHOD (method_get_type ())
#define METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METHOD, method))
#define METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METHOD, methodClass))
#define IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METHOD))
#define IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METHOD))
#define METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METHOD, methodClass))

typedef struct _method method;
typedef struct _methodClass methodClass;
typedef struct _methodPrivate methodPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecmethod ParamSpecmethod;

#define TYPE_SCREEN (screen_get_type ())
#define SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCREEN, screen))
#define SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCREEN, screenClass))
#define IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCREEN))
#define IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCREEN))
#define SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCREEN, screenClass))

typedef struct _screen screen;
typedef struct _screenClass screenClass;
typedef struct _screenPrivate screenPrivate;

#define WORLD_WIDE_TYPE_SCREEN_TYPE (world_wide_screen_type_get_type ())

#define TYPE_WORLD_WIDE (world_wide_get_type ())
#define WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORLD_WIDE, world_wide))
#define WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORLD_WIDE, world_wideClass))
#define IS_WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORLD_WIDE))
#define IS_WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORLD_WIDE))
#define WORLD_WIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORLD_WIDE, world_wideClass))

typedef struct _world_wide world_wide;
typedef struct _world_wideClass world_wideClass;

#define TYPE_EXTERNAL (external_get_type ())
#define EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL, external))
#define EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL, externalClass))
#define IS_EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL))
#define IS_EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL))
#define EXTERNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL, externalClass))

typedef struct _external external;
typedef struct _externalClass externalClass;
typedef struct _externalPrivate externalPrivate;

#define EXTERNAL_TYPE_KEY_HANDLED (external_key_handled_get_type ())
typedef struct _world_widePrivate world_widePrivate;

#define TYPE_CONSOLE (console_get_type ())
#define CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSOLE, console))
#define CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSOLE, consoleClass))
#define IS_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSOLE))
#define IS_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSOLE))
#define CONSOLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSOLE, consoleClass))

typedef struct _console console;
typedef struct _consoleClass consoleClass;

#define TYPE_KEY_MAPS (key_maps_get_type ())
#define KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MAPS, key_maps))
#define KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MAPS, key_mapsClass))
#define IS_KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MAPS))
#define IS_KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MAPS))
#define KEY_MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MAPS, key_mapsClass))

typedef struct _key_maps key_maps;
typedef struct _key_mapsClass key_mapsClass;

#define TYPE_AUDITIVE (auditive_get_type ())
#define AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUDITIVE, auditive))
#define AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUDITIVE, auditiveClass))
#define IS_AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUDITIVE))
#define IS_AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUDITIVE))
#define AUDITIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUDITIVE, auditiveClass))

typedef struct _auditive auditive;
typedef struct _auditiveClass auditiveClass;

#define TYPE_PLAYLIST (playlist_get_type ())
#define PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLIST, playlist))
#define PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLIST, playlistClass))
#define IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLIST))
#define IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLIST))
#define PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLIST, playlistClass))

typedef struct _playlist playlist;
typedef struct _playlistClass playlistClass;

#define TYPE_VIEWLIST (viewlist_get_type ())
#define VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEWLIST, viewlist))
#define VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEWLIST, viewlistClass))
#define IS_VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEWLIST))
#define IS_VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEWLIST))
#define VIEWLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEWLIST, viewlistClass))

typedef struct _viewlist viewlist;
typedef struct _viewlistClass viewlistClass;

#define TYPE_DBG (dbg_get_type ())
#define DBG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBG, dbg))
#define DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DBG, dbgClass))
#define IS_DBG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBG))
#define IS_DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DBG))
#define DBG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DBG, dbgClass))

typedef struct _dbg dbg;
typedef struct _dbgClass dbgClass;

#define TYPE_HELP (help_get_type ())
#define HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELP, help))
#define HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELP, helpClass))
#define IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELP))
#define IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELP))
#define HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELP, helpClass))

typedef struct _help help;
typedef struct _helpClass helpClass;

#define TYPE_FILES (files_get_type ())
#define FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILES, files))
#define FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILES, filesClass))
#define IS_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILES))
#define IS_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILES))
#define FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILES, filesClass))

typedef struct _files files;
typedef struct _filesClass filesClass;

#define WORLD_WIDE_TYPE_PLAYING_TYPE (world_wide_playing_type_get_type ())
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _method {
	GTypeInstance parent_instance;
	volatile int ref_count;
	methodPrivate * priv;
	gint key;
	gchar* name;
	gchar* cmd;
};

struct _methodClass {
	GTypeClass parent_class;
	void (*finalize) (method *self);
};

struct _ParamSpecmethod {
	GParamSpec parent_instance;
};

typedef enum  {
	WORLD_WIDE_SCREEN_TYPE_none,
	WORLD_WIDE_SCREEN_TYPE_file_list,
	WORLD_WIDE_SCREEN_TYPE_view_list,
	WORLD_WIDE_SCREEN_TYPE_play_list,
	WORLD_WIDE_SCREEN_TYPE_ext_list,
	WORLD_WIDE_SCREEN_TYPE_debug,
	WORLD_WIDE_SCREEN_TYPE_help
} world_widescreen_type;

struct _screen {
	GTypeInstance parent_instance;
	volatile int ref_count;
	screenPrivate * priv;
	world_wide* world;
	gint screen_pos;
	gint row_pos;
	gint key_handled;
};

struct _screenClass {
	GTypeClass parent_class;
	void (*finalize) (screen *self);
	gboolean (*has_title) (screen* self);
	gchar* (*get_title) (screen* self);
	void (*previous_song) (screen* self);
	void (*advance_song) (screen* self);
	void (*continue_songs) (screen* self);
	void (*continue_songs_draw) (screen* self);
	gint (*get_size) (screen* self);
	gchar* (*calc_target) (screen* self, guint num);
	gchar* (*get_line) (screen* self, guint num);
	world_widescreen_type (*get_screen_type) (screen* self);
	void (*reset_stop) (screen* self);
	void (*draw) (screen* self);
	void (*key_press) (screen* self, gint key_num);
};

struct _external {
	screen parent_instance;
	externalPrivate * priv;
	gchar* target;
};

struct _externalClass {
	screenClass parent_class;
};

typedef enum  {
	EXTERNAL_KEY_HANDLED_none,
	EXTERNAL_KEY_HANDLED_resync,
	EXTERNAL_KEY_HANDLED_opened
} externalkey_handled;

typedef enum  {
	WORLD_WIDE_PLAYING_TYPE_stop,
	WORLD_WIDE_PLAYING_TYPE_play,
	WORLD_WIDE_PLAYING_TYPE_pause
} world_wideplaying_type;

struct _world_wide {
	GTypeInstance parent_instance;
	volatile int ref_count;
	world_widePrivate * priv;
	console* con;
	key_maps* keys;
	auditive* player;
	playlist* play_screen;
	viewlist* view_screen;
	external* ext_screen;
	dbg* debug;
	help* help_screen;
	GList* files_array;
	GList* keys_array;
	world_widescreen_type screen_current;
	world_wideplaying_type playing_state;
	gint screen_files;
	gboolean play_advance;
	screen* playing_screen;
	gint playlist_position;
};

struct _world_wideClass {
	GTypeClass parent_class;
	void (*finalize) (world_wide *self);
};


static gpointer method_parent_class = NULL;
static gpointer external_parent_class = NULL;

gpointer method_ref (gpointer instance);
void method_unref (gpointer instance);
GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_method (GValue* value, gpointer v_object);
void value_take_method (GValue* value, gpointer v_object);
gpointer value_get_method (const GValue* value);
GType method_get_type (void) G_GNUC_CONST;
enum  {
	METHOD_DUMMY_PROPERTY
};
method* method_new (gint k, const gchar* n, const gchar* c);
method* method_construct (GType object_type, gint k, const gchar* n, const gchar* c);
static void method_finalize (method* obj);
gpointer screen_ref (gpointer instance);
void screen_unref (gpointer instance);
GParamSpec* param_spec_screen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_screen (GValue* value, gpointer v_object);
void value_take_screen (GValue* value, gpointer v_object);
gpointer value_get_screen (const GValue* value);
GType screen_get_type (void) G_GNUC_CONST;
GType world_wide_screen_type_get_type (void) G_GNUC_CONST;
gpointer world_wide_ref (gpointer instance);
void world_wide_unref (gpointer instance);
GParamSpec* param_spec_world_wide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_world_wide (GValue* value, gpointer v_object);
void value_take_world_wide (GValue* value, gpointer v_object);
gpointer value_get_world_wide (const GValue* value);
GType world_wide_get_type (void) G_GNUC_CONST;
GType external_get_type (void) G_GNUC_CONST;
enum  {
	EXTERNAL_DUMMY_PROPERTY
};
GType external_key_handled_get_type (void) G_GNUC_CONST;
external* external_new (world_wide* w);
external* external_construct (GType object_type, world_wide* w);
screen* screen_construct (GType object_type);
static gboolean external_real_has_title (screen* base);
static gchar* external_real_get_title (screen* base);
gchar* get_file_from_path (const gchar* full_path);
static gint external_real_get_size (screen* base);
gpointer console_ref (gpointer instance);
void console_unref (gpointer instance);
GParamSpec* param_spec_console (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_console (GValue* value, gpointer v_object);
void value_take_console (GValue* value, gpointer v_object);
gpointer value_get_console (const GValue* value);
GType console_get_type (void) G_GNUC_CONST;
gpointer key_maps_ref (gpointer instance);
void key_maps_unref (gpointer instance);
GParamSpec* param_spec_key_maps (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_maps (GValue* value, gpointer v_object);
void value_take_key_maps (GValue* value, gpointer v_object);
gpointer value_get_key_maps (const GValue* value);
GType key_maps_get_type (void) G_GNUC_CONST;
gpointer auditive_ref (gpointer instance);
void auditive_unref (gpointer instance);
GParamSpec* param_spec_auditive (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_auditive (GValue* value, gpointer v_object);
void value_take_auditive (GValue* value, gpointer v_object);
gpointer value_get_auditive (const GValue* value);
GType auditive_get_type (void) G_GNUC_CONST;
GType playlist_get_type (void) G_GNUC_CONST;
GType viewlist_get_type (void) G_GNUC_CONST;
GType dbg_get_type (void) G_GNUC_CONST;
GType help_get_type (void) G_GNUC_CONST;
GType files_get_type (void) G_GNUC_CONST;
GType world_wide_playing_type_get_type (void) G_GNUC_CONST;
static gchar* external_real_get_line (screen* base, guint num);
static world_widescreen_type external_real_get_screen_type (screen* base);
externalkey_handled external_external_key_press (external* self, gint key_num);
gint screen_get_size (screen* self);
externalkey_handled external_execute (external* self, gint index);
void auditive_open_path (auditive* self, const gchar* path);
void console_print_status (console* self, const gchar* text);
gchar* get_base_from_path (const gchar* full_path);
void dbg_add (dbg* self, const gchar* text);
static void external_real_key_press (screen* base, gint key_num);
#define KEY_MAPS_key_left ((gint) KEY_LEFT)
void screen_draw (screen* self);
void screen_key_press (screen* self, gint key_num);
static void external_finalize (screen* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


method* method_construct (GType object_type, gint k, const gchar* n, const gchar* c) {
	method* self = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (n != NULL, NULL);
	g_return_val_if_fail (c != NULL, NULL);
	self = (method*) g_type_create_instance (object_type);
	_tmp0_ = k;
	self->key = _tmp0_;
	_tmp1_ = n;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->name);
	self->name = _tmp2_;
	_tmp3_ = c;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->cmd);
	self->cmd = _tmp4_;
	return self;
}


method* method_new (gint k, const gchar* n, const gchar* c) {
	return method_construct (TYPE_METHOD, k, n, c);
}


static void value_method_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_method_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		method_unref (value->data[0].v_pointer);
	}
}


static void value_method_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = method_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_method_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_method_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		method* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = method_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_method_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	method** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = method_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecmethod* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_METHOD), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_method (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METHOD), NULL);
	return value->data[0].v_pointer;
}


void value_set_method (GValue* value, gpointer v_object) {
	method* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METHOD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METHOD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		method_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		method_unref (old);
	}
}


void value_take_method (GValue* value, gpointer v_object) {
	method* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_METHOD));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_METHOD));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		method_unref (old);
	}
}


static void method_class_init (methodClass * klass) {
	method_parent_class = g_type_class_peek_parent (klass);
	METHOD_CLASS (klass)->finalize = method_finalize;
}


static void method_instance_init (method * self) {
	self->ref_count = 1;
}


static void method_finalize (method* obj) {
	method * self;
	self = METHOD (obj);
	_g_free0 (self->name);
	_g_free0 (self->cmd);
}


GType method_get_type (void) {
	static volatile gsize method_type_id__volatile = 0;
	if (g_once_init_enter (&method_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_method_init, value_method_free_value, value_method_copy_value, value_method_peek_pointer, "p", value_method_collect_value, "p", value_method_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (methodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (method), 0, (GInstanceInitFunc) method_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType method_type_id;
		method_type_id = g_type_register_fundamental (g_type_fundamental_next (), "method", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&method_type_id__volatile, method_type_id);
	}
	return method_type_id__volatile;
}


gpointer method_ref (gpointer instance) {
	method* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void method_unref (gpointer instance) {
	method* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		METHOD_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType external_key_handled_get_type (void) {
	static volatile gsize external_key_handled_type_id__volatile = 0;
	if (g_once_init_enter (&external_key_handled_type_id__volatile)) {
		static const GEnumValue values[] = {{EXTERNAL_KEY_HANDLED_none, "EXTERNAL_KEY_HANDLED_none", "none"}, {EXTERNAL_KEY_HANDLED_resync, "EXTERNAL_KEY_HANDLED_resync", "resync"}, {EXTERNAL_KEY_HANDLED_opened, "EXTERNAL_KEY_HANDLED_opened", "opened"}, {0, NULL, NULL}};
		GType external_key_handled_type_id;
		external_key_handled_type_id = g_enum_register_static ("externalkey_handled", values);
		g_once_init_leave (&external_key_handled_type_id__volatile, external_key_handled_type_id);
	}
	return external_key_handled_type_id__volatile;
}


external* external_construct (GType object_type, world_wide* w) {
	external* self = NULL;
	world_wide* _tmp0_;
	self = (external*) screen_construct (object_type);
	_tmp0_ = w;
	((screen*) self)->world = _tmp0_;
	return self;
}


external* external_new (world_wide* w) {
	return external_construct (TYPE_EXTERNAL, w);
}


static gboolean external_real_has_title (screen* base) {
	external * self;
	gboolean result = FALSE;
	self = (external*) base;
	result = TRUE;
	return result;
}


static gchar* external_real_get_title (screen* base) {
	external * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	self = (external*) base;
	_tmp0_ = self->target;
	_tmp1_ = get_file_from_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("  Operating on: ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}


static gint external_real_get_size (screen* base) {
	external * self;
	gint result = 0;
	world_wide* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
	self = (external*) base;
	_tmp0_ = ((screen*) self)->world;
	_tmp1_ = _tmp0_->keys_array;
	_tmp2_ = g_list_length (_tmp1_);
	result = (gint) _tmp2_;
	return result;
}


static gchar* external_real_get_line (screen* base, guint num) {
	external * self;
	gchar* result = NULL;
	gchar* second = NULL;
	gchar* _tmp0_;
	gchar* third;
	world_wide* _tmp1_;
	GList* _tmp2_;
	guint _tmp3_;
	gconstpointer _tmp4_ = NULL;
	gint _tmp5_;
	gint key;
	world_wide* _tmp6_;
	GList* _tmp7_;
	guint _tmp8_;
	gconstpointer _tmp9_ = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gint _tmp13_;
	gboolean _tmp15_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	self = (external*) base;
	_tmp0_ = g_strdup ("");
	third = _tmp0_;
	_tmp1_ = ((screen*) self)->world;
	_tmp2_ = _tmp1_->keys_array;
	_tmp3_ = num;
	_tmp4_ = g_list_nth_data (_tmp2_, _tmp3_);
	_tmp5_ = ((method*) _tmp4_)->key;
	key = _tmp5_;
	_tmp6_ = ((screen*) self)->world;
	_tmp7_ = _tmp6_->keys_array;
	_tmp8_ = num;
	_tmp9_ = g_list_nth_data (_tmp7_, _tmp8_);
	_tmp10_ = ((method*) _tmp9_)->name;
	_tmp11_ = g_strdup (_tmp10_);
	_g_free0 (second);
	second = _tmp11_;
	_tmp13_ = key;
	if (_tmp13_ > 32) {
		gint _tmp14_;
		_tmp14_ = key;
		_tmp12_ = _tmp14_ < 127;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp15_ = _tmp12_;
	if (_tmp15_) {
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp16_ = key;
		_tmp17_ = g_strdup_printf (" (%c)", _tmp16_);
		_g_free0 (third);
		third = _tmp17_;
	} else {
		gint _tmp18_;
		_tmp18_ = key;
		if (_tmp18_ != 0) {
			gint _tmp19_;
			gchar* _tmp20_ = NULL;
			_tmp19_ = key;
			_tmp20_ = g_strdup_printf (" (#%d)", _tmp19_);
			_g_free0 (third);
			third = _tmp20_;
		}
	}
	_tmp21_ = second;
	_tmp22_ = g_strconcat ("  ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = third;
	_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp23_);
	result = _tmp26_;
	_g_free0 (third);
	_g_free0 (second);
	return result;
}


static world_widescreen_type external_real_get_screen_type (screen* base) {
	external * self;
	world_widescreen_type result = 0;
	self = (external*) base;
	result = WORLD_WIDE_SCREEN_TYPE_ext_list;
	return result;
}


externalkey_handled external_external_key_press (external* self, gint key_num) {
	externalkey_handled result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_ = 0;
				world_wide* _tmp5_;
				GList* _tmp6_;
				gint _tmp7_;
				gconstpointer _tmp8_ = NULL;
				gint _tmp9_;
				gint _tmp10_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = screen_get_size ((screen*) self);
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = ((screen*) self)->world;
				_tmp6_ = _tmp5_->keys_array;
				_tmp7_ = i;
				_tmp8_ = g_list_nth_data (_tmp6_, (guint) _tmp7_);
				_tmp9_ = ((method*) _tmp8_)->key;
				_tmp10_ = key_num;
				if (_tmp9_ == _tmp10_) {
					gint _tmp11_;
					externalkey_handled _tmp12_ = 0;
					_tmp11_ = i;
					_tmp12_ = external_execute (self, _tmp11_);
					result = _tmp12_;
					return result;
				}
			}
		}
	}
	result = EXTERNAL_KEY_HANDLED_none;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch1_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally1;
	__catch1_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


externalkey_handled external_execute (external* self, gint index) {
	externalkey_handled result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	world_wide* _tmp2_;
	GList* _tmp3_;
	gint _tmp4_;
	gconstpointer _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp24_ = FALSE;
	gchar** _tmp25_;
	gint _tmp25__length1;
	const gchar* _tmp26_;
	gboolean _tmp28_;
	world_wide* _tmp33_;
	console* _tmp34_;
	world_wide* _tmp35_;
	GList* _tmp36_;
	gint _tmp37_;
	gconstpointer _tmp38_ = NULL;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	_tmp1_ = screen_get_size ((screen*) self);
	if (_tmp0_ >= _tmp1_) {
		result = EXTERNAL_KEY_HANDLED_none;
		return result;
	}
	_tmp2_ = ((screen*) self)->world;
	_tmp3_ = _tmp2_->keys_array;
	_tmp4_ = index;
	_tmp5_ = g_list_nth_data (_tmp3_, (guint) _tmp4_);
	_tmp6_ = ((method*) _tmp5_)->cmd;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
	args = _tmp8_;
	args_length1 = _vala_array_length (_tmp7_);
	_args_size_ = args_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp9_;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				gchar** _tmp13_;
				gint _tmp13__length1;
				gchar** _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar* _tmp20_ = NULL;
				gchar* _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = i;
				_tmp13_ = args;
				_tmp13__length1 = args_length1;
				if (!(_tmp12_ < _tmp13__length1)) {
					break;
				}
				_tmp14_ = args;
				_tmp14__length1 = args_length1;
				_tmp15_ = i;
				_tmp16_ = args;
				_tmp16__length1 = args_length1;
				_tmp17_ = i;
				_tmp18_ = _tmp16_[_tmp17_];
				_tmp19_ = self->target;
				_tmp20_ = get_file_from_path (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_replace (_tmp18_, "?", _tmp21_);
				_g_free0 (_tmp14_[_tmp15_]);
				_tmp14_[_tmp15_] = _tmp22_;
				_tmp23_ = _tmp14_[_tmp15_];
				_g_free0 (_tmp21_);
			}
		}
	}
	_tmp25_ = args;
	_tmp25__length1 = args_length1;
	_tmp26_ = _tmp25_[0];
	if (g_strcmp0 (_tmp26_, "open") == 0) {
		gchar** _tmp27_;
		gint _tmp27__length1;
		_tmp27_ = args;
		_tmp27__length1 = args_length1;
		_tmp24_ = _tmp27__length1 == 2;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp28_ = _tmp24_;
	if (_tmp28_) {
		world_wide* _tmp29_;
		auditive* _tmp30_;
		gchar** _tmp31_;
		gint _tmp31__length1;
		const gchar* _tmp32_;
		_tmp29_ = ((screen*) self)->world;
		_tmp30_ = _tmp29_->player;
		_tmp31_ = args;
		_tmp31__length1 = args_length1;
		_tmp32_ = _tmp31_[1];
		auditive_open_path (_tmp30_, _tmp32_);
		result = EXTERNAL_KEY_HANDLED_opened;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp33_ = ((screen*) self)->world;
	_tmp34_ = _tmp33_->con;
	_tmp35_ = ((screen*) self)->world;
	_tmp36_ = _tmp35_->keys_array;
	_tmp37_ = index;
	_tmp38_ = g_list_nth_data (_tmp36_, (guint) _tmp37_);
	_tmp39_ = ((method*) _tmp38_)->name;
	_tmp40_ = g_strconcat ("  Executing: ", _tmp39_, NULL);
	_tmp41_ = _tmp40_;
	console_print_status (_tmp34_, _tmp41_);
	_g_free0 (_tmp41_);
	{
		gchar* s1 = NULL;
		gchar* s2 = NULL;
		const gchar* _tmp42_;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_;
		gchar** _tmp45_;
		gint _tmp45__length1;
		gchar* _tmp46_ = NULL;
		gchar* _tmp47_ = NULL;
		_tmp42_ = self->target;
		_tmp43_ = get_base_from_path (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = args;
		_tmp45__length1 = args_length1;
		g_spawn_sync (_tmp44_, _tmp45_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp46_, &_tmp47_, NULL, &_inner_error_);
		_g_free0 (s1);
		s1 = _tmp46_;
		_g_free0 (s2);
		s2 = _tmp47_;
		_g_free0 (_tmp44_);
		if (_inner_error_ != NULL) {
			_g_free0 (s2);
			_g_free0 (s1);
			goto __catch2_g_error;
		}
		_g_free0 (s2);
		_g_free0 (s1);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		world_wide* _tmp48_;
		dbg* _tmp49_;
		GError* _tmp50_;
		const gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		err = _inner_error_;
		_inner_error_ = NULL;
		_tmp48_ = ((screen*) self)->world;
		_tmp49_ = _tmp48_->debug;
		_tmp50_ = err;
		_tmp51_ = _tmp50_->message;
		_tmp52_ = g_strconcat ("Spawn error: ", _tmp51_, NULL);
		_tmp53_ = _tmp52_;
		dbg_add (_tmp49_, _tmp53_);
		_g_free0 (_tmp53_);
		_g_error_free0 (err);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = EXTERNAL_KEY_HANDLED_resync;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void external_real_key_press (screen* base, gint key_num) {
	external * self;
	gint _tmp0_;
	self = (external*) base;
	_tmp0_ = key_num;
	switch (_tmp0_) {
		world_wide* _tmp1_;
		key_maps* _tmp2_;
		_tmp1_ = ((screen*) self)->world;
		_tmp2_ = _tmp1_->keys;
		case KEY_MAPS_key_left:
		{
			world_wide* _tmp3_;
			GList* _tmp4_;
			world_wide* _tmp5_;
			gint _tmp6_;
			gconstpointer _tmp7_ = NULL;
			_tmp3_ = ((screen*) self)->world;
			_tmp4_ = _tmp3_->files_array;
			_tmp5_ = ((screen*) self)->world;
			_tmp6_ = _tmp5_->screen_files;
			_tmp7_ = g_list_nth_data (_tmp4_, (guint) _tmp6_);
			screen_draw ((screen*) _tmp7_);
			break;
		}
		case '\n':
		{
			gint _tmp8_;
			gint _tmp9_;
			_tmp8_ = ((screen*) self)->screen_pos;
			_tmp9_ = ((screen*) self)->row_pos;
			external_execute (self, _tmp8_ + _tmp9_);
			break;
		}
		default:
		{
			gint _tmp10_;
			externalkey_handled _tmp11_ = 0;
			_tmp10_ = key_num;
			_tmp11_ = external_external_key_press (self, _tmp10_);
			if (_tmp11_ == EXTERNAL_KEY_HANDLED_none) {
				gint _tmp12_;
				_tmp12_ = key_num;
				SCREEN_CLASS (external_parent_class)->key_press (SCREEN (self), _tmp12_);
			}
			break;
		}
	}
}


static void external_class_init (externalClass * klass) {
	external_parent_class = g_type_class_peek_parent (klass);
	SCREEN_CLASS (klass)->finalize = external_finalize;
	SCREEN_CLASS (klass)->has_title = external_real_has_title;
	SCREEN_CLASS (klass)->get_title = external_real_get_title;
	SCREEN_CLASS (klass)->get_size = external_real_get_size;
	SCREEN_CLASS (klass)->get_line = external_real_get_line;
	SCREEN_CLASS (klass)->get_screen_type = external_real_get_screen_type;
	SCREEN_CLASS (klass)->key_press = external_real_key_press;
}


static void external_instance_init (external * self) {
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	self->target = _tmp0_;
}


static void external_finalize (screen* obj) {
	external * self;
	self = EXTERNAL (obj);
	_g_free0 (self->target);
	SCREEN_CLASS (external_parent_class)->finalize (obj);
}


GType external_get_type (void) {
	static volatile gsize external_type_id__volatile = 0;
	if (g_once_init_enter (&external_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (externalClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) external_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (external), 0, (GInstanceInitFunc) external_instance_init, NULL };
		GType external_type_id;
		external_type_id = g_type_register_static (TYPE_SCREEN, "external", &g_define_type_info, 0);
		g_once_init_leave (&external_type_id__volatile, external_type_id);
	}
	return external_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



