/* console.c generated by valac 0.16.1, the Vala compiler
 * generated from console.vala, do not modify */

/*

This file is part of Auditive.

Copyright 2010-2012 Graeme Sheppard.

Auditive is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

Auditive is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Auditive. If not, see <http://www.gnu.org/licenses/>.

*/
/* not using curses directive: I want my own refresh() function*/

#include <glib.h>
#include <glib-object.h>
#include <curses.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CONSOLE (console_get_type ())
#define CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONSOLE, console))
#define CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONSOLE, consoleClass))
#define IS_CONSOLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONSOLE))
#define IS_CONSOLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONSOLE))
#define CONSOLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONSOLE, consoleClass))

typedef struct _console console;
typedef struct _consoleClass consoleClass;
typedef struct _consolePrivate consolePrivate;

#define TYPE_WORLD_WIDE (world_wide_get_type ())
#define WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORLD_WIDE, world_wide))
#define WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORLD_WIDE, world_wideClass))
#define IS_WORLD_WIDE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORLD_WIDE))
#define IS_WORLD_WIDE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORLD_WIDE))
#define WORLD_WIDE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORLD_WIDE, world_wideClass))

typedef struct _world_wide world_wide;
typedef struct _world_wideClass world_wideClass;
#define _delwin0(var) ((var == NULL) ? NULL : (var = (delwin (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _world_widePrivate world_widePrivate;

#define TYPE_KEY_MAPS (key_maps_get_type ())
#define KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEY_MAPS, key_maps))
#define KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEY_MAPS, key_mapsClass))
#define IS_KEY_MAPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEY_MAPS))
#define IS_KEY_MAPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEY_MAPS))
#define KEY_MAPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEY_MAPS, key_mapsClass))

typedef struct _key_maps key_maps;
typedef struct _key_mapsClass key_mapsClass;

#define TYPE_AUDITIVE (auditive_get_type ())
#define AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AUDITIVE, auditive))
#define AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AUDITIVE, auditiveClass))
#define IS_AUDITIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AUDITIVE))
#define IS_AUDITIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AUDITIVE))
#define AUDITIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AUDITIVE, auditiveClass))

typedef struct _auditive auditive;
typedef struct _auditiveClass auditiveClass;

#define TYPE_SCREEN (screen_get_type ())
#define SCREEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCREEN, screen))
#define SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCREEN, screenClass))
#define IS_SCREEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCREEN))
#define IS_SCREEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCREEN))
#define SCREEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCREEN, screenClass))

typedef struct _screen screen;
typedef struct _screenClass screenClass;

#define TYPE_PLAYLIST (playlist_get_type ())
#define PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYLIST, playlist))
#define PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYLIST, playlistClass))
#define IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYLIST))
#define IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYLIST))
#define PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYLIST, playlistClass))

typedef struct _playlist playlist;
typedef struct _playlistClass playlistClass;

#define TYPE_VIEWLIST (viewlist_get_type ())
#define VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIEWLIST, viewlist))
#define VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIEWLIST, viewlistClass))
#define IS_VIEWLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIEWLIST))
#define IS_VIEWLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIEWLIST))
#define VIEWLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIEWLIST, viewlistClass))

typedef struct _viewlist viewlist;
typedef struct _viewlistClass viewlistClass;

#define TYPE_EXTERNAL (external_get_type ())
#define EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EXTERNAL, external))
#define EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EXTERNAL, externalClass))
#define IS_EXTERNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EXTERNAL))
#define IS_EXTERNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EXTERNAL))
#define EXTERNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EXTERNAL, externalClass))

typedef struct _external external;
typedef struct _externalClass externalClass;

#define TYPE_DBG (dbg_get_type ())
#define DBG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DBG, dbg))
#define DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DBG, dbgClass))
#define IS_DBG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DBG))
#define IS_DBG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DBG))
#define DBG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DBG, dbgClass))

typedef struct _dbg dbg;
typedef struct _dbgClass dbgClass;

#define TYPE_HELP (help_get_type ())
#define HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HELP, help))
#define HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HELP, helpClass))
#define IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HELP))
#define IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HELP))
#define HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HELP, helpClass))

typedef struct _help help;
typedef struct _helpClass helpClass;

#define TYPE_FILES (files_get_type ())
#define FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILES, files))
#define FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILES, filesClass))
#define IS_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILES))
#define IS_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILES))
#define FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILES, filesClass))

typedef struct _files files;
typedef struct _filesClass filesClass;

#define TYPE_METHOD (method_get_type ())
#define METHOD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_METHOD, method))
#define METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_METHOD, methodClass))
#define IS_METHOD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_METHOD))
#define IS_METHOD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_METHOD))
#define METHOD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_METHOD, methodClass))

typedef struct _method method;
typedef struct _methodClass methodClass;

#define WORLD_WIDE_TYPE_SCREEN_TYPE (world_wide_screen_type_get_type ())

#define WORLD_WIDE_TYPE_PLAYING_TYPE (world_wide_playing_type_get_type ())
typedef struct _methodPrivate methodPrivate;
typedef struct _key_mapsPrivate key_mapsPrivate;
typedef struct _ParamSpecconsole ParamSpecconsole;

struct _console {
	GTypeInstance parent_instance;
	volatile int ref_count;
	consolePrivate * priv;
	gint raw_lines;
	gint raw_columns;
};

struct _consoleClass {
	GTypeClass parent_class;
	void (*finalize) (console *self);
};

struct _consolePrivate {
	world_wide* world;
	WINDOW* win;
};

typedef enum  {
	WORLD_WIDE_SCREEN_TYPE_none,
	WORLD_WIDE_SCREEN_TYPE_file_list,
	WORLD_WIDE_SCREEN_TYPE_view_list,
	WORLD_WIDE_SCREEN_TYPE_play_list,
	WORLD_WIDE_SCREEN_TYPE_ext_list,
	WORLD_WIDE_SCREEN_TYPE_debug,
	WORLD_WIDE_SCREEN_TYPE_help
} world_widescreen_type;

typedef enum  {
	WORLD_WIDE_PLAYING_TYPE_stop,
	WORLD_WIDE_PLAYING_TYPE_play,
	WORLD_WIDE_PLAYING_TYPE_pause
} world_wideplaying_type;

struct _world_wide {
	GTypeInstance parent_instance;
	volatile int ref_count;
	world_widePrivate * priv;
	console* con;
	key_maps* keys;
	auditive* player;
	playlist* play_screen;
	viewlist* view_screen;
	external* ext_screen;
	dbg* debug;
	help* help_screen;
	GList* files_array;
	GList* keys_array;
	world_widescreen_type screen_current;
	world_wideplaying_type playing_state;
	gint screen_files;
	gboolean play_advance;
	screen* playing_screen;
	gint playlist_position;
};

struct _world_wideClass {
	GTypeClass parent_class;
	void (*finalize) (world_wide *self);
};

struct _method {
	GTypeInstance parent_instance;
	volatile int ref_count;
	methodPrivate * priv;
	gint key;
	gchar* name;
	gchar* cmd;
};

struct _methodClass {
	GTypeClass parent_class;
	void (*finalize) (method *self);
};

struct _key_maps {
	GTypeInstance parent_instance;
	volatile int ref_count;
	key_mapsPrivate * priv;
	GHashTable* key_texts;
};

struct _key_mapsClass {
	GTypeClass parent_class;
	void (*finalize) (key_maps *self);
};

struct _ParamSpecconsole {
	GParamSpec parent_instance;
};


static gpointer console_parent_class = NULL;

gpointer console_ref (gpointer instance);
void console_unref (gpointer instance);
GParamSpec* param_spec_console (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_console (GValue* value, gpointer v_object);
void value_take_console (GValue* value, gpointer v_object);
gpointer value_get_console (const GValue* value);
GType console_get_type (void) G_GNUC_CONST;
gpointer world_wide_ref (gpointer instance);
void world_wide_unref (gpointer instance);
GParamSpec* param_spec_world_wide (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_world_wide (GValue* value, gpointer v_object);
void value_take_world_wide (GValue* value, gpointer v_object);
gpointer value_get_world_wide (const GValue* value);
GType world_wide_get_type (void) G_GNUC_CONST;
#define CONSOLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CONSOLE, consolePrivate))
enum  {
	CONSOLE_DUMMY_PROPERTY
};
console* console_new (world_wide* w);
console* console_construct (GType object_type, world_wide* w);
void console_end (console* self);
void console_cls (console* self);
void console_print_it (console* self, const gchar* text);
void console_print_title (console* self, const gchar* text);
void console_calculate_dimensions (console* self);
void console_print_status (console* self, const gchar* text);
void console_print_at (console* self, gint x, gint y, const gchar* text);
void console_print_inverse_at (console* self, gint x, gint y, const gchar* text);
void console_refresh (console* self);
gint console_get_key (console* self);
gint console_lookup_key (console* self, gint key_num);
gpointer key_maps_ref (gpointer instance);
void key_maps_unref (gpointer instance);
GParamSpec* param_spec_key_maps (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_key_maps (GValue* value, gpointer v_object);
void value_take_key_maps (GValue* value, gpointer v_object);
gpointer value_get_key_maps (const GValue* value);
GType key_maps_get_type (void) G_GNUC_CONST;
gpointer auditive_ref (gpointer instance);
void auditive_unref (gpointer instance);
GParamSpec* param_spec_auditive (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_auditive (GValue* value, gpointer v_object);
void value_take_auditive (GValue* value, gpointer v_object);
gpointer value_get_auditive (const GValue* value);
GType auditive_get_type (void) G_GNUC_CONST;
gpointer screen_ref (gpointer instance);
void screen_unref (gpointer instance);
GParamSpec* param_spec_screen (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_screen (GValue* value, gpointer v_object);
void value_take_screen (GValue* value, gpointer v_object);
gpointer value_get_screen (const GValue* value);
GType screen_get_type (void) G_GNUC_CONST;
GType playlist_get_type (void) G_GNUC_CONST;
GType viewlist_get_type (void) G_GNUC_CONST;
GType external_get_type (void) G_GNUC_CONST;
GType dbg_get_type (void) G_GNUC_CONST;
GType help_get_type (void) G_GNUC_CONST;
GType files_get_type (void) G_GNUC_CONST;
gpointer method_ref (gpointer instance);
void method_unref (gpointer instance);
GParamSpec* param_spec_method (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_method (GValue* value, gpointer v_object);
void value_take_method (GValue* value, gpointer v_object);
gpointer value_get_method (const GValue* value);
GType method_get_type (void) G_GNUC_CONST;
GType world_wide_screen_type_get_type (void) G_GNUC_CONST;
GType world_wide_playing_type_get_type (void) G_GNUC_CONST;
void dbg_add (dbg* self, const gchar* text);
gint console_calculate_screen_size (console* self);
static void console_finalize (console* obj);


console* console_construct (GType object_type, world_wide* w) {
	console* self = NULL;
	world_wide* _tmp0_;
	WINDOW* _tmp1_;
	WINDOW* _tmp2_;
	self = (console*) g_type_create_instance (object_type);
	_tmp0_ = w;
	self->priv->world = _tmp0_;
	initscr ();
	cbreak ();
	noecho ();
	curs_set (0);
	_tmp1_ = newwin (1, 1, 0, 0);
	_delwin0 (self->priv->win);
	self->priv->win = _tmp1_;
	_tmp2_ = self->priv->win;
	keypad (_tmp2_, TRUE);
	return self;
}


console* console_new (world_wide* w) {
	return console_construct (TYPE_CONSOLE, w);
}


void console_end (console* self) {
	g_return_if_fail (self != NULL);
	console_cls (self);
	endwin ();
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


void console_print_it (console* self, const gchar* text) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* txt;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint len;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp13_;
	gint _tmp14_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = text;
	_tmp1_ = g_strdup (_tmp0_);
	txt = _tmp1_;
	_tmp2_ = txt;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	len = (gint) _tmp4_;
	_tmp5_ = len;
	_tmp6_ = self->raw_columns;
	if (_tmp5_ < _tmp6_) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp7_ = txt;
		_tmp8_ = self->raw_columns;
		_tmp9_ = len;
		_tmp10_ = g_strnfill ((gsize) (_tmp8_ - _tmp9_), ' ');
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp7_, _tmp11_, NULL);
		_g_free0 (txt);
		txt = _tmp12_;
		_g_free0 (_tmp11_);
	}
	_tmp13_ = len;
	_tmp14_ = self->raw_columns;
	if (_tmp13_ > _tmp14_) {
		const gchar* _tmp15_;
		gint _tmp16_;
		gchar* _tmp17_ = NULL;
		_tmp15_ = txt;
		_tmp16_ = self->raw_columns;
		_tmp17_ = string_substring (_tmp15_, (glong) 0, (glong) _tmp16_);
		_g_free0 (txt);
		txt = _tmp17_;
	}
	_tmp18_ = txt;
	addstr (_tmp18_);
	_g_free0 (txt);
}


void console_print_title (console* self, const gchar* text) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	console_calculate_dimensions (self);
	move (0, 0);
	_tmp0_ = text;
	console_print_it (self, _tmp0_);
	refresh ();
}


void console_print_status (console* self, const gchar* text) {
	gint _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	console_calculate_dimensions (self);
	_tmp0_ = self->raw_lines;
	move (_tmp0_ - 1, 0);
	_tmp1_ = text;
	console_print_it (self, _tmp1_);
	refresh ();
}


void console_print_at (console* self, gint x, gint y, const gchar* text) {
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = y;
	_tmp1_ = x;
	move (_tmp0_, _tmp1_);
	_tmp2_ = text;
	console_print_it (self, _tmp2_);
}


void console_print_inverse_at (console* self, gint x, gint y, const gchar* text) {
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = y;
	_tmp1_ = x;
	move (_tmp0_, _tmp1_);
	attron ((gulong) A_REVERSE);
	_tmp2_ = text;
	console_print_it (self, _tmp2_);
	attroff ((gulong) A_REVERSE);
}


void console_refresh (console* self) {
	g_return_if_fail (self != NULL);
	refresh ();
}


void console_cls (console* self) {
	g_return_if_fail (self != NULL);
	attroff ((gulong) A_REVERSE);
	clear ();
	refresh ();
	move (0, 0);
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


gint console_get_key (console* self) {
	gint result = 0;
	WINDOW* _tmp0_;
	gint _tmp1_ = 0;
	gint key;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint i;
	gint _tmp4_;
	world_wide* _tmp5_;
	GList* _tmp6_;
	gint _tmp7_;
	gconstpointer _tmp8_ = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* text;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	world_wide* _tmp22_;
	key_maps* _tmp23_;
	GHashTable* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	world_wide* _tmp32_;
	dbg* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->win;
	_tmp1_ = wgetch (_tmp0_);
	key = _tmp1_;
	_tmp2_ = key;
	_tmp3_ = console_lookup_key (self, _tmp2_);
	i = _tmp3_;
	_tmp4_ = i;
	if (_tmp4_ < 0) {
		result = key;
		return result;
	}
	_tmp5_ = self->priv->world;
	_tmp6_ = _tmp5_->keys_array;
	_tmp7_ = i;
	_tmp8_ = g_list_nth_data (_tmp6_, (guint) _tmp7_);
	_tmp9_ = ((method*) _tmp8_)->cmd;
	_tmp10_ = g_strdup (_tmp9_);
	text = _tmp10_;
	_tmp11_ = text;
	_tmp12_ = string_slice (_tmp11_, (glong) 0, (glong) 4);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strcmp0 (_tmp13_, "key ") != 0;
	_g_free0 (_tmp13_);
	if (_tmp14_) {
		result = key;
		_g_free0 (text);
		return result;
	}
	_tmp15_ = text;
	_tmp16_ = string_substring (_tmp15_, (glong) 4, (glong) (-1));
	_g_free0 (text);
	text = _tmp16_;
	_tmp17_ = text;
	_tmp18_ = strlen (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == 1) {
		const gchar* _tmp20_;
		gchar _tmp21_ = '\0';
		_tmp20_ = text;
		_tmp21_ = string_get (_tmp20_, (glong) 0);
		result = (gint) _tmp21_;
		_g_free0 (text);
		return result;
	}
	_tmp22_ = self->priv->world;
	_tmp23_ = _tmp22_->keys;
	_tmp24_ = _tmp23_->key_texts;
	_tmp25_ = text;
	_tmp26_ = g_hash_table_contains (_tmp24_, _tmp25_);
	if (_tmp26_) {
		world_wide* _tmp27_;
		key_maps* _tmp28_;
		GHashTable* _tmp29_;
		const gchar* _tmp30_;
		gconstpointer _tmp31_ = NULL;
		_tmp27_ = self->priv->world;
		_tmp28_ = _tmp27_->keys;
		_tmp29_ = _tmp28_->key_texts;
		_tmp30_ = text;
		_tmp31_ = g_hash_table_lookup (_tmp29_, _tmp30_);
		result = GPOINTER_TO_INT (_tmp31_);
		_g_free0 (text);
		return result;
	}
	_tmp32_ = self->priv->world;
	_tmp33_ = _tmp32_->debug;
	_tmp34_ = text;
	_tmp35_ = g_strdup_printf ("discarded: %s", _tmp34_);
	_tmp36_ = _tmp35_;
	dbg_add (_tmp33_, _tmp36_);
	_g_free0 (_tmp36_);
	result = 0;
	_g_free0 (text);
	return result;
}


gint console_lookup_key (console* self, gint key_num) {
	gint result = 0;
	world_wide* _tmp0_;
	GList* _tmp1_;
	guint _tmp2_ = 0U;
	gint size;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->world;
	_tmp1_ = _tmp0_->keys_array;
	_tmp2_ = g_list_length (_tmp1_);
	size = (gint) _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gint _tmp7_;
				world_wide* _tmp8_;
				GList* _tmp9_;
				gint _tmp10_;
				gconstpointer _tmp11_ = NULL;
				gint _tmp12_;
				gint _tmp13_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = self->priv->world;
				_tmp9_ = _tmp8_->keys_array;
				_tmp10_ = i;
				_tmp11_ = g_list_nth_data (_tmp9_, (guint) _tmp10_);
				_tmp12_ = ((method*) _tmp11_)->key;
				_tmp13_ = key_num;
				if (_tmp12_ == _tmp13_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


void console_calculate_dimensions (console* self) {
	g_return_if_fail (self != NULL);
	self->raw_lines = LINES;
	self->raw_columns = COLS;
}


gint console_calculate_screen_size (console* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = COLS + (LINES * 10000);
	return result;
}


static void value_console_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_console_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		console_unref (value->data[0].v_pointer);
	}
}


static void value_console_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = console_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_console_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_console_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		console* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = console_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_console_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	console** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = console_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_console (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecconsole* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CONSOLE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_console (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CONSOLE), NULL);
	return value->data[0].v_pointer;
}


void value_set_console (GValue* value, gpointer v_object) {
	console* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CONSOLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CONSOLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		console_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		console_unref (old);
	}
}


void value_take_console (GValue* value, gpointer v_object) {
	console* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CONSOLE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CONSOLE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		console_unref (old);
	}
}


static void console_class_init (consoleClass * klass) {
	console_parent_class = g_type_class_peek_parent (klass);
	CONSOLE_CLASS (klass)->finalize = console_finalize;
	g_type_class_add_private (klass, sizeof (consolePrivate));
}


static void console_instance_init (console * self) {
	self->priv = CONSOLE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void console_finalize (console* obj) {
	console * self;
	self = CONSOLE (obj);
	_delwin0 (self->priv->win);
}


GType console_get_type (void) {
	static volatile gsize console_type_id__volatile = 0;
	if (g_once_init_enter (&console_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_console_init, value_console_free_value, value_console_copy_value, value_console_peek_pointer, "p", value_console_collect_value, "p", value_console_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (consoleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) console_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (console), 0, (GInstanceInitFunc) console_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType console_type_id;
		console_type_id = g_type_register_fundamental (g_type_fundamental_next (), "console", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&console_type_id__volatile, console_type_id);
	}
	return console_type_id__volatile;
}


gpointer console_ref (gpointer instance) {
	console* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void console_unref (gpointer instance) {
	console* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CONSOLE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



