
[//000000001]: # (fileutil::magic::rt \- file utilities)
[//000000002]: # (Generated from file 'rtcore\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (fileutil::magic::rt\(n\) 2\.0 tcllib "file utilities")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

fileutil::magic::rt \- Runtime core for file type recognition engines written in
pure Tcl

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [COMMANDS](#section2)

  - [NUMERIC TYPES](#section3)

  - [Bugs, Ideas, Feedback](#section4)

  - [See Also](#seealso)

  - [Keywords](#keywords)

  - [Category](#category)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.5 9  
package require fileutil::magic::rt ?2\.0?  

[__::fileutil::magic::rt::>__](#1)  
[__::fileutil::magic::rt::<__](#2)  
[__::fileutil::magic::rt::new__ *chan* *named* *analyze*](#3)  
[__::fileutil::magic::rt::file\_start__ *name*](#4)  
[__::fileutil::magic::rt::emit__ *msg*](#5)  
[__::fileutil::magic::rt::O__ *where*](#6)  
[__::fileutil::magic::rt::R__ *where*](#7)  
[__::fileutil::magic::rt::Nv__ *type* *offset* *compinvert* *comp* *expected*](#8)  
[__::fileutil::magic::rt::N__ *type* *offset* *testinvert* *compinvert* *mod* *mand* *comp* *expected*](#9)  
[__::fileutil::magic::rt::S__ *type* *offset* *testinvert* *mod* *mand* *comp* *val*](#10)  
[__::fileutil::magic::rt::L__ *newlevel*](#11)  
[__::fileutil::magic::rt::I__ *offset* *it* *ioi* *ioo* *iir* *io*](#12)  
[__::fileutil::magic::rt::R__ *offset*](#13)  
[__::fileutil::magic::rt::U__ *fileindex* *name*](#14)  

# <a name='description'></a>DESCRIPTION

This package provides the runtime core for file type recognition engines written
in pure Tcl and is thus used by all other packages in this module such as
__[fileutil::magic::filetype](filetypes\.md)__ and the two compiler
packages __[fileutil::magic::cgen](cgen\.md)__ and
__[fileutil::magic::cfront](cfront\.md)__\.

# <a name='section2'></a>COMMANDS

  - <a name='1'></a>__::fileutil::magic::rt::>__

    Increment the level and perform related housekeeping

  - <a name='2'></a>__::fileutil::magic::rt::<__

    Decrement the level and perform related housekeeping

  - <a name='3'></a>__::fileutil::magic::rt::new__ *chan* *named* *analyze*

    Create a new command which returns one description of the file each time it
    is called, and a code of *break* when there are no more descriptions\.
    *chan* is the channel containing the data to describe\. The channel
    configuration is then managed as needed\. *named* is a dictionary of named
    tests, as generated by __fileutil::magic::cfront::compile__\. *test* is
    a command prefix for a routine composed of the list of commands as returned
    by __fileutil::magic::cfront::compile__\.

  - <a name='4'></a>__::fileutil::magic::rt::file\_start__ *name*

    This command marks the start of a magic file when debugging\. It returns the
    empty string as its result\.

  - <a name='5'></a>__::fileutil::magic::rt::emit__ *msg*

    This command adds the text *msg* to the result buffer\. The message may
    contain the following special character sequences\. They will be replaced
    with buffered values before the message is added to the result\. The command
    returns the empty string as its result\.

      * __\\b__

        This sequence is removed

      * __%s__

        Replaced with the last buffered string value\.

      * __%ld__

        Replaced with the last buffered numeric value\.

      * __%d__

        See above\.

      * __$\{x:\.\.\.?\.\.\.\}__

        Substitute one string if the file is executable, and another string
        otherwise\.

  - <a name='6'></a>__::fileutil::magic::rt::O__ *where*

    Produce an offset from *where*, relative to the cursor one level up\.

  - <a name='7'></a>__::fileutil::magic::rt::R__ *where*

    Produce an offset from *where*, relative to the offset one level up\.

  - <a name='8'></a>__::fileutil::magic::rt::Nv__ *type* *offset* *compinvert* *comp* *expected*

    A limited form of __::fileutile::magic::rt::N__ that only checks for
    equality and can't be told to invert the test\.

  - <a name='9'></a>__::fileutil::magic::rt::N__ *type* *offset* *testinvert* *compinvert* *mod* *mand* *comp* *expected*

    Fetch the numeric value with *type* from the absolute location *offset*,
    compare it with *expected* using *comp* as the comparision operator, and
    returns the result\.

    The argument *comp* must be one of Tcl's comparison operators\.

        <comp> <fetched-and-masked-value> <comp> <expected>

    The special comparison operator __x__ signals that no comparison should
    be done, or, in other words, that the fetched value will always match
    *val*\.

  - <a name='10'></a>__::fileutil::magic::rt::S__ *type* *offset* *testinvert* *mod* *mand* *comp* *val*

    Like __::fileutil::magic::rt::N__ except that it fetches and compares
    string types , not numeric data\.

  - <a name='11'></a>__::fileutil::magic::rt::L__ *newlevel*

    Sets the current level in the calling context to *newlevel*\. The command
    returns the empty string as its result\.

  - <a name='12'></a>__::fileutil::magic::rt::I__ *offset* *it* *ioi* *ioo* *iir* *io*

    Calculates an offset based on an initial offset and the provided modifiers\.

  - <a name='13'></a>__::fileutil::magic::rt::R__ *offset*

    Given an initial offset, calculates an offset relative to the cursor at the
    next level up\. The cursor is the position in the data one character after
    the data extracted from the file one level up\.

  - <a name='14'></a>__::fileutil::magic::rt::U__ *fileindex* *name*

    Add a level and use a named test script\.

# <a name='section3'></a>NUMERIC TYPES

  - __byte__

    8\-bit integer

  - __short__

    16\-bit integer, stored in native endianess

  - __beshort__

    see above, stored in big endian

  - __leshort__

    see above, stored in small/little endian

  - __long__

    32\-bit integer, stored in native endianess

  - __belong__

    see above, stored in big endian

  - __lelong__

    see above, stored in small/little endian

All of the types above exit in an unsigned form as well\. The type names are the
same, with the character "u" added as prefix\.

  - __date__

    32\-bit integer timestamp, stored in native endianess

  - __bedate__

    see above, stored in big endian

  - __ledate__

    see above, stored in small/little endian

  - __ldate__

    32\-bit integer timestamp, stored in native endianess

  - __beldate__

    see above, stored in big endian

  - __leldate__

    see above, stored in small/little endian

# <a name='section4'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *fileutil :: magic* of the
[Tcllib Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report
any ideas for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='seealso'></a>SEE ALSO

file\(1\), [fileutil](\.\./fileutil/fileutil\.md), magic\(5\)

# <a name='keywords'></a>KEYWORDS

[file recognition](\.\./\.\./\.\./\.\./index\.md\#file\_recognition), [file
type](\.\./\.\./\.\./\.\./index\.md\#file\_type), [file
utilities](\.\./\.\./\.\./\.\./index\.md\#file\_utilities),
[mime](\.\./\.\./\.\./\.\./index\.md\#mime), [type](\.\./\.\./\.\./\.\./index\.md\#type)

# <a name='category'></a>CATEGORY

Programming tools
