#include <stdlib.h>
#include <FL/Fl_Preferences.H>

class FontSetup {
  char* font_name[FL_FREE_FONT];
public:
  FontSetup(){
    static const Fl_Font fs[] = {
      FL_HELVETICA,
      FL_HELVETICA_BOLD,
      FL_HELVETICA_ITALIC,
      FL_HELVETICA_BOLD_ITALIC,
      FL_COURIER,
      FL_COURIER_BOLD,
      FL_COURIER_ITALIC,
      FL_COURIER_BOLD_ITALIC,
      FL_TIMES,
      FL_TIMES_BOLD,
      FL_TIMES_ITALIC,
      FL_TIMES_BOLD_ITALIC,
      FL_SYMBOL,
      FL_SCREEN,
      FL_SCREEN_BOLD,
      FL_ZAPF_DINGBATS,
      };
    char key[64];
    Fl_Preferences* Fp;
    Fp = new Fl_Preferences(Fl_Preferences::USER, "Tiny Core UTF-8 porting team", "fltk_projects_unicode");
    for (int i=0; i<FL_FREE_FONT; i++){
    	sprintf(key, "FL_FONT_SLOT_%d", i);
    	Fp->get(key, font_name[i], Fl::get_font(fs[i]));
    	Fl::set_font(fs[i], font_name[i]);
    }
    delete Fp;
    Fp = new Fl_Preferences(Fl_Preferences::USER, "Tiny Core UTF-8 porting team", "fltk_projects_unicode");
    for (int i=0; i<FL_FREE_FONT; i++){
    	sprintf(key, "FL_FONT_SLOT_%d", i);
    	Fp->set(key, Fl::get_font(fs[i]));
    }
    delete Fp;
  }
  ~FontSetup(){
    for (int i=0; i<FL_FREE_FONT; i++){
    	free(font_name[i]);
    	font_name[i] = NULL;
    }
  }
};
static FontSetup _FontSetup;
