appname  := $(shell basename `pwd`)
prefix   := /usr/local
confflag := --prefix=$(prefix)
bdepends := squashfs-tools-4.x compiletc coreutils
delfiles := install.stamp build.stamp patch.stamp configure.stamp extract.stamp files.txt

bindir        := $(prefix)/bin
libdir        := $(prefix)/lib
datadir       := $(prefix)/share/$(appname)
desktopdir    := $(prefix)/share/applications
pixmapdir     := $(prefix)/share/pixmaps
tceinstalldir := /usr/local/tce.installed
tcedir        := /etc/sysconfig/tcedir
tczdir        := $(tcedir)/optional

export PKG_CONFIG_PATH = /usr/local/lib/pkgconfig:/usr/lib/pkgconfig
export CFLAGS = -march=i486 -mtune=i686 -Os -pipe
export CXXFLAGS = -march=i486 -mtune=i686 -Os -pipe

CAT      := busybox cat
WHOAMI   := busybox whoami
TOUCH    := busybox touch
TAR      := busybox tar
SORT     := busybox sort
SED      := busybox sed
RM       := busybox rm
BASENAME := busybox basename
DIRNAME  := busybox dirname
MKDIR    := busybox mkdir
CP       := busybox cp
MD5SUM   := busybox md5sum
INSTALL  := busybox install
FIND     := /usr/local/bin/find
WGET     := busybox wget
ZCAT     := busybox zcat
CPIO     := busybox cpio
CHOWN    := busybox chown
CHMOD    := busybox chmod
PATCH    := busybox patch
CHROOT   := busybox chroot
MOUNT    := busybox mount
UMOUNT   := busybox umount

.PHONY: all
all: build.stamp

.PHONY: build-dep
build-dep:
	@for i in $(bdepends); do \
		if [ ! -f /usr/local/tce.installed/$$i ]; then \
			tcedir="/etc/sysconfig/tcedir"; \
			if [ ! -f $$tcedir/optional/$$i.tcz ]; then \
				if [ `$(WHOAMI)` = "root" ]; then \
					sudo -u tc tce-load -w $$i; \
				else \
					tce-load -w $$i; \
				fi; \
			fi; \
			if [ `$(WHOAMI)` = "root" ]; then \
				sudo -u tc tce-load -i $$i; \
			else \
				tce-load -i $$i; \
			fi; \
			if [ ! -f /usr/local/tce.installed/$$i ]; then \
				exit 1; \
			fi; \
		fi; \
	done

extract.stamp: $(distfile)
	$(MAKE) extract
	$(TOUCH) extract.stamp

patch.stamp: extract.stamp
	@for i in $(patches); do \
		if [ -f $$i ]; then \
			cd $(workdir); \
			patch -p 1 < ../$$i; \
			[ "$$?" != "0" ] && exit 1; \
			cd ..; \
		fi; \
	done
	$(TOUCH) patch.stamp

configure.stamp: patch.stamp
	$(MAKE) build-dep
	$(MAKE) configure
	$(TOUCH) configure.stamp

build.stamp: configure.stamp
	$(MAKE) build-dep
	$(MAKE) build
	$(TOUCH) build.stamp

install.stamp: build.stamp
	$(TOUCH) install.stamp
	$(MAKE) install	
	$(FIND) /usr/local -newer install.stamp -not -type d | $(SORT) | $(SED) -e "s/^\///g" > files.txt

.PHONY: install_script
install_script: $(appname).install
	sudo $(INSTALL) -o root -g staff -m 775 $^ $(tceinstalldir)/$(appname)

.PHONY: package
package: install.stamp
	@for i in $(target_list); do \
		if [ -f "$$i.tcz.list" ]; then \
			echo "[$$i]"; \
			sudo $(MKDIR) -p "$$i"; \
			sudo $(TAR) cf - -T "$$i.tcz.list" -C / | sudo $(TAR) xf - -C "$$i"; \
			LIST=`sudo $(FIND) "$$i" -type f | $(SORT)`; \
			for j in "$$LIST"; do \
				f=`sudo file "$$j"`; \
				RET=`echo "$$f" | grep "ELF 32-bit LSB shared object,.*not stripped"`; \
				if [ -n "$$RET" ]; then echo "[strip] $$j"; sudo strip "$$j"; fi; \
				RET=`echo "$$f" | grep "ELF 32-bit LSB executable,.*not stripped"`; \
				if [ -n "$$RET" ]; then echo "[strip] $$j"; sudo strip "$$j"; fi \
			done; \
			[ -d "files.$$i" ] && sudo $(CP) -a "files.$$i/*" "$$i"; \
			[ -d "$$i/usr/local/tce.installed" ] && sudo chown -R root.staff "$$i/usr/local/tce.installed"; \
			[ -d "$$i/usr/local/tce.installed" ] && sudo chmod 775 "$$i/usr/local/tce.installed"; \
			$(MKDIR) -p packages; \
			[ -f "packages/$$i.tcz" ] && sudo $(RM) -f "packages/$$i.tcz"; \
			mksquashfs "$$i" "packages/$$i.tcz" -b 4096; \
			cd "$$i"; $(FIND) . -not -type d | $(SORT) | $(SED) -e "s/^\.\///" > "../packages/$$i.tcz.list"; cd ..; \
			cd packages; $(MD5SUM) "$$i.tcz" > "$$i.tcz.md5.txt"; cd ..; \
			[ -f "$$i.tcz.dep" ] && $(CP) -f "$$i.tcz.dep" "packages/$$i.tcz.dep"; \
			sudo $(RM) -rf "$$i"; \
			sudo $(TOUCH) "/usr/local/tce.installed/$$i"; \
		fi; \
	done

.PHONY: uninstall
uninstall:
	@for i in $(unins_list); do \
		echo "[uninstall] $$i"; \
		while read j; do \
			if [ -e "/$$j" ]; then \
				echo "[uninstall] /$$j"; \
				sudo $(RM) -f "/$$j"; \
			fi \
		done < "$$i"; \
	done

.PHONY: tcexpand
tcexpand: build-dep
	@for i in $(tcexpand_list); do \
		f="$(tczdir)/$$i.tcz"; \
		[ -f "$$f" ] || tce-load -w $$i; \
		if [ -f "$$f" ]; then \
			echo "[expand] $$f"; \
			unsquashfs -l -d . "$$f" | while read j; do \
				[ ! -f "/$$j" ] || sudo $(RM) -f "/$$j"; \
			done; \
			rm -f "$(tceinstalldir)/$$i"; \
			tce-load -ic "$$i"; \
		else \
			echo "[Error] $$i not found."; \
			return 1; \
		fi; \
	done

.PHONY: tcinstall
tcinstall: package
	@for i in $(target_list); do \
		echo "[tcinstall] $$i"; \
		if [ -f "$$i.tcz.list" ]; then \
			if [ -f "packages/$$i.tcz" ]; then \
#				while read j; do \
#					[ ! -e "/$$j" ] || sudo $(RM) -f "/$$j"; \
#				done < "$$i.tcz.list"; \
#				[ ! -e "$(tceinstalldir)/$$i" ] || sudo $(RM) -f "$(tceinstalldir)/$$i"; \
				if [ -f "packages/$$i.tcz.dep" ]; then \
					while read j; do \
						[ -f "$(tczdir)/$$j" ] || tce-load -w $$j; \
					done < "packages/$$i.tcz.dep"; \
				fi; \
				$(CP) -f "packages/$$i.tcz" "$(tczdir)"; \
				[ ! -f "packages/$$i.tcz.dep" ] || $(CP) -f "packages/$$i.tcz.dep" "$(tczdir)"; \
				[ ! -f "packages/$$i.tcz.md5.txt" ] || $(CP) -f "packages/$$i.tcz.md5.txt" "$(tczdir)"; \
			fi; \
		fi; \
	done

.PHONY: clean
clean:
	sudo $(RM) -rf packages $(workdir) $(delfiles)
