//
// "$Id: help.cxx 5519 2006-10-11 03:12:15Z mike $"
//
// Fl_Help_Dialog test program.
//
// Copyright 1999-2005 by Easy Software Products.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA.
//
// Please report all bugs and problems on the following page:
//
//     http://www.fltk.org/str.php
//
// Contents:
//
//   main() - Display the help GUI...
//

//
// Include necessary headers...
//

#include <FL/Fl_Help_Dialog.H>
#include <iostream>
using namespace std;


//
// 'main()' - Display the help GUI...
//

int				// O - Exit status
main(int  argc,			// I - Number of command-line arguments
     char *argv[])		// I - Command-line arguments
{
  Fl_Help_Dialog	*help;		// Help dialog


  help = new Fl_Help_Dialog;

  if (argc < 2)
    help->load("/usr/share/doc/tc/help.html");
  else
    help->load(argv[1]);

  help->textsize(15);
  help->show(1, argv);

  Fl::run();

  delete help;

  return (0);
}


//
// End of "$Id: help.cxx 5519 2006-10-11 03:12:15Z mike $".
//
