#!/bin/sh
test ! -t 0 && exit
cd `dirname $0`
RUN_DIR=`pwd`

. /etc/init.d/tc-functions
LIST=`busybox --list`
for i in $LIST; do
	alias $i="busybox $i"
done

TCE_INSTALLED_DIR="/usr/local/tce.installed"
TCE_DIR="/etc/sysconfig/tcedir"
TCZ_DIR="${TCE_DIR}/optional"

if [ ! -f "${TCE_INSTALLED_DIR}/make" ]; then
	if [ ! -f "${TCZ_DIR}/make.tcz" ]; then
		tce-load -w make
	fi
	tce-load -i make
fi

INATALL_LIST="
kmap-jp106
tz-jst-9
locale-ja
Xlibs-ja
fltk-1.3-ja
Xprogs-ja
flwm_topside-ja
anthy
scim
scim-anthy
rxvt-unicode
"
for i in ${INATALL_LIST}; do
	make -C "$i" clean tcinstall
	make -C "$i" clean
done

PDIR=".fltk/Tiny Core UTF-8 porting team"
PFILE="fltk_projects_unicode.prefs"
cp -f "/etc/skel/${PDIR}/${PFILE}" "/home/${USER}/${PDIR}"
 
echo "Done!"