// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::State;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "ShumateTile")]
    pub struct Tile(Object<ffi::ShumateTile, ffi::ShumateTileClass>);

    match fn {
        type_ => || ffi::shumate_tile_get_type(),
    }
}

impl Tile {
    #[doc(alias = "shumate_tile_new")]
    pub fn new() -> Tile {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::shumate_tile_new()) }
    }

    #[doc(alias = "shumate_tile_new_full")]
    pub fn new_full(x: u32, y: u32, size: u32, zoom_level: u32) -> Tile {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::shumate_tile_new_full(x, y, size, zoom_level)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Tile`] objects.
    ///
    /// This method returns an instance of [`TileBuilder`](crate::builders::TileBuilder) which can be used to create [`Tile`] objects.
    pub fn builder() -> TileBuilder {
        TileBuilder::default()
    }

    #[doc(alias = "shumate_tile_get_etag")]
    #[doc(alias = "get_etag")]
    pub fn etag(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::shumate_tile_get_etag(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_tile_get_fade_in")]
    #[doc(alias = "get_fade_in")]
    pub fn is_fade_in(&self) -> bool {
        unsafe { from_glib(ffi::shumate_tile_get_fade_in(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_tile_get_modified_time")]
    #[doc(alias = "get_modified_time")]
    pub fn modified_time(&self) -> Option<glib::DateTime> {
        unsafe { from_glib_full(ffi::shumate_tile_get_modified_time(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_tile_get_paintable")]
    #[doc(alias = "get_paintable")]
    pub fn paintable(&self) -> Option<gdk::Paintable> {
        unsafe { from_glib_none(ffi::shumate_tile_get_paintable(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_tile_get_size")]
    #[doc(alias = "get_size")]
    pub fn size(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_size(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_get_state")]
    #[doc(alias = "get_state")]
    pub fn state(&self) -> State {
        unsafe { from_glib(ffi::shumate_tile_get_state(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_tile_get_x")]
    #[doc(alias = "get_x")]
    pub fn x(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_x(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_get_y")]
    #[doc(alias = "get_y")]
    pub fn y(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_y(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_get_zoom_level")]
    #[doc(alias = "get_zoom_level")]
    pub fn zoom_level(&self) -> u32 {
        unsafe { ffi::shumate_tile_get_zoom_level(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_tile_set_etag")]
    pub fn set_etag(&self, etag: &str) {
        unsafe {
            ffi::shumate_tile_set_etag(self.to_glib_none().0, etag.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_tile_set_fade_in")]
    pub fn set_fade_in(&self, fade_in: bool) {
        unsafe {
            ffi::shumate_tile_set_fade_in(self.to_glib_none().0, fade_in.into_glib());
        }
    }

    #[doc(alias = "shumate_tile_set_modified_time")]
    pub fn set_modified_time(&self, modified_time: &glib::DateTime) {
        unsafe {
            ffi::shumate_tile_set_modified_time(
                self.to_glib_none().0,
                modified_time.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_tile_set_paintable")]
    pub fn set_paintable(&self, paintable: &impl IsA<gdk::Paintable>) {
        unsafe {
            ffi::shumate_tile_set_paintable(
                self.to_glib_none().0,
                paintable.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_tile_set_size")]
    pub fn set_size(&self, size: u32) {
        unsafe {
            ffi::shumate_tile_set_size(self.to_glib_none().0, size);
        }
    }

    #[doc(alias = "shumate_tile_set_state")]
    pub fn set_state(&self, state: State) {
        unsafe {
            ffi::shumate_tile_set_state(self.to_glib_none().0, state.into_glib());
        }
    }

    #[doc(alias = "shumate_tile_set_x")]
    pub fn set_x(&self, x: u32) {
        unsafe {
            ffi::shumate_tile_set_x(self.to_glib_none().0, x);
        }
    }

    #[doc(alias = "shumate_tile_set_y")]
    pub fn set_y(&self, y: u32) {
        unsafe {
            ffi::shumate_tile_set_y(self.to_glib_none().0, y);
        }
    }

    #[doc(alias = "shumate_tile_set_zoom_level")]
    pub fn set_zoom_level(&self, zoom_level: u32) {
        unsafe {
            ffi::shumate_tile_set_zoom_level(self.to_glib_none().0, zoom_level);
        }
    }

    #[doc(alias = "fade-in")]
    pub fn connect_fade_in_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fade_in_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fade-in\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fade_in_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "paintable")]
    pub fn connect_paintable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_paintable_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paintable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paintable_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "size")]
    pub fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state")]
    pub fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "x")]
    pub fn connect_x_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_x_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::x\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_x_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "y")]
    pub fn connect_y_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_y_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::y\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_y_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "zoom-level")]
    pub fn connect_zoom_level_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_zoom_level_trampoline<F: Fn(&Tile) + 'static>(
            this: *mut ffi::ShumateTile,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::zoom-level\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_zoom_level_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Tile {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Tile`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TileBuilder {
    fade_in: Option<bool>,
    paintable: Option<gdk::Paintable>,
    size: Option<u32>,
    state: Option<State>,
    x: Option<u32>,
    y: Option<u32>,
    zoom_level: Option<u32>,
}

impl TileBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`TileBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Tile`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Tile {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref fade_in) = self.fade_in {
            properties.push(("fade-in", fade_in));
        }
        if let Some(ref paintable) = self.paintable {
            properties.push(("paintable", paintable));
        }
        if let Some(ref size) = self.size {
            properties.push(("size", size));
        }
        if let Some(ref state) = self.state {
            properties.push(("state", state));
        }
        if let Some(ref x) = self.x {
            properties.push(("x", x));
        }
        if let Some(ref y) = self.y {
            properties.push(("y", y));
        }
        if let Some(ref zoom_level) = self.zoom_level {
            properties.push(("zoom-level", zoom_level));
        }
        glib::Object::new::<Tile>(&properties).expect("Failed to create an instance of Tile")
    }

    pub fn fade_in(mut self, fade_in: bool) -> Self {
        self.fade_in = Some(fade_in);
        self
    }

    pub fn paintable(mut self, paintable: &impl IsA<gdk::Paintable>) -> Self {
        self.paintable = Some(paintable.clone().upcast());
        self
    }

    pub fn size(mut self, size: u32) -> Self {
        self.size = Some(size);
        self
    }

    pub fn state(mut self, state: State) -> Self {
        self.state = Some(state);
        self
    }

    pub fn x(mut self, x: u32) -> Self {
        self.x = Some(x);
        self
    }

    pub fn y(mut self, y: u32) -> Self {
        self.y = Some(y);
        self
    }

    pub fn zoom_level(mut self, zoom_level: u32) -> Self {
        self.zoom_level = Some(zoom_level);
        self
    }
}

impl fmt::Display for Tile {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Tile")
    }
}
