// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Layer;
use crate::Location;
use crate::Viewport;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "ShumatePathLayer")]
    pub struct PathLayer(Object<ffi::ShumatePathLayer, ffi::ShumatePathLayerClass>) @extends Layer, gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::shumate_path_layer_get_type(),
    }
}

impl PathLayer {
    #[doc(alias = "shumate_path_layer_new")]
    pub fn new(viewport: &Viewport) -> PathLayer {
        skip_assert_initialized!();
        unsafe { from_glib_none(ffi::shumate_path_layer_new(viewport.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PathLayer`] objects.
    ///
    /// This method returns an instance of [`PathLayerBuilder`](crate::builders::PathLayerBuilder) which can be used to create [`PathLayer`] objects.
    pub fn builder() -> PathLayerBuilder {
        PathLayerBuilder::default()
    }

    #[doc(alias = "shumate_path_layer_add_node")]
    pub fn add_node(&self, location: &impl IsA<Location>) {
        unsafe {
            ffi::shumate_path_layer_add_node(
                self.to_glib_none().0,
                location.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_get_closed")]
    #[doc(alias = "get_closed")]
    pub fn is_closed(&self) -> bool {
        unsafe { from_glib(ffi::shumate_path_layer_get_closed(self.to_glib_none().0)) }
    }

    //#[doc(alias = "shumate_path_layer_get_dash")]
    //#[doc(alias = "get_dash")]
    //pub fn dash(&self) -> /*Unimplemented*/Option<List TypeId { ns_id: 0, id: 15 }> {
    //    unsafe { TODO: call ffi:shumate_path_layer_get_dash() }
    //}

    #[doc(alias = "shumate_path_layer_get_fill")]
    #[doc(alias = "get_fill")]
    pub fn fills(&self) -> bool {
        unsafe { from_glib(ffi::shumate_path_layer_get_fill(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_path_layer_get_fill_color")]
    #[doc(alias = "get_fill_color")]
    pub fn fill_color(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_full(ffi::shumate_path_layer_get_fill_color(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_nodes")]
    #[doc(alias = "get_nodes")]
    pub fn nodes(&self) -> Vec<Location> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::shumate_path_layer_get_nodes(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_outline_color")]
    #[doc(alias = "get_outline_color")]
    pub fn outline_color(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_full(ffi::shumate_path_layer_get_outline_color(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_outline_width")]
    #[doc(alias = "get_outline_width")]
    pub fn outline_width(&self) -> f64 {
        unsafe { ffi::shumate_path_layer_get_outline_width(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_path_layer_get_stroke")]
    #[doc(alias = "get_stroke")]
    pub fn is_stroke(&self) -> bool {
        unsafe { from_glib(ffi::shumate_path_layer_get_stroke(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_path_layer_get_stroke_color")]
    #[doc(alias = "get_stroke_color")]
    pub fn stroke_color(&self) -> Option<gdk::RGBA> {
        unsafe {
            from_glib_full(ffi::shumate_path_layer_get_stroke_color(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_path_layer_get_stroke_width")]
    #[doc(alias = "get_stroke_width")]
    pub fn stroke_width(&self) -> f64 {
        unsafe { ffi::shumate_path_layer_get_stroke_width(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_path_layer_insert_node")]
    pub fn insert_node(&self, location: &impl IsA<Location>, position: u32) {
        unsafe {
            ffi::shumate_path_layer_insert_node(
                self.to_glib_none().0,
                location.as_ref().to_glib_none().0,
                position,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_remove_all")]
    pub fn remove_all(&self) {
        unsafe {
            ffi::shumate_path_layer_remove_all(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_path_layer_remove_node")]
    pub fn remove_node(&self, location: &impl IsA<Location>) {
        unsafe {
            ffi::shumate_path_layer_remove_node(
                self.to_glib_none().0,
                location.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_set_closed")]
    pub fn set_closed(&self, value: bool) {
        unsafe {
            ffi::shumate_path_layer_set_closed(self.to_glib_none().0, value.into_glib());
        }
    }

    //#[doc(alias = "shumate_path_layer_set_dash")]
    //pub fn set_dash(&self, dash_pattern: /*Unimplemented*/&List TypeId { ns_id: 0, id: 15 }) {
    //    unsafe { TODO: call ffi:shumate_path_layer_set_dash() }
    //}

    #[doc(alias = "shumate_path_layer_set_fill")]
    pub fn set_fill(&self, value: bool) {
        unsafe {
            ffi::shumate_path_layer_set_fill(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_path_layer_set_fill_color")]
    pub fn set_fill_color(&self, color: Option<&gdk::RGBA>) {
        unsafe {
            ffi::shumate_path_layer_set_fill_color(self.to_glib_none().0, color.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_path_layer_set_outline_color")]
    pub fn set_outline_color(&self, color: Option<&gdk::RGBA>) {
        unsafe {
            ffi::shumate_path_layer_set_outline_color(
                self.to_glib_none().0,
                color.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_path_layer_set_outline_width")]
    pub fn set_outline_width(&self, value: f64) {
        unsafe {
            ffi::shumate_path_layer_set_outline_width(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "shumate_path_layer_set_stroke")]
    pub fn set_stroke(&self, value: bool) {
        unsafe {
            ffi::shumate_path_layer_set_stroke(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_path_layer_set_stroke_color")]
    pub fn set_stroke_color(&self, color: Option<&gdk::RGBA>) {
        unsafe {
            ffi::shumate_path_layer_set_stroke_color(self.to_glib_none().0, color.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_path_layer_set_stroke_width")]
    pub fn set_stroke_width(&self, value: f64) {
        unsafe {
            ffi::shumate_path_layer_set_stroke_width(self.to_glib_none().0, value);
        }
    }

    #[doc(alias = "closed")]
    pub fn connect_closed_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_closed_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::closed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_closed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "fill")]
    pub fn connect_fill_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fill_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fill\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fill_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "fill-color")]
    pub fn connect_fill_color_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fill_color_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fill-color\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fill_color_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "outline-color")]
    pub fn connect_outline_color_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_outline_color_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::outline-color\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_outline_color_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "outline-width")]
    pub fn connect_outline_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_outline_width_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::outline-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_outline_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stroke")]
    pub fn connect_stroke_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stroke_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stroke\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stroke_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stroke-color")]
    pub fn connect_stroke_color_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stroke_color_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stroke-color\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stroke_color_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "stroke-width")]
    pub fn connect_stroke_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stroke_width_trampoline<F: Fn(&PathLayer) + 'static>(
            this: *mut ffi::ShumatePathLayer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stroke-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stroke_width_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for PathLayer {
    fn default() -> Self {
        glib::object::Object::new::<Self>(&[])
            .expect("Can't construct PathLayer object with default parameters")
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PathLayer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PathLayerBuilder {
    closed: Option<bool>,
    fill: Option<bool>,
    fill_color: Option<gdk::RGBA>,
    outline_color: Option<gdk::RGBA>,
    outline_width: Option<f64>,
    stroke: Option<bool>,
    stroke_color: Option<gdk::RGBA>,
    stroke_width: Option<f64>,
    viewport: Option<Viewport>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<gtk::Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<gtk::LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<gtk::Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<gtk::AccessibleRole>,
}

impl PathLayerBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`PathLayerBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PathLayer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PathLayer {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref closed) = self.closed {
            properties.push(("closed", closed));
        }
        if let Some(ref fill) = self.fill {
            properties.push(("fill", fill));
        }
        if let Some(ref fill_color) = self.fill_color {
            properties.push(("fill-color", fill_color));
        }
        if let Some(ref outline_color) = self.outline_color {
            properties.push(("outline-color", outline_color));
        }
        if let Some(ref outline_width) = self.outline_width {
            properties.push(("outline-width", outline_width));
        }
        if let Some(ref stroke) = self.stroke {
            properties.push(("stroke", stroke));
        }
        if let Some(ref stroke_color) = self.stroke_color {
            properties.push(("stroke-color", stroke_color));
        }
        if let Some(ref stroke_width) = self.stroke_width {
            properties.push(("stroke-width", stroke_width));
        }
        if let Some(ref viewport) = self.viewport {
            properties.push(("viewport", viewport));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        glib::Object::new::<PathLayer>(&properties)
            .expect("Failed to create an instance of PathLayer")
    }

    pub fn closed(mut self, closed: bool) -> Self {
        self.closed = Some(closed);
        self
    }

    pub fn fill(mut self, fill: bool) -> Self {
        self.fill = Some(fill);
        self
    }

    pub fn fill_color(mut self, fill_color: &gdk::RGBA) -> Self {
        self.fill_color = Some(fill_color.clone());
        self
    }

    pub fn outline_color(mut self, outline_color: &gdk::RGBA) -> Self {
        self.outline_color = Some(outline_color.clone());
        self
    }

    pub fn outline_width(mut self, outline_width: f64) -> Self {
        self.outline_width = Some(outline_width);
        self
    }

    pub fn stroke(mut self, stroke: bool) -> Self {
        self.stroke = Some(stroke);
        self
    }

    pub fn stroke_color(mut self, stroke_color: &gdk::RGBA) -> Self {
        self.stroke_color = Some(stroke_color.clone());
        self
    }

    pub fn stroke_width(mut self, stroke_width: f64) -> Self {
        self.stroke_width = Some(stroke_width);
        self
    }

    pub fn viewport(mut self, viewport: &Viewport) -> Self {
        self.viewport = Some(viewport.clone());
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: gtk::Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: gtk::AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }
}

impl fmt::Display for PathLayer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("PathLayer")
    }
}
