// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Layer;
use crate::MapSource;
use crate::State;
use crate::Viewport;
use glib::object::Cast;
use glib::object::IsA;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "ShumateMap")]
    pub struct Map(Object<ffi::ShumateMap, ffi::ShumateMapClass>) @extends gtk::Widget, @implements gtk::Accessible, gtk::Buildable, gtk::ConstraintTarget;

    match fn {
        type_ => || ffi::shumate_map_get_type(),
    }
}

impl Map {
    #[doc(alias = "shumate_map_new")]
    pub fn new() -> Map {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_map_new()) }
    }

    #[doc(alias = "shumate_map_new_simple")]
    pub fn new_simple() -> Map {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_map_new_simple()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Map`] objects.
    ///
    /// This method returns an instance of [`MapBuilder`](crate::builders::MapBuilder) which can be used to create [`Map`] objects.
    pub fn builder() -> MapBuilder {
        MapBuilder::default()
    }

    #[doc(alias = "shumate_map_add_layer")]
    pub fn add_layer(&self, layer: &impl IsA<Layer>) {
        unsafe {
            ffi::shumate_map_add_layer(self.to_glib_none().0, layer.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_center_on")]
    pub fn center_on(&self, latitude: f64, longitude: f64) {
        unsafe {
            ffi::shumate_map_center_on(self.to_glib_none().0, latitude, longitude);
        }
    }

    #[doc(alias = "shumate_map_get_animate_zoom")]
    #[doc(alias = "get_animate_zoom")]
    pub fn is_animate_zoom(&self) -> bool {
        unsafe { from_glib(ffi::shumate_map_get_animate_zoom(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_map_get_go_to_duration")]
    #[doc(alias = "get_go_to_duration")]
    pub fn go_to_duration(&self) -> u32 {
        unsafe { ffi::shumate_map_get_go_to_duration(self.to_glib_none().0) }
    }

    #[doc(alias = "shumate_map_get_state")]
    #[doc(alias = "get_state")]
    pub fn state(&self) -> State {
        unsafe { from_glib(ffi::shumate_map_get_state(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_map_get_viewport")]
    #[doc(alias = "get_viewport")]
    pub fn viewport(&self) -> Option<Viewport> {
        unsafe { from_glib_none(ffi::shumate_map_get_viewport(self.to_glib_none().0)) }
    }

    #[doc(alias = "shumate_map_get_zoom_on_double_click")]
    #[doc(alias = "get_zoom_on_double_click")]
    pub fn is_zoom_on_double_click(&self) -> bool {
        unsafe {
            from_glib(ffi::shumate_map_get_zoom_on_double_click(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "shumate_map_go_to")]
    pub fn go_to(&self, latitude: f64, longitude: f64) {
        unsafe {
            ffi::shumate_map_go_to(self.to_glib_none().0, latitude, longitude);
        }
    }

    #[doc(alias = "shumate_map_go_to_full")]
    pub fn go_to_full(&self, latitude: f64, longitude: f64, zoom_level: f64) {
        unsafe {
            ffi::shumate_map_go_to_full(self.to_glib_none().0, latitude, longitude, zoom_level);
        }
    }

    #[doc(alias = "shumate_map_go_to_full_with_duration")]
    pub fn go_to_full_with_duration(
        &self,
        latitude: f64,
        longitude: f64,
        zoom_level: f64,
        duration_ms: u32,
    ) {
        unsafe {
            ffi::shumate_map_go_to_full_with_duration(
                self.to_glib_none().0,
                latitude,
                longitude,
                zoom_level,
                duration_ms,
            );
        }
    }

    #[doc(alias = "shumate_map_insert_layer_above")]
    pub fn insert_layer_above(
        &self,
        layer: &impl IsA<Layer>,
        next_sibling: Option<&impl IsA<Layer>>,
    ) {
        unsafe {
            ffi::shumate_map_insert_layer_above(
                self.to_glib_none().0,
                layer.as_ref().to_glib_none().0,
                next_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_map_insert_layer_behind")]
    pub fn insert_layer_behind(
        &self,
        layer: &impl IsA<Layer>,
        next_sibling: Option<&impl IsA<Layer>>,
    ) {
        unsafe {
            ffi::shumate_map_insert_layer_behind(
                self.to_glib_none().0,
                layer.as_ref().to_glib_none().0,
                next_sibling.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_map_remove_layer")]
    pub fn remove_layer(&self, layer: &impl IsA<Layer>) {
        unsafe {
            ffi::shumate_map_remove_layer(self.to_glib_none().0, layer.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_set_animate_zoom")]
    pub fn set_animate_zoom(&self, value: bool) {
        unsafe {
            ffi::shumate_map_set_animate_zoom(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_map_set_go_to_duration")]
    pub fn set_go_to_duration(&self, duration: u32) {
        unsafe {
            ffi::shumate_map_set_go_to_duration(self.to_glib_none().0, duration);
        }
    }

    #[doc(alias = "shumate_map_set_map_source")]
    pub fn set_map_source(&self, map_source: &impl IsA<MapSource>) {
        unsafe {
            ffi::shumate_map_set_map_source(
                self.to_glib_none().0,
                map_source.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "shumate_map_set_zoom_on_double_click")]
    pub fn set_zoom_on_double_click(&self, value: bool) {
        unsafe {
            ffi::shumate_map_set_zoom_on_double_click(self.to_glib_none().0, value.into_glib());
        }
    }

    #[doc(alias = "shumate_map_stop_go_to")]
    pub fn stop_go_to(&self) {
        unsafe {
            ffi::shumate_map_stop_go_to(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_zoom_in")]
    pub fn zoom_in(&self) {
        unsafe {
            ffi::shumate_map_zoom_in(self.to_glib_none().0);
        }
    }

    #[doc(alias = "shumate_map_zoom_out")]
    pub fn zoom_out(&self) {
        unsafe {
            ffi::shumate_map_zoom_out(self.to_glib_none().0);
        }
    }

    #[doc(alias = "animation-completed")]
    pub fn connect_animation_completed<F: Fn(&Self) + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn animation_completed_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            let detailed_signal_name =
                detail.map(|name| format!("animation-completed::{}\0", name));
            let signal_name: &[u8] = detailed_signal_name
                .as_ref()
                .map_or(&b"animation-completed\0"[..], |n| n.as_bytes());
            connect_raw(
                self.as_ptr() as *mut _,
                signal_name.as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    animation_completed_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "animate-zoom")]
    pub fn connect_animate_zoom_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_animate_zoom_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::animate-zoom\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_animate_zoom_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "go-to-duration")]
    pub fn connect_go_to_duration_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_go_to_duration_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::go-to-duration\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_go_to_duration_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state")]
    pub fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_state_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "viewport")]
    pub fn connect_viewport_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_viewport_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::viewport\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_viewport_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "zoom-on-double-click")]
    pub fn connect_zoom_on_double_click_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_zoom_on_double_click_trampoline<F: Fn(&Map) + 'static>(
            this: *mut ffi::ShumateMap,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::zoom-on-double-click\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_zoom_on_double_click_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Map {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Map`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct MapBuilder {
    animate_zoom: Option<bool>,
    go_to_duration: Option<u32>,
    zoom_on_double_click: Option<bool>,
    can_focus: Option<bool>,
    can_target: Option<bool>,
    css_classes: Option<Vec<String>>,
    css_name: Option<String>,
    cursor: Option<gdk::Cursor>,
    focus_on_click: Option<bool>,
    focusable: Option<bool>,
    halign: Option<gtk::Align>,
    has_tooltip: Option<bool>,
    height_request: Option<i32>,
    hexpand: Option<bool>,
    hexpand_set: Option<bool>,
    layout_manager: Option<gtk::LayoutManager>,
    margin_bottom: Option<i32>,
    margin_end: Option<i32>,
    margin_start: Option<i32>,
    margin_top: Option<i32>,
    name: Option<String>,
    opacity: Option<f64>,
    overflow: Option<gtk::Overflow>,
    receives_default: Option<bool>,
    sensitive: Option<bool>,
    tooltip_markup: Option<String>,
    tooltip_text: Option<String>,
    valign: Option<gtk::Align>,
    vexpand: Option<bool>,
    vexpand_set: Option<bool>,
    visible: Option<bool>,
    width_request: Option<i32>,
    accessible_role: Option<gtk::AccessibleRole>,
}

impl MapBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`MapBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Map`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Map {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref animate_zoom) = self.animate_zoom {
            properties.push(("animate-zoom", animate_zoom));
        }
        if let Some(ref go_to_duration) = self.go_to_duration {
            properties.push(("go-to-duration", go_to_duration));
        }
        if let Some(ref zoom_on_double_click) = self.zoom_on_double_click {
            properties.push(("zoom-on-double-click", zoom_on_double_click));
        }
        if let Some(ref can_focus) = self.can_focus {
            properties.push(("can-focus", can_focus));
        }
        if let Some(ref can_target) = self.can_target {
            properties.push(("can-target", can_target));
        }
        if let Some(ref css_classes) = self.css_classes {
            properties.push(("css-classes", css_classes));
        }
        if let Some(ref css_name) = self.css_name {
            properties.push(("css-name", css_name));
        }
        if let Some(ref cursor) = self.cursor {
            properties.push(("cursor", cursor));
        }
        if let Some(ref focus_on_click) = self.focus_on_click {
            properties.push(("focus-on-click", focus_on_click));
        }
        if let Some(ref focusable) = self.focusable {
            properties.push(("focusable", focusable));
        }
        if let Some(ref halign) = self.halign {
            properties.push(("halign", halign));
        }
        if let Some(ref has_tooltip) = self.has_tooltip {
            properties.push(("has-tooltip", has_tooltip));
        }
        if let Some(ref height_request) = self.height_request {
            properties.push(("height-request", height_request));
        }
        if let Some(ref hexpand) = self.hexpand {
            properties.push(("hexpand", hexpand));
        }
        if let Some(ref hexpand_set) = self.hexpand_set {
            properties.push(("hexpand-set", hexpand_set));
        }
        if let Some(ref layout_manager) = self.layout_manager {
            properties.push(("layout-manager", layout_manager));
        }
        if let Some(ref margin_bottom) = self.margin_bottom {
            properties.push(("margin-bottom", margin_bottom));
        }
        if let Some(ref margin_end) = self.margin_end {
            properties.push(("margin-end", margin_end));
        }
        if let Some(ref margin_start) = self.margin_start {
            properties.push(("margin-start", margin_start));
        }
        if let Some(ref margin_top) = self.margin_top {
            properties.push(("margin-top", margin_top));
        }
        if let Some(ref name) = self.name {
            properties.push(("name", name));
        }
        if let Some(ref opacity) = self.opacity {
            properties.push(("opacity", opacity));
        }
        if let Some(ref overflow) = self.overflow {
            properties.push(("overflow", overflow));
        }
        if let Some(ref receives_default) = self.receives_default {
            properties.push(("receives-default", receives_default));
        }
        if let Some(ref sensitive) = self.sensitive {
            properties.push(("sensitive", sensitive));
        }
        if let Some(ref tooltip_markup) = self.tooltip_markup {
            properties.push(("tooltip-markup", tooltip_markup));
        }
        if let Some(ref tooltip_text) = self.tooltip_text {
            properties.push(("tooltip-text", tooltip_text));
        }
        if let Some(ref valign) = self.valign {
            properties.push(("valign", valign));
        }
        if let Some(ref vexpand) = self.vexpand {
            properties.push(("vexpand", vexpand));
        }
        if let Some(ref vexpand_set) = self.vexpand_set {
            properties.push(("vexpand-set", vexpand_set));
        }
        if let Some(ref visible) = self.visible {
            properties.push(("visible", visible));
        }
        if let Some(ref width_request) = self.width_request {
            properties.push(("width-request", width_request));
        }
        if let Some(ref accessible_role) = self.accessible_role {
            properties.push(("accessible-role", accessible_role));
        }
        glib::Object::new::<Map>(&properties).expect("Failed to create an instance of Map")
    }

    pub fn animate_zoom(mut self, animate_zoom: bool) -> Self {
        self.animate_zoom = Some(animate_zoom);
        self
    }

    pub fn go_to_duration(mut self, go_to_duration: u32) -> Self {
        self.go_to_duration = Some(go_to_duration);
        self
    }

    pub fn zoom_on_double_click(mut self, zoom_on_double_click: bool) -> Self {
        self.zoom_on_double_click = Some(zoom_on_double_click);
        self
    }

    pub fn can_focus(mut self, can_focus: bool) -> Self {
        self.can_focus = Some(can_focus);
        self
    }

    pub fn can_target(mut self, can_target: bool) -> Self {
        self.can_target = Some(can_target);
        self
    }

    pub fn css_classes(mut self, css_classes: Vec<String>) -> Self {
        self.css_classes = Some(css_classes);
        self
    }

    pub fn css_name(mut self, css_name: &str) -> Self {
        self.css_name = Some(css_name.to_string());
        self
    }

    pub fn cursor(mut self, cursor: &gdk::Cursor) -> Self {
        self.cursor = Some(cursor.clone());
        self
    }

    pub fn focus_on_click(mut self, focus_on_click: bool) -> Self {
        self.focus_on_click = Some(focus_on_click);
        self
    }

    pub fn focusable(mut self, focusable: bool) -> Self {
        self.focusable = Some(focusable);
        self
    }

    pub fn halign(mut self, halign: gtk::Align) -> Self {
        self.halign = Some(halign);
        self
    }

    pub fn has_tooltip(mut self, has_tooltip: bool) -> Self {
        self.has_tooltip = Some(has_tooltip);
        self
    }

    pub fn height_request(mut self, height_request: i32) -> Self {
        self.height_request = Some(height_request);
        self
    }

    pub fn hexpand(mut self, hexpand: bool) -> Self {
        self.hexpand = Some(hexpand);
        self
    }

    pub fn hexpand_set(mut self, hexpand_set: bool) -> Self {
        self.hexpand_set = Some(hexpand_set);
        self
    }

    pub fn layout_manager(mut self, layout_manager: &impl IsA<gtk::LayoutManager>) -> Self {
        self.layout_manager = Some(layout_manager.clone().upcast());
        self
    }

    pub fn margin_bottom(mut self, margin_bottom: i32) -> Self {
        self.margin_bottom = Some(margin_bottom);
        self
    }

    pub fn margin_end(mut self, margin_end: i32) -> Self {
        self.margin_end = Some(margin_end);
        self
    }

    pub fn margin_start(mut self, margin_start: i32) -> Self {
        self.margin_start = Some(margin_start);
        self
    }

    pub fn margin_top(mut self, margin_top: i32) -> Self {
        self.margin_top = Some(margin_top);
        self
    }

    pub fn name(mut self, name: &str) -> Self {
        self.name = Some(name.to_string());
        self
    }

    pub fn opacity(mut self, opacity: f64) -> Self {
        self.opacity = Some(opacity);
        self
    }

    pub fn overflow(mut self, overflow: gtk::Overflow) -> Self {
        self.overflow = Some(overflow);
        self
    }

    pub fn receives_default(mut self, receives_default: bool) -> Self {
        self.receives_default = Some(receives_default);
        self
    }

    pub fn sensitive(mut self, sensitive: bool) -> Self {
        self.sensitive = Some(sensitive);
        self
    }

    pub fn tooltip_markup(mut self, tooltip_markup: &str) -> Self {
        self.tooltip_markup = Some(tooltip_markup.to_string());
        self
    }

    pub fn tooltip_text(mut self, tooltip_text: &str) -> Self {
        self.tooltip_text = Some(tooltip_text.to_string());
        self
    }

    pub fn valign(mut self, valign: gtk::Align) -> Self {
        self.valign = Some(valign);
        self
    }

    pub fn vexpand(mut self, vexpand: bool) -> Self {
        self.vexpand = Some(vexpand);
        self
    }

    pub fn vexpand_set(mut self, vexpand_set: bool) -> Self {
        self.vexpand_set = Some(vexpand_set);
        self
    }

    pub fn visible(mut self, visible: bool) -> Self {
        self.visible = Some(visible);
        self
    }

    pub fn width_request(mut self, width_request: i32) -> Self {
        self.width_request = Some(width_request);
        self
    }

    pub fn accessible_role(mut self, accessible_role: gtk::AccessibleRole) -> Self {
        self.accessible_role = Some(accessible_role);
        self
    }
}

impl fmt::Display for Map {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Map")
    }
}
