// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files.git)
// DO NOT EDIT

use crate::Location;
use glib::object::Cast;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::fmt;

glib::wrapper! {
    #[doc(alias = "ShumateCoordinate")]
    pub struct Coordinate(Object<ffi::ShumateCoordinate, ffi::ShumateCoordinateClass>) @implements Location;

    match fn {
        type_ => || ffi::shumate_coordinate_get_type(),
    }
}

impl Coordinate {
    pub const NONE: Option<&'static Coordinate> = None;

    #[doc(alias = "shumate_coordinate_new")]
    pub fn new() -> Coordinate {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_coordinate_new()) }
    }

    #[doc(alias = "shumate_coordinate_new_full")]
    pub fn new_full(latitude: f64, longitude: f64) -> Coordinate {
        assert_initialized_main_thread!();
        unsafe { from_glib_none(ffi::shumate_coordinate_new_full(latitude, longitude)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`Coordinate`] objects.
    ///
    /// This method returns an instance of [`CoordinateBuilder`](crate::builders::CoordinateBuilder) which can be used to create [`Coordinate`] objects.
    pub fn builder() -> CoordinateBuilder {
        CoordinateBuilder::default()
    }
}

impl Default for Coordinate {
    fn default() -> Self {
        Self::new()
    }
}

#[derive(Clone, Default)]
// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`Coordinate`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct CoordinateBuilder {
    latitude: Option<f64>,
    longitude: Option<f64>,
}

impl CoordinateBuilder {
    // rustdoc-stripper-ignore-next
    /// Create a new [`CoordinateBuilder`].
    pub fn new() -> Self {
        Self::default()
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`Coordinate`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> Coordinate {
        let mut properties: Vec<(&str, &dyn ToValue)> = vec![];
        if let Some(ref latitude) = self.latitude {
            properties.push(("latitude", latitude));
        }
        if let Some(ref longitude) = self.longitude {
            properties.push(("longitude", longitude));
        }
        glib::Object::new::<Coordinate>(&properties)
            .expect("Failed to create an instance of Coordinate")
    }

    pub fn latitude(mut self, latitude: f64) -> Self {
        self.latitude = Some(latitude);
        self
    }

    pub fn longitude(mut self, longitude: f64) -> Self {
        self.longitude = Some(longitude);
        self
    }
}

impl fmt::Display for Coordinate {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Coordinate")
    }
}
