// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// from gst-gir-files (https://gitlab.freedesktop.org/gstreamer/gir-files-rs.git)
// DO NOT EDIT

use crate::ClockTime;
use crate::Message;
use crate::Object;
use glib::object::ObjectType as ObjectType_;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "GstBus")]
    pub struct Bus(Object<ffi::GstBus, ffi::GstBusClass>) @extends Object;

    match fn {
        type_ => || ffi::gst_bus_get_type(),
    }
}

impl Bus {
    #[doc(alias = "gst_bus_new")]
    pub fn new() -> Bus {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gst_bus_new()) }
    }

    #[doc(alias = "gst_bus_add_signal_watch")]
    pub fn add_signal_watch(&self) {
        unsafe {
            ffi::gst_bus_add_signal_watch(self.to_glib_none().0);
        }
    }

    //#[doc(alias = "gst_bus_async_signal_func")]
    //pub fn async_signal_func(&self, message: &Message, data: /*Unimplemented*/Option<Fundamental: Pointer>) -> bool {
    //    unsafe { TODO: call ffi:gst_bus_async_signal_func() }
    //}

    #[doc(alias = "gst_bus_disable_sync_message_emission")]
    pub fn disable_sync_message_emission(&self) {
        unsafe {
            ffi::gst_bus_disable_sync_message_emission(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_bus_enable_sync_message_emission")]
    pub fn enable_sync_message_emission(&self) {
        unsafe {
            ffi::gst_bus_enable_sync_message_emission(self.to_glib_none().0);
        }
    }

    //#[cfg(any(feature = "v1_14", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v1_14")))]
    //#[doc(alias = "gst_bus_get_pollfd")]
    //#[doc(alias = "get_pollfd")]
    //pub fn pollfd(&self, fd: /*Ignored*/glib::PollFD) {
    //    unsafe { TODO: call ffi:gst_bus_get_pollfd() }
    //}

    #[doc(alias = "gst_bus_have_pending")]
    pub fn have_pending(&self) -> bool {
        unsafe { from_glib(ffi::gst_bus_have_pending(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_bus_peek")]
    pub fn peek(&self) -> Option<Message> {
        unsafe { from_glib_full(ffi::gst_bus_peek(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_bus_pop")]
    pub fn pop(&self) -> Option<Message> {
        unsafe { from_glib_full(ffi::gst_bus_pop(self.to_glib_none().0)) }
    }

    #[doc(alias = "gst_bus_post")]
    pub fn post(&self, message: &Message) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_bus_post(self.to_glib_none().0, message.to_glib_full()),
                "Failed to post message"
            )
        }
    }

    #[doc(alias = "gst_bus_remove_signal_watch")]
    pub fn remove_signal_watch(&self) {
        unsafe {
            ffi::gst_bus_remove_signal_watch(self.to_glib_none().0);
        }
    }

    #[doc(alias = "gst_bus_remove_watch")]
    pub fn remove_watch(&self) -> Result<(), glib::error::BoolError> {
        unsafe {
            glib::result_from_gboolean!(
                ffi::gst_bus_remove_watch(self.to_glib_none().0),
                "Bus has no event source"
            )
        }
    }

    #[doc(alias = "gst_bus_set_flushing")]
    pub fn set_flushing(&self, flushing: bool) {
        unsafe {
            ffi::gst_bus_set_flushing(self.to_glib_none().0, flushing.into_glib());
        }
    }

    //#[doc(alias = "gst_bus_sync_signal_handler")]
    //pub fn sync_signal_handler(&self, message: &Message, data: /*Unimplemented*/Option<Fundamental: Pointer>) -> BusSyncReply {
    //    unsafe { TODO: call ffi:gst_bus_sync_signal_handler() }
    //}

    #[doc(alias = "gst_bus_timed_pop")]
    pub fn timed_pop(&self, timeout: impl Into<Option<ClockTime>>) -> Option<Message> {
        unsafe {
            from_glib_full(ffi::gst_bus_timed_pop(
                self.to_glib_none().0,
                timeout.into().into_glib(),
            ))
        }
    }

    #[doc(alias = "message")]
    pub fn connect_message<F: Fn(&Self, &Message) + Send + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn message_trampoline<F: Fn(&Bus, &Message) + Send + 'static>(
            this: *mut ffi::GstBus,
            message: *mut ffi::GstMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            let detailed_signal_name = detail.map(|name| format!("message::{}\0", name));
            let signal_name: &[u8] = detailed_signal_name
                .as_ref()
                .map_or(&b"message\0"[..], |n| n.as_bytes());
            connect_raw(
                self.as_ptr() as *mut _,
                signal_name.as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    message_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "sync-message")]
    pub fn connect_sync_message<F: Fn(&Self, &Message) + Send + Sync + 'static>(
        &self,
        detail: Option<&str>,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn sync_message_trampoline<
            F: Fn(&Bus, &Message) + Send + Sync + 'static,
        >(
            this: *mut ffi::GstBus,
            message: *mut ffi::GstMessage,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            let detailed_signal_name = detail.map(|name| format!("sync-message::{}\0", name));
            let signal_name: &[u8] = detailed_signal_name
                .as_ref()
                .map_or(&b"sync-message\0"[..], |n| n.as_bytes());
            connect_raw(
                self.as_ptr() as *mut _,
                signal_name.as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    sync_message_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl Default for Bus {
    fn default() -> Self {
        Self::new()
    }
}

unsafe impl Send for Bus {}
unsafe impl Sync for Bus {}
