.\" -*- coding: us-ascii -*-
.if \n(.g .ds T< \\FC
.if \n(.g .ds T> \\F[\n[.fam]]
.de URL
\\$2 \(la\\$1\(ra\\$3
..
.if \n(.g .mso www.tmac
.TH pg_exec n "26 September 2016" "" "PostgreSQL Tcl Interface Documentation"
.SH NAME
pg_exec \- send a command to the server
.SH SYNOPSIS
.nf

pg_exec [\*(T<\-paramarray\*(T> arrayVar] \*(T<conn\*(T> \*(T<commandString\*(T> [\*(T<args\*(T>]
.fi
.SH DESCRIPTION
\*(T<\fBpg_exec\fR\*(T> submits a command to the
PostgreSQL server and returns a result.
Command result handles start with the connection handle and add a
period and a result number.
.PP
Note that lack of a Tcl error is not proof that the command
succeeded! An error message returned by the server will be
processed as a command result with failure status, not by
generating a Tcl error in \*(T<\fBpg_exec\fR\*(T>.
.PP
If the [-paramarray] flag is provided, then a substitution is performed on the query, securely replacing
each back-quote delimited name with the corresponding entry from the named array. If the array does not contain the named element,
then NULL is substituted (similarly to the way an array created by -withoutnulls is generated).
Each such name must occur in a location where a value or field name could appear. See pg_select for more info.
.SH ARGUMENTS
.TP 
\*(T<conn\*(T>
The handle of the connection on which to execute the command.
.TP 
\*(T<commandString\*(T>
The SQL command to execute.
.TP 
\*(T<args\*(T>
For PostgreSQL versions greater than 7.4, \*(T<args\*(T>
consists of zero or more optional values that can be inserted,
unquoted, into the SQL statement using $-style substitution. Nulls are represented by the string "NULL".
.SH "RETURN VALUE"
A result handle. A Tcl error will be returned if
pgtcl was unable to obtain a server
response. Otherwise, a command result object is created and a
handle for it is returned. This handle can be passed to
\*(T<\fBpg_result\fR\*(T> to obtain the results of the
command.
.SH EXAMPLE
.nf
\*(T<
pg_exec $conn {select * from table1 where id = $1 and user = $2} $id $user
\*(T>
.fi
