.\" Automatically generated from an mdoc input file.  Do not edit.
.\" zip_source_window_create.mdoc -- create zip data source overlay
.\" Copyright (C) 2021 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <info@libzip.org>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH "ZIP_SOURCE_WINDOW_CREATE" "3" "April 29, 2021" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_source_window_create\fR
\- create zip data source overlay
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIzip_source_t *\fR
.br
.PD 0
.HP 4n
\fBzip_source_window_create\fR(\fIzip_source_t\ *source\fR, \fIzip_uint64_t\ start\fR, \fIzip_int64_t\ len\fR, \fIzip_error_t\ *error\fR);
.PD
.SH "DESCRIPTION"
The
\fBzip_source_window_create\fR()
function create a zip source from an underlying zip source,
restricting access to a particular window starting at byte
\fIstart\fR
and having size
\fIlen\fR.
If
\fIlen\fR
is \-1, the window spans to the end of the underlying source.
.PP
\fBzip_source_window\fR()
and
\fBzip_source_window_create\fR()
don't take ownership of
\fIsource\fR.
The caller is responsible for freeing it.
(This is different to other layered sources.)
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
\fRNULL\fR
is returned and the error code in
\fIerror\fR
is set to indicate the error.
.SH "ERRORS"
\fBzip_source_window_create\fR()
fails if:
.TP 19n
[\fRZIP_ER_INVAL\fR]
\fIsrc\fR
is
\fRNULL\fR;
there is an integer overflow adding
\fIstart\fR
and
\fIlen\fR;
or
\fIlen\fR
is less than \-1.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.SH "SEE ALSO"
libzip(3),
zip_source(3)
zip_source(3)
.SH "HISTORY"
\fBzip_source_window_create\fR()
was added in libzip 1.8.0.
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
