#!/usr/bin/perl -w

# Generates xpm-color-table.h from X11's rgb.txt
# Adapted from gdk-pixbuf (LGPL-2.0-or-later)

if (@ARGV != 1) {
    die "Usage: gen-color-table.pl rgb.txt > xpm-color-table.h\n";
}

open IN, '<', $ARGV[0] or die "Cannot open $ARGV[0]: $!\n";

@colors = ();
while (<IN>) {
    next if /^!/;
    if (!/^\s*([0-9]+)\s+([0-9]+)\s+([0-9]+)\s+(.*\S)\s*$/) {
	die "Cannot parse line $_";
    }

    push @colors, [$1, $2, $3, $4];
}

close IN or die "close IN failed: $!\n";

@colors = sort { lc($a->[3]) cmp lc($b->[3]) } @colors;

$offset = 0;

$date = gmtime;

print <<EOT;
/* SPDX-License-Identifier: LGPL-2.0-or-later */
/* xpm-color-table.h: Generated by gen-color-table.pl from rgb.txt
 *
 *  Date: $date
 *
 * Do not edit.
 */
static const char color_names[] =
EOT

for $color (@colors) {
    $name = $color->[3];

    if ($offset != 0) {
	print qq(\n);
    }
    print qq(	"$name\\0");

    $color->[4] = $offset;
    $offset += length($name) + 1;
}

print ";\n\n";

print <<EOT;
struct xcolor_entry {
	uint16_t name_offset;
	uint8_t red;
	uint8_t green;
	uint8_t blue;
};

static const struct xcolor_entry xcolors[] = {
EOT

$i = 0;
for $color (@colors) {
    $red = $color->[0];
    $green = $color->[1];
    $blue = $color->[2];
    $offset = $color->[4];

    if ($i != 0) {
	print ",\n";
    }
    print "	{ $offset, $red, $green, $blue }";
    $i++;
}

print "\n};\n";
