/*
 * File: pixmaps.h
 *
 * Copyright (C) 2000, 2001 Jorge Arellano Cid <jcid@dillo.org>
 * Design by John Grantham, Dipl.-Designer; http://www.grantham.de/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#ifndef __PIXMAPS_H__
#define __PIXMAPS_H__

/* XPM */
static const char *const left_xpm[] = {
"22 22 8 1 ",
"  c #282C31",
". c #292C31",
"X c #282D31",
"o c #292D31",
"O c #282C32",
"+ c #FF0000",
"@ c #292D32",
"# c None",
/* pixels */
"#########@@@##########",
"########@@@###########",
"#######@@@############",
"######@@@#############",
"#####@@@##############",
"####@@@###############",
"###@@@################",
"##@@@#################",
"#@@@##################",
"@@@###################",
"@@@@@@@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@@@@@@@",
"@@@###################",
"#@@@##################",
"##@@@#################",
"###@@@################",
"####@@@###############",
"#####@@@##############",
"######@@@#############",
"#######@@@#######+++++",
"########@@@#######+++#",
"#########@@@#######+##"
};

/* XPM */
static const char *const right_xpm[] = {
"22 22 10 1",
"  c #272D31",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #FF0000",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%%%%%%%OOO%%%%%%%%%",
"%%%%%%%%%%%OOO%%%%%%%%",
"%%%%%%%%%%%%OOO%%%%%%%",
"%%%%%%%%%%%%%OOO%%%%%%",
"%%%%%%%%%%%%%%OOO%%%%%",
"%%%%%%%%%%%%%%%OOO%%%%",
"%%%%%%%%%%%%%%%%OOO%%%",
"%%%%%%%%%%%%%%%%%OOO%%",
"%%%%%%%%%%%%%%%%%%OOO%",
"%%%%%%%%%%%%%%%%%%%OOO",
"OOOOOOOOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOOOOOOOO",
"%%%%%%%%%%%%%%%%%%%OOO",
"%%%%%%%%%%%%%%%%%%OOO%",
"%%%%%%%%%%%%%%%%%OOO%%",
"%%%%%%%%%%%%%%%%OOO%%%",
"%%%%%%%%%%%%%%%OOO%%%%",
"%%%%%%%%%%%%%%OOO%%%%%",
"%%%%%%%%%%%%%OOO%%%%%%",
"%%%%%%%%%%%%OOO%%+++++",
"%%%%%%%%%%%OOO%%%%+++%",
"%%%%%%%%%%OOO%%%%%%+%%"
};
/* XPM */
static const char *const reload_xpm[] = {
"22 22 10 1",
"  c #282B31",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #282C32",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%@@@@@@@@%%%%%%",
"%%%%%%%@@@@@@@@@@%%%%%",
"%%%%%%@@@%%%%%%@@@%%%@",
"%%%%%@@@%%%%%%%%@@@%@@",
"%%%%@@@%%%%%%%%%%@@@@@",
"%%%@@@%%%%%%%%%%%%@@@@",
"%%@@@%%%%%%%%%%%%@@@@@",
"%@@@%%%%%%%%%%%%@@@@@@",
"@@@%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%@@@",
"%@@@@@@%%%%%%%%%%%@@@%",
"%@@@@@%%%%%%%%%%%@@@%%",
"%@@@@%%%%%%%%%%%@@@%%%",
"%@@@@@%%%%%%%%%@@@%%%%",
"%@@%@@@%%%%%%%@@@%%%%%",
"%@%%%@@@%%%%%@@@%%%%%%",
"%%%%%%@@@@@@@@@%%%%%%%",
"%%%%%%%@@@@@@@%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%"
};
/* XPM */
static const char *const home_xpm[] = {
"22 22 23 1",
"  c #282C2F",
". c #272B30",
"X c #272B32",
"o c #272D30",
"O c #272C32",
"+ c #272D32",
"@ c #292B30",
"# c #282B31",
"$ c #292B31",
"% c #292B32",
"& c #282C30",
"* c #292C30",
"= c #FF0000",
"- c #292D30",
"; c #282C31",
": c #292C31",
"> c #282D31",
", c #292D31",
"< c #282C32",
"1 c #292C32",
"2 c #282D32",
"3 c #292D32",
"4 c None",
/* pixels */
"44444444-----444444444",
"4444444-------44444444",
"444444--.444-------444",
"44444--%44444---4 o444",
"4444--%4444444----%444",
"444--%444444444----444",
"44--%44444444444----44",
"4--%4444444444444----4",
"---444444444444444----",
"---4444444444444444---",
"4--4444444444444444--4",
"4--4444444444444444--4",
"4--4444444444444444--4",
"4--4444444==4444444--4",
"4--444444====444444--4",
"4--444444====444444--4",
"4--4444444==4444444--4",
"4--4444444444444444--4",
"4--4444444444444444--4",
"4--4444444444444444--4",
"%--------------------%",
"----------------------"
};
/* XPM */
static const char *const save_xpm[] = {
"22 22 11 1",
"  c #272C31",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #FF0000",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c #282E32",
"& c None",
/* pixels */
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"..&&&&&&&&&&&&&&&&&&..",
"...&&&&&&&&&&&&&&&&...",
"&...&&&&&&&&&&&&&&...&",
"&&...&&&&&&&&&&&&...&&",
"&&&...&&++++++&&...&&&",
"&&&& ..&&++++&&...&&&&",
"&&&&&...&&++&&...&&&&&",
"&&&&&&...&&&&...&&&&&&",
"&&&&&&&...&&...&&&&&&&",
"&&&&&&&&......&&&&&&&&",
"&&&&&&&&&....&&&&&&&&&",
"&&&&&&&&&&..&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&&&&&&&"
};
/* XPM */
static const char *const stop_xpm[] = {
"22 22 10 1",
"  c #272D32",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #282C32",
"@ c #FF0000",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%$$$$$$$$$$$$$$%%%%",
"%%$$$$$$$$$$$$$$$$$$%%",
"%$$$%%%%%%%%%%%%%%$$$%",
"%$$%%%%%%%%%%%%%%%%$$%",
"$$%%%%%%%%%%%%%%%%%%$$",
"$$%%%%%%%%%%%%%%%%%%$$",
"$$%%%%%%%%%%%%%%%%%%$$",
"$$%%%%%%%%%%%%%%%%%%$$",
"$$%%%%%%@@%%@@%%%%%%$$",
"$$%%%%%%@@@@@@%%%%%%$$",
"$$%%%%%%%@@@@%%%%%%%$$",
"$$%%%%%%%@@@@%%%%%%%$$",
"$$%%%%%%@@@@@@%%%%%%$$",
"$$%%%%%%@@%%@@%%%%%%$$",
"$$%%%%%%%%%%%%%%%%%%$$",
"$$%%%%%%%%%%%%%%%%%%$$",
"$$%%%%%%%%%%%%%%%%%%$$",
"$$%%%%%%%%%%%%%%%%%%$$",
"%$$%%%%%%%%%%%%%%%%$$%",
"%$$$%%%%%%%%%%%%%%$$$%",
"%%$$$$$$$$$$$$$$$$$$%%",
"%%%%$$$$$$$$$$$$$$%%%%"
};
/* XPM */
static const char *const bm_xpm[] = {
"22 22 9 1",
"  c #282C31",
". c #292C31",
"X c #282D31",
"o c #292D31",
"O c #282C32",
"+ c #FF0000",
"@ c #282D32",
"# c #292D32",
"$ c None",
/* pixels */
"$                    $",
"                      ",
"   $$$$$$$  $$++$$$+  ",
"  $$$$$$$$  $$++$$++  ",
"  $$$$$$$$  $$++$+++  ",
"  $$$$$$$$  $$+++++$  ",
"  $$$$$$$$  $$++++$$  ",
"  $$$$$$$$  $$+++$$$  ",
"  $$$$$$$$  $$++$$$$  ",
"  $$$$$$$$  $$+$$$$$  ",
"  $$$$$$$$  $$$$$$$$  ",
"  $$    $$  $$$$$$$$  ",
"  $$    $$  $$$$$$$$  ",
"  $$$$$$$$  $$$$$$$$  ",
"  $$$$$$$$  $$$$$$$$  ",
"  $$    $$  $$$$$$$$  ",
"  $$    $$  $$$$$$$$  ",
"  $$$$$$$$  $$$$$$$$  ",
"  $$$$$$$$  $$$$$$$$  ",
"   $$$$$$$  $$$$$$$   ",
"                      ",
"$                    $"
};
/* XPM */
static const char *const tools_xpm[] = {
"22 22 10 1",
"  c #282C31",
". c #292C31",
"X c #282D31",
"o c #292D31",
"O c #282E31",
"+ c #282C32",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%%%%XXXX%%%%%%%%%%%",
"%%%%%%XXXXXX%%%%%%%%%%",
"%%%%%XXX%%XXX%%%%%%%%%",
"%%%%XXX%%%%XXX%%%%%%%%",
"XXXXXX%%%%%%XXXXXXXXXX",
"%XXXXX%%%%%%XXXXXXXXX%",
"%%%%XXX%%%%XXX%%%%%%%%",
"%%%%%XXX%%XXX%%%%%%%%%",
"%%%%%%XXXXXX%%%%%%%%%%",
"%%%%%%%XXXX%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%%%%%%%%%%%%",
"%%%%%%%%%%%XXXX%%%%%%%",
"%%%%%%%%%%XXXXXX%%%%%%",
"%%%%%%%%%XXX%%XXX%%%%%",
"%%%%%%%%XXX%%%%XXX%%%%",
"%XXXXXXXXX%%%%%%XXXXX%",
"XXXXXXXXXX%%%%%%XXXXXX",
"%%%%%%%%XXX%%%%XXX%%%%",
"%%%%%%%%%XXX%%XXX%%%%%",
"%%%%%%%%%%XXXXXX%%%%%%",
"%%%%%%%%%%%XXXX%%%%%%%"
};
/* Small icons here */

/* XPM */
static const char *const left_s_xpm[] = {
"16 16 8 1",
"  c #282C31",
". c #292C31",
"X c #282D31",
"o c #292D31",
"O c #282C32",
"+ c #FF0000",
"@ c #292D32",
"# c None",
/* pixels */
"######@@@#######",
"#####@@@########",
"####@@@#########",
"###@@@##########",
"##@@@###########",
"#@@@############",
"@@@#############",
"@@@@@@@@@@@@@@@@",
"@@@@@@@@@@@@@@@@",
"@@@#############",
"#@@@############",
"##@@@###########",
"###@@@##########",
"####@@@#########",
"#####@@@#####+++",
"######@@@#####+#",
};
/* XPM */
static const char *const right_s_xpm[] = {
"16 16 10 1",
"  c #272D31",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #FF0000",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%%%%OOO%%%%%%",
"%%%%%%%%OOO%%%%%",
"%%%%%%%%%OOO%%%%",
"%%%%%%%%%%OOO%%%",
"%%%%%%%%%%%OOO%%",
"%%%%%%%%%%%%OOO%",
"%%%%%%%%%%%%%OOO",
"OOOOOOOOOOOOOOOO",
"OOOOOOOOOOOOOOOO",
"%%%%%%%%%%%%%OOO",
"%%%%%%%%%%%%OOO%",
"%%%%%%%%%%%OOO%%",
"%%%%%%%%%%OOO%%%",
"%%%%%%%%%OOO%%%%",
"%%%%%%%%OOO%%+++",
"%%%%%%%OOO%%%%+%",
};
/* XPM */
static const char *const home_s_xpm[] = {
"16 16 23 1",
"  c #282C2F",
". c #272B30",
"X c #272B32",
"o c #272D30",
"O c #272C32",
"+ c #272D32",
"@ c #292B30",
"# c #282B31",
"$ c #292B31",
"% c #292B32",
"& c #282C30",
"* c #292C30",
"= c #FF0000",
"- c #292D30",
"; c #282C31",
": c #292C31",
"> c #282D31",
", c #292D31",
"< c #282C32",
"1 c #292C32",
"2 c #282D32",
"3 c #292D32",
"4 c None",
/* pixels */
"4444444--4444444",
"444444----444444",
"44444--------444",
"4444---44--4 444",
"444---4444---444",
"44---444444---44",
"4---44444444---4",
"---4444444444---",
"---4444444444---",
"4--4444444444--4",
"4--4444==4444--4",
"4--444====444--4",
"4--444====444--4",
"4--4444==4444--4",
"---4444444444---",
"----------------"
};
/* XPM */
static const char *const reload_s_xpm[] = {
"16 16 10 1",
"  c #282B31",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #282C32",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%%%%@@@@%%%%%",
"%%%%%%@@@@@@%%%@",
"%%%%%@@@%%@@@%@@",
"%%%%@@@%%%%@@@@@",
"%%%@@@%%%%%%@@@@",
"%%@@@%%%%%%@@@@@",
"%@@@%%%%%%@@@@@@",
"@@@%%%%%%%%%%%%%",
"%%%%%%%%%%%%%@@@",
"%@@@@@@%%%%%@@@%",
"%@@@@@%%%%%@@@%%",
"%@@@@%%%%%@@@%%%",
"%@@@@@%%%@@@%%%%",
"%@@%@@@%@@@%%%%%",
"%@%%%@@@@@%%%%%%",
"%%%%%%@@@%%%%%%%",
};
/* XPM */
static const char *const save_s_xpm[] = {
"16 16 11 1",
"  c #272C31",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #FF0000",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c #282E32",
"& c None",
/* pixels */
"&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&",
".&&&&&&&&&&&&&&.",
"..&&&&&&&&&&&&..",
"...&&&&&&&&&&...",
"& ..&&++++&&...&",
"&&...&&++&&...&&",
"&&&...&&&&...&&&",
"&&&&...&&...&&&&",
"&&&&&......&&&&&",
"&&&&&&....&&&&&&",
"&&&&&&&..&&&&&&&",
"&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&",
"&&&&&&&&&&&&&&&&"
};
/* XPM */
static const char *const stop_s_xpm[] = {
"16 16 10 1",
"  c #272D32",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #282C32",
"@ c #FF0000",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%$$$$$$$$%%%%",
"%%$$$$$$$$$$$$%%",
"%$$$%%%%%%%%$$$%",
"%$$%%%%%%%%%%%$$%",
"$$%%%%%%%%%%%%$$",
"$$%%%@@%%@@%%%$$",
"$$%%%@@@@@@%%%$$",
"$$%%%%@@@@%%%%$$",
"$$%%%%@@@@%%%%$$",
"$$%%%@@@@@@%%%$$",
"$$%%%@@%%@@%%%$$",
"$$%%%%%%%%%%%%$$",
"%$$%%%%%%%%%%$$%",
"%$$$%%%%%%%%$$$%",
"%%$$$$$$$$$$$$%%",
"%%%%$$$$$$$$%%%%"
};

/* XPM */
static const char *const bm_s_xpm[] = {
"16 16 9 1",
"  c #282C31",
". c #292C31",
"X c #282D31",
"o c #292D31",
"O c #282C32",
"+ c #FF0000",
"@ c #282D32",
"# c #292D32",
"$ c None",
/* pixels */
"$              $",
"                ",
"   $$$$  $$+++  ",
"  $$$$$  $$++$  ",
"  $$$$$  $$+$$  ",
"  $$$$$  $$+$$  ",
"  $$ $$  $$$$$  ",
"  $$ $$  $$$$$  ",
"  $$$$$  $$$$$  ",
"  $$$$$  $$$$$  ",
"  $$ $$  $$$$$  ",
"  $$ $$  $$$$$  ",
"  $$$$$  $$$$$  ",
"   $$$$  $$$$   ",
"                ",
"$              $"
};

/* XPM */
static const char *const tools_s_xpm[] = {
"16 16 10 1",
"  c #282C31",
". c #292C31",
"X c #282D31",
"o c #292D31",
"O c #282E31",
"+ c #282C32",
"@ c #292C32",
"# c #282D32",
"$ c #292D32",
"% c None",
/* pixels */
"%%%%%XXXX%%%%%%%",
"%%%%XXXXXX%%%%%%",
"%%%XXX%%XXX%%%%%",
"XXXXX%%%%XXXXXXX",
"%XXXX%%%%XXXXXX%",
"%%%XXX%%XXX%%%%%",
"%%%%XXXXXX%%%%%%",
"%%%%%XXXX%%%%%%%",
"%%%%%%%XXXX%%%%%",
"%%%%%%XXXXXX%%%%",
"%%%%%XXX%%XXX%%%",
"%XXXXXX%%%%XXXX%",
"XXXXXXX%%%%XXXXX",
"%%%%%XXX%%XXX%%%",
"%%%%%%XXXXXX%%%%",
"%%%%%%%XXXX%%%%%"
};

/* XPM */
static const char *const new_s_xpm[] = {
"11 11 10 1",
"  c #272D32",
". c #282C31",
"X c #292C31",
"o c #282D31",
"O c #292D31",
"+ c #282C32",
"@ c #292C32",
"# c #282D32",
"$ c #FF0000",
"% c None",
/* pixels */
"$$%%%%%%%$$",
"$$$%%%%%$$$",
"%$$$%%%$$$%",
"%%$$$%$$$%%",
"%%%$$$$$%%%",
"%%%%$$$%%%%",
"%%%$$$$$%%%",
"%%$$$%$$$%%",
"%$$$%%%$$$%",
"$$$%%%%%$$$",
"$$%%%%%%%$$",
};

/* XPM */
static const char *const search_xpm[] = {
"14 16 11 1",
"       c None",
".      c #000000",
"+      c #EEEEEE",
"[      c #EE0000",
"}      c #CC0000",
"|      c #BB0000",
"1      c #AA0000",
"2      c #880000",
"3      c #660000",
"4      c #440000",
"5      c #330000",
"   .....      ",
"  ..    .     ",
" ..      .    ",
"..        .   ",
"..        .   ",
"..        .   ",
"..        .   ",
" ..      .    ",
"  ..    .     ",
"   ...545     ",
"       424    ",
"       313    ",
"        2|2   ",
"        2}2   ",
"         2}2  ",
"         11   "};

/* XPM */
static const char *const help_xpm[] = {
"14 16 16 1",
"       c None",
"1      c #DBDBDB",
"2      c #B6B6B6",
"3      c #929292",
"4      c #6D6D6D",
"5      c #F1EFEF",
"6      c #018B00",
"7      c #000000",
"8      c #A4BDA4",
"9      c #FF0000",
"A      c #000000",
"B      c #000000",
"C      c #000000",
"D      c #000000",
"E      c #000000",
"F      c #000000",
"              ",
"     9997     ",
"   99999997   ",
"  999   9997  ",
"  9997  9997  ",
"  9997  9997  ",
"   99  9997   ",
"       999    ",
"      999     ",
"     999      ",
"     99       ",
"              ",
"     99       ",
"    9977      ",
"    9977      ",
"     99       "};

/* XPM */
static const char *const mini_bug_xpm[] = {
"16 16 7 1",
"       c None",
".      c #000000000000",
"r      c #FFFF00000000",
"X      c #BEFBC30BBEFB",
"o      c #861782078617",
"O      c #FFFFFFFFFFFF",
"+      c #30C230C230C2",
"                ",
"     .   .      ",
"      ...       ",
"    X.....X     ",
"    o.O...o     ",
"   o.O...o.o    ",
"   .rrrXrrr.    ",
"  .rrrrXrrrr.   ",
"   .rrrXrrr.    ",
"  .o.rrXrr.o.   ",
"    .rrXrr.     ",
"   .XrrXrrX.    ",
"      .o.       ",
"           .+++.",
"            .o. ",
"             .  "};

/* XPM */
static const char *const mini_ok_xpm[] = {
"15 15 5 1",
"@ c #000000",
"a c #808080",
"b c #303030",
"c c #606060",
"  s none m none c none",
"               ",
"               ",
"            @  ",
"           @@  ",
"          @@@  ",
"         @@@   ",
"   @@   @@@    ",
"  @@@  @@@     ",
"  @@@ @@@      ",
"  @@@@@@       ",
"  @@@@@        ",
"  @@@@         ",
"   @@     @bbb@",
"           @a@ ",
"            @  "
};

#if 0

/* XPM */
static const char *const left_i_xpm[] = {
"22 22 3 1",
"  c None",
". c #000000",
"@ c gray70",
"                      ",
"                      ",
"                      ",
"                      ",
"        @@            ",
"       @@@            ",
"      @@@@            ",
"     @@@@@@@@@@ @@@@  ",
"    @@@@@@@@@@@ @@@@  ",
"   @@@@@@@@@@@@ @@@@  ",
"  @@@@@@@@@@@@@ @@@@  ",
"  @@@@@@@@@@@@@ @@@@  ",
"   @@@@@@@@@@@@ @@@@  ",
"    @@@@@@@@@@@ @@@@  ",
"     @@@@@@@@@@ @@@@  ",
"      @@@@            ",
"       @@@            ",
"        @@            ",
"                 @@@@@",
"                  @ @ ",
"                   @  ",
"                      "};

/* XPM */
static const char *const right_i_xpm[] = {
"22 22 3 1",
"  c None",
". c #000000",
"@ c gray70",
"                      ",
"                      ",
"                      ",
"                      ",
"            @@        ",
"            @@@       ",
"            @@@@      ",
"  @@@@ @@@@@@@@@@     ",
"  @@@@ @@@@@@@@@@@    ",
"  @@@@ @@@@@@@@@@@@   ",
"  @@@@ @@@@@@@@@@@@@  ",
"  @@@@ @@@@@@@@@@@@@  ",
"  @@@@ @@@@@@@@@@@@   ",
"  @@@@ @@@@@@@@@@@    ",
"  @@@@ @@@@@@@@@@     ",
"            @@@@      ",
"            @@@       ",
"            @@        ",
"                 @@@@@",
"                  @ @ ",
"                   @  ",
"                      "};

/* XPM */
static const char *const stop_i_xpm[] = {
/* columns rows colors chars-per-pixel */
"22 22 2 1",
"       c None",
"@      c gray70",
/* pixels */
"                      ",
"                      ",
"      @@@@@@@@@       ",
"     @@@@@@@@@@@      ",
"    @@@@@@@@@@@@@     ",
"   @@@@@@@@@@@@@@@    ",
"  @@@@@@@@@@@@@@@@@   ",
" @@@@@@@@@@@@@@@@@@@  ",
" @@@@@@  @@@  @@@@@@  ",
" @@@@@@   @   @@@@@@  ",
" @@@@@@@     @@@@@@@  ",
" @@@@@@@@   @@@@@@@@  ",
" @@@@@@@     @@@@@@@  ",
" @@@@@@   @   @@@@@@  ",
" @@@@@@  @@@  @@@@@@  ",
" @@@@@@@@@@@@@@@@@@@  ",
"  @@@@@@@@@@@@@@@@@   ",
"   @@@@@@@@@@@@@@@    ",
"    @@@@@@@@@@@@@     ",
"     @@@@@@@@@@@      ",
"      @@@@@@@@@       ",
"                      "
};

/* XPM */
static const char *const stop_si_xpm[] = {
"16 16 2 1",
"       c None",
"@      c gray70",
"    @@@@@@@@    ",
"   @@@@@@@@@@   ",
"  @@@@@@@@@@@@  ",
" @@@@@@@@@@@@@@ ",
"@@@@@@@@@@@@@@@@",
"@@@@@ @@@@ @@@@@",
"@@@@@@ @@ @@@@@@",
"@@@@@@@  @@@@@@@",
"@@@@@@@  @@@@@@@",
"@@@@@@ @@ @@@@@@",
"@@@@@ @@@@ @@@@@",
"@@@@@@@@@@@@@@@@",
" @@@@@@@@@@@@@@ ",
"  @@@@@@@@@@@@  ",
"   @@@@@@@@@@   ",
"    @@@@@@@@    "};

/* XPM */
static const char *const left_si_xpm[] = {
"16 16 2 1",
"       c None",
"@      c gray70",
"                ",
"      @@        ",
"     @@@        ",
"    @@@@        ",
"   @@@@@@@@ @@@@",
"  @@@@@@@@@ @@@@",
" @@@@@@@@@@ @@@@",
"@@@@@@@@@@@ @@@@",
"@@@@@@@@@@@ @@@@",
" @@@@@@@@@@ @@@@",
"  @@@@@@@@@ @@@@",
"   @@@@@@@@ @@@@",
"    @@@@        ",
"     @@@   @@@@@",
"      @@    @ @ ",
"             @  "};

/* XPM */
static const char *const right_si_xpm[] = {
"16 16 2 1",
"       c None",
"@      c gray70",
"                ",
"        @@      ",
"        @@@     ",
"        @@@@    ",
"@@@@ @@@@@@@@   ",
"@@@@ @@@@@@@@@  ",
"@@@@ @@@@@@@@@@ ",
"@@@@ @@@@@@@@@@@",
"@@@@ @@@@@@@@@@@",
"@@@@ @@@@@@@@@@ ",
"@@@@ @@@@@@@@@  ",
"@@@@ @@@@@@@@   ",
"        @@@@    ",
"        @@@@@@@@",
"        @@  @ @ ",
"             @  "};
#endif

#endif /* __PIXMAPS_H__ */
