/*
 * File: pixmaps.h
 *
 * Copyright (C) 2000, 2001 Jorge Arellano Cid <jcid@dillo.org>
 * Design by John Grantham, Dipl.-Designer; http://www.grantham.de/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 */

#ifndef __PIXMAPS_H__
#define __PIXMAPS_H__

/* XPM */
static const char *const left_xpm[] = {
"22 22 46 1",
" 	c None",
".	c #000000",
"+	c #56C4FF",
"@	c #61C6FF",
"#	c #25B1FF",
"$	c #68C5FF",
"%	c #36B2FF",
"&	c #33B1FF",
"*	c #6BC1FF",
"=	c #39ADFF",
"-	c #119CFF",
";	c #61BDFF",
">	c #85CCFF",
",	c #59BAFF",
"'	c #6EBFFF",
")	c #3DA9FF",
"!	c #1697FF",
"~	c #0F94FF",
"{	c #0E88EC",
"]	c #4CA8FF",
"^	c #3B9FFF",
"/	c #1A8FFF",
"(	c #148DFF",
"_	c #1382EC",
":	c #3278C5",
"<	c #156BCB",
"[	c #1982F8",
"}	c #1A86FF",
"|	c #187CEC",
"1	c #31619F",
"2	c #1863C5",
"3	c #1E7CF8",
"4	c #1F80FF",
"5	c #1D77EC",
"6	c #325C9F",
"7	c #1C5EC5",
"8	c #2377F8",
"9	c #14438C",
"0	c #0C2A58",
"a	c #134189",
"b	c #35599F",
"c	c #205AC5",
"d	c #1E54B9",
"e	c #395AA4",
"f	c #2356C7",
"g	c #1C3E93",
"                      ",
"                      ",
"                      ",
"                      ",
"        ..            ",
"       .+.            ",
"      .@#.            ",
"     .$%&...... ....  ",
"    .*=-=;>>>,. .,,.  ",
"   .')!~~~~~~{. .{{.  ",
"  .]^/(((((((_. .__.  ",
"  .:<[}}}}}}}|. .||.  ",
"   .1234444445. .55.  ",
"    .67879000a. .aa.  ",
"     .bcd...... ....  ",
"      .ef.            ",
"       .g.            ",
"        ..            ",
"                 .....",
"                  .>. ",
"                   .  ",
"                      "};

/* XPM */
static const char *const right_xpm[] = {
"22 22 46 1",
" 	c None",
".	c #333333",
"+	c #7497B2",
"@	c #307DB7",
"#	c #809EB6",
"$	c #3D89C1",
"%	c #428BC0",
"&	c #84A5BE",
"*	c #749FBD",
"=	c #99B8CE",
"-	c #7BA4C0",
";	c #4490C5",
">	c #0A7CCD",
",	c #84A9C4",
"'	c #007BD3",
")	c #0081DC",
"!	c #0A83D9",
"~	c #4A95CB",
"{	c #84AECB",
"]	c #0083DE",
"^	c #0088E8",
"/	c #0A8BE6",
"(	c #4397D3",
"_	c #5E9FCB",
":	c #008AEA",
"<	c #0091F5",
"[	c #008FF0",
"}	c #007FD7",
"|	c #2D8ACA",
"1	c #0090F6",
"2	c #0299FF",
"3	c #0096FC",
"4	c #0084DD",
"5	c #2F7FB8",
"6	c #0073BF",
"7	c #005F9F",
"8	c #0072C2",
"9	c #008AE6",
"0	c #099CFF",
"a	c #2F85BF",
"b	c #008AE8",
"c	c #0090F0",
"d	c #2D88C6",
"e	c #0095F9",
"f	c #2C8ED0",
"g	c #0080D7",
"                      ",
"                      ",
"                      ",
"                      ",
"            ..        ",
"            .+.       ",
"            .@#.      ",
"  .... ......$%&.     ",
"  .**. .*===-;>;,.    ",
"  .''. .'))))))!~{.   ",
"  .]]. .]^^^^^^^/(_.  ",
"  .::. .:<<<<<<<[}|.  ",
"  .11. .1222222345.   ",
"  .66. .67778909a.    ",
"  .... ......bcd.     ",
"            .ef.      ",
"            .g.       ",
"            ..        ",
"                 .....",
"                  .=. ",
"                   .  ",
"                      "};

/* XPM */
static const char *const reload_xpm[] = {
"20 20 18 1",
" 	c None",
".	c #5C7FCE",
"+	c #6686CE",
"@	c #6586CE",
"#	c #5379CD",
"$	c #7297E5",
"%	c #3D6ACF",
"&	c #7992C9",
"*	c #6484CE",
"=	c #79A2FF",
"-	c #769DF0",
";	c #6284CE",
">	c #6A8ACF",
",	c #436ECE",
"'	c #5E81CE",
")	c #3B68D0",
"!	c #7891C9",
"~	c #6C8ACD",
"                    ",
"                    ",
"        .+@.#       ",
"      ++++++++$  %  ",
"     ++++&&&&+++%%  ",
"    ++&+++&&&&&+&%  ",
"   *+&%++%%%&&&+&%  ",
"   ++++=    %%&++%  ",
"  %+++=    %%&&&&%  ",
"  %++-    %%%%%%%%  ",
"  &+++              ",
"  &+;+              ",
"  &++               ",
"  %++%          >   ",
"   %&%%        >    ",
"    %&&,'    %>>    ",
"    )&&!~  %%>>=    ",
"     %%%&&&&>>=     ",
"       =>>>         ",
"                    "};

/* XPM */
static const char *const home_xpm[] = {
"20 20 5 1",
" 	c None",
".	c #0000FF",
"+	c #9292DB",
"@	c #DBFFFF",
"#	c #494992",
"                    ",
"                    ",
"         ..         ",
"        ....+       ",
"       ......+      ",
"      ........+     ",
"     ..........+    ",
"    .....+ .....+   ",
"   .....+   .....+  ",
"  .....+     .....+ ",
" .....+       .....+",
" ....+   ++++  ....+",
"  ...    +@@+   ..+ ",
"    .    +@@+    .  ",
"    .    +++     .  ",
"    .    +##     .  ",
"    .    +###    .  ",
"    .....+........  ",
"                    ",
"                    "
};

/* XPM */
static const char *const save_xpm[] = {
"22 22 62 1",
" 	c None",
".	c #5959CB",
"+	c #6D6DD0",
"@	c #6C6CD0",
"#	c #6A6ACF",
"$	c #6A6AD0",
"%	c #464646",
"&	c #2D2DAC",
"*	c #798D79",
"=	c #BDD0BD",
"-	c #4242C6",
";	c #297DA2",
">	c #0003DC",
",	c #0720CE",
"'	c #1347C4",
")	c #6464CE",
"!	c #236CAE",
"~	c #0415D3",
"{	c #0000DC",
"]	c #1E61B7",
"^	c #5D5DCB",
"/	c #0414D5",
"(	c #0412D6",
"_	c #0C29CB",
":	c #081ED1",
"<	c #4C4CC8",
"[	c #1F50B1",
"}	c #0716D4",
"|	c #3F873F",
"1	c #0304DA",
"2	c #0B21D0",
"3	c #0410D8",
"4	c #081DD3",
"5	c #2354AF",
"6	c #0C21CB",
"7	c #6868CF",
"8	c #5353C9",
"9	c #6968CF",
"0	c #6363CD",
"a	c #1E41B2",
"b	c #A5A5A5",
"c	c #B8B8B8",
"d	c #C8C8C8",
"e	c #B4B4B4",
"f	c #868686",
"g	c #848484",
"h	c #939393",
"i	c #A6A6A6",
"j	c #3838BE",
"k	c #9E9E9E",
"l	c #6060CC",
"m	c #B5B5B5",
"n	c #6B6AD0",
"o	c #D0D0D0",
"p	c #CDCDCD",
"q	c #C4C4C4",
"r	c #BABABA",
"s	c #0C1DCB",
"t	c #487C8A",
"u	c #B1B1B1",
"v	c #919191",
"w	c #6666CE",
"                      ",
"                      ",
"   .+++++@@##@@++$%   ",
"  & *============* $  ",
"  -;>            ,')  ",
"  -!~            {].  ",
"  ^ >            { -  ",
"  $ /            { #  ",
"  - (            > ^  ",
"  ^ _            : <  ",
"  + [            } &  ",
"  +  ||1{122234>5  .  ",
"  + 6#@77..8<^9^0a +  ",
"  + &bbbcddddddde@ +  ",
"  + ^f^^g       h@ +  ",
"  + #i&jkiiiiiiikl -  ",
"  @ )m^^ mmmmmmm n ^  ",
"  - $o&%pqqqqqqqr7s^  ",
"  ^t-uuuh       v<.   ",
"   ..)#)..l^$$##w$    ",
"                      ",
"                      "};

/* XPM */
static const char *const stop_xpm[] = {
"22 22 77 1",
"       c None",
".      c #000000",
"+      c #703434",
"@      c #E57F7F",
"#      c #E68080",
"$      c #6F2929",
"%      c #DB4343",
"&      c #D31A1A",
"*      c #CE0000",
"=      c #DC4343",
"-      c #D51A1A",
";      c #D00000",
">      c #702929",
",      c #DF4343",
"'      c #D71A1A",
")      c #D30000",
"!      c #6F1B1B",
"~      c #E14343",
"{      c #DA1A1A",
"]      c #D60000",
"^      c #A66666",
"/      c #841717",
"(      c #DA0404",
"_      c #DD1A1A",
":      c #D90000",
"<      c #D56B6B",
"[      c #FFFFFF",
"}      c #E7D5D5",
"|      c #861717",
"1      c #CC0000",
"2      c #DC0000",
"3      c #E64C4C",
"4      c #FADEDE",
"5      c #EAD5D5",
"6      c #722C2C",
"7      c #CF0000",
"8      c #E00000",
"9      c #EB5C5C",
"0      c #FBDFDF",
"a      c #FDF8F8",
"b      c #E40000",
"c      c #DE3535",
"d      c #FEF8F8",
"e      c #E70000",
"f      c #971C1C",
"g      c #EED5D5",
"h      c #FEFAFA",
"i      c #EB0000",
"j      c #AA1C1C",
"k      c #EFD5D5",
"l      c #FDE3E3",
"m      c #F69595",
"n      c #C50000",
"o      c #D50000",
"p      c #EF0000",
"q      c #F77777",
"r      c #FDE4E4",
"s      c #F56565",
"t      c #4D0000",
"u      c #9E0000",
"v      c #D70000",
"w      c #F20000",
"x      c #FAA7A7",
"y      c #F76969",
"z      c #420000",
"A      c #A00000",
"B      c #DA0000",
"C      c #F50000",
"D      c #A20000",
"E      c #DD0000",
"F      c #F80000",
"G      c #430000",
"H      c #A40000",
"I      c #DF0000",
"J      c #FB0000",
"K      c #380000",
"L      c #570000",
"                      ",
"                      ",
"      .........       ",
"     .+@#####@+.      ",
"    .$%&*****&%$.     ",
"   .$=-;;;;;;;-=$.    ",
"  .>,')))))))))',>.   ",
" .!~{]]^/]]]/^]]{~!.  ",
" .(_::<[}|:|}[<::_(.  ",
" .122234[565[432221.  ",
" .7888890[a[0988887.  ",
" .)bbbbbcd[dcbbbbb).  ",
" .]eeeefg[h[gfeeee].  ",
" .:iiijk[lml[kjiii:.  ",
" .noppq[rspsr[qppon.  ",
" .tuvwwxywwwyxwwvut.  ",
"  .zABCCCCCCCCCBAz.   ",
"   .zDEFFFFFFFEDz.    ",
"    .GHIJJJJJIHG.     ",
"     .KLLLLLLLK.      ",
"      .........       ",
"                      "};

/* XPM */
static const char *const bm_xpm[] = {
"20 20 285 2",
"  	c None",
". 	c #E1DDE3",
"+ 	c #CCCCD5",
"@ 	c #BFC4CB",
"# 	c #BAC1CB",
"$ 	c #C1C9D1",
"% 	c #C5CBD5",
"& 	c #C5CCD6",
"* 	c #C2CBD6",
"= 	c #B9C7D1",
"- 	c #B8C7D2",
"; 	c #B5C6D0",
"> 	c #B4C5CF",
", 	c #B8C7D0",
"' 	c #B4C1CC",
") 	c #ABB8C3",
"! 	c #96A1AC",
"~ 	c #C5C2CA",
"{ 	c #BBBCC8",
"] 	c #D9E0E5",
"^ 	c #E2EEF1",
"/ 	c #E0EAF1",
"( 	c #DEE8F1",
"_ 	c #DAE7F1",
": 	c #D7E6F0",
"< 	c #D5E7F1",
"[ 	c #D0E5F2",
"} 	c #CCE3F4",
"| 	c #CDE7F5",
"1 	c #CBE2F3",
"2 	c #CFE2F3",
"3 	c #DAE7F3",
"4 	c #798FA9",
"5 	c #B5B4BF",
"6 	c #AEAFBB",
"7 	c #959BAB",
"8 	c #95A4B7",
"9 	c #98A8BF",
"0 	c #97A7BE",
"a 	c #8E9FBC",
"b 	c #7C93BA",
"c 	c #7492BC",
"d 	c #618DBF",
"e 	c #4E8CC5",
"f 	c #268CD6",
"g 	c #3089CD",
"h 	c #4A88C1",
"i 	c #C7D5E7",
"j 	c #748AAE",
"k 	c #B4B2BE",
"l 	c #BDBECA",
"m 	c #A2A9B7",
"n 	c #ADBCCF",
"o 	c #B0C2D7",
"p 	c #A9BCD2",
"q 	c #A8B9D0",
"r 	c #A1B3CB",
"s 	c #9BB0CA",
"t 	c #91AAC7",
"u 	c #86A6C8",
"v 	c #82A4C7",
"w 	c #7B9DC4",
"x 	c #6B96C7",
"y 	c #CEDFF5",
"z 	c #758EB4",
"A 	c #AEACB8",
"B 	c #B6B7C2",
"C 	c #9CA5B3",
"D 	c #A8BACF",
"E 	c #A9BFD7",
"F 	c #A2B6CE",
"G 	c #A1B4CB",
"H 	c #9BAEC5",
"I 	c #94ACC5",
"J 	c #8BA9C7",
"K 	c #7BA1CA",
"L 	c #7FA3CB",
"M 	c #779DC9",
"N 	c #6292CC",
"O 	c #CBDBF5",
"P 	c #7C92B5",
"Q 	c #A2A1AD",
"R 	c #AEB1B8",
"S 	c #949FAC",
"T 	c #A0B4C8",
"U 	c #A6BCD2",
"V 	c #A0B4CB",
"W 	c #A9BCD0",
"X 	c #B1C3D7",
"Y 	c #9EB4CE",
"Z 	c #7C9EC4",
"` 	c #86A8CB",
" .	c #6B98CB",
"..	c #759BC9",
"+.	c #6B93CB",
"@.	c #CBDBF7",
"#.	c #5E7BB8",
"$.	c #A09FA9",
"%.	c #ACAEB4",
"&.	c #8C9BA6",
"*.	c #96ABBC",
"=.	c #A2B6CB",
"-.	c #9DB0C5",
";.	c #B0C0D0",
">.	c #C9D9E4",
",.	c #B9CAD9",
"'.	c #86A1BC",
").	c #7B9FC5",
"!.	c #789CC8",
"~.	c #7B9CC8",
"{.	c #6190CD",
"].	c #D0E0FA",
"^.	c #5A79B9",
"/.	c #9D9AA5",
"(.	c #A5A6AA",
"_.	c #86969F",
":.	c #9FB4C3",
"<.	c #A2B8CB",
"[.	c #8EA4B8",
"}.	c #B4C4D2",
"|.	c #DBEAF3",
"1.	c #C2D4E2",
"2.	c #7598B7",
"3.	c #6F99C1",
"4.	c #7098C6",
"5.	c #6D92C4",
"6.	c #688CC9",
"7.	c #CCD9F6",
"8.	c #5B78B8",
"9.	c #969297",
"0.	c #9D9B9D",
"a.	c #818B9C",
"b.	c #ABBED1",
"c.	c #D8ECF8",
"d.	c #E9FAFF",
"e.	c #EBF9FE",
"f.	c #ECF9FF",
"g.	c #EDFBFE",
"h.	c #EBFEFE",
"i.	c #DBF2FB",
"j.	c #B2CBE3",
"k.	c #6992C3",
"l.	c #5587CF",
"m.	c #D1E1F8",
"n.	c #6E85B8",
"o.	c #958E8B",
"p.	c #999698",
"q.	c #75819E",
"r.	c #8FA2BC",
"s.	c #ABBDCE",
"t.	c #C5D7E1",
"u.	c #E3F1F8",
"v.	c #EEFAFF",
"w.	c #E6F5FB",
"x.	c #D1E3ED",
"y.	c #A3BAD0",
"z.	c #6C97C6",
"A.	c #7195C4",
"B.	c #5186CD",
"C.	c #CEDDF2",
"D.	c #637CBA",
"E.	c #90847C",
"F.	c #918E91",
"G.	c #6C7A9E",
"H.	c #8D9FB9",
"I.	c #809CB9",
"J.	c #B7CBDE",
"K.	c #EBF9FF",
"L.	c #F1FFFF",
"M.	c #EFFDFF",
"N.	c #C9E0F1",
"O.	c #2987D1",
"P.	c #6692C2",
"Q.	c #5889CB",
"R.	c #D2DEF5",
"S.	c #5474B6",
"T.	c #8A7673",
"U.	c #86848C",
"V.	c #6275A0",
"W.	c #7B94B4",
"X.	c #879EBA",
"Y.	c #C5D7E5",
"Z.	c #E1F1FA",
"`.	c #CCDAE7",
" +	c #D4E4EE",
".+	c #D4E9F4",
"++	c #85A5CA",
"@+	c #6794C4",
"#+	c #5B8BC6",
"$+	c #5086CB",
"%+	c #CDD9F0",
"&+	c #6F84B2",
"*+	c #837377",
"=+	c #7D7989",
"-+	c #536AA5",
";+	c #6E8AB5",
">+	c #9AB0CD",
",+	c #B7CBDD",
"'+	c #AABFD5",
")+	c #7C9DC1",
"!+	c #8CAACB",
"~+	c #B0C6DA",
"{+	c #9BB5D6",
"]+	c #4B89CD",
"^+	c #5486CA",
"/+	c #638EC7",
"(+	c #C5D4EC",
"_+	c #6D83B2",
":+	c #82707F",
"<+	c #747289",
"[+	c #4A66A8",
"}+	c #7792BC",
"|+	c #8AA7CC",
"1+	c #85A3CD",
"2+	c #7A9BC4",
"3+	c #6992C1",
"4+	c #6693C6",
"5+	c #769ECF",
"6+	c #6A9BDA",
"7+	c #6091CF",
"8+	c #4C84D1",
"9+	c #4E72D7",
"0+	c #CFDFF6",
"a+	c #3F67CB",
"b+	c #7A6A7D",
"c+	c #6B6A89",
"d+	c #3E5FAD",
"e+	c #7A93BF",
"f+	c #7B9BC9",
"g+	c #638FC8",
"h+	c #6C92C7",
"i+	c #6F96C9",
"j+	c #6292CD",
"k+	c #5890D1",
"l+	c #4D8AD5",
"m+	c #598DD2",
"n+	c #4982D2",
"o+	c #4978DA",
"p+	c #D6E4F8",
"q+	c #486AC5",
"r+	c #5E3782",
"s+	c #63628C",
"t+	c #395CAF",
"u+	c #748EBD",
"v+	c #7E9BC5",
"w+	c #7093C5",
"x+	c #7093C4",
"y+	c #6B92C6",
"z+	c #608FCA",
"A+	c #5A8ECD",
"B+	c #5A8BCD",
"C+	c #5586CD",
"D+	c #6289C9",
"E+	c #4E7DC9",
"F+	c #A6B4CF",
"G+	c #687CB2",
"H+	c #948BA3",
"I+	c #63689A",
"J+	c #4566AD",
"K+	c #6F86B4",
"L+	c #7A91B9",
"M+	c #768FB9",
"N+	c #738FB9",
"O+	c #6D8DBB",
"P+	c #6489BE",
"Q+	c #5F87C0",
"R+	c #5D86C1",
"S+	c #5D83C0",
"T+	c #6D86B9",
"U+	c #647EB4",
"V+	c #6A7BAA",
"W+	c #6F80AD",
"X+	c #6975A1",
"Y+	c #4C6DAC",
"Z+	c #6C81AF",
"`+	c #7085B0",
" @	c #7187B1",
".@	c #7089B2",
"+@	c #6D88B3",
"@@	c #6485B5",
"#@	c #6183B8",
"$@	c #5F82B9",
"%@	c #5B7DB8",
"&@	c #6882B2",
"*@	c #7586AD",
"                                        ",
"                                        ",
"    . + @ # $ % & * = - ; > , ' ) !     ",
"    ~ { ] ^ / ( _ : < [ } | 1 2 3 4     ",
"    5 6 7 8 9 0 a b c d e f g h i j     ",
"    k l m n o p q r s t u v w x y z     ",
"    A B C D E F G H I J K L M N O P     ",
"    Q R S T U V W X Y Z `  ...+.@.#.    ",
"    $.%.&.*.=.-.;.>.,.'.).!.~.{.].^.    ",
"    /.(._.:.<.[.}.|.1.2.3.4.5.6.7.8.    ",
"    9.0.a.b.c.d.e.f.g.h.i.j.k.l.m.n.    ",
"    o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.D.    ",
"    E.F.G.H.I.J.K.L.M.N.O.P.k.Q.R.S.    ",
"    T.U.V.W.X.Y.Z.`. +.+++@+#+$+%+&+    ",
"    *+=+-+;+>+,+'+)+!+~+{+]+^+/+(+_+    ",
"    :+<+[+}+|+1+2+3+4+5+6+7+8+9+0+a+    ",
"    b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+    ",
"    r+s+t+u+v+w+x+y+z+A+B+C+D+E+F+G+    ",
"    H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+    ",
"      X+Y+Z+`+ @.@+@@@#@$@%@&@*@        "};

/* XPM */
static const char *const tools_xpm[] = {
"22 22 75 1",
" 	c None",
".	c #5877CB",
"+	c #5A79CA",
"@	c #5978CA",
"#	c #5A79CC",
"$	c #637FC8",
"%	c #5D7CCB",
"&	c #5876CB",
"*	c #5D7BC9",
"=	c #6482D0",
"-	c #647FC6",
";	c #A2A6CC",
">	c #617FC8",
",	c #5A7ACC",
"'	c #8094CA",
")	c #5978CB",
"!	c #5F7CC9",
"~	c #607DC8",
"{	c #5A79CB",
"]	c #5B7ACB",
"^	c #5C7BCA",
"/	c #5274CC",
"(	c #879BCC",
"_	c #5A7BCF",
":	c #6782C9",
"<	c #6480C8",
"[	c #5B7BCB",
"}	c #6280CC",
"|	c #6681C6",
"1	c #7D94CC",
"2	c #5777CD",
"3	c #5676CB",
"4	c #5375CC",
"5	c #92A3D2",
"6	c #5777CC",
"7	c #6683CC",
"8	c #6883C9",
"9	c #B8C6E9",
"0	c #7B91CC",
"a	c #6883C7",
"b	c #8397CC",
"c	c #B7C5E6",
"d	c #758CC7",
"e	c #8594CC",
"f	c #617EC7",
"g	c #778DC8",
"h	c #5676CC",
"i	c #90A2D0",
"j	c #7189C6",
"k	c #5F7BC9",
"l	c #446BD2",
"m	c #96A8D3",
"n	c #6F88C6",
"o	c #607CC8",
"p	c #7C94CD",
"q	c #7990CC",
"r	c #758ECC",
"s	c #758DCC",
"t	c #6D85C6",
"u	c #6580C6",
"v	c #7C92CA",
"w	c #7F96D2",
"x	c #6983C6",
"y	c #6882C6",
"z	c #8297CE",
"A	c #6E89CC",
"B	c #7189C5",
"C	c #8699CA",
"D	c #758BC6",
"E	c #6481CA",
"F	c #6482CC",
"G	c #708ACC",
"H	c #748DCD",
"I	c #5D7BCC",
"J	c #5C7ED3",
"                      ",
"                      ",
"                      ",
"         .++@         ",
"         #$%&*        ",
"         =-;;>@       ",
"          ,';;;@      ",
"    @     )!~;;;+     ",
"   @@{     @+;;;]     ",
"   @^;)     /(;;#_    ",
"   @:;;+    <;;;[}    ",
"   @|;;123^45;;;67    ",
"    8;;;90abc;;;de    ",
"    ^^f;;;;;;;;;g     ",
"     ~hi;;;;;;;;;j    ",
"      klm;;;;;;;;no   ",
"       ^hpqrstu;;;;v  ",
"             wxy;;;z  ",
"              A~BCDE  ",
"               FGHIJ  ",
"                      ",
"                      "};
/* XPM */
static const char *const newtab_xpm[] = {
"22 22 75 1",
" 	c None",
"B	c #5877CB",
"C	c #5A79CA",
"D	c #5978CA",
"E	c #5A79CC",
"F	c #637FC8",
"G	c #5D7CCB",
"H	c #5876CB",
"I	c #5D7BC9",
"J	c #6482D0",
"K	c #647FC6",
"L	c #A2A6CC",
"M	c #617FC8",
"N	c #5A7ACC",
"O	c #8094CA",
"P	c #5978CB",
"Q	c #5F7CC9",
"R	c #607DC8",
"S	c #5A79CB",
"T	c #5B7ACB",
"U	c #5C7BCA",
"V	c #5274CC",
"W	c #879BCC",
"X	c #5A7BCF",
"Y	c #6782C9",
"Z	c #6480C8",
"a	c #5B7BCB",
"b	c #6280CC",
"c	c #6681C6",
"d	c #7D94CC",
"e	c #5777CD",
"f	c #5676CB",
"g	c #5375CC",
"h	c #92A3D2",
"i	c #5777CC",
"j	c #6683CC",
"k	c #6883C9",
"l	c #B8C6E9",
"m	c #7B91CC",
"n	c #6883C7",
"o	c #8397CC",
"p	c #B7C5E6",
"q	c #758CC7",
"r	c #8594CC",
"s	c #617EC7",
"t	c #778DC8",
"u	c #5676CC",
"v	c #90A2D0",
"w	c #7189C6",
"x	c #5F7BC9",
"y	c #446BD2",
"z	c #96A8D3",
"0	c #6F88C6",
"1	c #607CC8",
"2	c #7C94CD",
"3	c #7990CC",
"4	c #758ECC",
"5	c #758DCC",
"6	c #6D85C6",
"7	c #6580C6",
"8	c #7C92CA",
"9	c #7F96D2",
"+	c #6983C6",
"/	c #6882C6",
"!	c #8297CE",
"#	c #6E89CC",
"$	c #7189C5",
"%	c #8699CA",
"&	c #758BC6",
"'	c #6481CA",
"(	c #6482CC",
")	c #708ACC",
"*	c #748DCD",
",	c #5D7BCC",
"-	c #5C7ED3",
"                      ",
"      BBBBBBBBBB      ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
" BBBBBBLLLLLLLLBBBBBB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BBBBBBLLLLLLLLBBBBBB ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
"      BLLLLLLLLB      ",
"      BBBBBBBBBB      ",
"                      "
};

/* Small icons here */

/* XPM */
static const char *const left_s_xpm[] = {
"22 22 46 1",
" 	c None",
".	c #000000",
"+	c #56C4FF",
"@	c #61C6FF",
"#	c #25B1FF",
"$	c #68C5FF",
"%	c #36B2FF",
"&	c #33B1FF",
"*	c #6BC1FF",
"=	c #39ADFF",
"-	c #119CFF",
";	c #61BDFF",
">	c #85CCFF",
",	c #59BAFF",
"'	c #6EBFFF",
")	c #3DA9FF",
"!	c #1697FF",
"~	c #0F94FF",
"{	c #0E88EC",
"]	c #4CA8FF",
"^	c #3B9FFF",
"/	c #1A8FFF",
"(	c #148DFF",
"_	c #1382EC",
":	c #3278C5",
"<	c #156BCB",
"[	c #1982F8",
"}	c #1A86FF",
"|	c #187CEC",
"1	c #31619F",
"2	c #1863C5",
"3	c #1E7CF8",
"4	c #1F80FF",
"5	c #1D77EC",
"6	c #325C9F",
"7	c #1C5EC5",
"8	c #2377F8",
"9	c #14438C",
"0	c #0C2A58",
"a	c #134189",
"b	c #35599F",
"c	c #205AC5",
"d	c #1E54B9",
"e	c #395AA4",
"f	c #2356C7",
"g	c #1C3E93",
"                      ",
"                      ",
"                      ",
"                      ",
"        ..            ",
"       .+.            ",
"      .@#.            ",
"     .$%&...... ....  ",
"    .*=-=;>>>,. .,,.  ",
"   .')!~~~~~~{. .{{.  ",
"  .]^/(((((((_. .__.  ",
"  .:<[}}}}}}}|. .||.  ",
"   .1234444445. .55.  ",
"    .67879000a. .aa.  ",
"     .bcd...... ....  ",
"      .ef.            ",
"       .g.            ",
"        ..            ",
"                 .....",
"                  .>. ",
"                   .  ",
"                      "};
/* XPM */
static const char *const right_s_xpm[] = {
"22 22 46 1",
" 	c None",
".	c #333333",
"+	c #7497B2",
"@	c #307DB7",
"#	c #809EB6",
"$	c #3D89C1",
"%	c #428BC0",
"&	c #84A5BE",
"*	c #749FBD",
"=	c #99B8CE",
"-	c #7BA4C0",
";	c #4490C5",
">	c #0A7CCD",
",	c #84A9C4",
"'	c #007BD3",
")	c #0081DC",
"!	c #0A83D9",
"~	c #4A95CB",
"{	c #84AECB",
"]	c #0083DE",
"^	c #0088E8",
"/	c #0A8BE6",
"(	c #4397D3",
"_	c #5E9FCB",
":	c #008AEA",
"<	c #0091F5",
"[	c #008FF0",
"}	c #007FD7",
"|	c #2D8ACA",
"1	c #0090F6",
"2	c #0299FF",
"3	c #0096FC",
"4	c #0084DD",
"5	c #2F7FB8",
"6	c #0073BF",
"7	c #005F9F",
"8	c #0072C2",
"9	c #008AE6",
"0	c #099CFF",
"a	c #2F85BF",
"b	c #008AE8",
"c	c #0090F0",
"d	c #2D88C6",
"e	c #0095F9",
"f	c #2C8ED0",
"g	c #0080D7",
"                      ",
"                      ",
"                      ",
"                      ",
"            ..        ",
"            .+.       ",
"            .@#.      ",
"  .... ......$%&.     ",
"  .**. .*===-;>;,.    ",
"  .''. .'))))))!~{.   ",
"  .]]. .]^^^^^^^/(_.  ",
"  .::. .:<<<<<<<[}|.  ",
"  .11. .1222222345.   ",
"  .66. .67778909a.    ",
"  .... ......bcd.     ",
"            .ef.      ",
"            .g.       ",
"            ..        ",
"                 .....",
"                  .=. ",
"                   .  ",
"                      "};
/* XPM */
static const char *const reload_s_xpm[] = {
"20 20 18 1",
" 	c None",
".	c #5C7FCE",
"+	c #6686CE",
"@	c #6586CE",
"#	c #5379CD",
"$	c #7297E5",
"%	c #3D6ACF",
"&	c #7992C9",
"*	c #6484CE",
"=	c #79A2FF",
"-	c #769DF0",
";	c #6284CE",
">	c #6A8ACF",
",	c #436ECE",
"'	c #5E81CE",
")	c #3B68D0",
"!	c #7891C9",
"~	c #6C8ACD",
"                    ",
"                    ",
"        .+@.#       ",
"      ++++++++$  %  ",
"     ++++&&&&+++%%  ",
"    ++&+++&&&&&+&%  ",
"   *+&%++%%%&&&+&%  ",
"   ++++=    %%&++%  ",
"  %+++=    %%&&&&%  ",
"  %++-    %%%%%%%%  ",
"  &+++              ",
"  &+;+              ",
"  &++               ",
"  %++%          >   ",
"   %&%%        >    ",
"    %&&,'    %>>    ",
"    )&&!~  %%>>=    ",
"     %%%&&&&>>=     ",
"       =>>>         ",
"                    "};
/* XPM */
static const char *const home_s_xpm[] = {
"20 20 5 1",
" 	c None",
".	c #0000FF",
"+	c #9292DB",
"@	c #DBFFFF",
"#	c #494992",
"                    ",
"                    ",
"         ..         ",
"        ....+       ",
"       ......+      ",
"      ........+     ",
"     ..........+    ",
"    .....+ .....+   ",
"   .....+   .....+  ",
"  .....+     .....+ ",
" .....+       .....+",
" ....+   ++++  ....+",
"  ...    +@@+   ..+ ",
"    .    +@@+    .  ",
"    .    +++     .  ",
"    .    +##     .  ",
"    .    +###    .  ",
"    .....+........  ",
"                    ",
"                    "
};
/* XPM */
static const char *const save_s_xpm[] = {
"22 22 62 1",
" 	c None",
".	c #5959CB",
"+	c #6D6DD0",
"@	c #6C6CD0",
"#	c #6A6ACF",
"$	c #6A6AD0",
"%	c #464646",
"&	c #2D2DAC",
"*	c #798D79",
"=	c #BDD0BD",
"-	c #4242C6",
";	c #297DA2",
">	c #0003DC",
",	c #0720CE",
"'	c #1347C4",
")	c #6464CE",
"!	c #236CAE",
"~	c #0415D3",
"{	c #0000DC",
"]	c #1E61B7",
"^	c #5D5DCB",
"/	c #0414D5",
"(	c #0412D6",
"_	c #0C29CB",
":	c #081ED1",
"<	c #4C4CC8",
"[	c #1F50B1",
"}	c #0716D4",
"|	c #3F873F",
"1	c #0304DA",
"2	c #0B21D0",
"3	c #0410D8",
"4	c #081DD3",
"5	c #2354AF",
"6	c #0C21CB",
"7	c #6868CF",
"8	c #5353C9",
"9	c #6968CF",
"0	c #6363CD",
"a	c #1E41B2",
"b	c #A5A5A5",
"c	c #B8B8B8",
"d	c #C8C8C8",
"e	c #B4B4B4",
"f	c #868686",
"g	c #848484",
"h	c #939393",
"i	c #A6A6A6",
"j	c #3838BE",
"k	c #9E9E9E",
"l	c #6060CC",
"m	c #B5B5B5",
"n	c #6B6AD0",
"o	c #D0D0D0",
"p	c #CDCDCD",
"q	c #C4C4C4",
"r	c #BABABA",
"s	c #0C1DCB",
"t	c #487C8A",
"u	c #B1B1B1",
"v	c #919191",
"w	c #6666CE",
"                      ",
"                      ",
"   .+++++@@##@@++$%   ",
"  & *============* $  ",
"  -;>            ,')  ",
"  -!~            {].  ",
"  ^ >            { -  ",
"  $ /            { #  ",
"  - (            > ^  ",
"  ^ _            : <  ",
"  + [            } &  ",
"  +  ||1{122234>5  .  ",
"  + 6#@77..8<^9^0a +  ",
"  + &bbbcddddddde@ +  ",
"  + ^f^^g       h@ +  ",
"  + #i&jkiiiiiiikl -  ",
"  @ )m^^ mmmmmmm n ^  ",
"  - $o&%pqqqqqqqr7s^  ",
"  ^t-uuuh       v<.   ",
"   ..)#)..l^$$##w$    ",
"                      ",
"                      "};
/* XPM */
static const char *const stop_s_xpm[] = {
"22 22 77 1",
"       c None",
".      c #000000",
"+      c #703434",
"@      c #E57F7F",
"#      c #E68080",
"$      c #6F2929",
"%      c #DB4343",
"&      c #D31A1A",
"*      c #CE0000",
"=      c #DC4343",
"-      c #D51A1A",
";      c #D00000",
">      c #702929",
",      c #DF4343",
"'      c #D71A1A",
")      c #D30000",
"!      c #6F1B1B",
"~      c #E14343",
"{      c #DA1A1A",
"]      c #D60000",
"^      c #A66666",
"/      c #841717",
"(      c #DA0404",
"_      c #DD1A1A",
":      c #D90000",
"<      c #D56B6B",
"[      c #FFFFFF",
"}      c #E7D5D5",
"|      c #861717",
"1      c #CC0000",
"2      c #DC0000",
"3      c #E64C4C",
"4      c #FADEDE",
"5      c #EAD5D5",
"6      c #722C2C",
"7      c #CF0000",
"8      c #E00000",
"9      c #EB5C5C",
"0      c #FBDFDF",
"a      c #FDF8F8",
"b      c #E40000",
"c      c #DE3535",
"d      c #FEF8F8",
"e      c #E70000",
"f      c #971C1C",
"g      c #EED5D5",
"h      c #FEFAFA",
"i      c #EB0000",
"j      c #AA1C1C",
"k      c #EFD5D5",
"l      c #FDE3E3",
"m      c #F69595",
"n      c #C50000",
"o      c #D50000",
"p      c #EF0000",
"q      c #F77777",
"r      c #FDE4E4",
"s      c #F56565",
"t      c #4D0000",
"u      c #9E0000",
"v      c #D70000",
"w      c #F20000",
"x      c #FAA7A7",
"y      c #F76969",
"z      c #420000",
"A      c #A00000",
"B      c #DA0000",
"C      c #F50000",
"D      c #A20000",
"E      c #DD0000",
"F      c #F80000",
"G      c #430000",
"H      c #A40000",
"I      c #DF0000",
"J      c #FB0000",
"K      c #380000",
"L      c #570000",
"                      ",
"                      ",
"      .........       ",
"     .+@#####@+.      ",
"    .$%&*****&%$.     ",
"   .$=-;;;;;;;-=$.    ",
"  .>,')))))))))',>.   ",
" .!~{]]^/]]]/^]]{~!.  ",
" .(_::<[}|:|}[<::_(.  ",
" .122234[565[432221.  ",
" .7888890[a[0988887.  ",
" .)bbbbbcd[dcbbbbb).  ",
" .]eeeefg[h[gfeeee].  ",
" .:iiijk[lml[kjiii:.  ",
" .noppq[rspsr[qppon.  ",
" .tuvwwxywwwyxwwvut.  ",
"  .zABCCCCCCCCCBAz.   ",
"   .zDEFFFFFFFEDz.    ",
"    .GHIJJJJJIHG.     ",
"     .KLLLLLLLK.      ",
"      .........       ",
"                      "};
/* XPM */
static const char *const bm_s_xpm[] = {
"20 20 285 2",
"  	c None",
". 	c #E1DDE3",
"+ 	c #CCCCD5",
"@ 	c #BFC4CB",
"# 	c #BAC1CB",
"$ 	c #C1C9D1",
"% 	c #C5CBD5",
"& 	c #C5CCD6",
"* 	c #C2CBD6",
"= 	c #B9C7D1",
"- 	c #B8C7D2",
"; 	c #B5C6D0",
"> 	c #B4C5CF",
", 	c #B8C7D0",
"' 	c #B4C1CC",
") 	c #ABB8C3",
"! 	c #96A1AC",
"~ 	c #C5C2CA",
"{ 	c #BBBCC8",
"] 	c #D9E0E5",
"^ 	c #E2EEF1",
"/ 	c #E0EAF1",
"( 	c #DEE8F1",
"_ 	c #DAE7F1",
": 	c #D7E6F0",
"< 	c #D5E7F1",
"[ 	c #D0E5F2",
"} 	c #CCE3F4",
"| 	c #CDE7F5",
"1 	c #CBE2F3",
"2 	c #CFE2F3",
"3 	c #DAE7F3",
"4 	c #798FA9",
"5 	c #B5B4BF",
"6 	c #AEAFBB",
"7 	c #959BAB",
"8 	c #95A4B7",
"9 	c #98A8BF",
"0 	c #97A7BE",
"a 	c #8E9FBC",
"b 	c #7C93BA",
"c 	c #7492BC",
"d 	c #618DBF",
"e 	c #4E8CC5",
"f 	c #268CD6",
"g 	c #3089CD",
"h 	c #4A88C1",
"i 	c #C7D5E7",
"j 	c #748AAE",
"k 	c #B4B2BE",
"l 	c #BDBECA",
"m 	c #A2A9B7",
"n 	c #ADBCCF",
"o 	c #B0C2D7",
"p 	c #A9BCD2",
"q 	c #A8B9D0",
"r 	c #A1B3CB",
"s 	c #9BB0CA",
"t 	c #91AAC7",
"u 	c #86A6C8",
"v 	c #82A4C7",
"w 	c #7B9DC4",
"x 	c #6B96C7",
"y 	c #CEDFF5",
"z 	c #758EB4",
"A 	c #AEACB8",
"B 	c #B6B7C2",
"C 	c #9CA5B3",
"D 	c #A8BACF",
"E 	c #A9BFD7",
"F 	c #A2B6CE",
"G 	c #A1B4CB",
"H 	c #9BAEC5",
"I 	c #94ACC5",
"J 	c #8BA9C7",
"K 	c #7BA1CA",
"L 	c #7FA3CB",
"M 	c #779DC9",
"N 	c #6292CC",
"O 	c #CBDBF5",
"P 	c #7C92B5",
"Q 	c #A2A1AD",
"R 	c #AEB1B8",
"S 	c #949FAC",
"T 	c #A0B4C8",
"U 	c #A6BCD2",
"V 	c #A0B4CB",
"W 	c #A9BCD0",
"X 	c #B1C3D7",
"Y 	c #9EB4CE",
"Z 	c #7C9EC4",
"` 	c #86A8CB",
" .	c #6B98CB",
"..	c #759BC9",
"+.	c #6B93CB",
"@.	c #CBDBF7",
"#.	c #5E7BB8",
"$.	c #A09FA9",
"%.	c #ACAEB4",
"&.	c #8C9BA6",
"*.	c #96ABBC",
"=.	c #A2B6CB",
"-.	c #9DB0C5",
";.	c #B0C0D0",
">.	c #C9D9E4",
",.	c #B9CAD9",
"'.	c #86A1BC",
").	c #7B9FC5",
"!.	c #789CC8",
"~.	c #7B9CC8",
"{.	c #6190CD",
"].	c #D0E0FA",
"^.	c #5A79B9",
"/.	c #9D9AA5",
"(.	c #A5A6AA",
"_.	c #86969F",
":.	c #9FB4C3",
"<.	c #A2B8CB",
"[.	c #8EA4B8",
"}.	c #B4C4D2",
"|.	c #DBEAF3",
"1.	c #C2D4E2",
"2.	c #7598B7",
"3.	c #6F99C1",
"4.	c #7098C6",
"5.	c #6D92C4",
"6.	c #688CC9",
"7.	c #CCD9F6",
"8.	c #5B78B8",
"9.	c #969297",
"0.	c #9D9B9D",
"a.	c #818B9C",
"b.	c #ABBED1",
"c.	c #D8ECF8",
"d.	c #E9FAFF",
"e.	c #EBF9FE",
"f.	c #ECF9FF",
"g.	c #EDFBFE",
"h.	c #EBFEFE",
"i.	c #DBF2FB",
"j.	c #B2CBE3",
"k.	c #6992C3",
"l.	c #5587CF",
"m.	c #D1E1F8",
"n.	c #6E85B8",
"o.	c #958E8B",
"p.	c #999698",
"q.	c #75819E",
"r.	c #8FA2BC",
"s.	c #ABBDCE",
"t.	c #C5D7E1",
"u.	c #E3F1F8",
"v.	c #EEFAFF",
"w.	c #E6F5FB",
"x.	c #D1E3ED",
"y.	c #A3BAD0",
"z.	c #6C97C6",
"A.	c #7195C4",
"B.	c #5186CD",
"C.	c #CEDDF2",
"D.	c #637CBA",
"E.	c #90847C",
"F.	c #918E91",
"G.	c #6C7A9E",
"H.	c #8D9FB9",
"I.	c #809CB9",
"J.	c #B7CBDE",
"K.	c #EBF9FF",
"L.	c #F1FFFF",
"M.	c #EFFDFF",
"N.	c #C9E0F1",
"O.	c #2987D1",
"P.	c #6692C2",
"Q.	c #5889CB",
"R.	c #D2DEF5",
"S.	c #5474B6",
"T.	c #8A7673",
"U.	c #86848C",
"V.	c #6275A0",
"W.	c #7B94B4",
"X.	c #879EBA",
"Y.	c #C5D7E5",
"Z.	c #E1F1FA",
"`.	c #CCDAE7",
" +	c #D4E4EE",
".+	c #D4E9F4",
"++	c #85A5CA",
"@+	c #6794C4",
"#+	c #5B8BC6",
"$+	c #5086CB",
"%+	c #CDD9F0",
"&+	c #6F84B2",
"*+	c #837377",
"=+	c #7D7989",
"-+	c #536AA5",
";+	c #6E8AB5",
">+	c #9AB0CD",
",+	c #B7CBDD",
"'+	c #AABFD5",
")+	c #7C9DC1",
"!+	c #8CAACB",
"~+	c #B0C6DA",
"{+	c #9BB5D6",
"]+	c #4B89CD",
"^+	c #5486CA",
"/+	c #638EC7",
"(+	c #C5D4EC",
"_+	c #6D83B2",
":+	c #82707F",
"<+	c #747289",
"[+	c #4A66A8",
"}+	c #7792BC",
"|+	c #8AA7CC",
"1+	c #85A3CD",
"2+	c #7A9BC4",
"3+	c #6992C1",
"4+	c #6693C6",
"5+	c #769ECF",
"6+	c #6A9BDA",
"7+	c #6091CF",
"8+	c #4C84D1",
"9+	c #4E72D7",
"0+	c #CFDFF6",
"a+	c #3F67CB",
"b+	c #7A6A7D",
"c+	c #6B6A89",
"d+	c #3E5FAD",
"e+	c #7A93BF",
"f+	c #7B9BC9",
"g+	c #638FC8",
"h+	c #6C92C7",
"i+	c #6F96C9",
"j+	c #6292CD",
"k+	c #5890D1",
"l+	c #4D8AD5",
"m+	c #598DD2",
"n+	c #4982D2",
"o+	c #4978DA",
"p+	c #D6E4F8",
"q+	c #486AC5",
"r+	c #5E3782",
"s+	c #63628C",
"t+	c #395CAF",
"u+	c #748EBD",
"v+	c #7E9BC5",
"w+	c #7093C5",
"x+	c #7093C4",
"y+	c #6B92C6",
"z+	c #608FCA",
"A+	c #5A8ECD",
"B+	c #5A8BCD",
"C+	c #5586CD",
"D+	c #6289C9",
"E+	c #4E7DC9",
"F+	c #A6B4CF",
"G+	c #687CB2",
"H+	c #948BA3",
"I+	c #63689A",
"J+	c #4566AD",
"K+	c #6F86B4",
"L+	c #7A91B9",
"M+	c #768FB9",
"N+	c #738FB9",
"O+	c #6D8DBB",
"P+	c #6489BE",
"Q+	c #5F87C0",
"R+	c #5D86C1",
"S+	c #5D83C0",
"T+	c #6D86B9",
"U+	c #647EB4",
"V+	c #6A7BAA",
"W+	c #6F80AD",
"X+	c #6975A1",
"Y+	c #4C6DAC",
"Z+	c #6C81AF",
"`+	c #7085B0",
" @	c #7187B1",
".@	c #7089B2",
"+@	c #6D88B3",
"@@	c #6485B5",
"#@	c #6183B8",
"$@	c #5F82B9",
"%@	c #5B7DB8",
"&@	c #6882B2",
"*@	c #7586AD",
"                                        ",
"                                        ",
"    . + @ # $ % & * = - ; > , ' ) !     ",
"    ~ { ] ^ / ( _ : < [ } | 1 2 3 4     ",
"    5 6 7 8 9 0 a b c d e f g h i j     ",
"    k l m n o p q r s t u v w x y z     ",
"    A B C D E F G H I J K L M N O P     ",
"    Q R S T U V W X Y Z `  ...+.@.#.    ",
"    $.%.&.*.=.-.;.>.,.'.).!.~.{.].^.    ",
"    /.(._.:.<.[.}.|.1.2.3.4.5.6.7.8.    ",
"    9.0.a.b.c.d.e.f.g.h.i.j.k.l.m.n.    ",
"    o.p.q.r.s.t.u.v.w.x.y.z.A.B.C.D.    ",
"    E.F.G.H.I.J.K.L.M.N.O.P.k.Q.R.S.    ",
"    T.U.V.W.X.Y.Z.`. +.+++@+#+$+%+&+    ",
"    *+=+-+;+>+,+'+)+!+~+{+]+^+/+(+_+    ",
"    :+<+[+}+|+1+2+3+4+5+6+7+8+9+0+a+    ",
"    b+c+d+e+f+g+h+i+j+k+l+m+n+o+p+q+    ",
"    r+s+t+u+v+w+x+y+z+A+B+C+D+E+F+G+    ",
"    H+I+J+K+L+M+N+O+P+Q+R+S+T+U+V+W+    ",
"      X+Y+Z+`+ @.@+@@@#@$@%@&@*@        "};
/* XPM */
static const char *const tools_s_xpm[] = {
"22 22 75 1",
" 	c None",
".	c #5877CB",
"+	c #5A79CA",
"@	c #5978CA",
"#	c #5A79CC",
"$	c #637FC8",
"%	c #5D7CCB",
"&	c #5876CB",
"*	c #5D7BC9",
"=	c #6482D0",
"-	c #647FC6",
";	c #A2A6CC",
">	c #617FC8",
",	c #5A7ACC",
"'	c #8094CA",
")	c #5978CB",
"!	c #5F7CC9",
"~	c #607DC8",
"{	c #5A79CB",
"]	c #5B7ACB",
"^	c #5C7BCA",
"/	c #5274CC",
"(	c #879BCC",
"_	c #5A7BCF",
":	c #6782C9",
"<	c #6480C8",
"[	c #5B7BCB",
"}	c #6280CC",
"|	c #6681C6",
"1	c #7D94CC",
"2	c #5777CD",
"3	c #5676CB",
"4	c #5375CC",
"5	c #92A3D2",
"6	c #5777CC",
"7	c #6683CC",
"8	c #6883C9",
"9	c #B8C6E9",
"0	c #7B91CC",
"a	c #6883C7",
"b	c #8397CC",
"c	c #B7C5E6",
"d	c #758CC7",
"e	c #8594CC",
"f	c #617EC7",
"g	c #778DC8",
"h	c #5676CC",
"i	c #90A2D0",
"j	c #7189C6",
"k	c #5F7BC9",
"l	c #446BD2",
"m	c #96A8D3",
"n	c #6F88C6",
"o	c #607CC8",
"p	c #7C94CD",
"q	c #7990CC",
"r	c #758ECC",
"s	c #758DCC",
"t	c #6D85C6",
"u	c #6580C6",
"v	c #7C92CA",
"w	c #7F96D2",
"x	c #6983C6",
"y	c #6882C6",
"z	c #8297CE",
"A	c #6E89CC",
"B	c #7189C5",
"C	c #8699CA",
"D	c #758BC6",
"E	c #6481CA",
"F	c #6482CC",
"G	c #708ACC",
"H	c #748DCD",
"I	c #5D7BCC",
"J	c #5C7ED3",
"                      ",
"                      ",
"                      ",
"         .++@         ",
"         #$%&*        ",
"         =-;;>@       ",
"          ,';;;@      ",
"    @     )!~;;;+     ",
"   @@{     @+;;;]     ",
"   @^;)     /(;;#_    ",
"   @:;;+    <;;;[}    ",
"   @|;;123^45;;;67    ",
"    8;;;90abc;;;de    ",
"    ^^f;;;;;;;;;g     ",
"     ~hi;;;;;;;;;j    ",
"      klm;;;;;;;;no   ",
"       ^hpqrstu;;;;v  ",
"             wxy;;;z  ",
"              A~BCDE  ",
"               FGHIJ  ",
"                      ",
"                      "};

/* XPM */
static const char *const  newtab_s_xpm[] = {
"22 22 75 1",
" 	c None",
"B	c #5877CB",
"C	c #5A79CA",
"D	c #5978CA",
"E	c #5A79CC",
"F	c #637FC8",
"G	c #5D7CCB",
"H	c #5876CB",
"I	c #5D7BC9",
"J	c #6482D0",
"K	c #647FC6",
"L	c #A2A6CC",
"M	c #617FC8",
"N	c #5A7ACC",
"O	c #8094CA",
"P	c #5978CB",
"Q	c #5F7CC9",
"R	c #607DC8",
"S	c #5A79CB",
"T	c #5B7ACB",
"U	c #5C7BCA",
"V	c #5274CC",
"W	c #879BCC",
"X	c #5A7BCF",
"Y	c #6782C9",
"Z	c #6480C8",
"a	c #5B7BCB",
"b	c #6280CC",
"c	c #6681C6",
"d	c #7D94CC",
"e	c #5777CD",
"f	c #5676CB",
"g	c #5375CC",
"h	c #92A3D2",
"i	c #5777CC",
"j	c #6683CC",
"k	c #6883C9",
"l	c #B8C6E9",
"m	c #7B91CC",
"n	c #6883C7",
"o	c #8397CC",
"p	c #B7C5E6",
"q	c #758CC7",
"r	c #8594CC",
"s	c #617EC7",
"t	c #778DC8",
"u	c #5676CC",
"v	c #90A2D0",
"w	c #7189C6",
"x	c #5F7BC9",
"y	c #446BD2",
"z	c #96A8D3",
"0	c #6F88C6",
"1	c #607CC8",
"2	c #7C94CD",
"3	c #7990CC",
"4	c #758ECC",
"5	c #758DCC",
"6	c #6D85C6",
"7	c #6580C6",
"8	c #7C92CA",
"9	c #7F96D2",
"+	c #6983C6",
"/	c #6882C6",
"!	c #8297CE",
"#	c #6E89CC",
"$	c #7189C5",
"%	c #8699CA",
"&	c #758BC6",
"'	c #6481CA",
"(	c #6482CC",
")	c #708ACC",
"*	c #748DCD",
",	c #5D7BCC",
"-	c #5C7ED3",
"                      ",
"        BBBBBB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
" BBBBBBBBLLLLBBBBBBBB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BLLLLLLLLLLLLLLLLLLB ",
" BBBBBBBBLLLLBBBBBBBB ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BLLLLB        ",
"        BBBBBB        ",
"                      "
};

/* XPM */
static const char *const new_s_xpm[] = {
"11 11 35 1",
"       c None",
".      c #000000",
"+      c #482929",
"@      c #0F0808",
"#      c #390606",
"$      c #A04242",
"%      c #925050",
"&      c #0F0707",
"*      c #0B0000",
"=      c #500000",
"-      c #8C0101",
";      c #944444",
">      c #221515",
",      c #0A0000",
"'      c #560000",
")      c #A10909",
"!      c #AE3636",
"~      c #230000",
"{      c #AE0000",
"]      c #B40000",
"^      c #180808",
"/      c #B43535",
"(      c #C40000",
"_      c #960000",
":      c #190606",
"<      c #C02B2B",
"[      c #E00000",
"}      c #6B0000",
"|      c #120000",
"1      c #590000",
"2      c #A30000",
"3      c #680000",
"4      c #0F0000",
"5      c #350000",
"6      c #100000",
"  .     .  ",
" .+@   @+. ",
".#$%& &%$#.",
" *=-;>;-=* ",
"  ,')!)',  ",
"   ~{]{~   ",
"  ^/(_(/^  ",
" :<[}|}[<: ",
".1234 4321.",
" .56   65. ",
"  .     .  "};

/* XPM */
static const char *const search_xpm[] = {
"14 16 14 1",
" 	c None",
".	c #3838B0",
"+	c #3939B1",
"@	c #3939B3",
"#	c #EEEEEE",
"$	c #3939B2",
"%	c #3838B1",
"&	c #140033",
"*	c #1B0044",
"=	c #360088",
"-	c #290066",
";	c #4400AA",
">	c #4A00BB",
",	c #5100CC",
"   ...++      ",
"  .     @     ",
" +  #    +    ",
"$  ###    $   ",
"+   #     %   ",
"%         .   ",
"%         .   ",
" @       .    ",
"  $     .     ",
"   +$$&*&     ",
"       *=*    ",
"       -;-    ",
"        =>=   ",
"        =,=   ",
"         =,=  ",
"         ;;   "};

/* XPM */
static const char *const help_xpm[] = {
"14 16 7 1",
" 	c None",
".	c #3766A4",
"+	c #5C8BC9",
"@	c #91B1DA",
"#	c #92B2DB",
"$	c #5385C6",
"%	c #325E96",
"              ",
"    ...+++    ",
"   .   .+@.   ",
"  ..    .#@+  ",
"  ....  .@#.  ",
"  ....  .#$.  ",
"   ..  .#$.   ",
"       .$.    ",
"      .$.     ",
"      ..      ",
"      ..      ",
"              ",
"      ..      ",
"     .$%.     ",
"     .%$.     ",
"      ..      "};

/* XPM */
static const char *const mini_bug_xpm[] = {
"16 16 7 1",
"       c None",
".      c #000000000000",
"r      c #FFFF00000000",
"X      c #BEFBC30BBEFB",
"o      c #861782078617",
"O      c #FFFFFFFFFFFF",
"+      c #30C230C230C2",
"                ",
"     .   .      ",
"      ...       ",
"    X.....X     ",
"    o.O...o     ",
"   o.O...o.o    ",
"   .rrrXrrr.    ",
"  .rrrrXrrrr.   ",
"   .rrrXrrr.    ",
"  .o.rrXrr.o.   ",
"    .rrXrr.     ",
"   .XrrXrrX.    ",
"      .o.       ",
"           .+++.",
"            .o. ",
"             .  "};

/* XPM */
static const char *const mini_ok_xpm[] = {
"15 15 5 1",
"@ c #000000",
"a c #808080",
"b c #303030",
"c c #606060",
"  s none m none c none",
"               ",
"               ",
"            @  ",
"           @@  ",
"          @@@  ",
"         @@@   ",
"   @@   @@@    ",
"  @@@  @@@     ",
"  @@@ @@@      ",
"  @@@@@@       ",
"  @@@@@        ",
"  @@@@         ",
"   @@     @bbb@",
"           @a@ ",
"            @  "
};

#if 0

/* XPM */
static const char *const left_i_xpm[] = {
"22 22 3 1",
"  c None",
". c #000000",
"@ c gray70",
"                      ",
"                      ",
"                      ",
"                      ",
"        @@            ",
"       @@@            ",
"      @@@@            ",
"     @@@@@@@@@@ @@@@  ",
"    @@@@@@@@@@@ @@@@  ",
"   @@@@@@@@@@@@ @@@@  ",
"  @@@@@@@@@@@@@ @@@@  ",
"  @@@@@@@@@@@@@ @@@@  ",
"   @@@@@@@@@@@@ @@@@  ",
"    @@@@@@@@@@@ @@@@  ",
"     @@@@@@@@@@ @@@@  ",
"      @@@@            ",
"       @@@            ",
"        @@            ",
"                 @@@@@",
"                  @ @ ",
"                   @  ",
"                      "};

/* XPM */
static const char *const right_i_xpm[] = {
"22 22 3 1",
"  c None",
". c #000000",
"@ c gray70",
"                      ",
"                      ",
"                      ",
"                      ",
"            @@        ",
"            @@@       ",
"            @@@@      ",
"  @@@@ @@@@@@@@@@     ",
"  @@@@ @@@@@@@@@@@    ",
"  @@@@ @@@@@@@@@@@@   ",
"  @@@@ @@@@@@@@@@@@@  ",
"  @@@@ @@@@@@@@@@@@@  ",
"  @@@@ @@@@@@@@@@@@   ",
"  @@@@ @@@@@@@@@@@    ",
"  @@@@ @@@@@@@@@@     ",
"            @@@@      ",
"            @@@       ",
"            @@        ",
"                 @@@@@",
"                  @ @ ",
"                   @  ",
"                      "};

/* XPM */
static const char *const stop_i_xpm[] = {
/* columns rows colors chars-per-pixel */
"22 22 2 1",
"       c None",
"@      c gray70",
/* pixels */
"                      ",
"                      ",
"      @@@@@@@@@       ",
"     @@@@@@@@@@@      ",
"    @@@@@@@@@@@@@     ",
"   @@@@@@@@@@@@@@@    ",
"  @@@@@@@@@@@@@@@@@   ",
" @@@@@@@@@@@@@@@@@@@  ",
" @@@@@@  @@@  @@@@@@  ",
" @@@@@@   @   @@@@@@  ",
" @@@@@@@     @@@@@@@  ",
" @@@@@@@@   @@@@@@@@  ",
" @@@@@@@     @@@@@@@  ",
" @@@@@@   @   @@@@@@  ",
" @@@@@@  @@@  @@@@@@  ",
" @@@@@@@@@@@@@@@@@@@  ",
"  @@@@@@@@@@@@@@@@@   ",
"   @@@@@@@@@@@@@@@    ",
"    @@@@@@@@@@@@@     ",
"     @@@@@@@@@@@      ",
"      @@@@@@@@@       ",
"                      "
};

/* XPM */
static const char *const stop_si_xpm[] = {
"16 16 2 1",
"       c None",
"@      c gray70",
"    @@@@@@@@    ",
"   @@@@@@@@@@   ",
"  @@@@@@@@@@@@  ",
" @@@@@@@@@@@@@@ ",
"@@@@@@@@@@@@@@@@",
"@@@@@ @@@@ @@@@@",
"@@@@@@ @@ @@@@@@",
"@@@@@@@  @@@@@@@",
"@@@@@@@  @@@@@@@",
"@@@@@@ @@ @@@@@@",
"@@@@@ @@@@ @@@@@",
"@@@@@@@@@@@@@@@@",
" @@@@@@@@@@@@@@ ",
"  @@@@@@@@@@@@  ",
"   @@@@@@@@@@   ",
"    @@@@@@@@    "};

/* XPM */
static const char *const left_si_xpm[] = {
"16 16 2 1",
"       c None",
"@      c gray70",
"                ",
"      @@        ",
"     @@@        ",
"    @@@@        ",
"   @@@@@@@@ @@@@",
"  @@@@@@@@@ @@@@",
" @@@@@@@@@@ @@@@",
"@@@@@@@@@@@ @@@@",
"@@@@@@@@@@@ @@@@",
" @@@@@@@@@@ @@@@",
"  @@@@@@@@@ @@@@",
"   @@@@@@@@ @@@@",
"    @@@@        ",
"     @@@   @@@@@",
"      @@    @ @ ",
"             @  "};

/* XPM */
static const char *const right_si_xpm[] = {
"16 16 2 1",
"       c None",
"@      c gray70",
"                ",
"        @@      ",
"        @@@     ",
"        @@@@    ",
"@@@@ @@@@@@@@   ",
"@@@@ @@@@@@@@@  ",
"@@@@ @@@@@@@@@@ ",
"@@@@ @@@@@@@@@@@",
"@@@@ @@@@@@@@@@@",
"@@@@ @@@@@@@@@@ ",
"@@@@ @@@@@@@@@  ",
"@@@@ @@@@@@@@   ",
"        @@@@    ",
"        @@@@@@@@",
"        @@  @ @ ",
"             @  "};
#endif

#endif /* __PIXMAPS_H__ */
