; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 4
; RUN: opt %s -S -passes=msan 2>&1 | FileCheck %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

define i64 @test_sadd_sat(i64 %a, i64 %b) #0 {
; CHECK-LABEL: define i64 @test_sadd_sat(
; CHECK-SAME: i64 [[A:%.*]], i64 [[B:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.sadd.sat.i64(i64 [[A]], i64 [[B]])
; CHECK-NEXT:    store i64 [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.sadd.sat(i64 %a, i64 %b)
  ret i64 %res
}

define i64 @test_uadd_sat(i64 %a, i64 %b) #0 {
; CHECK-LABEL: define i64 @test_uadd_sat(
; CHECK-SAME: i64 [[A:%.*]], i64 [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.uadd.sat.i64(i64 [[A]], i64 [[B]])
; CHECK-NEXT:    store i64 [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.uadd.sat(i64 %a, i64 %b)
  ret i64 %res
}

define i64 @test_ssub_sat(i64 %a, i64 %b) #0 {
; CHECK-LABEL: define i64 @test_ssub_sat(
; CHECK-SAME: i64 [[A:%.*]], i64 [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.ssub.sat.i64(i64 [[A]], i64 [[B]])
; CHECK-NEXT:    store i64 [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.ssub.sat(i64 %a, i64 %b)
  ret i64 %res
}

define i64 @test_usub_sat(i64 %a, i64 %b) #0 {
; CHECK-LABEL: define i64 @test_usub_sat(
; CHECK-SAME: i64 [[A:%.*]], i64 [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.usub.sat.i64(i64 [[A]], i64 [[B]])
; CHECK-NEXT:    store i64 [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.usub.sat(i64 %a, i64 %b)
  ret i64 %res
}

define i64 @test_sshl_sat(i64 %a, i64 %b) #0 {
; CHECK-LABEL: define i64 @test_sshl_sat(
; CHECK-SAME: i64 [[A:%.*]], i64 [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.sshl.sat.i64(i64 [[A]], i64 [[B]])
; CHECK-NEXT:    store i64 [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.sshl.sat(i64 %a, i64 %b)
  ret i64 %res
}

define i64 @test_ushl_sat(i64 %a, i64 %b) #0 {
; CHECK-LABEL: define i64 @test_ushl_sat(
; CHECK-SAME: i64 [[A:%.*]], i64 [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load i64, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load i64, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 8) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or i64 [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = call i64 @llvm.ushl.sat.i64(i64 [[A]], i64 [[B]])
; CHECK-NEXT:    store i64 [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret i64 [[RES]]
;
  %res = call i64 @llvm.ushl.sat(i64 %a, i64 %b)
  ret i64 %res
}

define <4 x i32> @test_sadd_sat_vec(<4 x i32> %a, <4 x i32> %b) #0 {
; CHECK-LABEL: define <4 x i32> @test_sadd_sat_vec(
; CHECK-SAME: <4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]]) #[[ATTR0]] {
; CHECK-NEXT:    [[TMP1:%.*]] = load <4 x i32>, ptr @__msan_param_tls, align 8
; CHECK-NEXT:    [[TMP2:%.*]] = load <4 x i32>, ptr inttoptr (i64 add (i64 ptrtoint (ptr @__msan_param_tls to i64), i64 16) to ptr), align 8
; CHECK-NEXT:    call void @llvm.donothing()
; CHECK-NEXT:    [[_MSPROP:%.*]] = or <4 x i32> [[TMP1]], [[TMP2]]
; CHECK-NEXT:    [[RES:%.*]] = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> [[A]], <4 x i32> [[B]])
; CHECK-NEXT:    store <4 x i32> [[_MSPROP]], ptr @__msan_retval_tls, align 8
; CHECK-NEXT:    ret <4 x i32> [[RES]]
;
  %res = call <4 x i32> @llvm.sadd.sat.v4i32(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}


attributes #0 = { sanitize_memory }
