; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zfh,+zvfh,+f,+d -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zfh,+zvfh,+f,+d  -verify-machineinstrs < %s | FileCheck %s

declare half @llvm.vector.reduce.fadd.v1f16(half, <1 x half>)

define half @vreduce_fadd_v1f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fadd.h fa0, fa0, fa5
; CHECK-NEXT:    ret
  %v = load <1 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v1f16(half %s, <1 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v1f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v1f16(half %s, <1 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v2f16(half, <2 x half>)

define half @vreduce_fadd_v2f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v2f16(half %s, <2 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v2f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v2f16(half %s, <2 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v4f16(half, <4 x half>)

define half @vreduce_fadd_v4f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v4f16(half %s, <4 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v4f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v4f16(half %s, <4 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v8f16(half, <8 x half>)

define half @vreduce_fadd_v8f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v8f16(half %s, <8 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v8f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v8f16(half %s, <8 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v16f16(half, <16 x half>)

define half @vreduce_fadd_v16f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v16f16(half %s, <16 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v16f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v16f16(half %s, <16 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v32f16(half, <32 x half>)

define half @vreduce_fadd_v32f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v32f16(half %s, <32 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v32f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v32f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v32f16(half %s, <32 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v64f16(half, <64 x half>)

define half @vreduce_fadd_v64f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v64f16(half %s, <64 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v64f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v64f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v64f16(half %s, <64 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fadd.v128f16(half, <128 x half>)

define half @vreduce_fadd_v128f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_fadd_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfadd.vv v8, v8, v16
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, ptr %x
  %red = call reassoc half @llvm.vector.reduce.fadd.v128f16(half %s, <128 x half> %v)
  ret half %red
}

define half @vreduce_ord_fadd_v128f16(ptr %x, half %s) {
; CHECK-LABEL: vreduce_ord_fadd_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    li a2, 64
; CHECK-NEXT:    vsetvli zero, a2, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vle16.v v16, (a1)
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v24
; CHECK-NEXT:    vfredosum.vs v8, v16, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fadd.v128f16(half %s, <128 x half> %v)
  ret half %red
}

declare float @llvm.vector.reduce.fadd.v1f32(float, <1 x float>)

define float @vreduce_fadd_v1f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fadd.s fa0, fa0, fa5
; CHECK-NEXT:    ret
  %v = load <1 x float>, ptr %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v1f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v1f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa5, v9
; CHECK-NEXT:    fadd.s fa0, fa0, fa5
; CHECK-NEXT:    ret
  %v = load <1 x half>, ptr %x
  %e = fpext <1 x half> %v to <1 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v1f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x half>, ptr %x
  %e = fpext <1 x half> %v to <1 x float>
  %red = call float @llvm.vector.reduce.fadd.v1f32(float %s, <1 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v2f32(float, <2 x float>)

define float @vreduce_fadd_v2f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v2f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v2f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, ptr %x
  %e = fpext <2 x half> %v to <2 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v2f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, ptr %x
  %e = fpext <2 x half> %v to <2 x float>
  %red = call float @llvm.vector.reduce.fadd.v2f32(float %s, <2 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v4f32(float, <4 x float>)

define float @vreduce_fadd_v4f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v4f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v4f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %e = fpext <4 x half> %v to <4 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v4f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %e = fpext <4 x half> %v to <4 x float>
  %red = call float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v8f32(float, <8 x float>)

define float @vreduce_fadd_v8f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v8f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v8f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, ptr %x
  %e = fpext <8 x half> %v to <8 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v8f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x half>, ptr %x
  %e = fpext <8 x half> %v to <8 x float>
  %red = call float @llvm.vector.reduce.fadd.v8f32(float %s, <8 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v16f32(float, <16 x float>)

define float @vreduce_fadd_v16f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v16f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v16f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, ptr %x
  %e = fpext <16 x half> %v to <16 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v16f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x half>, ptr %x
  %e = fpext <16 x half> %v to <16 x float>
  %red = call float @llvm.vector.reduce.fadd.v16f32(float %s, <16 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v32f32(float, <32 x float>)

define float @vreduce_fadd_v32f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v32f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v32f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, ptr %x
  %e = fpext <32 x half> %v to <32 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v32f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v12
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x half>, ptr %x
  %e = fpext <32 x half> %v to <32 x float>
  %red = call float @llvm.vector.reduce.fadd.v32f32(float %s, <32 x float> %e)
  ret float %red
}

declare float @llvm.vector.reduce.fadd.v64f32(float, <64 x float>)

define float @vreduce_fadd_v64f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vfadd.vv v8, v8, v16
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x float>, ptr %x
  %red = call reassoc float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %v)
  ret float %red
}

define float @vreduce_ord_fadd_v64f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vle32.v v16, (a1)
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v24
; CHECK-NEXT:    vfredosum.vs v8, v16, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %v)
  ret float %red
}

define float @vreduce_fwadd_v64f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_fwadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v16, v8, a0
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwadd.vv v24, v8, v16
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa0
; CHECK-NEXT:    vfredusum.vs v8, v24, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, ptr %x
  %e = fpext <64 x half> %v to <64 x float>
  %red = call reassoc float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %e)
  ret float %red
}

define float @vreduce_ord_fwadd_v64f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    li a0, 32
; CHECK-NEXT:    vsetvli zero, a0, e16, m8, ta, ma
; CHECK-NEXT:    vslidedown.vx v16, v8, a0
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v12
; CHECK-NEXT:    vfwredosum.vs v8, v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x half>, ptr %x
  %e = fpext <64 x half> %v to <64 x float>
  %red = call float @llvm.vector.reduce.fadd.v64f32(float %s, <64 x float> %e)
  ret float %red
}

declare double @llvm.vector.reduce.fadd.v1f64(double, <1 x double>)

define double @vreduce_fadd_v1f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.f.s fa5, v8
; CHECK-NEXT:    fadd.d fa0, fa0, fa5
; CHECK-NEXT:    ret
  %v = load <1 x double>, ptr %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v1f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v1f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa5, v9
; CHECK-NEXT:    fadd.d fa0, fa0, fa5
; CHECK-NEXT:    ret
  %v = load <1 x float>, ptr %x
  %e = fpext <1 x float> %v to <1 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v1f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 1, e64, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <1 x float>, ptr %x
  %e = fpext <1 x float> %v to <1 x double>
  %red = call double @llvm.vector.reduce.fadd.v1f64(double %s, <1 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v2f64(double, <2 x double>)

define double @vreduce_fadd_v2f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v2f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v2f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %e = fpext <2 x float> %v to <2 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v2f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %e = fpext <2 x float> %v to <2 x double>
  %red = call double @llvm.vector.reduce.fadd.v2f64(double %s, <2 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v4f64(double, <4 x double>)

define double @vreduce_fadd_v4f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v4f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v10
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v4f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %e = fpext <4 x float> %v to <4 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v4f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v9
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %e = fpext <4 x float> %v to <4 x double>
  %red = call double @llvm.vector.reduce.fadd.v4f64(double %s, <4 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v8f64(double, <8 x double>)

define double @vreduce_fadd_v8f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, ptr %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v8f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v12
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v8f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %e = fpext <8 x float> %v to <8 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v8f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v10, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v10
; CHECK-NEXT:    vsetvli zero, zero, e64, m4, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %e = fpext <8 x float> %v to <8 x double>
  %red = call double @llvm.vector.reduce.fadd.v8f64(double %s, <8 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v16f64(double, <16 x double>)

define double @vreduce_fadd_v16f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, ptr %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v16f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v16f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwredusum.vs v8, v8, v12
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %e = fpext <16 x float> %v to <16 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v16f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v12
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %e = fpext <16 x float> %v to <16 x double>
  %red = call double @llvm.vector.reduce.fadd.v16f64(double %s, <16 x double> %e)
  ret double %red
}

declare double @llvm.vector.reduce.fadd.v32f64(double, <32 x double>)

define double @vreduce_fadd_v32f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfadd.vv v8, v8, v16
; CHECK-NEXT:    vfmv.s.f v16, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v16
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call reassoc double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %v)
  ret double %red
}

define double @vreduce_ord_fadd_v32f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vle64.v v16, (a1)
; CHECK-NEXT:    vfmv.s.f v24, fa0
; CHECK-NEXT:    vfredosum.vs v8, v8, v24
; CHECK-NEXT:    vfredosum.vs v8, v16, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %v)
  ret double %red
}

define double @vreduce_fwadd_v32f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_fwadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; CHECK-NEXT:    vslidedown.vi v16, v8, 16
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfwadd.vv v24, v8, v16
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.s.f v8, fa0
; CHECK-NEXT:    vfredusum.vs v8, v24, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %e = fpext <32 x float> %v to <32 x double>
  %red = call reassoc double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %e)
  ret double %red
}

define double @vreduce_ord_fwadd_v32f64(ptr %x, double %s) {
; CHECK-LABEL: vreduce_ord_fwadd_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vsetivli zero, 16, e32, m8, ta, ma
; CHECK-NEXT:    vslidedown.vi v16, v8, 16
; CHECK-NEXT:    vsetivli zero, 16, e64, m1, ta, ma
; CHECK-NEXT:    vfmv.s.f v12, fa0
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vfwredosum.vs v8, v8, v12
; CHECK-NEXT:    vfwredosum.vs v8, v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e64, m8, ta, ma
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %e = fpext <32 x float> %v to <32 x double>
  %red = call double @llvm.vector.reduce.fadd.v32f64(double %s, <32 x double> %e)
  ret double %red
}

declare half @llvm.vector.reduce.fmin.v2f16(<2 x half>)

define half @vreduce_fmin_v2f16(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fmin.v2f16(<2 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmin.v4f16(<4 x half>)

define half @vreduce_fmin_v4f16(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fmin.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmin_v4f16_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call nnan half @llvm.vector.reduce.fmin.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmin_v4f16_nonans_noinfs(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f16_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call nnan ninf half @llvm.vector.reduce.fmin.v4f16(<4 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmin.v128f16(<128 x half>)

define half @vreduce_fmin_v128f16(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fmin.v128f16(<128 x half> %v)
  ret half %red
}

declare float @llvm.vector.reduce.fmin.v2f32(<2 x float>)

define float @vreduce_fmin_v2f32(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmin.v2f32(<2 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmin.v4f32(<4 x float>)

define float @vreduce_fmin_v4f32(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmin.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmin_v4f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmin.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmin_v4f32_nonans_noinfs(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f32_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call nnan ninf float @llvm.vector.reduce.fmin.v4f32(<4 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmin.v128f32(<128 x float>)

define float @vreduce_fmin_v128f32(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v128f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle32.v v16, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    vle32.v v0, (a1)
; CHECK-NEXT:    vfmin.vv v16, v24, v16
; CHECK-NEXT:    vfmin.vv v8, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmin.v128f32(<128 x float> %v)
  ret float %red
}

declare double @llvm.vector.reduce.fmin.v2f64(<2 x double>)

define double @vreduce_fmin_v2f64(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmin.v2f64(<2 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmin.v4f64(<4 x double>)

define double @vreduce_fmin_v4f64(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmin.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmin_v4f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmin.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmin_v4f64_nonans_noinfs(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v4f64_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call nnan ninf double @llvm.vector.reduce.fmin.v4f64(<4 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmin.v32f64(<32 x double>)

define double @vreduce_fmin_v32f64(ptr %x) {
; CHECK-LABEL: vreduce_fmin_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmin.v32f64(<32 x double> %v)
  ret double %red
}

declare half @llvm.vector.reduce.fmax.v2f16(<2 x half>)

define half @vreduce_fmax_v2f16(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fmax.v2f16(<2 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmax.v4f16(<4 x half>)

define half @vreduce_fmax_v4f16(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fmax.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmax_v4f16_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f16_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call nnan half @llvm.vector.reduce.fmax.v4f16(<4 x half> %v)
  ret half %red
}

define half @vreduce_fmax_v4f16_nonans_noinfs(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f16_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x half>, ptr %x
  %red = call nnan ninf half @llvm.vector.reduce.fmax.v4f16(<4 x half> %v)
  ret half %red
}

declare half @llvm.vector.reduce.fmax.v128f16(<128 x half>)

define half @vreduce_fmax_v128f16(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v128f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 64
; CHECK-NEXT:    vsetvli zero, a1, e16, m8, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle16.v v16, (a0)
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x half>, ptr %x
  %red = call half @llvm.vector.reduce.fmax.v128f16(<128 x half> %v)
  ret half %red
}

declare float @llvm.vector.reduce.fmax.v2f32(<2 x float>)

define float @vreduce_fmax_v2f32(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmax.v2f32(<2 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmax.v4f32(<4 x float>)

define float @vreduce_fmax_v4f32(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmax.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmax_v4f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmax.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmax_v4f32_nonans_noinfs(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f32_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call nnan ninf float @llvm.vector.reduce.fmax.v4f32(<4 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmax.v128f32(<128 x float>)

define float @vreduce_fmax_v128f32(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v128f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle32.v v16, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    vle32.v v0, (a1)
; CHECK-NEXT:    vfmax.vv v16, v24, v16
; CHECK-NEXT:    vfmax.vv v8, v8, v0
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmax.v128f32(<128 x float> %v)
  ret float %red
}

declare double @llvm.vector.reduce.fmax.v2f64(<2 x double>)

define double @vreduce_fmax_v2f64(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmax.v2f64(<2 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmax.v4f64(<4 x double>)

define double @vreduce_fmax_v4f64(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmax.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmax_v4f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmax.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmax_v4f64_nonans_noinfs(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v4f64_nonans_noinfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call nnan ninf double @llvm.vector.reduce.fmax.v4f64(<4 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmax.v32f64(<32 x double>)

define double @vreduce_fmax_v32f64(ptr %x) {
; CHECK-LABEL: vreduce_fmax_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmax.v32f64(<32 x double> %v)
  ret double %red
}

define float @vreduce_nsz_fadd_v4f32(ptr %x, float %s) {
; CHECK-LABEL: vreduce_nsz_fadd_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfmv.s.f v9, fa0
; CHECK-NEXT:    vfredusum.vs v8, v8, v9
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call reassoc nsz float @llvm.vector.reduce.fadd.v4f32(float %s, <4 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fminimum.v2f32(<2 x float>)

define float @vreduce_fminimum_v2f32(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v9, v8, v8
; CHECK-NEXT:    vcpop.m a0, v9
; CHECK-NEXT:    beqz a0, .LBB99_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB99_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fminimum.v2f32(<2 x float> %v)
  ret float %red
}

define float @vreduce_fminimum_v2f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v2f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fminimum.v2f32(<2 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fminimum.v4f32(<4 x float>)

define float @vreduce_fminimum_v4f32(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v9, v8, v8
; CHECK-NEXT:    vcpop.m a0, v9
; CHECK-NEXT:    beqz a0, .LBB101_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB101_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fminimum.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fminimum_v4f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fminimum.v4f32(<4 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fminimum.v8f32(<8 x float>)

define float @vreduce_fminimum_v8f32(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vcpop.m a0, v10
; CHECK-NEXT:    beqz a0, .LBB103_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB103_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fminimum.v8f32(<8 x float> %v)
  ret float %red
}

define float @vreduce_fminimum_v8f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fminimum.v8f32(<8 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fminimum.v16f32(<16 x float>)

define float @vreduce_fminimum_v16f32(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vcpop.m a0, v12
; CHECK-NEXT:    beqz a0, .LBB105_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB105_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fminimum.v16f32(<16 x float> %v)
  ret float %red
}

define float @vreduce_fminimum_v16f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v16f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fminimum.v16f32(<16 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fminimum.v32f32(<32 x float>)

define float @vreduce_fminimum_v32f32(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB107_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB107_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fminimum.v32f32(<32 x float> %v)
  ret float %red
}

define float @vreduce_fminimum_v32f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v32f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fminimum.v32f32(<32 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fminimum.v64f32(<64 x float>)

define float @vreduce_fminimum_v64f32(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vle32.v v24, (a1)
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB109_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    j .LBB109_3
; CHECK-NEXT:  .LBB109_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB109_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <64 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fminimum.v64f32(<64 x float> %v)
  ret float %red
}

define float @vreduce_fminimum_v64f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v64f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fminimum.v64f32(<64 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fminimum.v128f32(<128 x float>)

define float @vreduce_fminimum_v128f32(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v128f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    add a1, a1, a2
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 24 * vlenb
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    addi a2, a0, 128
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v16, (a2)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle32.v v8, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmerge.vvm v24, v16, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vle32.v v24, (a1)
; CHECK-NEXT:    vmerge.vvm v8, v8, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v16, v8, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v24, v24, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v24, v24, v8
; CHECK-NEXT:    vmfeq.vv v0, v24, v24
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v7, v16, v16
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB111_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    j .LBB111_3
; CHECK-NEXT:  .LBB111_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB111_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <128 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fminimum.v128f32(<128 x float> %v)
  ret float %red
}

define float @vreduce_fminimum_v128f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v128f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle32.v v16, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    vle32.v v0, (a1)
; CHECK-NEXT:    vfmin.vv v16, v24, v16
; CHECK-NEXT:    vfmin.vv v8, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fminimum.v128f32(<128 x float> %v)
  ret float %red
}

declare double @llvm.vector.reduce.fminimum.v2f64(<2 x double>)

define double @vreduce_fminimum_v2f64(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v9, v8, v8
; CHECK-NEXT:    vcpop.m a0, v9
; CHECK-NEXT:    beqz a0, .LBB113_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI113_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI113_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB113_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fminimum.v2f64(<2 x double> %v)
  ret double %red
}

define double @vreduce_fminimum_v2f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v2f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fminimum.v2f64(<2 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fminimum.v4f64(<4 x double>)

define double @vreduce_fminimum_v4f64(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vcpop.m a0, v10
; CHECK-NEXT:    beqz a0, .LBB115_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI115_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI115_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB115_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fminimum.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fminimum_v4f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fminimum.v4f64(<4 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fminimum.v8f64(<8 x double>)

define double @vreduce_fminimum_v8f64(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vcpop.m a0, v12
; CHECK-NEXT:    beqz a0, .LBB117_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI117_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI117_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB117_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fminimum.v8f64(<8 x double> %v)
  ret double %red
}

define double @vreduce_fminimum_v8f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fminimum.v8f64(<8 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fminimum.v16f64(<16 x double>)

define double @vreduce_fminimum_v16f64(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB119_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI119_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI119_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB119_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fminimum.v16f64(<16 x double> %v)
  ret double %red
}

define double @vreduce_fminimum_v16f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v16f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fminimum.v16f64(<16 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fminimum.v32f64(<32 x double>)

define double @vreduce_fminimum_v32f64(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vle64.v v24, (a1)
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB121_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI121_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI121_0)(a0)
; CHECK-NEXT:    j .LBB121_3
; CHECK-NEXT:  .LBB121_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB121_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fminimum.v32f64(<32 x double> %v)
  ret double %red
}

define double @vreduce_fminimum_v32f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v32f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fminimum.v32f64(<32 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fminimum.v64f64(<64 x double>)

define double @vreduce_fminimum_v64f64(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v64f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    add a1, a1, a2
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 24 * vlenb
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v16, (a1)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle64.v v8, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vle64.v v24, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmerge.vvm v24, v16, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vle64.v v24, (a1)
; CHECK-NEXT:    vmerge.vvm v8, v8, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v16, v8, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v24, v24, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v24, v24, v8
; CHECK-NEXT:    vmfeq.vv v0, v24, v24
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v7, v16, v16
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB123_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI123_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI123_0)(a0)
; CHECK-NEXT:    j .LBB123_3
; CHECK-NEXT:  .LBB123_2:
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB123_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <64 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fminimum.v64f64(<64 x double> %v)
  ret double %red
}

define double @vreduce_fminimum_v64f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fminimum_v64f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    addi a2, a0, 384
; CHECK-NEXT:    vle64.v v16, (a2)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v24, (a0)
; CHECK-NEXT:    vle64.v v0, (a1)
; CHECK-NEXT:    vfmin.vv v16, v24, v16
; CHECK-NEXT:    vfmin.vv v8, v8, v0
; CHECK-NEXT:    vfmin.vv v8, v8, v16
; CHECK-NEXT:    vfredmin.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fminimum.v64f64(<64 x double> %v)
  ret double %red
}

declare float @llvm.vector.reduce.fmaximum.v2f32(<2 x float>)

define float @vreduce_fmaximum_v2f32(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v9, v8, v8
; CHECK-NEXT:    vcpop.m a0, v9
; CHECK-NEXT:    beqz a0, .LBB125_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB125_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmaximum.v2f32(<2 x float> %v)
  ret float %red
}

define float @vreduce_fmaximum_v2f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v2f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmaximum.v2f32(<2 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmaximum.v4f32(<4 x float>)

define float @vreduce_fmaximum_v4f32(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v9, v8, v8
; CHECK-NEXT:    vcpop.m a0, v9
; CHECK-NEXT:    beqz a0, .LBB127_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB127_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> %v)
  ret float %red
}

define float @vreduce_fmaximum_v4f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v4f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmaximum.v4f32(<4 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmaximum.v8f32(<8 x float>)

define float @vreduce_fmaximum_v8f32(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vcpop.m a0, v10
; CHECK-NEXT:    beqz a0, .LBB129_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB129_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmaximum.v8f32(<8 x float> %v)
  ret float %red
}

define float @vreduce_fmaximum_v8f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v8f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmaximum.v8f32(<8 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmaximum.v16f32(<16 x float>)

define float @vreduce_fmaximum_v16f32(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vcpop.m a0, v12
; CHECK-NEXT:    beqz a0, .LBB131_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB131_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmaximum.v16f32(<16 x float> %v)
  ret float %red
}

define float @vreduce_fmaximum_v16f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v16f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmaximum.v16f32(<16 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmaximum.v32f32(<32 x float>)

define float @vreduce_fmaximum_v32f32(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v32f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB133_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB133_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmaximum.v32f32(<32 x float> %v)
  ret float %red
}

define float @vreduce_fmaximum_v32f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v32f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmaximum.v32f32(<32 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmaximum.v64f32(<64 x float>)

define float @vreduce_fmaximum_v64f32(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v64f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    li a2, 32
; CHECK-NEXT:    vsetvli zero, a2, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vle32.v v24, (a1)
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB135_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    j .LBB135_3
; CHECK-NEXT:  .LBB135_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB135_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <64 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmaximum.v64f32(<64 x float> %v)
  ret float %red
}

define float @vreduce_fmaximum_v64f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v64f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v16, (a0)
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmaximum.v64f32(<64 x float> %v)
  ret float %red
}

declare float @llvm.vector.reduce.fmaximum.v128f32(<128 x float>)

define float @vreduce_fmaximum_v128f32(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v128f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    add a1, a1, a2
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 24 * vlenb
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    addi a2, a0, 128
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v16, (a2)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle32.v v8, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmerge.vvm v24, v16, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vle32.v v24, (a1)
; CHECK-NEXT:    vmerge.vvm v8, v8, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v16, v8, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v24, v24, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v24, v24, v8
; CHECK-NEXT:    vmfeq.vv v0, v24, v24
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v7, v16, v16
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB137_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, 523264
; CHECK-NEXT:    fmv.w.x fa0, a0
; CHECK-NEXT:    j .LBB137_3
; CHECK-NEXT:  .LBB137_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB137_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <128 x float>, ptr %x
  %red = call float @llvm.vector.reduce.fmaximum.v128f32(<128 x float> %v)
  ret float %red
}

define float @vreduce_fmaximum_v128f32_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v128f32_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a1, 32
; CHECK-NEXT:    vsetvli zero, a1, e32, m8, ta, ma
; CHECK-NEXT:    vle32.v v8, (a0)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle32.v v16, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle32.v v24, (a0)
; CHECK-NEXT:    vle32.v v0, (a1)
; CHECK-NEXT:    vfmax.vv v16, v24, v16
; CHECK-NEXT:    vfmax.vv v8, v8, v0
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <128 x float>, ptr %x
  %red = call nnan float @llvm.vector.reduce.fmaximum.v128f32(<128 x float> %v)
  ret float %red
}

declare double @llvm.vector.reduce.fmaximum.v2f64(<2 x double>)

define double @vreduce_fmaximum_v2f64(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v9, v8, v8
; CHECK-NEXT:    vcpop.m a0, v9
; CHECK-NEXT:    beqz a0, .LBB139_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI139_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI139_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB139_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmaximum.v2f64(<2 x double> %v)
  ret double %red
}

define double @vreduce_fmaximum_v2f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v2f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e64, m1, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <2 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmaximum.v2f64(<2 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmaximum.v4f64(<4 x double>)

define double @vreduce_fmaximum_v4f64(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v10, v8, v8
; CHECK-NEXT:    vcpop.m a0, v10
; CHECK-NEXT:    beqz a0, .LBB141_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI141_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI141_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB141_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmaximum.v4f64(<4 x double> %v)
  ret double %red
}

define double @vreduce_fmaximum_v4f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v4f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <4 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmaximum.v4f64(<4 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmaximum.v8f64(<8 x double>)

define double @vreduce_fmaximum_v8f64(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v12, v8, v8
; CHECK-NEXT:    vcpop.m a0, v12
; CHECK-NEXT:    beqz a0, .LBB143_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI143_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI143_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB143_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmaximum.v8f64(<8 x double> %v)
  ret double %red
}

define double @vreduce_fmaximum_v8f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v8f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <8 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmaximum.v8f64(<8 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmaximum.v16f64(<16 x double>)

define double @vreduce_fmaximum_v16f64(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v16f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB145_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI145_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI145_0)(a0)
; CHECK-NEXT:    ret
; CHECK-NEXT:  .LBB145_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmaximum.v16f64(<16 x double> %v)
  ret double %red
}

define double @vreduce_fmaximum_v16f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v16f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <16 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmaximum.v16f64(<16 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmaximum.v32f64(<32 x double>)

define double @vreduce_fmaximum_v32f64(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v32f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x08, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 8 * vlenb
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vle64.v v24, (a1)
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB147_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI147_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI147_0)(a0)
; CHECK-NEXT:    j .LBB147_3
; CHECK-NEXT:  .LBB147_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB147_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmaximum.v32f64(<32 x double> %v)
  ret double %red
}

define double @vreduce_fmaximum_v32f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v32f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v16, (a0)
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <32 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmaximum.v32f64(<32 x double> %v)
  ret double %red
}

declare double @llvm.vector.reduce.fmaximum.v64f64(<64 x double>)

define double @vreduce_fmaximum_v64f64(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v64f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addi sp, sp, -16
; CHECK-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NEXT:    csrr a1, vlenb
; CHECK-NEXT:    slli a1, a1, 3
; CHECK-NEXT:    mv a2, a1
; CHECK-NEXT:    slli a1, a1, 1
; CHECK-NEXT:    add a1, a1, a2
; CHECK-NEXT:    sub sp, sp, a1
; CHECK-NEXT:    .cfi_escape 0x0f, 0x0d, 0x72, 0x00, 0x11, 0x10, 0x22, 0x11, 0x18, 0x92, 0xa2, 0x38, 0x00, 0x1e, 0x22 # sp + 16 + 24 * vlenb
; CHECK-NEXT:    addi a1, a0, 128
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v16, (a1)
; CHECK-NEXT:    addi a1, a0, 384
; CHECK-NEXT:    vle64.v v8, (a1)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    vmfeq.vv v0, v16, v16
; CHECK-NEXT:    vle64.v v24, (a0)
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmerge.vvm v24, v16, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v24, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vle64.v v24, (a1)
; CHECK-NEXT:    vmerge.vvm v8, v8, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v0, v8, v8
; CHECK-NEXT:    vmfeq.vv v7, v24, v24
; CHECK-NEXT:    vmerge.vvm v16, v8, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v16, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v24, v24, v8, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v8, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v24, v24, v8
; CHECK-NEXT:    vmfeq.vv v0, v24, v24
; CHECK-NEXT:    addi a0, sp, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vmfeq.vv v7, v16, v16
; CHECK-NEXT:    vmerge.vvm v8, v24, v16, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vs8r.v v8, (a0) # Unknown-size Folded Spill
; CHECK-NEXT:    vmv1r.v v0, v7
; CHECK-NEXT:    vmerge.vvm v8, v16, v24, v0
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 4
; CHECK-NEXT:    add a0, sp, a0
; CHECK-NEXT:    addi a0, a0, 16
; CHECK-NEXT:    vl8r.v v16, (a0) # Unknown-size Folded Reload
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vmfne.vv v16, v8, v8
; CHECK-NEXT:    vcpop.m a0, v16
; CHECK-NEXT:    beqz a0, .LBB149_2
; CHECK-NEXT:  # %bb.1:
; CHECK-NEXT:    lui a0, %hi(.LCPI149_0)
; CHECK-NEXT:    fld fa0, %lo(.LCPI149_0)(a0)
; CHECK-NEXT:    j .LBB149_3
; CHECK-NEXT:  .LBB149_2:
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:  .LBB149_3:
; CHECK-NEXT:    csrr a0, vlenb
; CHECK-NEXT:    slli a0, a0, 3
; CHECK-NEXT:    mv a1, a0
; CHECK-NEXT:    slli a0, a0, 1
; CHECK-NEXT:    add a0, a0, a1
; CHECK-NEXT:    add sp, sp, a0
; CHECK-NEXT:    addi sp, sp, 16
; CHECK-NEXT:    ret
  %v = load <64 x double>, ptr %x
  %red = call double @llvm.vector.reduce.fmaximum.v64f64(<64 x double> %v)
  ret double %red
}

define double @vreduce_fmaximum_v64f64_nonans(ptr %x) {
; CHECK-LABEL: vreduce_fmaximum_v64f64_nonans:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-NEXT:    vle64.v v8, (a0)
; CHECK-NEXT:    addi a1, a0, 256
; CHECK-NEXT:    addi a2, a0, 384
; CHECK-NEXT:    vle64.v v16, (a2)
; CHECK-NEXT:    addi a0, a0, 128
; CHECK-NEXT:    vle64.v v24, (a0)
; CHECK-NEXT:    vle64.v v0, (a1)
; CHECK-NEXT:    vfmax.vv v16, v24, v16
; CHECK-NEXT:    vfmax.vv v8, v8, v0
; CHECK-NEXT:    vfmax.vv v8, v8, v16
; CHECK-NEXT:    vfredmax.vs v8, v8, v8
; CHECK-NEXT:    vfmv.f.s fa0, v8
; CHECK-NEXT:    ret
  %v = load <64 x double>, ptr %x
  %red = call nnan double @llvm.vector.reduce.fmaximum.v64f64(<64 x double> %v)
  ret double %red
}
