; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=+d < %s | FileCheck %s --check-prefix=LA32
; RUN: llc --mtriple=loongarch64 -mattr=+d < %s | FileCheck %s --check-prefix=LA64
; RUN: llc --mtriple=loongarch32 -mattr=+d -loongarch-check-zero-division < %s \
; RUN:     | FileCheck %s --check-prefix=LA32-TRAP
; RUN: llc --mtriple=loongarch64 -mattr=+d -loongarch-check-zero-division < %s \
; RUN:     | FileCheck %s --check-prefix=LA64-TRAP

;; Test the sdiv/udiv/srem/urem LLVM IR.

define i1 @sdiv_i1(i1 %a, i1 %b) {
; LA32-LABEL: sdiv_i1:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_i1:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i1 %a, %b
  ret i1 %r
}

define i8 @sdiv_i8(i8 %a, i8 %b) {
; LA32-LABEL: sdiv_i8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ext.w.b $a1, $a1
; LA32-NEXT:    ext.w.b $a0, $a0
; LA32-NEXT:    div.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.b $a1, $a1
; LA64-NEXT:    ext.w.b $a0, $a0
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_i8:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    ext.w.b $a1, $a1
; LA32-TRAP-NEXT:    ext.w.b $a0, $a0
; LA32-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB1_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB1_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.b $a1, $a1
; LA64-TRAP-NEXT:    ext.w.b $a0, $a0
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB1_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB1_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i8 %a, %b
  ret i8 %r
}

define i16 @sdiv_i16(i16 %a, i16 %b) {
; LA32-LABEL: sdiv_i16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ext.w.h $a1, $a1
; LA32-NEXT:    ext.w.h $a0, $a0
; LA32-NEXT:    div.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.h $a1, $a1
; LA64-NEXT:    ext.w.h $a0, $a0
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_i16:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    ext.w.h $a1, $a1
; LA32-TRAP-NEXT:    ext.w.h $a0, $a0
; LA32-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB2_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB2_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.h $a1, $a1
; LA64-TRAP-NEXT:    ext.w.h $a0, $a0
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB2_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB2_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i16 %a, %b
  ret i16 %r
}

define i32 @sdiv_i32(i32 %a, i32 %b) {
; LA32-LABEL: sdiv_i32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_i32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB3_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB3_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB3_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB3_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define i32 @sdiv_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: sdiv_ui32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_ui32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB4_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB4_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB4_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB4_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define signext i32 @sdiv_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32-LABEL: sdiv_si32_ui32_ui32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_si32_ui32_ui32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB5_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB5_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB5_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB5_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define signext i32 @sdiv_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: sdiv_si32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.w $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_si32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB6_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB6_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.w $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB6_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB6_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i32 %a, %b
  ret i32 %r
}

define i64 @sdiv_i64(i64 %a, i64 %b) {
; LA32-LABEL: sdiv_i64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    .cfi_def_cfa_offset 16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    .cfi_offset 1, -4
; LA32-NEXT:    bl %plt(__divdi3)
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: sdiv_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: sdiv_i64:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-TRAP-NEXT:    .cfi_offset 1, -4
; LA32-TRAP-NEXT:    bl %plt(__divdi3)
; LA32-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: sdiv_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB7_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB7_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = sdiv i64 %a, %b
  ret i64 %r
}

define i1 @udiv_i1(i1 %a, i1 %b) {
; LA32-LABEL: udiv_i1:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_i1:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i1 %a, %b
  ret i1 %r
}

define i8 @udiv_i8(i8 %a, i8 %b) {
; LA32-LABEL: udiv_i8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    andi $a1, $a1, 255
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    div.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    div.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_i8:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    andi $a1, $a1, 255
; LA32-TRAP-NEXT:    andi $a0, $a0, 255
; LA32-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB9_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB9_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    andi $a1, $a1, 255
; LA64-TRAP-NEXT:    andi $a0, $a0, 255
; LA64-TRAP-NEXT:    div.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB9_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB9_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i8 %a, %b
  ret i8 %r
}

define i16 @udiv_i16(i16 %a, i16 %b) {
; LA32-LABEL: udiv_i16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32-NEXT:    div.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    div.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_i16:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32-TRAP-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB10_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB10_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-TRAP-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-TRAP-NEXT:    div.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB10_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB10_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i16 %a, %b
  ret i16 %r
}

define i32 @udiv_i32(i32 %a, i32 %b) {
; LA32-LABEL: udiv_i32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_i32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB11_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB11_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB11_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB11_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define i32 @udiv_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: udiv_ui32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_ui32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB12_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB12_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB12_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB12_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define signext i32 @udiv_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32-LABEL: udiv_si32_ui32_ui32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_si32_ui32_ui32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB13_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB13_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB13_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB13_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define signext i32 @udiv_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: udiv_si32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    div.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_si32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB14_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB14_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB14_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB14_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i32 %a, %b
  ret i32 %r
}

define i64 @udiv_i64(i64 %a, i64 %b) {
; LA32-LABEL: udiv_i64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    .cfi_def_cfa_offset 16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    .cfi_offset 1, -4
; LA32-NEXT:    bl %plt(__udivdi3)
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: udiv_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    div.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: udiv_i64:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-TRAP-NEXT:    .cfi_offset 1, -4
; LA32-TRAP-NEXT:    bl %plt(__udivdi3)
; LA32-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: udiv_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    div.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB15_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB15_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = udiv i64 %a, %b
  ret i64 %r
}

define i1 @srem_i1(i1 %a, i1 %b) {
; LA32-LABEL: srem_i1:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    move $a0, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_i1:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    move $a0, $zero
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    move $a0, $zero
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i1 %a, %b
  ret i1 %r
}

define i8 @srem_i8(i8 %a, i8 %b) {
; LA32-LABEL: srem_i8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ext.w.b $a1, $a1
; LA32-NEXT:    ext.w.b $a0, $a0
; LA32-NEXT:    mod.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.b $a1, $a1
; LA64-NEXT:    ext.w.b $a0, $a0
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_i8:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    ext.w.b $a1, $a1
; LA32-TRAP-NEXT:    ext.w.b $a0, $a0
; LA32-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB17_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB17_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.b $a1, $a1
; LA64-TRAP-NEXT:    ext.w.b $a0, $a0
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB17_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB17_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i8 %a, %b
  ret i8 %r
}

define i16 @srem_i16(i16 %a, i16 %b) {
; LA32-LABEL: srem_i16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    ext.w.h $a1, $a1
; LA32-NEXT:    ext.w.h $a0, $a0
; LA32-NEXT:    mod.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    ext.w.h $a1, $a1
; LA64-NEXT:    ext.w.h $a0, $a0
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_i16:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    ext.w.h $a1, $a1
; LA32-TRAP-NEXT:    ext.w.h $a0, $a0
; LA32-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB18_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB18_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    ext.w.h $a1, $a1
; LA64-TRAP-NEXT:    ext.w.h $a0, $a0
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB18_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB18_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i16 %a, %b
  ret i16 %r
}

define i32 @srem_i32(i32 %a, i32 %b) {
; LA32-LABEL: srem_i32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_i32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB19_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB19_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB19_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB19_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define i32 @srem_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: srem_ui32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_ui32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB20_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB20_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB20_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB20_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define signext i32 @srem_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32-LABEL: srem_si32_ui32_ui32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_si32_ui32_ui32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB21_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB21_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB21_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB21_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define signext i32 @srem_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: srem_si32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.w $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_si32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.w $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB22_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB22_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB22_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB22_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i32 %a, %b
  ret i32 %r
}

define i64 @srem_i64(i64 %a, i64 %b) {
; LA32-LABEL: srem_i64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    .cfi_def_cfa_offset 16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    .cfi_offset 1, -4
; LA32-NEXT:    bl %plt(__moddi3)
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: srem_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.d $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: srem_i64:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-TRAP-NEXT:    .cfi_offset 1, -4
; LA32-TRAP-NEXT:    bl %plt(__moddi3)
; LA32-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: srem_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.d $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB23_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB23_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = srem i64 %a, %b
  ret i64 %r
}

define i1 @urem_i1(i1 %a, i1 %b) {
; LA32-LABEL: urem_i1:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    move $a0, $zero
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_i1:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_i1:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    move $a0, $zero
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i1:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    move $a0, $zero
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i1 %a, %b
  ret i1 %r
}

define i8 @urem_i8(i8 %a, i8 %b) {
; LA32-LABEL: urem_i8:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    andi $a1, $a1, 255
; LA32-NEXT:    andi $a0, $a0, 255
; LA32-NEXT:    mod.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_i8:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    andi $a1, $a1, 255
; LA64-NEXT:    andi $a0, $a0, 255
; LA64-NEXT:    mod.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_i8:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    andi $a1, $a1, 255
; LA32-TRAP-NEXT:    andi $a0, $a0, 255
; LA32-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB25_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB25_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i8:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    andi $a1, $a1, 255
; LA64-TRAP-NEXT:    andi $a0, $a0, 255
; LA64-TRAP-NEXT:    mod.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB25_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB25_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i8 %a, %b
  ret i8 %r
}

define i16 @urem_i16(i16 %a, i16 %b) {
; LA32-LABEL: urem_i16:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32-NEXT:    mod.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_i16:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-NEXT:    mod.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_i16:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    bstrpick.w $a1, $a1, 15, 0
; LA32-TRAP-NEXT:    bstrpick.w $a0, $a0, 15, 0
; LA32-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB26_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB26_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i16:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    bstrpick.d $a1, $a1, 15, 0
; LA64-TRAP-NEXT:    bstrpick.d $a0, $a0, 15, 0
; LA64-TRAP-NEXT:    mod.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB26_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB26_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i16 %a, %b
  ret i16 %r
}

define i32 @urem_i32(i32 %a, i32 %b) {
; LA32-LABEL: urem_i32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_i32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_i32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB27_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB27_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB27_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB27_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define i32 @urem_ui32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: urem_ui32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_ui32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_ui32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB28_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB28_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_ui32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB28_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB28_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define signext i32 @urem_si32_ui32_ui32(i32 %a, i32 %b) {
; LA32-LABEL: urem_si32_ui32_ui32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_si32_ui32_ui32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    addi.w $a1, $a1, 0
; LA64-NEXT:    addi.w $a0, $a0, 0
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_si32_ui32_ui32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB29_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB29_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_si32_ui32_ui32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    addi.w $a1, $a1, 0
; LA64-TRAP-NEXT:    addi.w $a0, $a0, 0
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB29_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB29_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define signext i32 @urem_si32_si32_si32(i32 signext %a, i32 signext %b) {
; LA32-LABEL: urem_si32_si32_si32:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    mod.wu $a0, $a0, $a1
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_si32_si32_si32:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.wu $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_si32_si32_si32:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA32-TRAP-NEXT:    bnez $a1, .LBB30_2
; LA32-TRAP-NEXT:  # %bb.1: # %entry
; LA32-TRAP-NEXT:    break 7
; LA32-TRAP-NEXT:  .LBB30_2: # %entry
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_si32_si32_si32:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.wu $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB30_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB30_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i32 %a, %b
  ret i32 %r
}

define i64 @urem_i64(i64 %a, i64 %b) {
; LA32-LABEL: urem_i64:
; LA32:       # %bb.0: # %entry
; LA32-NEXT:    addi.w $sp, $sp, -16
; LA32-NEXT:    .cfi_def_cfa_offset 16
; LA32-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-NEXT:    .cfi_offset 1, -4
; LA32-NEXT:    bl %plt(__umoddi3)
; LA32-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-NEXT:    addi.w $sp, $sp, 16
; LA32-NEXT:    ret
;
; LA64-LABEL: urem_i64:
; LA64:       # %bb.0: # %entry
; LA64-NEXT:    mod.du $a0, $a0, $a1
; LA64-NEXT:    ret
;
; LA32-TRAP-LABEL: urem_i64:
; LA32-TRAP:       # %bb.0: # %entry
; LA32-TRAP-NEXT:    addi.w $sp, $sp, -16
; LA32-TRAP-NEXT:    .cfi_def_cfa_offset 16
; LA32-TRAP-NEXT:    st.w $ra, $sp, 12 # 4-byte Folded Spill
; LA32-TRAP-NEXT:    .cfi_offset 1, -4
; LA32-TRAP-NEXT:    bl %plt(__umoddi3)
; LA32-TRAP-NEXT:    ld.w $ra, $sp, 12 # 4-byte Folded Reload
; LA32-TRAP-NEXT:    addi.w $sp, $sp, 16
; LA32-TRAP-NEXT:    ret
;
; LA64-TRAP-LABEL: urem_i64:
; LA64-TRAP:       # %bb.0: # %entry
; LA64-TRAP-NEXT:    mod.du $a0, $a0, $a1
; LA64-TRAP-NEXT:    bnez $a1, .LBB31_2
; LA64-TRAP-NEXT:  # %bb.1: # %entry
; LA64-TRAP-NEXT:    break 7
; LA64-TRAP-NEXT:  .LBB31_2: # %entry
; LA64-TRAP-NEXT:    ret
entry:
  %r = urem i64 %a, %b
  ret i64 %r
}
