; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn -mcpu=gfx900 -global-isel -mattr=-promote-alloca -mattr=+enable-flat-scratch -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1030 -global-isel -mattr=-promote-alloca -mattr=+enable-flat-scratch -verify-machineinstrs < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx940 -global-isel -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefix=GFX940 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1100 -global-isel -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -mtriple=amdgcn -mcpu=gfx1200 -global-isel -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefix=GFX12 %s

define amdgpu_kernel void @store_load_sindex_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    s_add_i32 s1, s1, 0
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_add_i32 s0, s0, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    s_add_i32 s0, s0, 0
; GFX10-NEXT:    s_add_i32 s1, s1, 0
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_sindex_kernel:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX940-NEXT:    v_mov_b32_e32 v0, 15
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_lshl_b32 s1, s0, 2
; GFX940-NEXT:    s_and_b32 s0, s0, 15
; GFX940-NEXT:    s_add_i32 s1, s1, 0
; GFX940-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NEXT:    scratch_load_dword v0, v0, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 15 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_add_i32 s0, s0, 0
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b32 s1, s0, 2
; GFX12-NEXT:    s_and_b32 s0, s0, 15
; GFX12-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    scratch_store_b32 v0, v1, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v2, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_kernel() {
; GFX9-LABEL: store_load_vindex_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    v_add_u32_e32 v1, 0, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_vindex_kernel:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX940-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX940-NEXT:    v_mov_b32_e32 v2, 15
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v0, 0, v0
; GFX940-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0, v1
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v1
; GFX12-NEXT:    scratch_store_b32 v0, v2, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:124 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 31, %i2
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s32, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s32, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_vindex_foo:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX940-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX940-NEXT:    v_mov_b32_e32 v2, 15
; GFX940-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX940-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-NEXT:    scratch_load_dword v0, v0, s32 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, s32 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @private_ptr_foo(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: private_ptr_foo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX9-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: private_ptr_foo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: private_ptr_foo:
; GFX940:       ; %bb.0:
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX940-NEXT:    scratch_store_dword v0, v1, off offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: private_ptr_foo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: private_ptr_foo:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr inbounds float, ptr addrspace(5) %arg, i32 1
  store float 1.000000e+01, ptr addrspace(5) %gep, align 4
  ret void
}

define amdgpu_kernel void @store_load_sindex_small_offset_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_small_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s1 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_addk_i32 s1, 0x100
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_addk_i32 s0, 0x100
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_small_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX10-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    s_addk_i32 s0, 0x100
; GFX10-NEXT:    s_addk_i32 s1, 0x100
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_sindex_small_offset_kernel:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX940-NEXT:    scratch_load_dword v0, off, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 15
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_lshl_b32 s1, s0, 2
; GFX940-NEXT:    s_and_b32 s0, s0, 15
; GFX940-NEXT:    s_addk_i32 s1, 0x100
; GFX940-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NEXT:    scratch_load_dword v0, v0, off offset:256 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_small_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX11-NEXT:    scratch_load_b32 v2, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 15 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_addk_i32 s0, 0x100
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:256 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_small_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b32 s1, s0, 2
; GFX12-NEXT:    s_and_b32 s0, s0, 15
; GFX12-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v2, off offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 undef
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_small_offset_kernel() {
; GFX9-LABEL: store_load_vindex_small_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_load_dword v1, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x100, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 0x100, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_small_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x100, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x100, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_vindex_small_offset_kernel:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    scratch_load_dword v1, off, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX940-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX940-NEXT:    v_mov_b32_e32 v2, 15
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-NEXT:    scratch_store_dword v1, v2, off offset:256 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v0, 0x100, v0
; GFX940-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_small_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    scratch_load_b32 v3, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    scratch_store_b32 v0, v2, off offset:256 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x100, v1
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_small_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v1
; GFX12-NEXT:    scratch_store_b32 v0, v2, off offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:380 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 undef
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 31, %i2
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_small_offset_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_small_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v1, off, s32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    s_add_i32 s0, s32, 0x100
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_add_i32 s0, s32, 0x100
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_small_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x100
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, s32 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x100
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_vindex_small_offset_foo:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    scratch_load_dword v1, off, s32 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX940-NEXT:    s_add_i32 s0, s32, 0x100
; GFX940-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-NEXT:    v_mov_b32_e32 v2, 15
; GFX940-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX940-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-NEXT:    scratch_load_dword v0, v0, s32 offset:256 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_small_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-NEXT:    s_add_i32 s0, s32, 0x100
; GFX11-NEXT:    scratch_load_b32 v3, off, s32 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, s32 offset:256 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_small_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 undef
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_sindex_large_offset_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_large_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_addk_i32 s1, 0x4004
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_large_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX10-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    s_addk_i32 s0, 0x4004
; GFX10-NEXT:    s_addk_i32 s1, 0x4004
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_sindex_large_offset_kernel:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX940-NEXT:    scratch_load_dword v0, off, off offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 15
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    s_lshl_b32 s1, s0, 2
; GFX940-NEXT:    s_and_b32 s0, s0, 15
; GFX940-NEXT:    s_addk_i32 s1, 0x4004
; GFX940-NEXT:    s_lshl_b32 s0, s0, 2
; GFX940-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, s0
; GFX940-NEXT:    s_movk_i32 s0, 0x4004
; GFX940-NEXT:    scratch_load_dword v0, v0, s0 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_large_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX11-NEXT:    scratch_load_b32 v2, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 15 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_movk_i32 s0, 0x4004
; GFX11-NEXT:    scratch_load_b32 v0, v1, s0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_large_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b32 s1, s0, 2
; GFX12-NEXT:    s_and_b32 s0, s0, 15
; GFX12-NEXT:    v_mov_b32_e32 v0, s1
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_mov_b32_e32 v2, s0
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v2, off offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 undef
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_large_offset_kernel() {
; GFX9-LABEL: store_load_vindex_large_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_load_dword v1, off, s0 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x4004, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 0x4004, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_large_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x4004, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_vindex_large_offset_kernel:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    scratch_load_dword v1, off, off offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX940-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX940-NEXT:    v_mov_b32_e32 v2, 15
; GFX940-NEXT:    s_movk_i32 s0, 0x4004
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-NEXT:    scratch_store_dword v1, v2, s0 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_add_u32_e32 v0, 0x4004, v0
; GFX940-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_large_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_movk_i32 s0, 0x4004
; GFX11-NEXT:    scratch_load_b32 v3, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    scratch_store_b32 v0, v2, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v1
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_large_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v1
; GFX12-NEXT:    scratch_store_b32 v0, v2, off offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:16508 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 undef
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 31, %i2
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_large_offset_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_large_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v1, off, s32 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_large_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, s32 offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_vindex_large_offset_foo:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    scratch_load_dword v1, off, s32 offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX940-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX940-NEXT:    v_add_u32_e32 v1, s0, v1
; GFX940-NEXT:    v_mov_b32_e32 v2, 15
; GFX940-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX940-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX940-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX940-NEXT:    scratch_load_dword v0, v0, s0 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_large_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_load_b32 v3, off, s32 offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, s0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_large_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 undef
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_large_imm_offset_kernel() {
; GFX9-LABEL: store_load_large_imm_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_store_dword off, v0, s0 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_movk_i32 s0, 0x3e80
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_add_i32 s0, s0, 4
; GFX9-NEXT:    scratch_store_dword off, v0, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_large_imm_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    v_mov_b32_e32 v0, 13
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_movk_i32 s0, 0x3e80
; GFX10-NEXT:    s_add_i32 s0, s0, 4
; GFX10-NEXT:    scratch_store_dword off, v0, off offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_store_dword off, v1, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_large_imm_offset_kernel:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    v_mov_b32_e32 v0, 13
; GFX940-NEXT:    scratch_store_dword off, v0, off offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0x3e80
; GFX940-NEXT:    v_mov_b32_e32 v1, 15
; GFX940-NEXT:    scratch_store_dword v0, v1, off offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    scratch_load_dword v0, v0, off offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_large_imm_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 0x3e80
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    scratch_store_b32 off, v0, off offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_store_b32 v1, v2, off offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_large_imm_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-NEXT:    scratch_store_b32 off, v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v1, off offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, off offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %i = alloca [4096 x i32], align 4, addrspace(5)
  %i1 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 undef
  store volatile i32 13, ptr addrspace(5) %i1, align 4
  %i7 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i10 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_large_imm_offset_foo() {
; GFX9-LABEL: store_load_large_imm_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-NEXT:    s_movk_i32 s0, 0x3e80
; GFX9-NEXT:    s_add_i32 s1, s32, 4
; GFX9-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_add_i32 s0, s0, s1
; GFX9-NEXT:    scratch_store_dword off, v0, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_large_imm_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 13
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_movk_i32 s0, 0x3e80
; GFX10-NEXT:    s_add_i32 s1, s32, 4
; GFX10-NEXT:    s_add_i32 s0, s0, s1
; GFX10-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_store_dword off, v1, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_large_imm_offset_foo:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 13
; GFX940-NEXT:    scratch_store_dword off, v0, s32 offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    v_mov_b32_e32 v0, 0x3e80
; GFX940-NEXT:    v_mov_b32_e32 v1, 15
; GFX940-NEXT:    scratch_store_dword v0, v1, s32 offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    scratch_load_dword v0, v0, s32 offset:4 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_large_imm_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 0x3e80
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    scratch_store_b32 off, v0, s32 offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_store_b32 v1, v2, s32 offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, s32 offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_large_imm_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v0, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v1, s32 offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s32 offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = alloca [4096 x i32], align 4, addrspace(5)
  %i1 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 undef
  store volatile i32 13, ptr addrspace(5) %i1, align 4
  %i7 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i10 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vidx_sidx_offset(i32 %sidx) {
; GFX9-LABEL: store_load_vidx_sidx_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s6, s11
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s7, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX9-NEXT:    v_add_u32_e32 v0, 0, v0
; GFX9-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vidx_sidx_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s6, s6, s11
; GFX10-NEXT:    s_addc_u32 s7, s7, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s6
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s7
; GFX10-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0, v0
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX940-LABEL: store_load_vidx_sidx_offset:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_load_dword s0, s[2:3], 0x24
; GFX940-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX940-NEXT:    v_mov_b32_e32 v1, 15
; GFX940-NEXT:    s_waitcnt lgkmcnt(0)
; GFX940-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX940-NEXT:    v_add_u32_e32 v0, 0, v0
; GFX940-NEXT:    scratch_store_dword v0, v1, off offset:1024 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    scratch_load_dword v0, v0, off offset:1024 sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vidx_sidx_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX11-NEXT:    v_add_nc_u32_e32 v0, 0, v0
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:1024 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, off offset:1024 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vidx_sidx_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[2:3], 0x24
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:1024 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v0, off offset:1024 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
bb:
  %alloca = alloca [32 x i32], align 4, addrspace(5)
  %vidx = tail call i32 @llvm.amdgcn.workitem.id.x()
  %add1 = add nsw i32 %sidx, %vidx
  %add2 = add nsw i32 %add1, 256
  %gep = getelementptr inbounds [32 x i32], ptr addrspace(5) %alloca, i32 0, i32 %add2
  store volatile i32 15, ptr addrspace(5) %gep, align 4
  %load = load volatile i32, ptr addrspace(5) %gep, align 4
  ret void
}

define void @store_load_i64_aligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i64_aligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i64_aligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_i64_aligned:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], 15
; GFX940-NEXT:    scratch_store_dwordx2 v0, v[2:3], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v0, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_i64_aligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_i64_aligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile i64 15, ptr addrspace(5) %arg, align 8
  %load = load volatile i64, ptr addrspace(5) %arg, align 8
  ret void
}

define void @store_load_i64_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i64_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i64_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_i64_unaligned:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], 15
; GFX940-NEXT:    scratch_store_dwordx2 v0, v[2:3], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    scratch_load_dwordx2 v[0:1], v0, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_i64_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_i64_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile i64 15, ptr addrspace(5) %arg, align 1
  %load = load volatile i64, ptr addrspace(5) %arg, align 1
  ret void
}

define void @store_load_v3i32_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_v3i32_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s2, 3
; GFX9-NEXT:    s_mov_b32 s1, 2
; GFX9-NEXT:    s_mov_b32 s0, 1
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_v3i32_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s2, 3
; GFX10-NEXT:    s_mov_b32 s1, 2
; GFX10-NEXT:    s_mov_b32 s0, 1
; GFX10-NEXT:    v_mov_b32_e32 v3, s2
; GFX10-NEXT:    v_mov_b32_e32 v2, s1
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_v3i32_unaligned:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b32 s2, 3
; GFX940-NEXT:    s_mov_b32 s1, 2
; GFX940-NEXT:    s_mov_b32 s0, 1
; GFX940-NEXT:    v_mov_b32_e32 v4, s2
; GFX940-NEXT:    v_mov_b32_e32 v3, s1
; GFX940-NEXT:    v_mov_b32_e32 v2, s0
; GFX940-NEXT:    scratch_store_dwordx3 v0, v[2:4], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    scratch_load_dwordx3 v[0:2], v0, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_v3i32_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s2, 3
; GFX11-NEXT:    s_mov_b32 s1, 2
; GFX11-NEXT:    s_mov_b32 s0, 1
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v2, s1
; GFX11-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-NEXT:    scratch_store_b96 v0, v[1:3], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b96 v[0:2], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_v3i32_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s2, 3
; GFX12-NEXT:    s_mov_b32 s1, 2
; GFX12-NEXT:    s_mov_b32 s0, 1
; GFX12-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v2, s1
; GFX12-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b96 v0, v[1:3], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b96 v[0:2], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile <3 x i32> <i32 1, i32 2, i32 3>, ptr addrspace(5) %arg, align 1
  %load = load volatile <3 x i32>, ptr addrspace(5) %arg, align 1
  ret void
}

define void @store_load_v4i32_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_v4i32_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 4
; GFX9-NEXT:    s_mov_b32 s2, 3
; GFX9-NEXT:    s_mov_b32 s1, 2
; GFX9-NEXT:    s_mov_b32 s0, 1
; GFX9-NEXT:    v_mov_b32_e32 v4, s3
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_v4i32_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s3, 4
; GFX10-NEXT:    s_mov_b32 s2, 3
; GFX10-NEXT:    s_mov_b32 s1, 2
; GFX10-NEXT:    s_mov_b32 s0, 1
; GFX10-NEXT:    v_mov_b32_e32 v4, s3
; GFX10-NEXT:    v_mov_b32_e32 v3, s2
; GFX10-NEXT:    v_mov_b32_e32 v2, s1
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX940-LABEL: store_load_v4i32_unaligned:
; GFX940:       ; %bb.0: ; %bb
; GFX940-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX940-NEXT:    s_mov_b32 s3, 4
; GFX940-NEXT:    s_mov_b32 s2, 3
; GFX940-NEXT:    s_mov_b32 s1, 2
; GFX940-NEXT:    s_mov_b32 s0, 1
; GFX940-NEXT:    v_mov_b64_e32 v[4:5], s[2:3]
; GFX940-NEXT:    v_mov_b64_e32 v[2:3], s[0:1]
; GFX940-NEXT:    scratch_store_dwordx4 v0, v[2:5], off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    scratch_load_dwordx4 v[0:3], v0, off sc0 sc1
; GFX940-NEXT:    s_waitcnt vmcnt(0)
; GFX940-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_v4i32_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s3, 4
; GFX11-NEXT:    s_mov_b32 s2, 3
; GFX11-NEXT:    s_mov_b32 s1, 2
; GFX11-NEXT:    s_mov_b32 s0, 1
; GFX11-NEXT:    v_dual_mov_b32 v4, s3 :: v_dual_mov_b32 v3, s2
; GFX11-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    scratch_store_b128 v0, v[1:4], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b128 v[0:3], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_v4i32_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s3, 4
; GFX12-NEXT:    s_mov_b32 s2, 3
; GFX12-NEXT:    s_mov_b32 s1, 2
; GFX12-NEXT:    s_mov_b32 s0, 1
; GFX12-NEXT:    v_dual_mov_b32 v4, s3 :: v_dual_mov_b32 v3, s2
; GFX12-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b128 v0, v[1:4], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b128 v[0:3], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile <4 x i32> <i32 1, i32 2, i32 3, i32 4>, ptr addrspace(5) %arg, align 1
  %load = load volatile <4 x i32>, ptr addrspace(5) %arg, align 1
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
