; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -select-optimize -mtriple=aarch64-linux-gnu -mcpu=neoverse-v2 -S < %s | FileCheck %s --check-prefixes=CHECK,CHECK-STANDARD
; RUN: opt -select-optimize -mtriple=aarch64-linux-gnu -mcpu=neoverse-v2 -S -disable-loop-level-heuristics < %s | FileCheck %s --check-prefixes=CHECK,CHECK-FORCED

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "aarch64"

define i32 @minloc1(ptr nocapture readonly %0, ptr nocapture readonly %1, ptr nocapture readonly %2) {
; CHECK-LABEL: @minloc1(
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[TMP0:%.*]], i64 40
; CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP4]], align 8
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[TMP0]], i64 64
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP6]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[TMP0]], i64 80
; CHECK-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[TMP0]], i64 88
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP0]], align 8
; CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP1:%.*]], align 4
; CHECK-NEXT:    [[TMP14:%.*]] = sext i32 [[TMP13]] to i64
; CHECK-NEXT:    [[TMP15:%.*]] = add nsw i64 [[TMP14]], -1
; CHECK-NEXT:    [[TMP16:%.*]] = mul i64 [[TMP15]], [[TMP5]]
; CHECK-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[TMP12]], i64 [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = shl i64 [[TMP7]], 3
; CHECK-NEXT:    [[TMP19:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP2:%.*]], align 4
; CHECK-NEXT:    [[DOTNOT:%.*]] = icmp slt i64 [[TMP9]], 1
; CHECK-NEXT:    br i1 [[DOTNOT]], label [[DOTPREHEADER:%.*]], label [[DOTPREHEADER35_LR_PH:%.*]]
; CHECK:       .preheader35.lr.ph:
; CHECK-NEXT:    [[TMP21:%.*]] = sub i64 0, [[TMP7]]
; CHECK-NEXT:    br label [[DOTPREHEADER35:%.*]]
; CHECK:       .preheader35:
; CHECK-NEXT:    [[TMP22:%.*]] = phi i32 [ 2147483647, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP30:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[TMP23:%.*]] = phi i64 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[IV_N:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[DOT045:%.*]] = phi i1 [ false, [[DOTPREHEADER35_LR_PH]] ], [ [[DOT2:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[DOTLCSSA364144:%.*]] = phi i32 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP29:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[TMP24:%.*]] = mul nsw i64 [[TMP23]], [[TMP11]]
; CHECK-NEXT:    [[TMP25:%.*]] = getelementptr i8, ptr [[TMP19]], i64 [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
; CHECK-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], [[TMP20]]
; CHECK-NEXT:    [[TMP28:%.*]] = icmp sge i32 [[TMP26]], [[TMP22]]
; CHECK-NEXT:    [[DOTNOT33:%.*]] = and i1 [[DOT045]], [[TMP28]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[TMP27]], i1 true, i1 [[DOTNOT33]]
; CHECK-NEXT:    [[OR_COND_FROZEN:%.*]] = freeze i1 [[OR_COND]]
; CHECK-NEXT:    br i1 [[OR_COND_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false:
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[TMP29]] = phi i32 [ [[DOTLCSSA364144]], [[DOTPREHEADER35]] ], [ 1, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[DOT2]] = phi i1 [ [[DOT045]], [[DOTPREHEADER35]] ], [ true, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[TMP30]] = phi i32 [ [[TMP22]], [[DOTPREHEADER35]] ], [ [[TMP20]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[NOT_OR_COND:%.*]] = xor i1 [[OR_COND]], true
; CHECK-NEXT:    [[IV_N]] = add nuw nsw i64 [[TMP23]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV_N]], [[TMP9]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[DOTPREHEADER]], label [[DOTPREHEADER35]]
; CHECK:       .preheader:
; CHECK-NEXT:    [[DOTLCSSA3641_LCSSA:%.*]] = phi i32 [ 0, [[TMP3:%.*]] ], [ [[TMP29]], [[SELECT_END]] ]
; CHECK-NEXT:    ret i32 [[DOTLCSSA3641_LCSSA]]
;
  %4 = getelementptr i8, ptr %0, i64 40
  %5 = load i64, ptr %4, align 8
  %6 = getelementptr i8, ptr %0, i64 64
  %7 = load i64, ptr %6, align 8
  %8 = getelementptr i8, ptr %0, i64 80
  %9 = load i64, ptr %8, align 8
  %10 = getelementptr i8, ptr %0, i64 88
  %11 = load i64, ptr %10, align 8
  %12 = load ptr, ptr %0, align 8
  %13 = load i32, ptr %1, align 4
  %14 = sext i32 %13 to i64
  %15 = add nsw i64 %14, -1
  %16 = mul i64 %15, %5
  %17 = getelementptr i8, ptr %12, i64 %16
  %18 = shl i64 %7, 3
  %19 = getelementptr i8, ptr %17, i64 %18
  %20 = load i32, ptr %2, align 4
  %.not = icmp slt i64 %9, 1
  br i1 %.not, label %.preheader, label %.preheader35.lr.ph

.preheader35.lr.ph:                               ; preds = %3
  %21 = sub i64 0, %7
  br label %.preheader35

.preheader35:                                     ; preds = %.preheader35.lr.ph, %.preheader35
  %22 = phi i32 [ 2147483647, %.preheader35.lr.ph ], [ %30, %.preheader35 ]
  %23 = phi i64 [ 0, %.preheader35.lr.ph ], [ %iv.n, %.preheader35 ]
  %.045 = phi i1 [ false, %.preheader35.lr.ph ], [ %.2, %.preheader35 ]
  %.lcssa364144 = phi i32 [ 0, %.preheader35.lr.ph ], [ %29, %.preheader35 ]
  %24 = mul nsw i64 %23, %11
  %25 = getelementptr i8, ptr %19, i64 %24
  %26 = load i32, ptr %25, align 4
  %27 = icmp ne i32 %26, %20
  %28 = icmp sge i32 %26, %22
  %.not33 = and i1 %.045, %28
  %or.cond = select i1 %27, i1 true, i1 %.not33
  %29 = select i1 %or.cond, i32 %.lcssa364144, i32 1
  %not.or.cond = xor i1 %or.cond, true
  %.2 = select i1 %not.or.cond, i1 true, i1 %.045
  %30 = select i1 %or.cond, i32 %22, i32 %20
  %iv.n = add nuw nsw i64 %23, 1
  %exitcond.not = icmp eq i64 %iv.n, %9
  br i1 %exitcond.not, label %.preheader, label %.preheader35

.preheader:                                       ; preds = %.preheader35, %3
  %.lcssa3641.lcssa = phi i32 [ 0, %3 ], [ %29, %.preheader35 ]
  ret i32 %.lcssa3641.lcssa
}

define i32 @minloc1_otherunusednot(ptr nocapture readonly %0, ptr nocapture readonly %1, ptr nocapture readonly %2) {
; CHECK-STANDARD-LABEL: @minloc1_otherunusednot(
; CHECK-STANDARD-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[TMP0:%.*]], i64 40
; CHECK-STANDARD-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP4]], align 8
; CHECK-STANDARD-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[TMP0]], i64 64
; CHECK-STANDARD-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP6]], align 8
; CHECK-STANDARD-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[TMP0]], i64 80
; CHECK-STANDARD-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
; CHECK-STANDARD-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[TMP0]], i64 88
; CHECK-STANDARD-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
; CHECK-STANDARD-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP0]], align 8
; CHECK-STANDARD-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP1:%.*]], align 4
; CHECK-STANDARD-NEXT:    [[TMP14:%.*]] = sext i32 [[TMP13]] to i64
; CHECK-STANDARD-NEXT:    [[TMP15:%.*]] = add nsw i64 [[TMP14]], -1
; CHECK-STANDARD-NEXT:    [[TMP16:%.*]] = mul i64 [[TMP15]], [[TMP5]]
; CHECK-STANDARD-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[TMP12]], i64 [[TMP16]]
; CHECK-STANDARD-NEXT:    [[TMP18:%.*]] = shl i64 [[TMP7]], 3
; CHECK-STANDARD-NEXT:    [[TMP19:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP18]]
; CHECK-STANDARD-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP2:%.*]], align 4
; CHECK-STANDARD-NEXT:    [[DOTNOT:%.*]] = icmp slt i64 [[TMP9]], 1
; CHECK-STANDARD-NEXT:    br i1 [[DOTNOT]], label [[DOTPREHEADER:%.*]], label [[DOTPREHEADER35_LR_PH:%.*]]
; CHECK-STANDARD:       .preheader35.lr.ph:
; CHECK-STANDARD-NEXT:    [[TMP21:%.*]] = sub i64 0, [[TMP7]]
; CHECK-STANDARD-NEXT:    br label [[DOTPREHEADER35:%.*]]
; CHECK-STANDARD:       .preheader35:
; CHECK-STANDARD-NEXT:    [[TMP22:%.*]] = phi i32 [ 2147483647, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP30:%.*]], [[DOTPREHEADER35]] ]
; CHECK-STANDARD-NEXT:    [[TMP23:%.*]] = phi i64 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[IV_N:%.*]], [[DOTPREHEADER35]] ]
; CHECK-STANDARD-NEXT:    [[DOT045:%.*]] = phi i1 [ false, [[DOTPREHEADER35_LR_PH]] ], [ [[DOT2:%.*]], [[DOTPREHEADER35]] ]
; CHECK-STANDARD-NEXT:    [[DOTLCSSA364144:%.*]] = phi i32 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP29:%.*]], [[DOTPREHEADER35]] ]
; CHECK-STANDARD-NEXT:    [[TMP24:%.*]] = mul nsw i64 [[TMP23]], [[TMP11]]
; CHECK-STANDARD-NEXT:    [[TMP25:%.*]] = getelementptr i8, ptr [[TMP19]], i64 [[TMP24]]
; CHECK-STANDARD-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
; CHECK-STANDARD-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], [[TMP20]]
; CHECK-STANDARD-NEXT:    [[TMP28:%.*]] = icmp sge i32 [[TMP26]], [[TMP22]]
; CHECK-STANDARD-NEXT:    [[DOTNOT33:%.*]] = and i1 [[DOT045]], [[TMP28]]
; CHECK-STANDARD-NEXT:    [[OR_COND:%.*]] = select i1 [[TMP27]], i1 true, i1 [[DOTNOT33]]
; CHECK-STANDARD-NEXT:    [[TMP29]] = select i1 [[OR_COND]], i32 [[DOTLCSSA364144]], i32 1
; CHECK-STANDARD-NEXT:    [[DOT2]] = select i1 [[OR_COND]], i1 [[DOT045]], i1 true
; CHECK-STANDARD-NEXT:    [[NOT_OR_COND:%.*]] = xor i1 [[OR_COND]], true
; CHECK-STANDARD-NEXT:    [[TMP30]] = select i1 [[OR_COND]], i32 [[TMP22]], i32 [[TMP20]]
; CHECK-STANDARD-NEXT:    [[IV_N]] = add nuw nsw i64 [[TMP23]], 1
; CHECK-STANDARD-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV_N]], [[TMP9]]
; CHECK-STANDARD-NEXT:    br i1 [[EXITCOND_NOT]], label [[DOTPREHEADER]], label [[DOTPREHEADER35]]
; CHECK-STANDARD:       .preheader:
; CHECK-STANDARD-NEXT:    [[DOTLCSSA3641_LCSSA:%.*]] = phi i32 [ 0, [[TMP3:%.*]] ], [ [[TMP29]], [[DOTPREHEADER35]] ]
; CHECK-STANDARD-NEXT:    [[P:%.*]] = phi i1 [ false, [[TMP3]] ], [ [[NOT_OR_COND]], [[DOTPREHEADER35]] ]
; CHECK-STANDARD-NEXT:    [[Q:%.*]] = select i1 [[P]], i32 [[DOTLCSSA3641_LCSSA]], i32 1
; CHECK-STANDARD-NEXT:    ret i32 [[Q]]
;
; CHECK-FORCED-LABEL: @minloc1_otherunusednot(
; CHECK-FORCED-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[TMP0:%.*]], i64 40
; CHECK-FORCED-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP4]], align 8
; CHECK-FORCED-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[TMP0]], i64 64
; CHECK-FORCED-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP6]], align 8
; CHECK-FORCED-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[TMP0]], i64 80
; CHECK-FORCED-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
; CHECK-FORCED-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[TMP0]], i64 88
; CHECK-FORCED-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
; CHECK-FORCED-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP0]], align 8
; CHECK-FORCED-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP1:%.*]], align 4
; CHECK-FORCED-NEXT:    [[TMP14:%.*]] = sext i32 [[TMP13]] to i64
; CHECK-FORCED-NEXT:    [[TMP15:%.*]] = add nsw i64 [[TMP14]], -1
; CHECK-FORCED-NEXT:    [[TMP16:%.*]] = mul i64 [[TMP15]], [[TMP5]]
; CHECK-FORCED-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[TMP12]], i64 [[TMP16]]
; CHECK-FORCED-NEXT:    [[TMP18:%.*]] = shl i64 [[TMP7]], 3
; CHECK-FORCED-NEXT:    [[TMP19:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP18]]
; CHECK-FORCED-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP2:%.*]], align 4
; CHECK-FORCED-NEXT:    [[DOTNOT:%.*]] = icmp slt i64 [[TMP9]], 1
; CHECK-FORCED-NEXT:    br i1 [[DOTNOT]], label [[DOTPREHEADER:%.*]], label [[DOTPREHEADER35_LR_PH:%.*]]
; CHECK-FORCED:       .preheader35.lr.ph:
; CHECK-FORCED-NEXT:    [[TMP21:%.*]] = sub i64 0, [[TMP7]]
; CHECK-FORCED-NEXT:    br label [[DOTPREHEADER35:%.*]]
; CHECK-FORCED:       .preheader35:
; CHECK-FORCED-NEXT:    [[TMP22:%.*]] = phi i32 [ 2147483647, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP30:%.*]], [[SELECT_END:%.*]] ]
; CHECK-FORCED-NEXT:    [[TMP23:%.*]] = phi i64 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[IV_N:%.*]], [[SELECT_END]] ]
; CHECK-FORCED-NEXT:    [[DOT045:%.*]] = phi i1 [ false, [[DOTPREHEADER35_LR_PH]] ], [ [[DOT2:%.*]], [[SELECT_END]] ]
; CHECK-FORCED-NEXT:    [[DOTLCSSA364144:%.*]] = phi i32 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP29:%.*]], [[SELECT_END]] ]
; CHECK-FORCED-NEXT:    [[TMP24:%.*]] = mul nsw i64 [[TMP23]], [[TMP11]]
; CHECK-FORCED-NEXT:    [[TMP25:%.*]] = getelementptr i8, ptr [[TMP19]], i64 [[TMP24]]
; CHECK-FORCED-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
; CHECK-FORCED-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], [[TMP20]]
; CHECK-FORCED-NEXT:    [[TMP28:%.*]] = icmp sge i32 [[TMP26]], [[TMP22]]
; CHECK-FORCED-NEXT:    [[DOTNOT33:%.*]] = and i1 [[DOT045]], [[TMP28]]
; CHECK-FORCED-NEXT:    [[OR_COND:%.*]] = select i1 [[TMP27]], i1 true, i1 [[DOTNOT33]]
; CHECK-FORCED-NEXT:    [[OR_COND_FROZEN:%.*]] = freeze i1 [[OR_COND]]
; CHECK-FORCED-NEXT:    br i1 [[OR_COND_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE:%.*]]
; CHECK-FORCED:       select.false:
; CHECK-FORCED-NEXT:    br label [[SELECT_END]]
; CHECK-FORCED:       select.end:
; CHECK-FORCED-NEXT:    [[TMP29]] = phi i32 [ [[DOTLCSSA364144]], [[DOTPREHEADER35]] ], [ 1, [[SELECT_FALSE]] ]
; CHECK-FORCED-NEXT:    [[DOT2]] = phi i1 [ [[DOT045]], [[DOTPREHEADER35]] ], [ true, [[SELECT_FALSE]] ]
; CHECK-FORCED-NEXT:    [[TMP30]] = phi i32 [ [[TMP22]], [[DOTPREHEADER35]] ], [ [[TMP20]], [[SELECT_FALSE]] ]
; CHECK-FORCED-NEXT:    [[NOT_OR_COND:%.*]] = xor i1 [[OR_COND]], true
; CHECK-FORCED-NEXT:    [[IV_N]] = add nuw nsw i64 [[TMP23]], 1
; CHECK-FORCED-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV_N]], [[TMP9]]
; CHECK-FORCED-NEXT:    br i1 [[EXITCOND_NOT]], label [[DOTPREHEADER]], label [[DOTPREHEADER35]]
; CHECK-FORCED:       .preheader:
; CHECK-FORCED-NEXT:    [[DOTLCSSA3641_LCSSA:%.*]] = phi i32 [ 0, [[TMP3:%.*]] ], [ [[TMP29]], [[SELECT_END]] ]
; CHECK-FORCED-NEXT:    [[P:%.*]] = phi i1 [ false, [[TMP3]] ], [ [[NOT_OR_COND]], [[SELECT_END]] ]
; CHECK-FORCED-NEXT:    [[Q:%.*]] = select i1 [[P]], i32 [[DOTLCSSA3641_LCSSA]], i32 1
; CHECK-FORCED-NEXT:    ret i32 [[Q]]
;
  %4 = getelementptr i8, ptr %0, i64 40
  %5 = load i64, ptr %4, align 8
  %6 = getelementptr i8, ptr %0, i64 64
  %7 = load i64, ptr %6, align 8
  %8 = getelementptr i8, ptr %0, i64 80
  %9 = load i64, ptr %8, align 8
  %10 = getelementptr i8, ptr %0, i64 88
  %11 = load i64, ptr %10, align 8
  %12 = load ptr, ptr %0, align 8
  %13 = load i32, ptr %1, align 4
  %14 = sext i32 %13 to i64
  %15 = add nsw i64 %14, -1
  %16 = mul i64 %15, %5
  %17 = getelementptr i8, ptr %12, i64 %16
  %18 = shl i64 %7, 3
  %19 = getelementptr i8, ptr %17, i64 %18
  %20 = load i32, ptr %2, align 4
  %.not = icmp slt i64 %9, 1
  br i1 %.not, label %.preheader, label %.preheader35.lr.ph

.preheader35.lr.ph:                               ; preds = %3
  %21 = sub i64 0, %7
  br label %.preheader35

.preheader35:                                     ; preds = %.preheader35.lr.ph, %.preheader35
  %22 = phi i32 [ 2147483647, %.preheader35.lr.ph ], [ %30, %.preheader35 ]
  %23 = phi i64 [ 0, %.preheader35.lr.ph ], [ %iv.n, %.preheader35 ]
  %.045 = phi i1 [ false, %.preheader35.lr.ph ], [ %.2, %.preheader35 ]
  %.lcssa364144 = phi i32 [ 0, %.preheader35.lr.ph ], [ %29, %.preheader35 ]
  %24 = mul nsw i64 %23, %11
  %25 = getelementptr i8, ptr %19, i64 %24
  %26 = load i32, ptr %25, align 4
  %27 = icmp ne i32 %26, %20
  %28 = icmp sge i32 %26, %22
  %.not33 = and i1 %.045, %28
  %or.cond = select i1 %27, i1 true, i1 %.not33
  %29 = select i1 %or.cond, i32 %.lcssa364144, i32 1
  %.2 = select i1 %or.cond, i1 %.045, i1 true
  %not.or.cond = xor i1 %or.cond, true
  %30 = select i1 %or.cond, i32 %22, i32 %20
  %iv.n = add nuw nsw i64 %23, 1
  %exitcond.not = icmp eq i64 %iv.n, %9
  br i1 %exitcond.not, label %.preheader, label %.preheader35

.preheader:                                       ; preds = %.preheader35, %3
  %.lcssa3641.lcssa = phi i32 [ 0, %3 ], [ %29, %.preheader35 ]
  %p = phi i1 [ false, %3 ], [ %not.or.cond, %.preheader35 ]
  %q = select i1 %p, i32 %.lcssa3641.lcssa, i32 1
  ret i32 %q
}

define i32 @minloc1_twonot(ptr nocapture readonly %0, ptr nocapture readonly %1, ptr nocapture readonly %2) {
; CHECK-LABEL: @minloc1_twonot(
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[TMP0:%.*]], i64 40
; CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP4]], align 8
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[TMP0]], i64 64
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP6]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[TMP0]], i64 80
; CHECK-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[TMP0]], i64 88
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP0]], align 8
; CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP1:%.*]], align 4
; CHECK-NEXT:    [[TMP14:%.*]] = sext i32 [[TMP13]] to i64
; CHECK-NEXT:    [[TMP15:%.*]] = add nsw i64 [[TMP14]], -1
; CHECK-NEXT:    [[TMP16:%.*]] = mul i64 [[TMP15]], [[TMP5]]
; CHECK-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[TMP12]], i64 [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = shl i64 [[TMP7]], 3
; CHECK-NEXT:    [[TMP19:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP2:%.*]], align 4
; CHECK-NEXT:    [[DOTNOT:%.*]] = icmp slt i64 [[TMP9]], 1
; CHECK-NEXT:    br i1 [[DOTNOT]], label [[DOTPREHEADER:%.*]], label [[DOTPREHEADER35_LR_PH:%.*]]
; CHECK:       .preheader35.lr.ph:
; CHECK-NEXT:    [[TMP21:%.*]] = sub i64 0, [[TMP7]]
; CHECK-NEXT:    br label [[DOTPREHEADER35:%.*]]
; CHECK:       .preheader35:
; CHECK-NEXT:    [[TMP22:%.*]] = phi i32 [ 2147483647, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP30:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[TMP23:%.*]] = phi i64 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[IV_N:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[DOT045:%.*]] = phi i1 [ false, [[DOTPREHEADER35_LR_PH]] ], [ [[DOT3:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[DOTLCSSA364144:%.*]] = phi i32 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP29:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[TMP24:%.*]] = mul nsw i64 [[TMP23]], [[TMP11]]
; CHECK-NEXT:    [[TMP25:%.*]] = getelementptr i8, ptr [[TMP19]], i64 [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
; CHECK-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], [[TMP20]]
; CHECK-NEXT:    [[TMP28:%.*]] = icmp sge i32 [[TMP26]], [[TMP22]]
; CHECK-NEXT:    [[DOTNOT33:%.*]] = and i1 [[DOT045]], [[TMP28]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[TMP27]], i1 true, i1 [[DOTNOT33]]
; CHECK-NEXT:    [[OR_COND_FROZEN:%.*]] = freeze i1 [[OR_COND]]
; CHECK-NEXT:    br i1 [[OR_COND_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false:
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[TMP29]] = phi i32 [ [[DOTLCSSA364144]], [[DOTPREHEADER35]] ], [ 1, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[DOT2:%.*]] = phi i1 [ [[DOT045]], [[DOTPREHEADER35]] ], [ true, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[DOT3]] = phi i1 [ [[DOT045]], [[DOTPREHEADER35]] ], [ true, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[TMP30]] = phi i32 [ [[TMP22]], [[DOTPREHEADER35]] ], [ [[TMP20]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[NOT_OR_COND:%.*]] = xor i1 [[OR_COND]], true
; CHECK-NEXT:    [[IV_N]] = add nuw nsw i64 [[TMP23]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV_N]], [[TMP9]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[DOTPREHEADER]], label [[DOTPREHEADER35]]
; CHECK:       .preheader:
; CHECK-NEXT:    [[DOTLCSSA3641_LCSSA:%.*]] = phi i32 [ 0, [[TMP3:%.*]] ], [ [[TMP29]], [[SELECT_END]] ]
; CHECK-NEXT:    ret i32 [[DOTLCSSA3641_LCSSA]]
;
  %4 = getelementptr i8, ptr %0, i64 40
  %5 = load i64, ptr %4, align 8
  %6 = getelementptr i8, ptr %0, i64 64
  %7 = load i64, ptr %6, align 8
  %8 = getelementptr i8, ptr %0, i64 80
  %9 = load i64, ptr %8, align 8
  %10 = getelementptr i8, ptr %0, i64 88
  %11 = load i64, ptr %10, align 8
  %12 = load ptr, ptr %0, align 8
  %13 = load i32, ptr %1, align 4
  %14 = sext i32 %13 to i64
  %15 = add nsw i64 %14, -1
  %16 = mul i64 %15, %5
  %17 = getelementptr i8, ptr %12, i64 %16
  %18 = shl i64 %7, 3
  %19 = getelementptr i8, ptr %17, i64 %18
  %20 = load i32, ptr %2, align 4
  %.not = icmp slt i64 %9, 1
  br i1 %.not, label %.preheader, label %.preheader35.lr.ph

.preheader35.lr.ph:                               ; preds = %3
  %21 = sub i64 0, %7
  br label %.preheader35

.preheader35:                                     ; preds = %.preheader35.lr.ph, %.preheader35
  %22 = phi i32 [ 2147483647, %.preheader35.lr.ph ], [ %30, %.preheader35 ]
  %23 = phi i64 [ 0, %.preheader35.lr.ph ], [ %iv.n, %.preheader35 ]
  %.045 = phi i1 [ false, %.preheader35.lr.ph ], [ %.3, %.preheader35 ]
  %.lcssa364144 = phi i32 [ 0, %.preheader35.lr.ph ], [ %29, %.preheader35 ]
  %24 = mul nsw i64 %23, %11
  %25 = getelementptr i8, ptr %19, i64 %24
  %26 = load i32, ptr %25, align 4
  %27 = icmp ne i32 %26, %20
  %28 = icmp sge i32 %26, %22
  %.not33 = and i1 %.045, %28
  %or.cond = select i1 %27, i1 true, i1 %.not33
  %29 = select i1 %or.cond, i32 %.lcssa364144, i32 1
  %not.or.cond = xor i1 %or.cond, true
  %.2 = select i1 %not.or.cond, i1 true, i1 %.045
  %.3 = select i1 %not.or.cond, i1 true, i1 %.2
  %30 = select i1 %or.cond, i32 %22, i32 %20
  %iv.n = add nuw nsw i64 %23, 1
  %exitcond.not = icmp eq i64 %iv.n, %9
  br i1 %exitcond.not, label %.preheader, label %.preheader35

.preheader:                                       ; preds = %.preheader35, %3
  %.lcssa3641.lcssa = phi i32 [ 0, %3 ], [ %29, %.preheader35 ]
  ret i32 %.lcssa3641.lcssa
}

define i32 @minloc1_onenotdependent(ptr nocapture readonly %0, ptr nocapture readonly %1, ptr nocapture readonly %2) {
; CHECK-LABEL: @minloc1_onenotdependent(
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[TMP0:%.*]], i64 40
; CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP4]], align 8
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[TMP0]], i64 64
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP6]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[TMP0]], i64 80
; CHECK-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[TMP0]], i64 88
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP0]], align 8
; CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP1:%.*]], align 4
; CHECK-NEXT:    [[TMP14:%.*]] = sext i32 [[TMP13]] to i64
; CHECK-NEXT:    [[TMP15:%.*]] = add nsw i64 [[TMP14]], -1
; CHECK-NEXT:    [[TMP16:%.*]] = mul i64 [[TMP15]], [[TMP5]]
; CHECK-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[TMP12]], i64 [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = shl i64 [[TMP7]], 3
; CHECK-NEXT:    [[TMP19:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP2:%.*]], align 4
; CHECK-NEXT:    [[DOTNOT:%.*]] = icmp slt i64 [[TMP9]], 1
; CHECK-NEXT:    br i1 [[DOTNOT]], label [[DOTPREHEADER:%.*]], label [[DOTPREHEADER35_LR_PH:%.*]]
; CHECK:       .preheader35.lr.ph:
; CHECK-NEXT:    [[TMP21:%.*]] = sub i64 0, [[TMP7]]
; CHECK-NEXT:    br label [[DOTPREHEADER35:%.*]]
; CHECK:       .preheader35:
; CHECK-NEXT:    [[TMP22:%.*]] = phi i32 [ 2147483647, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP30:%.*]], [[SELECT_END:%.*]] ]
; CHECK-NEXT:    [[TMP23:%.*]] = phi i64 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[IV_N:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[DOT045:%.*]] = phi i1 [ false, [[DOTPREHEADER35_LR_PH]] ], [ [[DOT3:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[DOTLCSSA364144:%.*]] = phi i32 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP29:%.*]], [[SELECT_END]] ]
; CHECK-NEXT:    [[TMP24:%.*]] = mul nsw i64 [[TMP23]], [[TMP11]]
; CHECK-NEXT:    [[TMP25:%.*]] = getelementptr i8, ptr [[TMP19]], i64 [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
; CHECK-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], [[TMP20]]
; CHECK-NEXT:    [[TMP28:%.*]] = icmp sge i32 [[TMP26]], [[TMP22]]
; CHECK-NEXT:    [[DOTNOT33:%.*]] = and i1 [[DOT045]], [[TMP28]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[TMP27]], i1 true, i1 [[DOTNOT33]]
; CHECK-NEXT:    [[OR_COND_FROZEN:%.*]] = freeze i1 [[OR_COND]]
; CHECK-NEXT:    br i1 [[OR_COND_FROZEN]], label [[SELECT_END]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false:
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[TMP29]] = phi i32 [ [[DOTLCSSA364144]], [[DOTPREHEADER35]] ], [ 1, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[DOT2:%.*]] = phi i1 [ true, [[DOTPREHEADER35]] ], [ [[DOT045]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[DOT3]] = phi i1 [ true, [[DOTPREHEADER35]] ], [ true, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[TMP30]] = phi i32 [ [[TMP22]], [[DOTPREHEADER35]] ], [ [[TMP20]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[NOT_OR_COND:%.*]] = xor i1 [[OR_COND]], true
; CHECK-NEXT:    [[IV_N]] = add nuw nsw i64 [[TMP23]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[IV_N]], [[TMP9]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[DOTPREHEADER]], label [[DOTPREHEADER35]]
; CHECK:       .preheader:
; CHECK-NEXT:    [[DOTLCSSA3641_LCSSA:%.*]] = phi i32 [ 0, [[TMP3:%.*]] ], [ [[TMP29]], [[SELECT_END]] ]
; CHECK-NEXT:    ret i32 [[DOTLCSSA3641_LCSSA]]
;
  %4 = getelementptr i8, ptr %0, i64 40
  %5 = load i64, ptr %4, align 8
  %6 = getelementptr i8, ptr %0, i64 64
  %7 = load i64, ptr %6, align 8
  %8 = getelementptr i8, ptr %0, i64 80
  %9 = load i64, ptr %8, align 8
  %10 = getelementptr i8, ptr %0, i64 88
  %11 = load i64, ptr %10, align 8
  %12 = load ptr, ptr %0, align 8
  %13 = load i32, ptr %1, align 4
  %14 = sext i32 %13 to i64
  %15 = add nsw i64 %14, -1
  %16 = mul i64 %15, %5
  %17 = getelementptr i8, ptr %12, i64 %16
  %18 = shl i64 %7, 3
  %19 = getelementptr i8, ptr %17, i64 %18
  %20 = load i32, ptr %2, align 4
  %.not = icmp slt i64 %9, 1
  br i1 %.not, label %.preheader, label %.preheader35.lr.ph

.preheader35.lr.ph:                               ; preds = %3
  %21 = sub i64 0, %7
  br label %.preheader35

.preheader35:                                     ; preds = %.preheader35.lr.ph, %.preheader35
  %22 = phi i32 [ 2147483647, %.preheader35.lr.ph ], [ %30, %.preheader35 ]
  %23 = phi i64 [ 0, %.preheader35.lr.ph ], [ %iv.n, %.preheader35 ]
  %.045 = phi i1 [ false, %.preheader35.lr.ph ], [ %.3, %.preheader35 ]
  %.lcssa364144 = phi i32 [ 0, %.preheader35.lr.ph ], [ %29, %.preheader35 ]
  %24 = mul nsw i64 %23, %11
  %25 = getelementptr i8, ptr %19, i64 %24
  %26 = load i32, ptr %25, align 4
  %27 = icmp ne i32 %26, %20
  %28 = icmp sge i32 %26, %22
  %.not33 = and i1 %.045, %28
  %or.cond = select i1 %27, i1 true, i1 %.not33
  %29 = select i1 %or.cond, i32 %.lcssa364144, i32 1
  %not.or.cond = xor i1 %or.cond, true
  %.2 = select i1 %or.cond, i1 true, i1 %.045
  %.3 = select i1 %not.or.cond, i1 true, i1 %.2
  %30 = select i1 %or.cond, i32 %22, i32 %20
  %iv.n = add nuw nsw i64 %23, 1
  %exitcond.not = icmp eq i64 %iv.n, %9
  br i1 %exitcond.not, label %.preheader, label %.preheader35

.preheader:                                       ; preds = %.preheader35, %3
  %.lcssa3641.lcssa = phi i32 [ 0, %3 ], [ %29, %.preheader35 ]
  ret i32 %.lcssa3641.lcssa
}


define i32 @minloc9(ptr nocapture readonly %0, ptr nocapture readonly %1, ptr nocapture readonly %2) {
; CHECK-LABEL: @minloc9(
; CHECK-NEXT:    [[TMP4:%.*]] = getelementptr i8, ptr [[TMP0:%.*]], i64 40
; CHECK-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP4]], align 8
; CHECK-NEXT:    [[TMP6:%.*]] = getelementptr i8, ptr [[TMP0]], i64 64
; CHECK-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP6]], align 8
; CHECK-NEXT:    [[TMP8:%.*]] = getelementptr i8, ptr [[TMP0]], i64 80
; CHECK-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP8]], align 8
; CHECK-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[TMP0]], i64 88
; CHECK-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP10]], align 8
; CHECK-NEXT:    [[TMP12:%.*]] = load ptr, ptr [[TMP0]], align 8
; CHECK-NEXT:    [[TMP13:%.*]] = load i32, ptr [[TMP1:%.*]], align 4
; CHECK-NEXT:    [[TMP14:%.*]] = sext i32 [[TMP13]] to i64
; CHECK-NEXT:    [[TMP15:%.*]] = add nsw i64 [[TMP14]], -1
; CHECK-NEXT:    [[TMP16:%.*]] = mul i64 [[TMP15]], [[TMP5]]
; CHECK-NEXT:    [[TMP17:%.*]] = getelementptr i8, ptr [[TMP12]], i64 [[TMP16]]
; CHECK-NEXT:    [[TMP18:%.*]] = shl i64 [[TMP7]], 3
; CHECK-NEXT:    [[TMP19:%.*]] = getelementptr i8, ptr [[TMP17]], i64 [[TMP18]]
; CHECK-NEXT:    [[TMP20:%.*]] = load i32, ptr [[TMP2:%.*]], align 4
; CHECK-NEXT:    [[DOTNOT:%.*]] = icmp slt i64 [[TMP9]], 1
; CHECK-NEXT:    br i1 [[DOTNOT]], label [[DOTPREHEADER:%.*]], label [[DOTPREHEADER35_LR_PH:%.*]]
; CHECK:       .preheader35.lr.ph:
; CHECK-NEXT:    [[TMP21:%.*]] = sub i64 0, [[TMP7]]
; CHECK-NEXT:    [[DOTNEG:%.*]] = mul i64 [[TMP7]], -2
; CHECK-NEXT:    [[DOTNEG50:%.*]] = mul i64 [[TMP7]], -3
; CHECK-NEXT:    [[DOTNEG51:%.*]] = mul i64 [[TMP7]], -4
; CHECK-NEXT:    [[DOTNEG52:%.*]] = mul i64 [[TMP7]], -5
; CHECK-NEXT:    [[DOTNEG53:%.*]] = mul i64 [[TMP7]], -6
; CHECK-NEXT:    [[DOTNEG54:%.*]] = mul i64 [[TMP7]], -7
; CHECK-NEXT:    [[DOTNEG55:%.*]] = mul i64 [[TMP7]], -8
; CHECK-NEXT:    br label [[DOTPREHEADER35:%.*]]
; CHECK:       .preheader35:
; CHECK-NEXT:    [[TMP22:%.*]] = phi i32 [ 2147483647, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP78:%.*]], [[SELECT_END15:%.*]] ]
; CHECK-NEXT:    [[TMP23:%.*]] = phi i64 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP79:%.*]], [[SELECT_END15]] ]
; CHECK-NEXT:    [[DOT045:%.*]] = phi i1 [ false, [[DOTPREHEADER35_LR_PH]] ], [ [[DOT2_8:%.*]], [[SELECT_END15]] ]
; CHECK-NEXT:    [[DOTLCSSA364144:%.*]] = phi i32 [ 0, [[DOTPREHEADER35_LR_PH]] ], [ [[TMP77:%.*]], [[SELECT_END15]] ]
; CHECK-NEXT:    [[TMP24:%.*]] = mul nsw i64 [[TMP23]], [[TMP11]]
; CHECK-NEXT:    [[TMP25:%.*]] = getelementptr i8, ptr [[TMP19]], i64 [[TMP24]]
; CHECK-NEXT:    [[TMP26:%.*]] = load i32, ptr [[TMP25]], align 4
; CHECK-NEXT:    [[TMP27:%.*]] = icmp ne i32 [[TMP26]], [[TMP20]]
; CHECK-NEXT:    [[TMP28:%.*]] = icmp sge i32 [[TMP26]], [[TMP22]]
; CHECK-NEXT:    [[DOTNOT33:%.*]] = and i1 [[DOT045]], [[TMP28]]
; CHECK-NEXT:    [[OR_COND:%.*]] = select i1 [[TMP27]], i1 true, i1 [[DOTNOT33]]
; CHECK-NEXT:    [[OR_COND_FROZEN:%.*]] = freeze i1 [[OR_COND]]
; CHECK-NEXT:    br i1 [[OR_COND_FROZEN]], label [[SELECT_END:%.*]], label [[SELECT_FALSE:%.*]]
; CHECK:       select.false:
; CHECK-NEXT:    br label [[SELECT_END]]
; CHECK:       select.end:
; CHECK-NEXT:    [[TMP29:%.*]] = phi i32 [ [[DOTLCSSA364144]], [[DOTPREHEADER35]] ], [ 1, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[DOT2:%.*]] = phi i1 [ [[DOT045]], [[DOTPREHEADER35]] ], [ true, [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[TMP30:%.*]] = phi i32 [ [[TMP22]], [[DOTPREHEADER35]] ], [ [[TMP20]], [[SELECT_FALSE]] ]
; CHECK-NEXT:    [[NOT_OR_COND:%.*]] = xor i1 [[OR_COND]], true
; CHECK-NEXT:    [[TMP31:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[TMP21]]
; CHECK-NEXT:    [[TMP32:%.*]] = load i32, ptr [[TMP31]], align 4
; CHECK-NEXT:    [[TMP33:%.*]] = icmp ne i32 [[TMP32]], [[TMP20]]
; CHECK-NEXT:    [[TMP34:%.*]] = icmp sge i32 [[TMP32]], [[TMP30]]
; CHECK-NEXT:    [[DOTNOT33_1:%.*]] = and i1 [[DOT2]], [[TMP34]]
; CHECK-NEXT:    [[OR_COND_1:%.*]] = select i1 [[TMP33]], i1 true, i1 [[DOTNOT33_1]]
; CHECK-NEXT:    [[OR_COND_1_FROZEN:%.*]] = freeze i1 [[OR_COND_1]]
; CHECK-NEXT:    br i1 [[OR_COND_1_FROZEN]], label [[SELECT_END1:%.*]], label [[SELECT_FALSE2:%.*]]
; CHECK:       select.false2:
; CHECK-NEXT:    br label [[SELECT_END1]]
; CHECK:       select.end1:
; CHECK-NEXT:    [[TMP35:%.*]] = phi i32 [ [[TMP29]], [[SELECT_END]] ], [ 2, [[SELECT_FALSE2]] ]
; CHECK-NEXT:    [[DOT2_1:%.*]] = phi i1 [ [[DOT2]], [[SELECT_END]] ], [ true, [[SELECT_FALSE2]] ]
; CHECK-NEXT:    [[TMP36:%.*]] = phi i32 [ [[TMP30]], [[SELECT_END]] ], [ [[TMP20]], [[SELECT_FALSE2]] ]
; CHECK-NEXT:    [[NOT_OR_COND_1:%.*]] = xor i1 [[OR_COND_1]], true
; CHECK-NEXT:    [[TMP37:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[DOTNEG]]
; CHECK-NEXT:    [[TMP38:%.*]] = load i32, ptr [[TMP37]], align 4
; CHECK-NEXT:    [[TMP39:%.*]] = icmp ne i32 [[TMP38]], [[TMP20]]
; CHECK-NEXT:    [[TMP40:%.*]] = icmp sge i32 [[TMP38]], [[TMP36]]
; CHECK-NEXT:    [[DOTNOT33_2:%.*]] = and i1 [[DOT2_1]], [[TMP40]]
; CHECK-NEXT:    [[OR_COND_2:%.*]] = select i1 [[TMP39]], i1 true, i1 [[DOTNOT33_2]]
; CHECK-NEXT:    [[OR_COND_2_FROZEN:%.*]] = freeze i1 [[OR_COND_2]]
; CHECK-NEXT:    br i1 [[OR_COND_2_FROZEN]], label [[SELECT_END3:%.*]], label [[SELECT_FALSE4:%.*]]
; CHECK:       select.false4:
; CHECK-NEXT:    br label [[SELECT_END3]]
; CHECK:       select.end3:
; CHECK-NEXT:    [[TMP41:%.*]] = phi i32 [ [[TMP35]], [[SELECT_END1]] ], [ 3, [[SELECT_FALSE4]] ]
; CHECK-NEXT:    [[DOT2_2:%.*]] = phi i1 [ [[DOT2_1]], [[SELECT_END1]] ], [ true, [[SELECT_FALSE4]] ]
; CHECK-NEXT:    [[TMP42:%.*]] = phi i32 [ [[TMP36]], [[SELECT_END1]] ], [ [[TMP20]], [[SELECT_FALSE4]] ]
; CHECK-NEXT:    [[NOT_OR_COND_2:%.*]] = xor i1 [[OR_COND_2]], true
; CHECK-NEXT:    [[TMP43:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[DOTNEG50]]
; CHECK-NEXT:    [[TMP44:%.*]] = load i32, ptr [[TMP43]], align 4
; CHECK-NEXT:    [[TMP45:%.*]] = icmp ne i32 [[TMP44]], [[TMP20]]
; CHECK-NEXT:    [[TMP46:%.*]] = icmp sge i32 [[TMP44]], [[TMP42]]
; CHECK-NEXT:    [[DOTNOT33_3:%.*]] = and i1 [[DOT2_2]], [[TMP46]]
; CHECK-NEXT:    [[OR_COND_3:%.*]] = select i1 [[TMP45]], i1 true, i1 [[DOTNOT33_3]]
; CHECK-NEXT:    [[OR_COND_3_FROZEN:%.*]] = freeze i1 [[OR_COND_3]]
; CHECK-NEXT:    br i1 [[OR_COND_3_FROZEN]], label [[SELECT_END5:%.*]], label [[SELECT_FALSE6:%.*]]
; CHECK:       select.false6:
; CHECK-NEXT:    br label [[SELECT_END5]]
; CHECK:       select.end5:
; CHECK-NEXT:    [[TMP47:%.*]] = phi i32 [ [[TMP41]], [[SELECT_END3]] ], [ 4, [[SELECT_FALSE6]] ]
; CHECK-NEXT:    [[DOT2_3:%.*]] = phi i1 [ [[DOT2_2]], [[SELECT_END3]] ], [ true, [[SELECT_FALSE6]] ]
; CHECK-NEXT:    [[TMP48:%.*]] = phi i32 [ [[TMP42]], [[SELECT_END3]] ], [ [[TMP20]], [[SELECT_FALSE6]] ]
; CHECK-NEXT:    [[NOT_OR_COND_3:%.*]] = xor i1 [[OR_COND_3]], true
; CHECK-NEXT:    [[TMP49:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[DOTNEG51]]
; CHECK-NEXT:    [[TMP50:%.*]] = load i32, ptr [[TMP49]], align 4
; CHECK-NEXT:    [[TMP51:%.*]] = icmp ne i32 [[TMP50]], [[TMP20]]
; CHECK-NEXT:    [[TMP52:%.*]] = icmp sge i32 [[TMP50]], [[TMP48]]
; CHECK-NEXT:    [[DOTNOT33_4:%.*]] = and i1 [[DOT2_3]], [[TMP52]]
; CHECK-NEXT:    [[OR_COND_4:%.*]] = select i1 [[TMP51]], i1 true, i1 [[DOTNOT33_4]]
; CHECK-NEXT:    [[OR_COND_4_FROZEN:%.*]] = freeze i1 [[OR_COND_4]]
; CHECK-NEXT:    br i1 [[OR_COND_4_FROZEN]], label [[SELECT_END7:%.*]], label [[SELECT_FALSE8:%.*]]
; CHECK:       select.false8:
; CHECK-NEXT:    br label [[SELECT_END7]]
; CHECK:       select.end7:
; CHECK-NEXT:    [[TMP53:%.*]] = phi i32 [ [[TMP47]], [[SELECT_END5]] ], [ 5, [[SELECT_FALSE8]] ]
; CHECK-NEXT:    [[DOT2_4:%.*]] = phi i1 [ [[DOT2_3]], [[SELECT_END5]] ], [ true, [[SELECT_FALSE8]] ]
; CHECK-NEXT:    [[TMP54:%.*]] = phi i32 [ [[TMP48]], [[SELECT_END5]] ], [ [[TMP20]], [[SELECT_FALSE8]] ]
; CHECK-NEXT:    [[NOT_OR_COND_4:%.*]] = xor i1 [[OR_COND_4]], true
; CHECK-NEXT:    [[TMP55:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[DOTNEG52]]
; CHECK-NEXT:    [[TMP56:%.*]] = load i32, ptr [[TMP55]], align 4
; CHECK-NEXT:    [[TMP57:%.*]] = icmp ne i32 [[TMP56]], [[TMP20]]
; CHECK-NEXT:    [[TMP58:%.*]] = icmp sge i32 [[TMP56]], [[TMP54]]
; CHECK-NEXT:    [[DOTNOT33_5:%.*]] = and i1 [[DOT2_4]], [[TMP58]]
; CHECK-NEXT:    [[OR_COND_5:%.*]] = select i1 [[TMP57]], i1 true, i1 [[DOTNOT33_5]]
; CHECK-NEXT:    [[OR_COND_5_FROZEN:%.*]] = freeze i1 [[OR_COND_5]]
; CHECK-NEXT:    br i1 [[OR_COND_5_FROZEN]], label [[SELECT_END9:%.*]], label [[SELECT_FALSE10:%.*]]
; CHECK:       select.false10:
; CHECK-NEXT:    br label [[SELECT_END9]]
; CHECK:       select.end9:
; CHECK-NEXT:    [[TMP59:%.*]] = phi i32 [ [[TMP53]], [[SELECT_END7]] ], [ 6, [[SELECT_FALSE10]] ]
; CHECK-NEXT:    [[DOT2_5:%.*]] = phi i1 [ [[DOT2_4]], [[SELECT_END7]] ], [ true, [[SELECT_FALSE10]] ]
; CHECK-NEXT:    [[TMP60:%.*]] = phi i32 [ [[TMP54]], [[SELECT_END7]] ], [ [[TMP20]], [[SELECT_FALSE10]] ]
; CHECK-NEXT:    [[NOT_OR_COND_5:%.*]] = xor i1 [[OR_COND_5]], true
; CHECK-NEXT:    [[TMP61:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[DOTNEG53]]
; CHECK-NEXT:    [[TMP62:%.*]] = load i32, ptr [[TMP61]], align 4
; CHECK-NEXT:    [[TMP63:%.*]] = icmp ne i32 [[TMP62]], [[TMP20]]
; CHECK-NEXT:    [[TMP64:%.*]] = icmp sge i32 [[TMP62]], [[TMP60]]
; CHECK-NEXT:    [[DOTNOT33_6:%.*]] = and i1 [[DOT2_5]], [[TMP64]]
; CHECK-NEXT:    [[OR_COND_6:%.*]] = select i1 [[TMP63]], i1 true, i1 [[DOTNOT33_6]]
; CHECK-NEXT:    [[OR_COND_6_FROZEN:%.*]] = freeze i1 [[OR_COND_6]]
; CHECK-NEXT:    br i1 [[OR_COND_6_FROZEN]], label [[SELECT_END11:%.*]], label [[SELECT_FALSE12:%.*]]
; CHECK:       select.false12:
; CHECK-NEXT:    br label [[SELECT_END11]]
; CHECK:       select.end11:
; CHECK-NEXT:    [[TMP65:%.*]] = phi i32 [ [[TMP59]], [[SELECT_END9]] ], [ 7, [[SELECT_FALSE12]] ]
; CHECK-NEXT:    [[DOT2_6:%.*]] = phi i1 [ [[DOT2_5]], [[SELECT_END9]] ], [ true, [[SELECT_FALSE12]] ]
; CHECK-NEXT:    [[TMP66:%.*]] = phi i32 [ [[TMP60]], [[SELECT_END9]] ], [ [[TMP20]], [[SELECT_FALSE12]] ]
; CHECK-NEXT:    [[NOT_OR_COND_6:%.*]] = xor i1 [[OR_COND_6]], true
; CHECK-NEXT:    [[TMP67:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[DOTNEG54]]
; CHECK-NEXT:    [[TMP68:%.*]] = load i32, ptr [[TMP67]], align 4
; CHECK-NEXT:    [[TMP69:%.*]] = icmp ne i32 [[TMP68]], [[TMP20]]
; CHECK-NEXT:    [[TMP70:%.*]] = icmp sge i32 [[TMP68]], [[TMP66]]
; CHECK-NEXT:    [[DOTNOT33_7:%.*]] = and i1 [[DOT2_6]], [[TMP70]]
; CHECK-NEXT:    [[OR_COND_7:%.*]] = select i1 [[TMP69]], i1 true, i1 [[DOTNOT33_7]]
; CHECK-NEXT:    [[OR_COND_7_FROZEN:%.*]] = freeze i1 [[OR_COND_7]]
; CHECK-NEXT:    br i1 [[OR_COND_7_FROZEN]], label [[SELECT_END13:%.*]], label [[SELECT_FALSE14:%.*]]
; CHECK:       select.false14:
; CHECK-NEXT:    br label [[SELECT_END13]]
; CHECK:       select.end13:
; CHECK-NEXT:    [[TMP71:%.*]] = phi i32 [ [[TMP65]], [[SELECT_END11]] ], [ 8, [[SELECT_FALSE14]] ]
; CHECK-NEXT:    [[DOT2_7:%.*]] = phi i1 [ [[DOT2_6]], [[SELECT_END11]] ], [ true, [[SELECT_FALSE14]] ]
; CHECK-NEXT:    [[TMP72:%.*]] = phi i32 [ [[TMP66]], [[SELECT_END11]] ], [ [[TMP20]], [[SELECT_FALSE14]] ]
; CHECK-NEXT:    [[NOT_OR_COND_7:%.*]] = xor i1 [[OR_COND_7]], true
; CHECK-NEXT:    [[TMP73:%.*]] = getelementptr i8, ptr [[TMP25]], i64 [[DOTNEG55]]
; CHECK-NEXT:    [[TMP74:%.*]] = load i32, ptr [[TMP73]], align 4
; CHECK-NEXT:    [[TMP75:%.*]] = icmp ne i32 [[TMP74]], [[TMP20]]
; CHECK-NEXT:    [[TMP76:%.*]] = icmp sge i32 [[TMP74]], [[TMP72]]
; CHECK-NEXT:    [[DOTNOT33_8:%.*]] = and i1 [[DOT2_7]], [[TMP76]]
; CHECK-NEXT:    [[OR_COND_8:%.*]] = select i1 [[TMP75]], i1 true, i1 [[DOTNOT33_8]]
; CHECK-NEXT:    [[OR_COND_8_FROZEN:%.*]] = freeze i1 [[OR_COND_8]]
; CHECK-NEXT:    br i1 [[OR_COND_8_FROZEN]], label [[SELECT_END15]], label [[SELECT_FALSE16:%.*]]
; CHECK:       select.false16:
; CHECK-NEXT:    br label [[SELECT_END15]]
; CHECK:       select.end15:
; CHECK-NEXT:    [[TMP77]] = phi i32 [ [[TMP71]], [[SELECT_END13]] ], [ 9, [[SELECT_FALSE16]] ]
; CHECK-NEXT:    [[DOT2_8]] = phi i1 [ [[DOT2_7]], [[SELECT_END13]] ], [ true, [[SELECT_FALSE16]] ]
; CHECK-NEXT:    [[TMP78]] = phi i32 [ [[TMP72]], [[SELECT_END13]] ], [ [[TMP20]], [[SELECT_FALSE16]] ]
; CHECK-NEXT:    [[NOT_OR_COND_8:%.*]] = xor i1 [[OR_COND_8]], true
; CHECK-NEXT:    [[TMP79]] = add nuw nsw i64 [[TMP23]], 1
; CHECK-NEXT:    [[EXITCOND_NOT:%.*]] = icmp eq i64 [[TMP79]], [[TMP9]]
; CHECK-NEXT:    br i1 [[EXITCOND_NOT]], label [[DOTPREHEADER]], label [[DOTPREHEADER35]]
; CHECK:       .preheader:
; CHECK-NEXT:    [[DOTLCSSA3641_LCSSA:%.*]] = phi i32 [ 0, [[TMP3:%.*]] ], [ [[TMP77]], [[SELECT_END15]] ]
; CHECK-NEXT:    ret i32 [[DOTLCSSA3641_LCSSA]]
;
  %4 = getelementptr i8, ptr %0, i64 40
  %5 = load i64, ptr %4, align 8
  %6 = getelementptr i8, ptr %0, i64 64
  %7 = load i64, ptr %6, align 8
  %8 = getelementptr i8, ptr %0, i64 80
  %9 = load i64, ptr %8, align 8
  %10 = getelementptr i8, ptr %0, i64 88
  %11 = load i64, ptr %10, align 8
  %12 = load ptr, ptr %0, align 8
  %13 = load i32, ptr %1, align 4
  %14 = sext i32 %13 to i64
  %15 = add nsw i64 %14, -1
  %16 = mul i64 %15, %5
  %17 = getelementptr i8, ptr %12, i64 %16
  %18 = shl i64 %7, 3
  %19 = getelementptr i8, ptr %17, i64 %18
  %20 = load i32, ptr %2, align 4
  %.not = icmp slt i64 %9, 1
  br i1 %.not, label %.preheader, label %.preheader35.lr.ph

.preheader35.lr.ph:                               ; preds = %3
  %21 = sub i64 0, %7
  %.neg = mul i64 %7, -2
  %.neg50 = mul i64 %7, -3
  %.neg51 = mul i64 %7, -4
  %.neg52 = mul i64 %7, -5
  %.neg53 = mul i64 %7, -6
  %.neg54 = mul i64 %7, -7
  %.neg55 = mul i64 %7, -8
  br label %.preheader35

.preheader35:                                     ; preds = %.preheader35.lr.ph, %.preheader35
  %22 = phi i32 [ 2147483647, %.preheader35.lr.ph ], [ %78, %.preheader35 ]
  %23 = phi i64 [ 0, %.preheader35.lr.ph ], [ %79, %.preheader35 ]
  %.045 = phi i1 [ false, %.preheader35.lr.ph ], [ %.2.8, %.preheader35 ]
  %.lcssa364144 = phi i32 [ 0, %.preheader35.lr.ph ], [ %77, %.preheader35 ]
  %24 = mul nsw i64 %23, %11
  %25 = getelementptr i8, ptr %19, i64 %24
  %26 = load i32, ptr %25, align 4
  %27 = icmp ne i32 %26, %20
  %28 = icmp sge i32 %26, %22
  %.not33 = and i1 %.045, %28
  %or.cond = select i1 %27, i1 true, i1 %.not33
  %29 = select i1 %or.cond, i32 %.lcssa364144, i32 1
  %not.or.cond = xor i1 %or.cond, true
  %.2 = select i1 %not.or.cond, i1 true, i1 %.045
  %30 = select i1 %or.cond, i32 %22, i32 %20
  %31 = getelementptr i8, ptr %25, i64 %21
  %32 = load i32, ptr %31, align 4
  %33 = icmp ne i32 %32, %20
  %34 = icmp sge i32 %32, %30
  %.not33.1 = and i1 %.2, %34
  %or.cond.1 = select i1 %33, i1 true, i1 %.not33.1
  %35 = select i1 %or.cond.1, i32 %29, i32 2
  %not.or.cond.1 = xor i1 %or.cond.1, true
  %.2.1 = select i1 %not.or.cond.1, i1 true, i1 %.2
  %36 = select i1 %or.cond.1, i32 %30, i32 %20
  %37 = getelementptr i8, ptr %25, i64 %.neg
  %38 = load i32, ptr %37, align 4
  %39 = icmp ne i32 %38, %20
  %40 = icmp sge i32 %38, %36
  %.not33.2 = and i1 %.2.1, %40
  %or.cond.2 = select i1 %39, i1 true, i1 %.not33.2
  %41 = select i1 %or.cond.2, i32 %35, i32 3
  %not.or.cond.2 = xor i1 %or.cond.2, true
  %.2.2 = select i1 %not.or.cond.2, i1 true, i1 %.2.1
  %42 = select i1 %or.cond.2, i32 %36, i32 %20
  %43 = getelementptr i8, ptr %25, i64 %.neg50
  %44 = load i32, ptr %43, align 4
  %45 = icmp ne i32 %44, %20
  %46 = icmp sge i32 %44, %42
  %.not33.3 = and i1 %.2.2, %46
  %or.cond.3 = select i1 %45, i1 true, i1 %.not33.3
  %47 = select i1 %or.cond.3, i32 %41, i32 4
  %not.or.cond.3 = xor i1 %or.cond.3, true
  %.2.3 = select i1 %not.or.cond.3, i1 true, i1 %.2.2
  %48 = select i1 %or.cond.3, i32 %42, i32 %20
  %49 = getelementptr i8, ptr %25, i64 %.neg51
  %50 = load i32, ptr %49, align 4
  %51 = icmp ne i32 %50, %20
  %52 = icmp sge i32 %50, %48
  %.not33.4 = and i1 %.2.3, %52
  %or.cond.4 = select i1 %51, i1 true, i1 %.not33.4
  %53 = select i1 %or.cond.4, i32 %47, i32 5
  %not.or.cond.4 = xor i1 %or.cond.4, true
  %.2.4 = select i1 %not.or.cond.4, i1 true, i1 %.2.3
  %54 = select i1 %or.cond.4, i32 %48, i32 %20
  %55 = getelementptr i8, ptr %25, i64 %.neg52
  %56 = load i32, ptr %55, align 4
  %57 = icmp ne i32 %56, %20
  %58 = icmp sge i32 %56, %54
  %.not33.5 = and i1 %.2.4, %58
  %or.cond.5 = select i1 %57, i1 true, i1 %.not33.5
  %59 = select i1 %or.cond.5, i32 %53, i32 6
  %not.or.cond.5 = xor i1 %or.cond.5, true
  %.2.5 = select i1 %not.or.cond.5, i1 true, i1 %.2.4
  %60 = select i1 %or.cond.5, i32 %54, i32 %20
  %61 = getelementptr i8, ptr %25, i64 %.neg53
  %62 = load i32, ptr %61, align 4
  %63 = icmp ne i32 %62, %20
  %64 = icmp sge i32 %62, %60
  %.not33.6 = and i1 %.2.5, %64
  %or.cond.6 = select i1 %63, i1 true, i1 %.not33.6
  %65 = select i1 %or.cond.6, i32 %59, i32 7
  %not.or.cond.6 = xor i1 %or.cond.6, true
  %.2.6 = select i1 %not.or.cond.6, i1 true, i1 %.2.5
  %66 = select i1 %or.cond.6, i32 %60, i32 %20
  %67 = getelementptr i8, ptr %25, i64 %.neg54
  %68 = load i32, ptr %67, align 4
  %69 = icmp ne i32 %68, %20
  %70 = icmp sge i32 %68, %66
  %.not33.7 = and i1 %.2.6, %70
  %or.cond.7 = select i1 %69, i1 true, i1 %.not33.7
  %71 = select i1 %or.cond.7, i32 %65, i32 8
  %not.or.cond.7 = xor i1 %or.cond.7, true
  %.2.7 = select i1 %not.or.cond.7, i1 true, i1 %.2.6
  %72 = select i1 %or.cond.7, i32 %66, i32 %20
  %73 = getelementptr i8, ptr %25, i64 %.neg55
  %74 = load i32, ptr %73, align 4
  %75 = icmp ne i32 %74, %20
  %76 = icmp sge i32 %74, %72
  %.not33.8 = and i1 %.2.7, %76
  %or.cond.8 = select i1 %75, i1 true, i1 %.not33.8
  %77 = select i1 %or.cond.8, i32 %71, i32 9
  %not.or.cond.8 = xor i1 %or.cond.8, true
  %.2.8 = select i1 %not.or.cond.8, i1 true, i1 %.2.7
  %78 = select i1 %or.cond.8, i32 %72, i32 %20
  %79 = add nuw nsw i64 %23, 1
  %exitcond.not = icmp eq i64 %79, %9
  br i1 %exitcond.not, label %.preheader, label %.preheader35

.preheader:                                       ; preds = %.preheader35, %3
  %.lcssa3641.lcssa = phi i32 [ 0, %3 ], [ %77, %.preheader35 ]
  ret i32 %.lcssa3641.lcssa
}
