; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=fiji < %s | FileCheck -check-prefixes=CIVI,VI %s
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=hawaii < %s | FileCheck -check-prefixes=CIVI,CI %s
; RUN: llc -verify-machineinstrs -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 < %s | FileCheck -check-prefix=GFX11 %s

define amdgpu_kernel void @s_insertelement_v2i16_0(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_lh_b32_b16 s2, 0x3e7, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2i16_0:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s2, 0xffff0000
; CIVI-NEXT:    s_or_b32 s0, s0, 0x3e7
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_lh_b32_b16 s2, 0x3e7, s2
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out
  ret void
}


define amdgpu_kernel void @s_insertelement_v2i16_0_reg(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, [8 x i32], i16 %elt) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x30
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_lh_b32_b16 s2, s4, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reg:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_and_b32 s0, s4, 0xffff
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s1, s2, 0xffff0000
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reg:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_and_b32 s1, s4, 0xffff
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s0, s2, 0xffff0000
; CI-NEXT:    s_or_b32 s0, s1, s0
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_0_reg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x30
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s1, s[6:7], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_lh_b32_b16 s0, s0, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_multi_use_hi_reg(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, [8 x i32], i16 %elt) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_multi_use_hi_reg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x30
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s2, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s3, s4, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s3
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s2
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_multi_use_hi_reg:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_and_b32 s0, s4, 0xffff
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s1, s2, 16
; VI-NEXT:    s_and_b32 s2, s2, 0xffff0000
; VI-NEXT:    s_or_b32 s0, s0, s2
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s1
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_multi_use_hi_reg:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_and_b32 s0, s4, 0xffff
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s1, s2, 0xffff0000
; CI-NEXT:    s_or_b32 s0, s0, s1
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    s_lshr_b32 s2, s2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s2
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_0_multi_use_hi_reg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x30
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s1, s[6:7], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use s1
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %elt1 = extractelement <2 x i16> %vec, i32 1
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out
  %use1 = zext i16 %elt1 to i32
  call void asm sideeffect "; use $0", "s"(i32 %use1) #0
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_reghi(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, [8 x i32], i32 %elt.arg) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reghi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x30
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_hh_b32_b16 s2, s4, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reghi:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s0, s2, 16
; VI-NEXT:    v_alignbit_b32 v2, s0, v2, 16
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reghi:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshr_b32 s0, s2, 16
; CI-NEXT:    v_alignbit_b32 v2, s0, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_0_reghi:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x30
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s1, s[6:7], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_hh_b32_b16 s0, s0, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_reghi_multi_use_1(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, i32 %elt.arg) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reghi_multi_use_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s3, s4, 16
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_lh_b32_b16 s2, s3, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s3
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reghi_multi_use_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_lshr_b32 s0, s4, 16
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s1, s2, 16
; VI-NEXT:    v_alignbit_b32 v2, s1, v2, 16
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s0
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reghi_multi_use_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_lshr_b32 s0, s4, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshr_b32 s1, s2, 16
; CI-NEXT:    v_alignbit_b32 v2, s1, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s0
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_0_reghi_multi_use_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s1, s[6:7], 0x0
; GFX11-NEXT:    s_lshr_b32 s0, s0, 16
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_lh_b32_b16 s1, s0, s1
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s1
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use s0
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out
  %use1 = zext i16 %elt to i32
  call void asm sideeffect "; use $0", "s"(i32 %use1) #0
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_0_reghi_both_multi_use_1(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, i32 %elt.arg) #0 {
; GFX9-LABEL: s_insertelement_v2i16_0_reghi_both_multi_use_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_lshr_b32 s3, s4, 16
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s2, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s3, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s4
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s3
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    ;;#ASMSTART
; GFX9-NEXT:    ; use s2
; GFX9-NEXT:    ;;#ASMEND
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_0_reghi_both_multi_use_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_mov_b32_e32 v2, s4
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    s_lshr_b32 s0, s4, 16
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshr_b32 s1, s2, 16
; VI-NEXT:    v_alignbit_b32 v2, s1, v2, 16
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s0
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    ;;#ASMSTART
; VI-NEXT:    ; use s1
; VI-NEXT:    ;;#ASMEND
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_0_reghi_both_multi_use_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_mov_b32_e32 v2, s4
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    s_lshr_b32 s0, s4, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshr_b32 s1, s2, 16
; CI-NEXT:    v_alignbit_b32 v2, s1, v2, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s0
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    ;;#ASMSTART
; CI-NEXT:    ; use s1
; CI-NEXT:    ;;#ASMEND
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_0_reghi_both_multi_use_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s1, s[6:7], 0x0
; GFX11-NEXT:    s_lshr_b32 s0, s0, 16
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s1, s1, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s0, s1
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use s0
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    ;;#ASMSTART
; GFX11-NEXT:    ; use s1
; GFX11-NEXT:    ;;#ASMEND
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vec.hi = extractelement <2 x i16> %vec, i32 1
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out
  %use1 = zext i16 %elt to i32
  %vec.hi.use1 = zext i16 %vec.hi to i32

  call void asm sideeffect "; use $0", "s"(i32 %use1) #0
  call void asm sideeffect "; use $0", "s"(i32 %vec.hi.use1) #0
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_1(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2i16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s2, 0x3e7
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2i16_1:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s2, 0xffff
; CIVI-NEXT:    s_or_b32 s0, s0, 0x3e70000
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, 0x3e7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 1
  store <2 x i16> %vecins, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2i16_1_reg(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, [8 x i32], i16 %elt) #0 {
; GFX9-LABEL: s_insertelement_v2i16_1_reg:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x30
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s2, s4
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_1_reg:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x30
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_lshl_b32 s0, s4, 16
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_and_b32 s1, s2, 0xffff
; VI-NEXT:    s_or_b32 s0, s1, s0
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_1_reg:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0xc
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_lshl_b32 s1, s4, 16
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_and_b32 s0, s2, 0xffff
; CI-NEXT:    s_or_b32 s0, s0, s1
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_1_reg:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x30
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s1, s[6:7], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s1, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 1
  store <2 x i16> %vecins, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2f16_0(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2f16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshr_b32 s2, s2, 16
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, 0x4500, s2
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2f16_0:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s2, 0xffff0000
; CIVI-NEXT:    s_or_b32 s0, s0, 0x4500
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2f16_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshr_b32 s2, s2, 16
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, 0x4500, s2
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x half>, ptr addrspace(4) %vec.ptr
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 0
  store <2 x half> %vecins, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @s_insertelement_v2f16_1(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2f16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s2, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s2, 0x4500
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; CIVI-LABEL: s_insertelement_v2f16_1:
; CIVI:       ; %bb.0:
; CIVI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CIVI-NEXT:    v_mov_b32_e32 v0, s0
; CIVI-NEXT:    v_mov_b32_e32 v1, s1
; CIVI-NEXT:    s_waitcnt lgkmcnt(0)
; CIVI-NEXT:    s_and_b32 s0, s2, 0xffff
; CIVI-NEXT:    s_or_b32 s0, s0, 0x45000000
; CIVI-NEXT:    v_mov_b32_e32 v2, s0
; CIVI-NEXT:    flat_store_dword v[0:1], v2
; CIVI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2f16_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s2, 0x4500
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %vec = load <2 x half>, ptr addrspace(4) %vec.ptr
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 1
  store <2 x half> %vecins, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_0(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x3e7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, v2, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v2, 0x3e7, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_0:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x3e7, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2i16_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_movk_i32 s2, 0x3e7
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, 0xffff, s2, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x i16>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_0_reghi(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %elt.arg) #0 {
; GFX9-LABEL: v_insertelement_v2i16_0_reghi:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x7060302
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v1, v1, s4, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_0_reghi:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v2, 0x3020706
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_perm_b32 v2, s4, v3, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_0_reghi:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshrrev_b32_e32 v2, 16, v3
; CI-NEXT:    v_alignbit_b32 v2, v2, s4, 16
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2i16_0_reghi:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v1, v1, s0, 0x7060302
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x i16>, ptr addrspace(1) %in.gep
  %elt.hi = lshr i32 %elt.arg, 16
  %elt = trunc i32 %elt.hi to i16
  %vecins = insertelement <2 x i16> %vec, i16 %elt, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_0_inlineimm(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_0_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, 53, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_0_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v2, 53, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_0_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; CI-NEXT:    v_or_b32_e32 v2, 53, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2i16_0_inlineimm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, 0xffff, 53, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x i16>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 53, i32 0
  store <2 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

; FIXME: fold lshl_or c0, c1, v0 -> or (c0 << c1), v0
define amdgpu_kernel void @v_insertelement_v2i16_1(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_movk_i32 s2, 0x3e7
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v1, s2, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v2, 0x3e70000
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x3e70000, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2i16_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_movk_i32 s2, 0x3e7
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v1, s2, v1, 0x5040100
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x i16>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 1
  store <2 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_1_inlineimm(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2i16_1_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v1, -15, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_1_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v2, 0xfff10000
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_1_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; CI-NEXT:    v_or_b32_e32 v2, 0xfff10000, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2i16_1_inlineimm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v1, -15, v1, 0x5040100
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x i16>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 -15, i32 1
  store <2 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_0(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x4500
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, v2, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v2, 0x4500, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_0:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x4500, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2f16_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_movk_i32 s2, 0x4500
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, 0xffff, s2, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x half>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 0
  store <2 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_0_inlineimm(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_0_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, 53, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_0_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; VI-NEXT:    v_or_b32_e32 v2, 53, v2
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_0_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff0000, v3
; CI-NEXT:    v_or_b32_e32 v2, 53, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2f16_0_inlineimm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, 0xffff, 53, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x half>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x half> %vec, half 0xH0035, i32 0
  store <2 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_1(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_movk_i32 s2, 0x4500
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v1, s2, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v2, 0x45000000
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x45000000, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2f16_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_movk_i32 s2, 0x4500
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v1, s2, v1, 0x5040100
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x half>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x half> %vec, half 5.000000e+00, i32 1
  store <2 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_1_inlineimm(ptr addrspace(1) %out, ptr addrspace(1) %in) #0 {
; GFX9-LABEL: v_insertelement_v2f16_1_inlineimm:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v1, 35, v1, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_1_inlineimm:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v2, 0x230000
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v2, v3, v2 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_1_inlineimm:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v2, 0xffff, v3
; CI-NEXT:    v_or_b32_e32 v2, 0x230000, v2
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2f16_1_inlineimm:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v1, 35, v1, 0x5040100
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x half>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x half> %vec, half 0xH0023, i32 1
  store <2 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

; FIXME: Enable for others when argument load not split
define amdgpu_kernel void @s_insertelement_v2i16_dynamic(ptr addrspace(1) %out, ptr addrspace(4) %vec.ptr, ptr addrspace(4) %idx.ptr) #0 {
; GFX9-LABEL: s_insertelement_v2i16_dynamic:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_mov_b32_e32 v0, 0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_load_dword s6, s[4:5], 0x0
; GFX9-NEXT:    s_load_dword s7, s[2:3], 0x0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s2, s6, 4
; GFX9-NEXT:    s_lshl_b32 s2, 0xffff, s2
; GFX9-NEXT:    s_andn2_b32 s3, s7, s2
; GFX9-NEXT:    s_and_b32 s2, s2, 0x3e703e7
; GFX9-NEXT:    s_or_b32 s2, s2, s3
; GFX9-NEXT:    v_mov_b32_e32 v1, s2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: s_insertelement_v2i16_dynamic:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_load_dword s4, s[4:5], 0x0
; VI-NEXT:    s_load_dword s2, s[2:3], 0x0
; VI-NEXT:    v_mov_b32_e32 v0, s0
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    s_lshl_b32 s0, s4, 4
; VI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; VI-NEXT:    s_andn2_b32 s1, s2, s0
; VI-NEXT:    s_and_b32 s0, s0, 0x3e703e7
; VI-NEXT:    s_or_b32 s0, s0, s1
; VI-NEXT:    v_mov_b32_e32 v2, s0
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: s_insertelement_v2i16_dynamic:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x4
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_load_dword s4, s[4:5], 0x0
; CI-NEXT:    s_load_dword s2, s[2:3], 0x0
; CI-NEXT:    v_mov_b32_e32 v0, s0
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    s_lshl_b32 s0, s4, 4
; CI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; CI-NEXT:    s_andn2_b32 s1, s2, s0
; CI-NEXT:    s_and_b32 s0, s0, 0x3e703e7
; CI-NEXT:    s_or_b32 s0, s0, s1
; CI-NEXT:    v_mov_b32_e32 v2, s0
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: s_insertelement_v2i16_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[4:5], s[2:3], 0x10
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_load_b32 s4, s[4:5], 0x0
; GFX11-NEXT:    s_load_b32 s2, s[2:3], 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s3, s4, 4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_lshl_b32 s3, 0xffff, s3
; GFX11-NEXT:    s_and_not1_b32 s2, s2, s3
; GFX11-NEXT:    s_and_b32 s3, s3, 0x3e703e7
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1) | instskip(NEXT) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    s_or_b32 s2, s3, s2
; GFX11-NEXT:    v_dual_mov_b32 v0, 0 :: v_dual_mov_b32 v1, s2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %idx = load volatile i32, ptr addrspace(4) %idx.ptr
  %vec = load <2 x i16>, ptr addrspace(4) %vec.ptr
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 %idx
  store <2 x i16> %vecins, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @v_insertelement_v2i16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %idx) #0 {
; GFX9-LABEL: v_insertelement_v2i16_dynamic_sgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_mov_b32_e32 v2, 0x3e703e7
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[2:3]
; GFX9-NEXT:    s_lshl_b32 s2, s4, 4
; GFX9-NEXT:    s_lshl_b32 s2, 0xffff, s2
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, v2, v1
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2i16_dynamic_sgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    s_lshl_b32 s0, s4, 4
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; VI-NEXT:    v_mov_b32_e32 v2, 0x3e703e7
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v2, s0, v2, v3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2i16_dynamic_sgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    s_lshl_b32 s0, s4, 4
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_lshl_b32 s0, 0xffff, s0
; CI-NEXT:    v_mov_b32_e32 v2, 0x3e703e7
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v2, s0, v2, v3
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2i16_dynamic_sgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b32 v1, v0, s[6:7]
; GFX11-NEXT:    s_lshl_b32 s0, s0, 4
; GFX11-NEXT:    s_lshl_b32 s0, 0xffff, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, s0, 0x3e703e7, v1
; GFX11-NEXT:    global_store_b32 v0, v1, s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <2 x i16>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x i16> %vec, i16 999, i32 %idx
  store <2 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v2f16_dynamic_vgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, ptr addrspace(1) %idx.ptr) #0 {
; GFX9-LABEL: v_insertelement_v2f16_dynamic_vgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dword v1, v0, s[4:5]
; GFX9-NEXT:    global_load_dword v2, v0, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX9-NEXT:    v_lshlrev_b32_e64 v1, v1, s2
; GFX9-NEXT:    s_mov_b32 s2, 0x12341234
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v1, s2, v2
; GFX9-NEXT:    global_store_dword v0, v1, s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v2f16_dynamic_vgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v3, s3
; VI-NEXT:    v_mov_b32_e32 v1, s5
; VI-NEXT:    v_add_u32_e32 v0, vcc, s4, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dword v4, v[0:1]
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; VI-NEXT:    flat_load_dword v3, v[0:1]
; VI-NEXT:    s_mov_b32 s2, 0xffff
; VI-NEXT:    v_add_u32_e32 v0, vcc, s0, v2
; VI-NEXT:    v_mov_b32_e32 v1, s1
; VI-NEXT:    s_mov_b32 s0, 0x12341234
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 4, v4
; VI-NEXT:    v_lshlrev_b32_e64 v2, v2, s2
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v2, v2, s0, v3
; VI-NEXT:    flat_store_dword v[0:1], v2
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v2f16_dynamic_vgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v3, s3
; CI-NEXT:    v_mov_b32_e32 v1, s5
; CI-NEXT:    v_add_i32_e32 v0, vcc, s4, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dword v4, v[0:1]
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v3, vcc
; CI-NEXT:    flat_load_dword v3, v[0:1]
; CI-NEXT:    v_add_i32_e32 v0, vcc, s0, v2
; CI-NEXT:    v_mov_b32_e32 v1, s1
; CI-NEXT:    s_mov_b32 s0, 0x12341234
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    s_waitcnt vmcnt(1)
; CI-NEXT:    v_lshlrev_b32_e32 v2, 4, v4
; CI-NEXT:    v_lshl_b32_e32 v2, 0xffff, v2
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v2, v2, s0, v3
; CI-NEXT:    flat_store_dword v[0:1], v2
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v2f16_dynamic_vgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b64 s[4:5], s[2:3], 0x10
; GFX11-NEXT:    s_load_b128 s[0:3], s[2:3], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_load_b32 v1, v0, s[4:5]
; GFX11-NEXT:    global_load_b32 v2, v0, s[2:3]
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 4, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e64 v1, v1, 0xffff
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, v1, 0x12341234, v2
; GFX11-NEXT:    global_store_b32 v0, v1, s[0:1]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %idx.gep = getelementptr inbounds i32, ptr addrspace(1) %idx.ptr, i64 %tid.ext
  %out.gep = getelementptr inbounds <2 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %idx = load i32, ptr addrspace(1) %idx.gep
  %vec = load <2 x half>, ptr addrspace(1) %in.gep
  %vecins = insertelement <2 x half> %vec, half 0xH1234, i32 %idx
  store <2 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_0(ptr addrspace(1) %out, ptr addrspace(1) %in, [8 x i32], i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_0:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x30
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v0, s2, v3, v0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_0:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x30
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    v_mov_b32_e32 v4, 0x3020504
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_perm_b32 v0, s4, v0, v4
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_0:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0xc
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_mov_b32 s0, 0xffff
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v0, s0, v4, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4f16_0:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x30
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v0, 0xffff, s0, v0
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 0
  store <4 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_1(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_1:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v0, s4, v0, v3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_1:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    v_mov_b32_e32 v4, 0x1000504
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_perm_b32 v0, v0, s4, v4
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_1:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_lshl_b32 s0, s4, 16
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v0, 0xffff, v0
; CI-NEXT:    v_or_b32_e32 v0, s0, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4f16_1:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v0, s0, v0, 0x5040100
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 1
  store <4 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_2(ptr addrspace(1) %out, ptr addrspace(1) %in, [8 x i32], i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x30
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, v3, v1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x30
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    v_mov_b32_e32 v4, 0x3020504
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_perm_b32 v1, s4, v1, v4
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_2:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0xc
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_mov_b32 s0, 0xffff
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, s0, v4, v1
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4f16_2:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x30
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, 0xffff, s0, v1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 2
  store <4 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_3(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4f16_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    v_mov_b32_e32 v3, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v1, s4, v1, v3
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_3:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    v_mov_b32_e32 v4, 0x1000504
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_perm_b32 v1, v1, s4, v4
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_3:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_lshl_b32 s0, s4, 16
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; CI-NEXT:    v_or_b32_e32 v1, s0, v1
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4f16_3:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v1, s0, v1, 0x5040100
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 3
  store <4 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4i16_2(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4i16_2:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s2, v3, v1
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4i16_2:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    v_mov_b32_e32 v4, 0x3020504
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_perm_b32 v1, s4, v1, v4
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4i16_2:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_mov_b32 s0, 0xffff
; CI-NEXT:    v_mov_b32_e32 v4, s4
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, s0, v4, v1
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4i16_2:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, 0xffff, s0, v1
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x i16>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to i16
  %vecins = insertelement <4 x i16> %vec, i16 %val.cvt, i32 2
  store <4 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

; FIXME: Better code on CI?
define amdgpu_kernel void @v_insertelement_v4i16_dynamic_vgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) #0 {
; GFX9-LABEL: v_insertelement_v4i16_dynamic_vgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    global_load_dword v2, v[0:1], off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v4, s[2:3]
; GFX9-NEXT:    s_mov_b64 s[2:3], 0xffff
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX9-NEXT:    v_lshlrev_b64 v[2:3], v2, s[2:3]
; GFX9-NEXT:    s_pack_ll_b32_b16 s2, s4, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, v3, s2, v1
; GFX9-NEXT:    v_bfi_b32 v0, v2, s2, v0
; GFX9-NEXT:    global_store_dwordx2 v4, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4i16_dynamic_vgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    flat_load_dword v4, v[0:1] glc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    s_mov_b64 s[2:3], 0xffff
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_lshl_b32 s1, s4, 16
; VI-NEXT:    s_and_b32 s4, s4, 0xffff
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    s_or_b32 s0, s4, s1
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v4, 4, v4
; VI-NEXT:    v_lshlrev_b64 v[4:5], v4, s[2:3]
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v1, v5, s0, v1
; VI-NEXT:    v_bfi_b32 v0, v4, s0, v0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4i16_dynamic_vgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    flat_load_dword v4, v[0:1] glc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    s_mov_b64 s[2:3], 0xffff
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_lshl_b32 s1, s4, 16
; CI-NEXT:    s_and_b32 s4, s4, 0xffff
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_or_b32 s0, s4, s1
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    v_lshlrev_b32_e32 v4, 4, v4
; CI-NEXT:    v_lshl_b64 v[4:5], s[2:3], v4
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, v5, s0, v1
; CI-NEXT:    v_bfi_b32 v0, v4, s0, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4i16_dynamic_vgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    global_load_b32 v2, v[0:1], off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_4) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v4, s[6:7]
; GFX11-NEXT:    s_pack_ll_b32_b16 s0, s0, s0
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 4, v2
; GFX11-NEXT:    v_lshlrev_b64 v[2:3], v2, 0xffff
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_bfi_b32 v1, v3, s0, v1
; GFX11-NEXT:    v_bfi_b32 v0, v2, s0, v0
; GFX11-NEXT:    global_store_b64 v4, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %idx.val = load volatile i32, ptr addrspace(1) undef
  %vec = load <4 x i16>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to i16
  %vecins = insertelement <4 x i16> %vec, i16 %val.cvt, i32 %idx.val
  store <4 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v4f16_dynamic_sgpr(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val, i32 %idxval) #0 {
; GFX9-LABEL: v_insertelement_v4f16_dynamic_sgpr:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx2 v[0:1], v2, s[2:3]
; GFX9-NEXT:    s_lshl_b32 s2, s5, 4
; GFX9-NEXT:    s_pack_ll_b32_b16 s4, s4, s4
; GFX9-NEXT:    s_lshl_b64 s[2:3], 0xffff, s2
; GFX9-NEXT:    v_mov_b32_e32 v3, s4
; GFX9-NEXT:    v_mov_b32_e32 v4, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v1, s3, v3, v1
; GFX9-NEXT:    v_bfi_b32 v0, s2, v4, v0
; GFX9-NEXT:    global_store_dwordx2 v2, v[0:1], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v4f16_dynamic_sgpr:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v2
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v3, s1
; VI-NEXT:    s_lshl_b32 s1, s4, 16
; VI-NEXT:    s_and_b32 s2, s4, 0xffff
; VI-NEXT:    s_lshl_b32 s3, s5, 4
; VI-NEXT:    s_or_b32 s2, s2, s1
; VI-NEXT:    v_add_u32_e32 v2, vcc, s0, v2
; VI-NEXT:    s_lshl_b64 s[0:1], 0xffff, s3
; VI-NEXT:    v_mov_b32_e32 v4, s2
; VI-NEXT:    v_mov_b32_e32 v5, s2
; VI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v1, s1, v4, v1
; VI-NEXT:    v_bfi_b32 v0, s0, v5, v0
; VI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v4f16_dynamic_sgpr:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v2
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx2 v[0:1], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v3, s1
; CI-NEXT:    s_and_b32 s1, s4, 0xffff
; CI-NEXT:    s_lshl_b32 s2, s4, 16
; CI-NEXT:    s_lshl_b32 s3, s5, 4
; CI-NEXT:    s_or_b32 s2, s1, s2
; CI-NEXT:    v_add_i32_e32 v2, vcc, s0, v2
; CI-NEXT:    s_lshl_b64 s[0:1], 0xffff, s3
; CI-NEXT:    v_mov_b32_e32 v4, s2
; CI-NEXT:    v_mov_b32_e32 v5, s2
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v3, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v1, s1, v4, v1
; CI-NEXT:    v_bfi_b32 v0, s0, v5, v0
; CI-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v4f16_dynamic_sgpr:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 3, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b64 v[0:1], v2, s[6:7]
; GFX11-NEXT:    s_lshl_b32 s1, s1, 4
; GFX11-NEXT:    s_pack_ll_b32_b16 s2, s0, s0
; GFX11-NEXT:    s_lshl_b64 s[0:1], 0xffff, s1
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v1, s1, s2, v1
; GFX11-NEXT:    v_bfi_b32 v0, s0, s2, v0
; GFX11-NEXT:    global_store_b64 v2, v[0:1], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <4 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <4 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <4 x half> %vec, half %val.cvt, i32 %idxval
  store <4 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v8f16_3(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) {
; GFX9-LABEL: v_insertelement_v8f16_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX9-NEXT:    v_mov_b32_e32 v5, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v4, s[2:3]
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_perm_b32 v1, s4, v1, v5
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v8f16_3:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v4
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    v_add_u32_e32 v4, vcc, s0, v4
; VI-NEXT:    s_lshl_b32 s0, s4, 16
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_mov_b32_e32 v6, s0
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v8f16_3:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v4
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v5, s1
; CI-NEXT:    v_add_i32_e32 v4, vcc, s0, v4
; CI-NEXT:    s_lshl_b32 s0, s4, 16
; CI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; CI-NEXT:    v_or_b32_e32 v1, s0, v1
; CI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v8f16_3:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b128 v[0:3], v4, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_perm_b32 v1, s0, v1, 0x5040100
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <8 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <8 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <8 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <8 x half> %vec, half %val.cvt, i32 3
  store <8 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v8i16_6(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) {
; GFX9-LABEL: v_insertelement_v8i16_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v4, s[2:3]
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v5, s4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_bfi_b32 v3, s2, v5, v3
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v8i16_6:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v4
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_add_u32_e32 v4, vcc, s0, v4
; VI-NEXT:    s_mov_b32 s0, 0xffff
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_bfi_b32 v3, s0, v6, v3
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v8i16_6:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v4
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v5, s1
; CI-NEXT:    v_add_i32_e32 v4, vcc, s0, v4
; CI-NEXT:    s_mov_b32 s0, 0xffff
; CI-NEXT:    v_mov_b32_e32 v6, s4
; CI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_bfi_b32 v3, s0, v6, v3
; CI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v8i16_6:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b128 v[0:3], v4, s[6:7]
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_bfi_b32 v3, 0xffff, s0, v3
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <8 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <8 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <8 x i16>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to i16
  %vecins = insertelement <8 x i16> %vec, i16 %val.cvt, i32 6
  store <8 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v8f16_dynamic(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val, i32 %n) {
; GFX9-LABEL: v_insertelement_v8f16_dynamic:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v4, s[2:3]
; GFX9-NEXT:    s_cmp_eq_u32 s5, 6
; GFX9-NEXT:    v_mov_b32_e32 v5, s4
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 7
; GFX9-NEXT:    s_mov_b32 s2, 0x5040100
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v3, v5, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 4
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 5
; GFX9-NEXT:    v_lshrrev_b32_e32 v7, 16, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v5, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 2
; GFX9-NEXT:    v_perm_b32 v3, v3, v6, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v7, v5, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 3
; GFX9-NEXT:    v_lshrrev_b32_e32 v8, 16, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v5, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 0
; GFX9-NEXT:    v_perm_b32 v2, v6, v2, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v8, v5, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 1
; GFX9-NEXT:    v_lshrrev_b32_e32 v9, 16, v0
; GFX9-NEXT:    v_cndmask_b32_e32 v0, v0, v5, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v9, v5, vcc
; GFX9-NEXT:    v_perm_b32 v1, v6, v1, s2
; GFX9-NEXT:    v_perm_b32 v0, v5, v0, s2
; GFX9-NEXT:    global_store_dwordx4 v4, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v8f16_dynamic:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v4
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    v_mov_b32_e32 v5, s1
; VI-NEXT:    v_add_u32_e32 v4, vcc, s0, v4
; VI-NEXT:    s_cmp_eq_u32 s5, 6
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; VI-NEXT:    v_mov_b32_e32 v6, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 7
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_cndmask_b32_e32 v7, v3, v6, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 4
; VI-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 5
; VI-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 2
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cndmask_b32_e32 v8, v8, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 3
; VI-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; VI-NEXT:    v_or_b32_sdwa v3, v7, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; VI-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 0
; VI-NEXT:    v_or_b32_sdwa v2, v2, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_cndmask_b32_e32 v7, v9, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 1
; VI-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v6, v10, v6, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v7, 16, v7
; VI-NEXT:    v_lshlrev_b32_e32 v6, 16, v6
; VI-NEXT:    v_or_b32_sdwa v1, v1, v7 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v0, v0, v6 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v8f16_dynamic:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v4
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v5, s1
; CI-NEXT:    v_add_i32_e32 v4, vcc, s0, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v6, s4
; CI-NEXT:    s_cmp_eq_u32 s5, 7
; CI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 6
; CI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 5
; CI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 4
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshrrev_b32_e32 v7, 16, v3
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_lshrrev_b32_e32 v9, 16, v1
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; CI-NEXT:    v_lshrrev_b32_e32 v8, 16, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_lshrrev_b32_e32 v10, 16, v0
; CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; CI-NEXT:    v_cndmask_b32_e64 v3, v3, v6, s[0:1]
; CI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 3
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; CI-NEXT:    v_cndmask_b32_e32 v7, v7, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 2
; CI-NEXT:    v_cndmask_b32_e32 v9, v9, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 1
; CI-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 0
; CI-NEXT:    v_cndmask_b32_e64 v8, v8, v6, s[2:3]
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_cndmask_b32_e32 v10, v10, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    v_cndmask_b32_e64 v2, v2, v6, s[0:1]
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; CI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; CI-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; CI-NEXT:    v_lshlrev_b32_e32 v6, 16, v7
; CI-NEXT:    v_lshlrev_b32_e32 v7, 16, v8
; CI-NEXT:    v_lshlrev_b32_e32 v8, 16, v9
; CI-NEXT:    v_or_b32_e32 v3, v3, v6
; CI-NEXT:    v_lshlrev_b32_e32 v6, 16, v10
; CI-NEXT:    v_or_b32_e32 v2, v2, v7
; CI-NEXT:    v_or_b32_e32 v1, v1, v8
; CI-NEXT:    v_or_b32_e32 v0, v0, v6
; CI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v8f16_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v4, 4, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    global_load_b128 v[0:3], v4, s[6:7]
; GFX11-NEXT:    s_cmp_eq_u32 s1, 6
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 7
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_cndmask_b32_e64 v5, v3, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 4
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_cselect_b32 s3, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 5
; GFX11-NEXT:    v_lshrrev_b32_e32 v6, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, s0, s3
; GFX11-NEXT:    s_cselect_b32 s3, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 2
; GFX11-NEXT:    v_lshrrev_b32_e32 v7, 16, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v3, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 3
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v1, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v8, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v7, v7, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 1
; GFX11-NEXT:    v_cndmask_b32_e64 v6, v6, s0, s3
; GFX11-NEXT:    s_cselect_b32 s1, -1, 0
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s0, s2
; GFX11-NEXT:    v_cndmask_b32_e64 v8, v8, s0, s1
; GFX11-NEXT:    v_perm_b32 v3, v3, v5, 0x5040100
; GFX11-NEXT:    v_perm_b32 v2, v6, v2, 0x5040100
; GFX11-NEXT:    v_perm_b32 v1, v7, v1, 0x5040100
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_4)
; GFX11-NEXT:    v_perm_b32 v0, v8, v0, 0x5040100
; GFX11-NEXT:    global_store_b128 v4, v[0:3], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <8 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <8 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <8 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <8 x half> %vec, half %val.cvt, i32 %n
  store <8 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v16f16_3(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) {
; GFX9-LABEL: v_insertelement_v16f16_3:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; GFX9-NEXT:    v_mov_b32_e32 v9, 0x5040100
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v8, s[2:3] offset:16
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_perm_b32 v1, s4, v1, v9
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] offset:16
; GFX9-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v16f16_3:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v8
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; VI-NEXT:    v_mov_b32_e32 v9, s1
; VI-NEXT:    v_add_u32_e32 v8, vcc, s0, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    s_lshl_b32 s1, s4, 16
; VI-NEXT:    v_add_u32_e32 v10, vcc, 16, v8
; VI-NEXT:    v_mov_b32_e32 v12, s1
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v9, vcc
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_or_b32_sdwa v1, v1, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; VI-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v16f16_3:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v0, s3
; CI-NEXT:    v_add_i32_e32 v4, vcc, s2, v8
; CI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v0, vcc
; CI-NEXT:    flat_load_dwordx4 v[0:3], v[4:5]
; CI-NEXT:    v_add_i32_e32 v4, vcc, 16, v4
; CI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; CI-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; CI-NEXT:    v_mov_b32_e32 v9, s1
; CI-NEXT:    v_add_i32_e32 v8, vcc, s0, v8
; CI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; CI-NEXT:    v_add_i32_e32 v10, vcc, 16, v8
; CI-NEXT:    s_lshl_b32 s1, s4, 16
; CI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v9, vcc
; CI-NEXT:    s_waitcnt vmcnt(1)
; CI-NEXT:    v_and_b32_e32 v1, 0xffff, v1
; CI-NEXT:    v_or_b32_e32 v1, s1, v1
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; CI-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v16f16_3:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_load_b128 v[0:3], v8, s[6:7]
; GFX11-NEXT:    global_load_b128 v[4:7], v8, s[6:7] offset:16
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_perm_b32 v1, s0, v1, 0x5040100
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b128 v8, v[4:7], s[4:5] offset:16
; GFX11-NEXT:    global_store_b128 v8, v[0:3], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <16 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <16 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <16 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <16 x half> %vec, half %val.cvt, i32 3
  store <16 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v16i16_6(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val) {
; GFX9-LABEL: v_insertelement_v16i16_6:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dword s4, s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[0:3], v8, s[2:3]
; GFX9-NEXT:    global_load_dwordx4 v[4:7], v8, s[2:3] offset:16
; GFX9-NEXT:    s_mov_b32 s2, 0xffff
; GFX9-NEXT:    v_mov_b32_e32 v9, s4
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_bfi_b32 v3, s2, v9, v3
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dwordx4 v8, v[4:7], s[0:1] offset:16
; GFX9-NEXT:    global_store_dwordx4 v8, v[0:3], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v16i16_6:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dword s4, s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; VI-NEXT:    v_mov_b32_e32 v12, 0x3020504
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v1, s3
; VI-NEXT:    v_add_u32_e32 v0, vcc, s2, v8
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; VI-NEXT:    v_add_u32_e32 v4, vcc, 16, v0
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; VI-NEXT:    v_mov_b32_e32 v9, s1
; VI-NEXT:    v_add_u32_e32 v8, vcc, s0, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 16, v8
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v9, vcc
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_perm_b32 v3, s4, v3, v12
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; VI-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v16i16_6:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dword s4, s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v8
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    v_add_i32_e32 v4, vcc, 16, v0
; CI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; CI-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; CI-NEXT:    v_mov_b32_e32 v9, s1
; CI-NEXT:    v_add_i32_e32 v8, vcc, s0, v8
; CI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; CI-NEXT:    v_add_i32_e32 v10, vcc, 16, v8
; CI-NEXT:    s_mov_b32 s2, 0xffff
; CI-NEXT:    v_mov_b32_e32 v12, s4
; CI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v9, vcc
; CI-NEXT:    s_waitcnt vmcnt(1)
; CI-NEXT:    v_bfi_b32 v3, s2, v12, v3
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    flat_store_dwordx4 v[10:11], v[4:7]
; CI-NEXT:    flat_store_dwordx4 v[8:9], v[0:3]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v16i16_6:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b32 s0, s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_load_b128 v[0:3], v8, s[6:7]
; GFX11-NEXT:    global_load_b128 v[4:7], v8, s[6:7] offset:16
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_bfi_b32 v3, 0xffff, s0, v3
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b128 v8, v[4:7], s[4:5] offset:16
; GFX11-NEXT:    global_store_b128 v8, v[0:3], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <16 x i16>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <16 x i16>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <16 x i16>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to i16
  %vecins = insertelement <16 x i16> %vec, i16 %val.cvt, i32 6
  store <16 x i16> %vecins, ptr addrspace(1) %out.gep
  ret void
}

define amdgpu_kernel void @v_insertelement_v16f16_dynamic(ptr addrspace(1) %out, ptr addrspace(1) %in, i32 %val, i32 %n) {
; GFX9-LABEL: v_insertelement_v16f16_dynamic:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; GFX9-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 5, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    global_load_dwordx4 v[1:4], v0, s[2:3]
; GFX9-NEXT:    global_load_dwordx4 v[5:8], v0, s[2:3] offset:16
; GFX9-NEXT:    s_cmp_eq_u32 s5, 6
; GFX9-NEXT:    v_mov_b32_e32 v9, s4
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 7
; GFX9-NEXT:    s_mov_b32 s2, 0x5040100
; GFX9-NEXT:    s_waitcnt vmcnt(1)
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v4, v9, vcc
; GFX9-NEXT:    v_lshrrev_b32_e32 v4, 16, v4
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 4
; GFX9-NEXT:    v_cndmask_b32_e32 v4, v4, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 5
; GFX9-NEXT:    v_lshrrev_b32_e32 v11, 16, v3
; GFX9-NEXT:    v_cndmask_b32_e32 v3, v3, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 2
; GFX9-NEXT:    v_perm_b32 v4, v4, v10, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v11, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 3
; GFX9-NEXT:    v_lshrrev_b32_e32 v12, 16, v2
; GFX9-NEXT:    v_cndmask_b32_e32 v2, v2, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 0
; GFX9-NEXT:    v_perm_b32 v3, v10, v3, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v12, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 1
; GFX9-NEXT:    v_lshrrev_b32_e32 v13, 16, v1
; GFX9-NEXT:    v_cndmask_b32_e32 v1, v1, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 14
; GFX9-NEXT:    v_perm_b32 v2, v10, v2, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v13, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 15
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshrrev_b32_e32 v14, 16, v8
; GFX9-NEXT:    v_cndmask_b32_e32 v8, v8, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 12
; GFX9-NEXT:    v_perm_b32 v1, v10, v1, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v14, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 13
; GFX9-NEXT:    v_lshrrev_b32_e32 v15, 16, v7
; GFX9-NEXT:    v_cndmask_b32_e32 v7, v7, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 10
; GFX9-NEXT:    v_perm_b32 v8, v10, v8, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v15, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 11
; GFX9-NEXT:    v_lshrrev_b32_e32 v16, 16, v6
; GFX9-NEXT:    v_cndmask_b32_e32 v6, v6, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 8
; GFX9-NEXT:    v_perm_b32 v7, v10, v7, s2
; GFX9-NEXT:    v_cndmask_b32_e32 v10, v16, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    s_cmp_eq_u32 s5, 9
; GFX9-NEXT:    v_lshrrev_b32_e32 v17, 16, v5
; GFX9-NEXT:    v_cndmask_b32_e32 v5, v5, v9, vcc
; GFX9-NEXT:    s_cselect_b64 vcc, -1, 0
; GFX9-NEXT:    v_cndmask_b32_e32 v9, v17, v9, vcc
; GFX9-NEXT:    v_perm_b32 v6, v10, v6, s2
; GFX9-NEXT:    v_perm_b32 v5, v9, v5, s2
; GFX9-NEXT:    global_store_dwordx4 v0, v[5:8], s[0:1] offset:16
; GFX9-NEXT:    global_store_dwordx4 v0, v[1:4], s[0:1]
; GFX9-NEXT:    s_endpgm
;
; VI-LABEL: v_insertelement_v16f16_dynamic:
; VI:       ; %bb.0:
; VI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; VI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x10
; VI-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; VI-NEXT:    s_waitcnt lgkmcnt(0)
; VI-NEXT:    v_mov_b32_e32 v0, s3
; VI-NEXT:    v_add_u32_e32 v4, vcc, s2, v8
; VI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v0, vcc
; VI-NEXT:    v_add_u32_e32 v0, vcc, 16, v4
; VI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; VI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; VI-NEXT:    flat_load_dwordx4 v[4:7], v[4:5]
; VI-NEXT:    v_mov_b32_e32 v9, s1
; VI-NEXT:    v_add_u32_e32 v8, vcc, s0, v8
; VI-NEXT:    v_addc_u32_e32 v9, vcc, 0, v9, vcc
; VI-NEXT:    v_add_u32_e32 v10, vcc, 16, v8
; VI-NEXT:    s_cmp_eq_u32 s5, 14
; VI-NEXT:    v_addc_u32_e32 v11, vcc, 0, v9, vcc
; VI-NEXT:    v_mov_b32_e32 v12, s4
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 15
; VI-NEXT:    s_waitcnt vmcnt(1)
; VI-NEXT:    v_cndmask_b32_e32 v13, v3, v12, vcc
; VI-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 12
; VI-NEXT:    v_cndmask_b32_e32 v3, v3, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 13
; VI-NEXT:    v_lshrrev_b32_e32 v14, 16, v2
; VI-NEXT:    v_cndmask_b32_e32 v2, v2, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 10
; VI-NEXT:    v_lshlrev_b32_e32 v3, 16, v3
; VI-NEXT:    v_cndmask_b32_e32 v14, v14, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 11
; VI-NEXT:    v_lshrrev_b32_e32 v15, 16, v1
; VI-NEXT:    v_or_b32_sdwa v3, v13, v3 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_lshlrev_b32_e32 v13, 16, v14
; VI-NEXT:    v_cndmask_b32_e32 v1, v1, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 8
; VI-NEXT:    v_or_b32_sdwa v2, v2, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_cndmask_b32_e32 v13, v15, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 9
; VI-NEXT:    v_lshrrev_b32_e32 v16, 16, v0
; VI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; VI-NEXT:    v_cndmask_b32_e32 v0, v0, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 6
; VI-NEXT:    v_or_b32_sdwa v1, v1, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_cndmask_b32_e32 v13, v16, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 7
; VI-NEXT:    s_waitcnt vmcnt(0)
; VI-NEXT:    v_lshrrev_b32_e32 v17, 16, v7
; VI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; VI-NEXT:    v_cndmask_b32_e32 v7, v7, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 4
; VI-NEXT:    v_or_b32_sdwa v0, v0, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_cndmask_b32_e32 v13, v17, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 5
; VI-NEXT:    v_lshrrev_b32_e32 v18, 16, v6
; VI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; VI-NEXT:    v_cndmask_b32_e32 v6, v6, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 2
; VI-NEXT:    v_or_b32_sdwa v7, v7, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_cndmask_b32_e32 v13, v18, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 3
; VI-NEXT:    v_lshrrev_b32_e32 v19, 16, v5
; VI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; VI-NEXT:    v_cndmask_b32_e32 v5, v5, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 0
; VI-NEXT:    v_or_b32_sdwa v6, v6, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_cndmask_b32_e32 v13, v19, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    s_cmp_eq_u32 s5, 1
; VI-NEXT:    v_lshrrev_b32_e32 v20, 16, v4
; VI-NEXT:    v_cndmask_b32_e32 v4, v4, v12, vcc
; VI-NEXT:    s_cselect_b64 vcc, -1, 0
; VI-NEXT:    v_cndmask_b32_e32 v12, v20, v12, vcc
; VI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; VI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; VI-NEXT:    v_or_b32_sdwa v5, v5, v13 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    v_or_b32_sdwa v4, v4, v12 dst_sel:DWORD dst_unused:UNUSED_PAD src0_sel:WORD_0 src1_sel:DWORD
; VI-NEXT:    flat_store_dwordx4 v[8:9], v[4:7]
; VI-NEXT:    flat_store_dwordx4 v[10:11], v[0:3]
; VI-NEXT:    s_endpgm
;
; CI-LABEL: v_insertelement_v16f16_dynamic:
; CI:       ; %bb.0:
; CI-NEXT:    s_load_dwordx4 s[0:3], s[6:7], 0x0
; CI-NEXT:    s_load_dwordx2 s[4:5], s[6:7], 0x4
; CI-NEXT:    v_lshlrev_b32_e32 v4, 5, v0
; CI-NEXT:    s_waitcnt lgkmcnt(0)
; CI-NEXT:    v_mov_b32_e32 v1, s3
; CI-NEXT:    v_add_i32_e32 v0, vcc, s2, v4
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v1, vcc
; CI-NEXT:    v_add_i32_e32 v2, vcc, 16, v0
; CI-NEXT:    v_addc_u32_e32 v3, vcc, 0, v1, vcc
; CI-NEXT:    flat_load_dwordx4 v[7:10], v[2:3]
; CI-NEXT:    flat_load_dwordx4 v[0:3], v[0:1]
; CI-NEXT:    v_mov_b32_e32 v5, s1
; CI-NEXT:    v_add_i32_e32 v4, vcc, s0, v4
; CI-NEXT:    v_cvt_f32_f16_e32 v6, s4
; CI-NEXT:    s_cmp_eq_u32 s5, 15
; CI-NEXT:    v_addc_u32_e32 v5, vcc, 0, v5, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 14
; CI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 13
; CI-NEXT:    s_cselect_b64 s[2:3], -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 12
; CI-NEXT:    s_waitcnt vmcnt(1)
; CI-NEXT:    v_lshrrev_b32_e32 v11, 16, v10
; CI-NEXT:    v_cvt_f32_f16_e32 v10, v10
; CI-NEXT:    v_lshrrev_b32_e32 v13, 16, v8
; CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; CI-NEXT:    v_cvt_f32_f16_e32 v13, v13
; CI-NEXT:    v_cvt_f32_f16_e32 v8, v8
; CI-NEXT:    v_lshrrev_b32_e32 v14, 16, v7
; CI-NEXT:    v_cvt_f32_f16_e32 v14, v14
; CI-NEXT:    v_cndmask_b32_e64 v10, v10, v6, s[0:1]
; CI-NEXT:    s_cselect_b64 s[0:1], -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 11
; CI-NEXT:    v_cvt_f32_f16_e32 v7, v7
; CI-NEXT:    s_waitcnt vmcnt(0)
; CI-NEXT:    v_lshrrev_b32_e32 v15, 16, v3
; CI-NEXT:    v_cndmask_b32_e32 v11, v11, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 10
; CI-NEXT:    v_cvt_f32_f16_e32 v15, v15
; CI-NEXT:    v_cndmask_b32_e32 v13, v13, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 9
; CI-NEXT:    v_cvt_f32_f16_e32 v3, v3
; CI-NEXT:    v_lshrrev_b32_e32 v16, 16, v2
; CI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; CI-NEXT:    v_cndmask_b32_e32 v8, v8, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 8
; CI-NEXT:    v_cvt_f32_f16_e32 v16, v16
; CI-NEXT:    v_cvt_f16_f32_e32 v10, v10
; CI-NEXT:    v_cndmask_b32_e32 v14, v14, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 7
; CI-NEXT:    v_lshrrev_b32_e32 v12, 16, v9
; CI-NEXT:    v_cvt_f32_f16_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e32 v7, v7, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 6
; CI-NEXT:    v_cvt_f32_f16_e32 v12, v12
; CI-NEXT:    v_cndmask_b32_e32 v15, v15, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 5
; CI-NEXT:    v_cvt_f32_f16_e32 v9, v9
; CI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; CI-NEXT:    v_cndmask_b32_e32 v3, v3, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 4
; CI-NEXT:    v_or_b32_e32 v10, v10, v11
; CI-NEXT:    v_cndmask_b32_e32 v11, v16, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; CI-NEXT:    v_cndmask_b32_e32 v2, v2, v6, vcc
; CI-NEXT:    v_cndmask_b32_e64 v12, v12, v6, s[2:3]
; CI-NEXT:    v_cvt_f16_f32_e32 v2, v2
; CI-NEXT:    v_cndmask_b32_e64 v9, v9, v6, s[0:1]
; CI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; CI-NEXT:    v_lshrrev_b32_e32 v17, 16, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v9, v9
; CI-NEXT:    v_cvt_f16_f32_e32 v14, v14
; CI-NEXT:    v_cvt_f32_f16_e32 v17, v17
; CI-NEXT:    v_cvt_f16_f32_e32 v7, v7
; CI-NEXT:    v_lshlrev_b32_e32 v11, 16, v11
; CI-NEXT:    v_cvt_f32_f16_e32 v1, v1
; CI-NEXT:    v_or_b32_e32 v2, v2, v11
; CI-NEXT:    v_lshrrev_b32_e32 v11, 16, v0
; CI-NEXT:    v_lshlrev_b32_e32 v12, 16, v12
; CI-NEXT:    s_cmp_eq_u32 s5, 3
; CI-NEXT:    v_cvt_f32_f16_e32 v11, v11
; CI-NEXT:    v_or_b32_e32 v9, v9, v12
; CI-NEXT:    v_lshlrev_b32_e32 v12, 16, v14
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 2
; CI-NEXT:    v_cvt_f32_f16_e32 v0, v0
; CI-NEXT:    v_or_b32_e32 v7, v7, v12
; CI-NEXT:    v_cndmask_b32_e32 v12, v17, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 1
; CI-NEXT:    v_cndmask_b32_e32 v1, v1, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    s_cmp_eq_u32 s5, 0
; CI-NEXT:    v_cvt_f16_f32_e32 v13, v13
; CI-NEXT:    v_cvt_f16_f32_e32 v12, v12
; CI-NEXT:    v_cndmask_b32_e32 v11, v11, v6, vcc
; CI-NEXT:    s_cselect_b64 vcc, -1, 0
; CI-NEXT:    v_cvt_f16_f32_e32 v8, v8
; CI-NEXT:    v_cvt_f16_f32_e32 v15, v15
; CI-NEXT:    v_cvt_f16_f32_e32 v1, v1
; CI-NEXT:    v_cvt_f16_f32_e32 v11, v11
; CI-NEXT:    v_cndmask_b32_e32 v0, v0, v6, vcc
; CI-NEXT:    v_cvt_f16_f32_e32 v3, v3
; CI-NEXT:    v_cvt_f16_f32_e32 v0, v0
; CI-NEXT:    v_lshlrev_b32_e32 v13, 16, v13
; CI-NEXT:    v_lshlrev_b32_e32 v6, 16, v12
; CI-NEXT:    v_or_b32_e32 v8, v8, v13
; CI-NEXT:    v_lshlrev_b32_e32 v13, 16, v15
; CI-NEXT:    v_or_b32_e32 v1, v1, v6
; CI-NEXT:    v_lshlrev_b32_e32 v6, 16, v11
; CI-NEXT:    v_or_b32_e32 v3, v3, v13
; CI-NEXT:    v_or_b32_e32 v0, v0, v6
; CI-NEXT:    flat_store_dwordx4 v[4:5], v[0:3]
; CI-NEXT:    s_nop 0
; CI-NEXT:    v_add_i32_e32 v0, vcc, 16, v4
; CI-NEXT:    v_addc_u32_e32 v1, vcc, 0, v5, vcc
; CI-NEXT:    flat_store_dwordx4 v[0:1], v[7:10]
; CI-NEXT:    s_endpgm
;
; GFX11-LABEL: v_insertelement_v16f16_dynamic:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    s_load_b128 s[4:7], s[2:3], 0x0
; GFX11-NEXT:    s_load_b64 s[0:1], s[2:3], 0x10
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v8, 5, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_load_b128 v[0:3], v8, s[6:7]
; GFX11-NEXT:    global_load_b128 v[4:7], v8, s[6:7] offset:16
; GFX11-NEXT:    s_cmp_eq_u32 s1, 6
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 7
; GFX11-NEXT:    s_waitcnt vmcnt(1)
; GFX11-NEXT:    v_cndmask_b32_e64 v9, v3, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 4
; GFX11-NEXT:    v_lshrrev_b32_e32 v3, 16, v3
; GFX11-NEXT:    s_cselect_b32 s3, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 5
; GFX11-NEXT:    v_lshrrev_b32_e32 v10, 16, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, v2, s0, s3
; GFX11-NEXT:    s_cselect_b32 s3, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 2
; GFX11-NEXT:    v_lshrrev_b32_e32 v11, 16, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v3, v3, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 3
; GFX11-NEXT:    v_cndmask_b32_e64 v1, v1, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 0
; GFX11-NEXT:    v_lshrrev_b32_e32 v12, 16, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v11, v11, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 1
; GFX11-NEXT:    v_cndmask_b32_e64 v0, v0, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 14
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_lshrrev_b32_e32 v13, 16, v7
; GFX11-NEXT:    v_cndmask_b32_e64 v10, v10, s0, s3
; GFX11-NEXT:    v_perm_b32 v3, v3, v9, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e64 v9, v12, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 15
; GFX11-NEXT:    v_cndmask_b32_e64 v7, v7, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 12
; GFX11-NEXT:    v_lshrrev_b32_e32 v14, 16, v6
; GFX11-NEXT:    v_perm_b32 v2, v10, v2, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e64 v10, v13, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 13
; GFX11-NEXT:    v_cndmask_b32_e64 v6, v6, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 10
; GFX11-NEXT:    v_lshrrev_b32_e32 v15, 16, v5
; GFX11-NEXT:    v_cndmask_b32_e64 v12, v14, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 11
; GFX11-NEXT:    v_cndmask_b32_e64 v5, v5, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 8
; GFX11-NEXT:    v_lshrrev_b32_e32 v16, 16, v4
; GFX11-NEXT:    v_cndmask_b32_e64 v13, v15, s0, s2
; GFX11-NEXT:    s_cselect_b32 s2, -1, 0
; GFX11-NEXT:    s_cmp_eq_u32 s1, 9
; GFX11-NEXT:    v_cndmask_b32_e64 v4, v4, s0, s2
; GFX11-NEXT:    s_cselect_b32 s1, -1, 0
; GFX11-NEXT:    v_perm_b32 v7, v10, v7, 0x5040100
; GFX11-NEXT:    v_cndmask_b32_e64 v14, v16, s0, s1
; GFX11-NEXT:    v_perm_b32 v6, v12, v6, 0x5040100
; GFX11-NEXT:    v_perm_b32 v5, v13, v5, 0x5040100
; GFX11-NEXT:    v_perm_b32 v1, v11, v1, 0x5040100
; GFX11-NEXT:    v_perm_b32 v0, v9, v0, 0x5040100
; GFX11-NEXT:    v_perm_b32 v4, v14, v4, 0x5040100
; GFX11-NEXT:    s_clause 0x1
; GFX11-NEXT:    global_store_b128 v8, v[4:7], s[4:5] offset:16
; GFX11-NEXT:    global_store_b128 v8, v[0:3], s[4:5]
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
  %tid = call i32 @llvm.amdgcn.workitem.id.x() #1
  %tid.ext = sext i32 %tid to i64
  %in.gep = getelementptr inbounds <16 x half>, ptr addrspace(1) %in, i64 %tid.ext
  %out.gep = getelementptr inbounds <16 x half>, ptr addrspace(1) %out, i64 %tid.ext
  %vec = load <16 x half>, ptr addrspace(1) %in.gep
  %val.trunc = trunc i32 %val to i16
  %val.cvt = bitcast i16 %val.trunc to half
  %vecins = insertelement <16 x half> %vec, half %val.cvt, i32 %n
  store <16 x half> %vecins, ptr addrspace(1) %out.gep
  ret void
}


declare i32 @llvm.amdgcn.workitem.id.x() #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readnone }
